/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.Sys;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.linux.Visual;
import org.lwjgl.system.linux.XClassHint;
import org.lwjgl.system.linux.XColor;
import org.lwjgl.system.linux.XErrorHandler;
import org.lwjgl.system.linux.XEvent;
import org.lwjgl.system.linux.XGCValues;
import org.lwjgl.system.linux.XGenericEventCookie;
import org.lwjgl.system.linux.XSetWindowAttributes;
import org.lwjgl.system.linux.XSizeHints;
import org.lwjgl.system.linux.XWMHints;
import org.lwjgl.system.linux.XWindowAttributes;

public final class Xlib {
    public static final int True = 1;
    public static final int False = 0;
    public static final int QueuedAlready = 0;
    public static final int QueuedAfterReading = 1;
    public static final int QueuedAfterFlush = 2;

    private Xlib() {
    }

    public static native int XInitThreads();

    public static native long nXSetErrorHandler(long var0);

    public static long XSetErrorHandler(long handler) {
        return Xlib.nXSetErrorHandler(handler);
    }

    public static long XSetErrorHandler(XErrorHandler handler) {
        return Xlib.nXSetErrorHandler(XErrorHandler.Util.register(handler));
    }

    public static native int nXGetErrorText(long var0, int var2, long var3, int var5);

    public static int XGetErrorText(long display, int code, ByteBuffer buffer_return, int length) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)buffer_return, length);
        }
        return Xlib.nXGetErrorText(display, code, MemoryUtil.memAddress(buffer_return), length);
    }

    public static int XGetErrorText(long display, int code, ByteBuffer buffer_return) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXGetErrorText(display, code, MemoryUtil.memAddress(buffer_return), buffer_return.remaining());
    }

    public static native int nXFree(long var0);

    public static int XFree(ByteBuffer data) {
        return Xlib.nXFree(MemoryUtil.memAddress(data));
    }

    public static int XFree(PointerBuffer data) {
        return Xlib.nXFree(MemoryUtil.memAddress(data));
    }

    public static native long nXOpenDisplay(long var0);

    public static long XOpenDisplay(ByteBuffer display_name) {
        if (LWJGLUtil.CHECKS && display_name != null) {
            Checks.checkNT1(display_name);
        }
        return Xlib.nXOpenDisplay(MemoryUtil.memAddressSafe(display_name));
    }

    public static long XOpenDisplay(CharSequence display_name) {
        ByteBuffer display_nameEncoded = MemoryUtil.memEncodeASCII(display_name);
        return Xlib.nXOpenDisplay(MemoryUtil.memAddressSafe(display_nameEncoded));
    }

    public static native int nXCloseDisplay(long var0);

    public static int XCloseDisplay(long display) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXCloseDisplay(display);
    }

    public static native long nXInternAtom(long var0, long var2, int var4);

    public static long XInternAtom(long display, ByteBuffer atom_name, int only_if_exists) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkNT1(atom_name);
        }
        return Xlib.nXInternAtom(display, MemoryUtil.memAddress(atom_name), only_if_exists);
    }

    public static long XInternAtom(long display, CharSequence atom_name, int only_if_exists) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        ByteBuffer atom_nameEncoded = MemoryUtil.memEncodeASCII(atom_name);
        return Xlib.nXInternAtom(display, MemoryUtil.memAddress(atom_nameEncoded), only_if_exists);
    }

    public static native int nXDefaultScreen(long var0);

    public static int XDefaultScreen(long display) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXDefaultScreen(display);
    }

    public static native int nXDefaultDepth(long var0, int var2);

    public static int XDefaultDepth(long display, int screen_number) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXDefaultDepth(display, screen_number);
    }

    public static native int nXDisplayWidth(long var0, int var2);

    public static int XDisplayWidth(long display, int screen_number) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXDisplayWidth(display, screen_number);
    }

    public static native int nXDisplayHeight(long var0, int var2);

    public static int XDisplayHeight(long display, int screen_number) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXDisplayHeight(display, screen_number);
    }

    public static native int nXDisplayWidthMM(long var0, int var2);

    public static int XDisplayWidthMM(long display, int screen_number) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXDisplayWidthMM(display, screen_number);
    }

    public static native int nXDisplayHeightMM(long var0, int var2);

    public static int XDisplayHeightMM(long display, int screen_number) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXDisplayHeightMM(display, screen_number);
    }

    public static native int nXSync(long var0, int var2);

    public static int XSync(long display, int discard) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXSync(display, discard);
    }

    public static native long nXRootWindow(long var0, int var2);

    public static long XRootWindow(long display, int screen_number) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXRootWindow(display, screen_number);
    }

    public static native int nXQueryExtension(long var0, long var2, long var4, long var6, long var8);

    public static int XQueryExtension(long display, ByteBuffer name, ByteBuffer major_opcode_return, ByteBuffer first_event_return, ByteBuffer first_error_return) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkNT1(name);
        }
        return Xlib.nXQueryExtension(display, MemoryUtil.memAddress(name), MemoryUtil.memAddress(major_opcode_return), MemoryUtil.memAddress(first_event_return), MemoryUtil.memAddress(first_error_return));
    }

    public static int XQueryExtension(long display, ByteBuffer name, IntBuffer major_opcode_return, IntBuffer first_event_return, IntBuffer first_error_return) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXQueryExtension(display, MemoryUtil.memAddress(name), MemoryUtil.memAddress(major_opcode_return), MemoryUtil.memAddress(first_event_return), MemoryUtil.memAddress(first_error_return));
    }

    public static int XQueryExtension(long display, CharSequence name, IntBuffer major_opcode_return, IntBuffer first_event_return, IntBuffer first_error_return) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        ByteBuffer nameEncoded = MemoryUtil.memEncodeASCII(name);
        return Xlib.nXQueryExtension(display, MemoryUtil.memAddress(nameEncoded), MemoryUtil.memAddress(major_opcode_return), MemoryUtil.memAddress(first_event_return), MemoryUtil.memAddress(first_error_return));
    }

    public static native int nXFlush(long var0);

    public static int XFlush(long display) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXFlush(display);
    }

    public static native int nXPending(long var0);

    public static int XPending(long display) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXPending(display);
    }

    public static native int nXNextEvent(long var0, long var2);

    public static int XNextEvent(long display, ByteBuffer event_return) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)event_return, XEvent.SIZEOF);
        }
        return Xlib.nXNextEvent(display, MemoryUtil.memAddress(event_return));
    }

    public static native long nXCreateColormap(long var0, long var2, long var4, int var6);

    public static long XCreateColormap(long display, long w, ByteBuffer visual, int alloc) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)visual, Visual.SIZEOF);
        }
        return Xlib.nXCreateColormap(display, w, MemoryUtil.memAddress(visual), alloc);
    }

    public static native int nXFreeColormap(long var0, long var2);

    public static int XFreeColormap(long display, long colormap) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXFreeColormap(display, colormap);
    }

    public static native long nXScreenOfDisplay(long var0, int var2);

    public static long XScreenOfDisplay(long display, int screen_number) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXScreenOfDisplay(display, screen_number);
    }

    public static native long nXBlackPixel(long var0, int var2);

    public static long XBlackPixel(long display, int screen_number) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXBlackPixel(display, screen_number);
    }

    public static native int nXConnectionNumber(long var0);

    public static int XConnectionNumber(long display) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXConnectionNumber(display);
    }

    public static native long nXCreateWindow(long var0, long var2, int var4, int var5, int var6, int var7, int var8, int var9, int var10, long var11, long var13, long var15);

    public static long XCreateWindow(long display, long parent, int x, int y, int width, int height, int border_width, int depth, int windowClass, ByteBuffer visual, long valuemask, ByteBuffer attributes) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)visual, Visual.SIZEOF);
            Checks.checkBuffer((Buffer)attributes, XSetWindowAttributes.SIZEOF);
        }
        return Xlib.nXCreateWindow(display, parent, x, y, width, height, border_width, depth, windowClass, MemoryUtil.memAddress(visual), valuemask, MemoryUtil.memAddress(attributes));
    }

    public static native int nXChangeWindowAttributes(long var0, long var2, long var4, long var6);

    public static int XChangeWindowAttributes(long display, long w, long valuemask, ByteBuffer attributes) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)attributes, XSetWindowAttributes.SIZEOF);
        }
        return Xlib.nXChangeWindowAttributes(display, w, valuemask, MemoryUtil.memAddress(attributes));
    }

    public static native int nXSetWMProtocols(long var0, long var2, long var4, int var6);

    public static int XSetWMProtocols(long display, long w, ByteBuffer protocols, int count) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)protocols, count << Pointer.POINTER_SHIFT);
        }
        return Xlib.nXSetWMProtocols(display, w, MemoryUtil.memAddress(protocols), count);
    }

    public static int XSetWMProtocols(long display, long w, PointerBuffer protocols) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXSetWMProtocols(display, w, MemoryUtil.memAddress(protocols), protocols.remaining());
    }

    public static native int nXSetWMHints(long var0, long var2, long var4);

    public static int XSetWMHints(long display, long w, ByteBuffer hints) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)hints, XWMHints.SIZEOF);
        }
        return Xlib.nXSetWMHints(display, w, MemoryUtil.memAddress(hints));
    }

    public static native int nXSetSizeHints(long var0, long var2, long var4, long var6);

    public static int XSetSizeHints(long display, long w, ByteBuffer hints, long property) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)hints, XSizeHints.SIZEOF);
        }
        return Xlib.nXSetSizeHints(display, w, MemoryUtil.memAddress(hints), property);
    }

    public static native void nXSetWMNormalHints(long var0, long var2, long var4);

    public static void XSetWMNormalHints(long display, long w, ByteBuffer hints) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)hints, XSizeHints.SIZEOF);
        }
        Xlib.nXSetWMNormalHints(display, w, MemoryUtil.memAddress(hints));
    }

    public static native int nXGrabPointer(long var0, long var2, int var4, int var5, int var6, int var7, long var8, long var10, long var12);

    public static int XGrabPointer(long display, long grab_window, int owner_events, int event_mask, int pointer_mode, int keyboard_mode, long confine_to, long cursor, long time) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXGrabPointer(display, grab_window, owner_events, event_mask, pointer_mode, keyboard_mode, confine_to, cursor, time);
    }

    public static native int nXUngrabPointer(long var0, long var2);

    public static int XUngrabPointer(long display, long time) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXUngrabPointer(display, time);
    }

    public static native int nXDefineCursor(long var0, long var2, long var4);

    public static int XDefineCursor(long display, long w, long cursor) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXDefineCursor(display, w, cursor);
    }

    public static native int nXUndefineCursor(long var0, long var2);

    public static int XUndefineCursor(long display, long w) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXUndefineCursor(display, w);
    }

    public static native int nXFreeCursor(long var0, long var2);

    public static int XFreeCursor(long display, long cursor) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXFreeCursor(display, cursor);
    }

    public static native int nXGetScreenSaver(long var0, long var2, long var4, long var6, long var8);

    public static int XGetScreenSaver(long display, ByteBuffer timeout_return, ByteBuffer interval_return, ByteBuffer prefer_blanking_return, ByteBuffer allow_exposures_return) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)timeout_return, 4);
            Checks.checkBuffer((Buffer)interval_return, 4);
            Checks.checkBuffer((Buffer)prefer_blanking_return, 4);
            Checks.checkBuffer((Buffer)allow_exposures_return, 4);
        }
        return Xlib.nXGetScreenSaver(display, MemoryUtil.memAddress(timeout_return), MemoryUtil.memAddress(interval_return), MemoryUtil.memAddress(prefer_blanking_return), MemoryUtil.memAddress(allow_exposures_return));
    }

    public static int XGetScreenSaver(long display, IntBuffer timeout_return, IntBuffer interval_return, IntBuffer prefer_blanking_return, IntBuffer allow_exposures_return) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)timeout_return, 1);
            Checks.checkBuffer((Buffer)interval_return, 1);
            Checks.checkBuffer((Buffer)prefer_blanking_return, 1);
            Checks.checkBuffer((Buffer)allow_exposures_return, 1);
        }
        return Xlib.nXGetScreenSaver(display, MemoryUtil.memAddress(timeout_return), MemoryUtil.memAddress(interval_return), MemoryUtil.memAddress(prefer_blanking_return), MemoryUtil.memAddress(allow_exposures_return));
    }

    public static native int nXSetScreenSaver(long var0, int var2, int var3, int var4, int var5);

    public static int XSetScreenSaver(long display, int timeout_return, int interval_return, int prefer_blanking_return, int allow_exposures_return) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXSetScreenSaver(display, timeout_return, interval_return, prefer_blanking_return, allow_exposures_return);
    }

    public static native int nXSendEvent(long var0, long var2, int var4, long var5, long var7);

    public static int XSendEvent(long display, long w, int propagate, long event_mask, ByteBuffer event_send) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)event_send, XEvent.SIZEOF);
        }
        return Xlib.nXSendEvent(display, w, propagate, event_mask, MemoryUtil.memAddress(event_send));
    }

    public static native int nXRaiseWindow(long var0, long var2);

    public static int XRaiseWindow(long display, long w) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXRaiseWindow(display, w);
    }

    public static native int nXSetInputFocus(long var0, long var2, int var4, long var5);

    public static int XSetInputFocus(long display, long focus, int revert_to, long time) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXSetInputFocus(display, focus, revert_to, time);
    }

    public static native int nXMoveWindow(long var0, long var2, int var4, int var5);

    public static int XMoveWindow(long display, long w, int x, int y) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXMoveWindow(display, w, x, y);
    }

    public static native int nXResizeWindow(long var0, long var2, int var4, int var5);

    public static int XResizeWindow(long display, long w, int width, int height) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXResizeWindow(display, w, width, height);
    }

    public static native int nXGetEventData(long var0, long var2);

    public static int XGetEventData(long display, ByteBuffer cookie) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)cookie, XGenericEventCookie.SIZEOF);
        }
        return Xlib.nXGetEventData(display, MemoryUtil.memAddress(cookie));
    }

    public static native void nXFreeEventData(long var0, long var2);

    public static void XFreeEventData(long display, ByteBuffer cookie) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)cookie, XGenericEventCookie.SIZEOF);
        }
        Xlib.nXFreeEventData(display, MemoryUtil.memAddress(cookie));
    }

    public static native int nXGetWindowProperty(long var0, long var2, long var4, long var6, long var8, int var10, long var11, long var13, long var15, long var17, long var19, long var21);

    public static int XGetWindowProperty(long display, long w, long property, long long_offset, long long_length, int delete, long req_type, ByteBuffer actual_type_return, ByteBuffer actual_format_return, ByteBuffer nitems_return, ByteBuffer bytes_after_return, ByteBuffer prop_return) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXGetWindowProperty(display, w, property, long_offset, long_length, delete, req_type, MemoryUtil.memAddress(actual_type_return), MemoryUtil.memAddress(actual_format_return), MemoryUtil.memAddress(nitems_return), MemoryUtil.memAddress(bytes_after_return), MemoryUtil.memAddress(prop_return));
    }

    public static int XGetWindowProperty(long display, long w, long property, long long_offset, long long_length, int delete, long req_type, PointerBuffer actual_type_return, IntBuffer actual_format_return, PointerBuffer nitems_return, PointerBuffer bytes_after_return, PointerBuffer prop_return) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXGetWindowProperty(display, w, property, long_offset, long_length, delete, req_type, MemoryUtil.memAddress(actual_type_return), MemoryUtil.memAddress(actual_format_return), MemoryUtil.memAddress(nitems_return), MemoryUtil.memAddress(bytes_after_return), MemoryUtil.memAddress(prop_return));
    }

    public static native int nXDeleteProperty(long var0, long var2, long var4);

    public static int XDeleteProperty(long display, long w, long property) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXDeleteProperty(display, w, property);
    }

    public static native int nXQueryPointer(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16);

    public static int XQueryPointer(long display, long w, ByteBuffer root_return, ByteBuffer child_return, ByteBuffer root_x_return, ByteBuffer root_y_return, ByteBuffer win_x_return, ByteBuffer win_y_return, ByteBuffer mask_return) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXQueryPointer(display, w, MemoryUtil.memAddress(root_return), MemoryUtil.memAddress(child_return), MemoryUtil.memAddress(root_x_return), MemoryUtil.memAddress(root_y_return), MemoryUtil.memAddress(win_x_return), MemoryUtil.memAddress(win_y_return), MemoryUtil.memAddress(mask_return));
    }

    public static int XQueryPointer(long display, long w, PointerBuffer root_return, PointerBuffer child_return, IntBuffer root_x_return, IntBuffer root_y_return, IntBuffer win_x_return, IntBuffer win_y_return, IntBuffer mask_return) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXQueryPointer(display, w, MemoryUtil.memAddress(root_return), MemoryUtil.memAddress(child_return), MemoryUtil.memAddress(root_x_return), MemoryUtil.memAddress(root_y_return), MemoryUtil.memAddress(win_x_return), MemoryUtil.memAddress(win_y_return), MemoryUtil.memAddress(mask_return));
    }

    public static native int nXUnmapWindow(long var0, long var2);

    public static int XUnmapWindow(long display, long w) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXUnmapWindow(display, w);
    }

    public static native int nXDestroyWindow(long var0, long var2);

    public static int XDestroyWindow(long display, long w) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXDestroyWindow(display, w);
    }

    public static native void nXutf8SetWMProperties(long var0, long var2, long var4, long var6, long var8, int var10, long var11, long var13, long var15);

    public static void Xutf8SetWMProperties(long display, long w, ByteBuffer window_name, ByteBuffer icon_name, ByteBuffer argv, int argc, ByteBuffer normal_hints, ByteBuffer wm_hints, ByteBuffer class_hints) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkNT1(window_name);
            Checks.checkNT1(icon_name);
            if (argv != null) {
                Checks.checkBuffer((Buffer)argv, argc << Pointer.POINTER_SHIFT);
            }
            if (normal_hints != null) {
                Checks.checkBuffer((Buffer)normal_hints, XSizeHints.SIZEOF);
            }
            if (wm_hints != null) {
                Checks.checkBuffer((Buffer)wm_hints, XWMHints.SIZEOF);
            }
            if (class_hints != null) {
                Checks.checkBuffer((Buffer)class_hints, XClassHint.SIZEOF);
            }
        }
        Xlib.nXutf8SetWMProperties(display, w, MemoryUtil.memAddress(window_name), MemoryUtil.memAddress(icon_name), MemoryUtil.memAddressSafe(argv), argc, MemoryUtil.memAddressSafe(normal_hints), MemoryUtil.memAddressSafe(wm_hints), MemoryUtil.memAddressSafe(class_hints));
    }

    public static void Xutf8SetWMProperties(long display, long w, ByteBuffer window_name, ByteBuffer icon_name, PointerBuffer argv, ByteBuffer normal_hints, ByteBuffer wm_hints, ByteBuffer class_hints) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            if (normal_hints != null) {
                Checks.checkBuffer((Buffer)normal_hints, XSizeHints.SIZEOF);
            }
            if (wm_hints != null) {
                Checks.checkBuffer((Buffer)wm_hints, XWMHints.SIZEOF);
            }
            if (class_hints != null) {
                Checks.checkBuffer((Buffer)class_hints, XClassHint.SIZEOF);
            }
        }
        Xlib.nXutf8SetWMProperties(display, w, MemoryUtil.memAddress(window_name), MemoryUtil.memAddress(icon_name), MemoryUtil.memAddressSafe(argv), argv == null ? 0 : argv.remaining(), MemoryUtil.memAddressSafe(normal_hints), MemoryUtil.memAddressSafe(wm_hints), MemoryUtil.memAddressSafe(class_hints));
    }

    public static void Xutf8SetWMProperties(long display, long w, CharSequence window_name, CharSequence icon_name, PointerBuffer argv, ByteBuffer normal_hints, ByteBuffer wm_hints, ByteBuffer class_hints) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            if (normal_hints != null) {
                Checks.checkBuffer((Buffer)normal_hints, XSizeHints.SIZEOF);
            }
            if (wm_hints != null) {
                Checks.checkBuffer((Buffer)wm_hints, XWMHints.SIZEOF);
            }
            if (class_hints != null) {
                Checks.checkBuffer((Buffer)class_hints, XClassHint.SIZEOF);
            }
        }
        ByteBuffer window_nameEncoded = MemoryUtil.memEncodeUTF8(window_name);
        ByteBuffer icon_nameEncoded = MemoryUtil.memEncodeUTF8(icon_name);
        Xlib.nXutf8SetWMProperties(display, w, MemoryUtil.memAddress(window_nameEncoded), MemoryUtil.memAddress(icon_nameEncoded), MemoryUtil.memAddressSafe(argv), argv == null ? 0 : argv.remaining(), MemoryUtil.memAddressSafe(normal_hints), MemoryUtil.memAddressSafe(wm_hints), MemoryUtil.memAddressSafe(class_hints));
    }

    public static native int nXChangeProperty(long var0, long var2, long var4, long var6, int var8, int var9, long var10, int var12);

    public static int XChangeProperty(long display, long w, long property, long type, int format, int mode, ByteBuffer data, int nelements) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)data, nelements);
        }
        return Xlib.nXChangeProperty(display, w, property, type, format, mode, MemoryUtil.memAddress(data), nelements);
    }

    public static int XChangeProperty(long display, long w, long property, long type, int format, int mode, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXChangeProperty(display, w, property, type, format, mode, MemoryUtil.memAddress(data), data.remaining());
    }

    public static int XChangeProperty(long display, long w, long property, long type, int format, int mode, ShortBuffer data) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXChangeProperty(display, w, property, type, format, mode, MemoryUtil.memAddress(data), data.remaining());
    }

    public static int XChangeProperty(long display, long w, long property, long type, int format, int mode, IntBuffer data) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXChangeProperty(display, w, property, type, format, mode, MemoryUtil.memAddress(data), data.remaining());
    }

    public static native int nXTranslateCoordinates(long var0, long var2, long var4, int var6, int var7, long var8, long var10, long var12);

    public static int XTranslateCoordinates(long display, long src_w, long dest_w, int src_x, int src_y, ByteBuffer dest_x_return, ByteBuffer dest_y_return, ByteBuffer child_return) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)dest_x_return, 4);
            Checks.checkBuffer((Buffer)dest_y_return, 4);
        }
        return Xlib.nXTranslateCoordinates(display, src_w, dest_w, src_x, src_y, MemoryUtil.memAddress(dest_x_return), MemoryUtil.memAddress(dest_y_return), MemoryUtil.memAddress(child_return));
    }

    public static int XTranslateCoordinates(long display, long src_w, long dest_w, int src_x, int src_y, IntBuffer dest_x_return, IntBuffer dest_y_return, PointerBuffer child_return) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)dest_x_return, 1);
            Checks.checkBuffer((Buffer)dest_y_return, 1);
        }
        return Xlib.nXTranslateCoordinates(display, src_w, dest_w, src_x, src_y, MemoryUtil.memAddress(dest_x_return), MemoryUtil.memAddress(dest_y_return), MemoryUtil.memAddress(child_return));
    }

    public static native int nXGetWindowAttributes(long var0, long var2, long var4);

    public static int XGetWindowAttributes(long display, long w, ByteBuffer window_attributes_return) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)window_attributes_return, XWindowAttributes.SIZEOF);
        }
        return Xlib.nXGetWindowAttributes(display, w, MemoryUtil.memAddress(window_attributes_return));
    }

    public static native int nXIconifyWindow(long var0, long var2, int var4);

    public static int XIconifyWindow(long display, long w, int screen_number) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXIconifyWindow(display, w, screen_number);
    }

    public static native int nXMapWindow(long var0, long var2);

    public static int XMapWindow(long display, long w) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXMapWindow(display, w);
    }

    public static native int nXMapRaised(long var0, long var2);

    public static int XMapRaised(long display, long w) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXMapRaised(display, w);
    }

    public static native int nXWarpPointer(long var0, long var2, long var4, int var6, int var7, int var8, int var9, int var10, int var11);

    public static int XWarpPointer(long display, long src_w, long dest_w, int src_x, int src_y, int src_width, int src_height, int dest_x, int dest_y) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXWarpPointer(display, src_w, dest_w, src_x, src_y, src_width, src_height, dest_x, dest_y);
    }

    public static native int nXSetSelectionOwner(long var0, long var2, long var4, long var6);

    public static int XSetSelectionOwner(long display, long selection, long owner, long time) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXSetSelectionOwner(display, selection, owner, time);
    }

    public static native long nXGetSelectionOwner(long var0, long var2);

    public static long XGetSelectionOwner(long display, long selection) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXGetSelectionOwner(display, selection);
    }

    public static native int nXConvertSelection(long var0, long var2, long var4, long var6, long var8, long var10);

    public static int XConvertSelection(long display, long selection, long target, long property, long requestor, long time) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXConvertSelection(display, selection, target, property, requestor, time);
    }

    public static native int nXCheckTypedEvent(long var0, int var2, long var3);

    public static int XCheckTypedEvent(long display, int event_type, ByteBuffer event_return) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)event_return, XEvent.SIZEOF);
        }
        return Xlib.nXCheckTypedEvent(display, event_type, MemoryUtil.memAddress(event_return));
    }

    public static native long nXCreatePixmap(long var0, long var2, int var4, int var5, int var6);

    public static long XCreatePixmap(long display, long d, int width, int height, int depth) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXCreatePixmap(display, d, width, height, depth);
    }

    public static native long nXCreateGC(long var0, long var2, long var4, long var6);

    public static long XCreateGC(long display, long d, long valuemask, ByteBuffer values) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)values, XGCValues.SIZEOF);
        }
        return Xlib.nXCreateGC(display, d, valuemask, MemoryUtil.memAddress(values));
    }

    public static native int nXFillRectangle(long var0, long var2, long var4, int var6, int var7, int var8, int var9);

    public static int XFillRectangle(long display, long d, long gc, int x, int y, int width, int height) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(gc);
        }
        return Xlib.nXFillRectangle(display, d, gc, x, y, width, height);
    }

    public static native long nXCreatePixmapCursor(long var0, long var2, long var4, long var6, long var8, int var10, int var11);

    public static long XCreatePixmapCursor(long display, long source, long mask, ByteBuffer foreground_color, ByteBuffer background_color, int x, int y) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)foreground_color, XColor.SIZEOF);
            Checks.checkBuffer((Buffer)background_color, XColor.SIZEOF);
        }
        return Xlib.nXCreatePixmapCursor(display, source, mask, MemoryUtil.memAddress(foreground_color), MemoryUtil.memAddress(background_color), x, y);
    }

    public static native int nXFreePixmap(long var0, long var2);

    public static int XFreePixmap(long display, long pixmap) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xlib.nXFreePixmap(display, pixmap);
    }

    public static native int nXFreeGC(long var0, long var2);

    public static int XFreeGC(long display, long gc) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkPointer(gc);
        }
        return Xlib.nXFreeGC(display, gc);
    }

    static {
        Sys.touch();
    }
}

