/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.linux.XkbKeyAliasRec;
import org.lwjgl.system.linux.XkbKeyNameRec;

public final class XkbNamesRec {
    public static final int SIZEOF;
    public static final int KEYCODES;
    public static final int GEOMETRY;
    public static final int SYMBOLS;
    public static final int TYPES;
    public static final int COMPAT;
    public static final int VMODS;
    public static final int INDICATORS;
    public static final int GROUPS;
    public static final int KEYS;
    public static final int KEY_ALIASES;
    public static final int RADIO_GROUPS;
    public static final int PHYS_SYMBOLS;
    public static final int NUM_KEYS;
    public static final int NUM_KEY_ALIASES;
    public static final int NUM_RG;

    private XkbNamesRec() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long keycodes, long geometry, long symbols, long types, long compat, long vmods, int vmodsBytes, long indicators, int indicatorsBytes, long groups, int groupsBytes, long keys, long key_aliases, long radio_groups, long phys_symbols, int num_keys, int num_key_aliases, int num_rg) {
        ByteBuffer xkbnamesrec = XkbNamesRec.malloc();
        XkbNamesRec.keycodes(xkbnamesrec, keycodes);
        XkbNamesRec.geometry(xkbnamesrec, geometry);
        XkbNamesRec.symbols(xkbnamesrec, symbols);
        XkbNamesRec.types(xkbnamesrec, types);
        XkbNamesRec.compat(xkbnamesrec, compat);
        XkbNamesRec.vmodsSet(xkbnamesrec, vmods, vmodsBytes);
        XkbNamesRec.indicatorsSet(xkbnamesrec, indicators, indicatorsBytes);
        XkbNamesRec.groupsSet(xkbnamesrec, groups, groupsBytes);
        XkbNamesRec.keys(xkbnamesrec, keys);
        XkbNamesRec.key_aliases(xkbnamesrec, key_aliases);
        XkbNamesRec.radio_groups(xkbnamesrec, radio_groups);
        XkbNamesRec.phys_symbols(xkbnamesrec, phys_symbols);
        XkbNamesRec.num_keys(xkbnamesrec, num_keys);
        XkbNamesRec.num_key_aliases(xkbnamesrec, num_key_aliases);
        XkbNamesRec.num_rg(xkbnamesrec, num_rg);
        return xkbnamesrec;
    }

    public static ByteBuffer malloc(long keycodes, long geometry, long symbols, long types, long compat, ByteBuffer vmods, ByteBuffer indicators, ByteBuffer groups, ByteBuffer keys, ByteBuffer key_aliases, ByteBuffer radio_groups, long phys_symbols, int num_keys, int num_key_aliases, int num_rg) {
        ByteBuffer xkbnamesrec = XkbNamesRec.malloc();
        XkbNamesRec.keycodes(xkbnamesrec, keycodes);
        XkbNamesRec.geometry(xkbnamesrec, geometry);
        XkbNamesRec.symbols(xkbnamesrec, symbols);
        XkbNamesRec.types(xkbnamesrec, types);
        XkbNamesRec.compat(xkbnamesrec, compat);
        XkbNamesRec.vmodsSet(xkbnamesrec, vmods);
        XkbNamesRec.indicatorsSet(xkbnamesrec, indicators);
        XkbNamesRec.groupsSet(xkbnamesrec, groups);
        XkbNamesRec.keys(xkbnamesrec, keys);
        XkbNamesRec.key_aliases(xkbnamesrec, key_aliases);
        XkbNamesRec.radio_groups(xkbnamesrec, radio_groups);
        XkbNamesRec.phys_symbols(xkbnamesrec, phys_symbols);
        XkbNamesRec.num_keys(xkbnamesrec, num_keys);
        XkbNamesRec.num_key_aliases(xkbnamesrec, num_key_aliases);
        XkbNamesRec.num_rg(xkbnamesrec, num_rg);
        return xkbnamesrec;
    }

    public static void keycodes(ByteBuffer xkbnamesrec, long keycodes) {
        PointerBuffer.put(xkbnamesrec, xkbnamesrec.position() + KEYCODES, keycodes);
    }

    public static void geometry(ByteBuffer xkbnamesrec, long geometry) {
        PointerBuffer.put(xkbnamesrec, xkbnamesrec.position() + GEOMETRY, geometry);
    }

    public static void symbols(ByteBuffer xkbnamesrec, long symbols) {
        PointerBuffer.put(xkbnamesrec, xkbnamesrec.position() + SYMBOLS, symbols);
    }

    public static void types(ByteBuffer xkbnamesrec, long types) {
        PointerBuffer.put(xkbnamesrec, xkbnamesrec.position() + TYPES, types);
    }

    public static void compat(ByteBuffer xkbnamesrec, long compat) {
        PointerBuffer.put(xkbnamesrec, xkbnamesrec.position() + COMPAT, compat);
    }

    public static void vmodsSet(ByteBuffer xkbnamesrec, long vmods, int bytes) {
        MemoryUtil.memCopy(vmods, MemoryUtil.memAddress(xkbnamesrec) + (long)VMODS, bytes);
    }

    public static void vmodsSet(ByteBuffer xkbnamesrec, ByteBuffer vmods) {
        Checks.checkBufferGT(vmods, 128);
        XkbNamesRec.vmodsSet(xkbnamesrec, MemoryUtil.memAddress(vmods), vmods.remaining());
    }

    public static void indicatorsSet(ByteBuffer xkbnamesrec, long indicators, int bytes) {
        MemoryUtil.memCopy(indicators, MemoryUtil.memAddress(xkbnamesrec) + (long)INDICATORS, bytes);
    }

    public static void indicatorsSet(ByteBuffer xkbnamesrec, ByteBuffer indicators) {
        Checks.checkBufferGT(indicators, 256);
        XkbNamesRec.indicatorsSet(xkbnamesrec, MemoryUtil.memAddress(indicators), indicators.remaining());
    }

    public static void groupsSet(ByteBuffer xkbnamesrec, long groups, int bytes) {
        MemoryUtil.memCopy(groups, MemoryUtil.memAddress(xkbnamesrec) + (long)GROUPS, bytes);
    }

    public static void groupsSet(ByteBuffer xkbnamesrec, ByteBuffer groups) {
        Checks.checkBufferGT(groups, 32);
        XkbNamesRec.groupsSet(xkbnamesrec, MemoryUtil.memAddress(groups), groups.remaining());
    }

    public static void keys(ByteBuffer xkbnamesrec, long keys) {
        PointerBuffer.put(xkbnamesrec, xkbnamesrec.position() + KEYS, keys);
    }

    public static void keys(ByteBuffer xkbnamesrec, ByteBuffer keys) {
        XkbNamesRec.keys(xkbnamesrec, MemoryUtil.memAddress(keys));
    }

    public static void key_aliases(ByteBuffer xkbnamesrec, long key_aliases) {
        PointerBuffer.put(xkbnamesrec, xkbnamesrec.position() + KEY_ALIASES, key_aliases);
    }

    public static void key_aliases(ByteBuffer xkbnamesrec, ByteBuffer key_aliases) {
        XkbNamesRec.key_aliases(xkbnamesrec, MemoryUtil.memAddress(key_aliases));
    }

    public static void radio_groups(ByteBuffer xkbnamesrec, long radio_groups) {
        PointerBuffer.put(xkbnamesrec, xkbnamesrec.position() + RADIO_GROUPS, radio_groups);
    }

    public static void radio_groups(ByteBuffer xkbnamesrec, ByteBuffer radio_groups) {
        XkbNamesRec.radio_groups(xkbnamesrec, MemoryUtil.memAddress(radio_groups));
    }

    public static void phys_symbols(ByteBuffer xkbnamesrec, long phys_symbols) {
        PointerBuffer.put(xkbnamesrec, xkbnamesrec.position() + PHYS_SYMBOLS, phys_symbols);
    }

    public static void num_keys(ByteBuffer xkbnamesrec, int num_keys) {
        xkbnamesrec.put(xkbnamesrec.position() + NUM_KEYS, (byte)num_keys);
    }

    public static void num_key_aliases(ByteBuffer xkbnamesrec, int num_key_aliases) {
        xkbnamesrec.put(xkbnamesrec.position() + NUM_KEY_ALIASES, (byte)num_key_aliases);
    }

    public static void num_rg(ByteBuffer xkbnamesrec, int num_rg) {
        xkbnamesrec.putShort(xkbnamesrec.position() + NUM_RG, (short)num_rg);
    }

    public static long keycodes(ByteBuffer xkbnamesrec) {
        return PointerBuffer.get(xkbnamesrec, xkbnamesrec.position() + KEYCODES);
    }

    public static long geometry(ByteBuffer xkbnamesrec) {
        return PointerBuffer.get(xkbnamesrec, xkbnamesrec.position() + GEOMETRY);
    }

    public static long symbols(ByteBuffer xkbnamesrec) {
        return PointerBuffer.get(xkbnamesrec, xkbnamesrec.position() + SYMBOLS);
    }

    public static long types(ByteBuffer xkbnamesrec) {
        return PointerBuffer.get(xkbnamesrec, xkbnamesrec.position() + TYPES);
    }

    public static long compat(ByteBuffer xkbnamesrec) {
        return PointerBuffer.get(xkbnamesrec, xkbnamesrec.position() + COMPAT);
    }

    public static void vmodsGet(ByteBuffer xkbnamesrec, long vmods, int bytes) {
        MemoryUtil.memCopy(MemoryUtil.memAddress(xkbnamesrec) + (long)VMODS, vmods, bytes);
    }

    public static void vmodsGet(ByteBuffer xkbnamesrec, ByteBuffer vmods) {
        Checks.checkBufferGT(vmods, 128);
        XkbNamesRec.vmodsGet(xkbnamesrec, MemoryUtil.memAddress(vmods), vmods.remaining());
    }

    public static void indicatorsGet(ByteBuffer xkbnamesrec, long indicators, int bytes) {
        MemoryUtil.memCopy(MemoryUtil.memAddress(xkbnamesrec) + (long)INDICATORS, indicators, bytes);
    }

    public static void indicatorsGet(ByteBuffer xkbnamesrec, ByteBuffer indicators) {
        Checks.checkBufferGT(indicators, 256);
        XkbNamesRec.indicatorsGet(xkbnamesrec, MemoryUtil.memAddress(indicators), indicators.remaining());
    }

    public static void groupsGet(ByteBuffer xkbnamesrec, long groups, int bytes) {
        MemoryUtil.memCopy(MemoryUtil.memAddress(xkbnamesrec) + (long)GROUPS, groups, bytes);
    }

    public static void groupsGet(ByteBuffer xkbnamesrec, ByteBuffer groups) {
        Checks.checkBufferGT(groups, 32);
        XkbNamesRec.groupsGet(xkbnamesrec, MemoryUtil.memAddress(groups), groups.remaining());
    }

    public static long keys(ByteBuffer xkbnamesrec) {
        return PointerBuffer.get(xkbnamesrec, xkbnamesrec.position() + KEYS);
    }

    public static ByteBuffer keysb(ByteBuffer xkbnamesrec) {
        return MemoryUtil.memByteBuffer(XkbNamesRec.keys(xkbnamesrec), XkbKeyNameRec.SIZEOF);
    }

    public static long key_aliases(ByteBuffer xkbnamesrec) {
        return PointerBuffer.get(xkbnamesrec, xkbnamesrec.position() + KEY_ALIASES);
    }

    public static ByteBuffer key_aliasesb(ByteBuffer xkbnamesrec) {
        return MemoryUtil.memByteBuffer(XkbNamesRec.key_aliases(xkbnamesrec), XkbKeyAliasRec.SIZEOF);
    }

    public static long radio_groups(ByteBuffer xkbnamesrec) {
        return PointerBuffer.get(xkbnamesrec, xkbnamesrec.position() + RADIO_GROUPS);
    }

    public static ByteBuffer radio_groups(ByteBuffer xkbnamesrec, int size) {
        long address = XkbNamesRec.radio_groups(xkbnamesrec);
        return address == 0L ? null : MemoryUtil.memByteBuffer(address, size);
    }

    public static long phys_symbols(ByteBuffer xkbnamesrec) {
        return PointerBuffer.get(xkbnamesrec, xkbnamesrec.position() + PHYS_SYMBOLS);
    }

    public static int num_keys(ByteBuffer xkbnamesrec) {
        return xkbnamesrec.get(xkbnamesrec.position() + NUM_KEYS) & 0xFF;
    }

    public static int num_key_aliases(ByteBuffer xkbnamesrec) {
        return xkbnamesrec.get(xkbnamesrec.position() + NUM_KEY_ALIASES) & 0xFF;
    }

    public static int num_rg(ByteBuffer xkbnamesrec) {
        return xkbnamesrec.getShort(xkbnamesrec.position() + NUM_RG) & 0xFFFF;
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(15);
        SIZEOF = XkbNamesRec.offsets(MemoryUtil.memAddress(offsets));
        KEYCODES = offsets.get(0);
        GEOMETRY = offsets.get(1);
        SYMBOLS = offsets.get(2);
        TYPES = offsets.get(3);
        COMPAT = offsets.get(4);
        VMODS = offsets.get(5);
        INDICATORS = offsets.get(6);
        GROUPS = offsets.get(7);
        KEYS = offsets.get(8);
        KEY_ALIASES = offsets.get(9);
        RADIO_GROUPS = offsets.get(10);
        PHYS_SYMBOLS = offsets.get(11);
        NUM_KEYS = offsets.get(12);
        NUM_KEY_ALIASES = offsets.get(13);
        NUM_RG = offsets.get(14);
    }
}

