/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class XkbKeyNameRec {
    public static final int SIZEOF;
    public static final int NAME;

    private XkbKeyNameRec() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long name, int nameBytes) {
        ByteBuffer xkbkeynamerec = XkbKeyNameRec.malloc();
        XkbKeyNameRec.nameSet(xkbkeynamerec, name, nameBytes);
        return xkbkeynamerec;
    }

    public static ByteBuffer malloc(ByteBuffer name) {
        ByteBuffer xkbkeynamerec = XkbKeyNameRec.malloc();
        XkbKeyNameRec.nameSet(xkbkeynamerec, name);
        return xkbkeynamerec;
    }

    public static ByteBuffer malloc(CharSequence name) {
        ByteBuffer xkbkeynamerec = XkbKeyNameRec.malloc();
        XkbKeyNameRec.nameSet(xkbkeynamerec, name);
        return xkbkeynamerec;
    }

    public static void nameSet(ByteBuffer xkbkeynamerec, long name, int bytes) {
        MemoryUtil.memCopy(name, MemoryUtil.memAddress(xkbkeynamerec) + (long)NAME, bytes);
    }

    public static void nameSet(ByteBuffer xkbkeynamerec, ByteBuffer name) {
        Checks.checkNT1(name);
        Checks.checkBufferGT(name, 4);
        XkbKeyNameRec.nameSet(xkbkeynamerec, MemoryUtil.memAddress(name), name.remaining());
    }

    public static void nameSet(ByteBuffer xkbkeynamerec, CharSequence name) {
        ByteBuffer buffer = MemoryUtil.memEncodeASCII(name, false);
        XkbKeyNameRec.nameSet(xkbkeynamerec, MemoryUtil.memAddress(buffer), buffer.capacity());
    }

    public static void nameGet(ByteBuffer xkbkeynamerec, long name, int bytes) {
        MemoryUtil.memCopy(MemoryUtil.memAddress(xkbkeynamerec) + (long)NAME, name, bytes);
    }

    public static void nameGet(ByteBuffer xkbkeynamerec, ByteBuffer name) {
        Checks.checkBufferGT(name, 4);
        XkbKeyNameRec.nameGet(xkbkeynamerec, MemoryUtil.memAddress(name), name.remaining());
    }

    public static String nameGets(ByteBuffer xkbkeynamerec) {
        return MemoryUtil.memDecodeASCII(xkbkeynamerec, 4, NAME);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(1);
        SIZEOF = XkbKeyNameRec.offsets(MemoryUtil.memAddress(offsets));
        NAME = offsets.get(0);
    }
}

