/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class XkbKeyAliasRec {
    public static final int SIZEOF;
    public static final int REAL;
    public static final int ALIAS;

    private XkbKeyAliasRec() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long real, int realBytes, long alias, int aliasBytes) {
        ByteBuffer xkbkeyaliasrec = XkbKeyAliasRec.malloc();
        XkbKeyAliasRec.realSet(xkbkeyaliasrec, real, realBytes);
        XkbKeyAliasRec.aliasSet(xkbkeyaliasrec, alias, aliasBytes);
        return xkbkeyaliasrec;
    }

    public static ByteBuffer malloc(ByteBuffer real, ByteBuffer alias) {
        ByteBuffer xkbkeyaliasrec = XkbKeyAliasRec.malloc();
        XkbKeyAliasRec.realSet(xkbkeyaliasrec, real);
        XkbKeyAliasRec.aliasSet(xkbkeyaliasrec, alias);
        return xkbkeyaliasrec;
    }

    public static ByteBuffer malloc(CharSequence real, CharSequence alias) {
        ByteBuffer xkbkeyaliasrec = XkbKeyAliasRec.malloc();
        XkbKeyAliasRec.realSet(xkbkeyaliasrec, real);
        XkbKeyAliasRec.aliasSet(xkbkeyaliasrec, alias);
        return xkbkeyaliasrec;
    }

    public static void realSet(ByteBuffer xkbkeyaliasrec, long real, int bytes) {
        MemoryUtil.memCopy(real, MemoryUtil.memAddress(xkbkeyaliasrec) + (long)REAL, bytes);
    }

    public static void realSet(ByteBuffer xkbkeyaliasrec, ByteBuffer real) {
        Checks.checkNT1(real);
        Checks.checkBufferGT(real, 4);
        XkbKeyAliasRec.realSet(xkbkeyaliasrec, MemoryUtil.memAddress(real), real.remaining());
    }

    public static void realSet(ByteBuffer xkbkeyaliasrec, CharSequence real) {
        ByteBuffer buffer = MemoryUtil.memEncodeASCII(real, false);
        XkbKeyAliasRec.realSet(xkbkeyaliasrec, MemoryUtil.memAddress(buffer), buffer.capacity());
    }

    public static void aliasSet(ByteBuffer xkbkeyaliasrec, long alias, int bytes) {
        MemoryUtil.memCopy(alias, MemoryUtil.memAddress(xkbkeyaliasrec) + (long)ALIAS, bytes);
    }

    public static void aliasSet(ByteBuffer xkbkeyaliasrec, ByteBuffer alias) {
        Checks.checkNT1(alias);
        Checks.checkBufferGT(alias, 4);
        XkbKeyAliasRec.aliasSet(xkbkeyaliasrec, MemoryUtil.memAddress(alias), alias.remaining());
    }

    public static void aliasSet(ByteBuffer xkbkeyaliasrec, CharSequence alias) {
        ByteBuffer buffer = MemoryUtil.memEncodeASCII(alias, false);
        XkbKeyAliasRec.aliasSet(xkbkeyaliasrec, MemoryUtil.memAddress(buffer), buffer.capacity());
    }

    public static void realGet(ByteBuffer xkbkeyaliasrec, long real, int bytes) {
        MemoryUtil.memCopy(MemoryUtil.memAddress(xkbkeyaliasrec) + (long)REAL, real, bytes);
    }

    public static void realGet(ByteBuffer xkbkeyaliasrec, ByteBuffer real) {
        Checks.checkBufferGT(real, 4);
        XkbKeyAliasRec.realGet(xkbkeyaliasrec, MemoryUtil.memAddress(real), real.remaining());
    }

    public static String realGets(ByteBuffer xkbkeyaliasrec) {
        return MemoryUtil.memDecodeASCII(xkbkeyaliasrec, 4, REAL);
    }

    public static void aliasGet(ByteBuffer xkbkeyaliasrec, long alias, int bytes) {
        MemoryUtil.memCopy(MemoryUtil.memAddress(xkbkeyaliasrec) + (long)ALIAS, alias, bytes);
    }

    public static void aliasGet(ByteBuffer xkbkeyaliasrec, ByteBuffer alias) {
        Checks.checkBufferGT(alias, 4);
        XkbKeyAliasRec.aliasGet(xkbkeyaliasrec, MemoryUtil.memAddress(alias), alias.remaining());
    }

    public static String aliasGets(ByteBuffer xkbkeyaliasrec) {
        return MemoryUtil.memDecodeASCII(xkbkeyaliasrec, 4, ALIAS);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(2);
        SIZEOF = XkbKeyAliasRec.offsets(MemoryUtil.memAddress(offsets));
        REAL = offsets.get(0);
        ALIAS = offsets.get(1);
    }
}

