/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.linux.XkbNamesRec;

public final class XkbDescRec {
    public static final int SIZEOF;
    public static final int DPY;
    public static final int DEVICE_SPEC;
    public static final int MIN_KEY_CODE;
    public static final int MAX_KEY_CODE;
    public static final int NAMES;

    private XkbDescRec() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long dpy, int device_spec, int min_key_code, int max_key_code, long names) {
        ByteBuffer xkbdescrec = XkbDescRec.malloc();
        XkbDescRec.dpy(xkbdescrec, dpy);
        XkbDescRec.device_spec(xkbdescrec, device_spec);
        XkbDescRec.min_key_code(xkbdescrec, min_key_code);
        XkbDescRec.max_key_code(xkbdescrec, max_key_code);
        XkbDescRec.names(xkbdescrec, names);
        return xkbdescrec;
    }

    public static ByteBuffer malloc(long dpy, int device_spec, int min_key_code, int max_key_code, ByteBuffer names) {
        ByteBuffer xkbdescrec = XkbDescRec.malloc();
        XkbDescRec.dpy(xkbdescrec, dpy);
        XkbDescRec.device_spec(xkbdescrec, device_spec);
        XkbDescRec.min_key_code(xkbdescrec, min_key_code);
        XkbDescRec.max_key_code(xkbdescrec, max_key_code);
        XkbDescRec.names(xkbdescrec, names);
        return xkbdescrec;
    }

    public static void dpy(ByteBuffer xkbdescrec, long dpy) {
        PointerBuffer.put(xkbdescrec, xkbdescrec.position() + DPY, dpy);
    }

    public static void device_spec(ByteBuffer xkbdescrec, int device_spec) {
        xkbdescrec.putShort(xkbdescrec.position() + DEVICE_SPEC, (short)device_spec);
    }

    public static void min_key_code(ByteBuffer xkbdescrec, int min_key_code) {
        xkbdescrec.put(xkbdescrec.position() + MIN_KEY_CODE, (byte)min_key_code);
    }

    public static void max_key_code(ByteBuffer xkbdescrec, int max_key_code) {
        xkbdescrec.put(xkbdescrec.position() + MAX_KEY_CODE, (byte)max_key_code);
    }

    public static void names(ByteBuffer xkbdescrec, long names) {
        PointerBuffer.put(xkbdescrec, xkbdescrec.position() + NAMES, names);
    }

    public static void names(ByteBuffer xkbdescrec, ByteBuffer names) {
        XkbDescRec.names(xkbdescrec, MemoryUtil.memAddress(names));
    }

    public static long dpy(ByteBuffer xkbdescrec) {
        return PointerBuffer.get(xkbdescrec, xkbdescrec.position() + DPY);
    }

    public static int device_spec(ByteBuffer xkbdescrec) {
        return xkbdescrec.getShort(xkbdescrec.position() + DEVICE_SPEC) & 0xFFFF;
    }

    public static int min_key_code(ByteBuffer xkbdescrec) {
        return xkbdescrec.get(xkbdescrec.position() + MIN_KEY_CODE) & 0xFF;
    }

    public static int max_key_code(ByteBuffer xkbdescrec) {
        return xkbdescrec.get(xkbdescrec.position() + MAX_KEY_CODE) & 0xFF;
    }

    public static long names(ByteBuffer xkbdescrec) {
        return PointerBuffer.get(xkbdescrec, xkbdescrec.position() + NAMES);
    }

    public static ByteBuffer namesb(ByteBuffer xkbdescrec) {
        return MemoryUtil.memByteBuffer(XkbDescRec.names(xkbdescrec), XkbNamesRec.SIZEOF);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(5);
        SIZEOF = XkbDescRec.offsets(MemoryUtil.memAddress(offsets));
        DPY = offsets.get(0);
        DEVICE_SPEC = offsets.get(1);
        MIN_KEY_CODE = offsets.get(2);
        MAX_KEY_CODE = offsets.get(3);
        NAMES = offsets.get(4);
    }
}

