/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class Xf86vmode {
    private Xf86vmode() {
    }

    public static native int nXF86VidModeQueryExtension(long var0, long var2, long var4);

    public static int XF86VidModeQueryExtension(long display, ByteBuffer event_base, ByteBuffer error_base) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)event_base, 4);
            Checks.checkBuffer((Buffer)error_base, 4);
        }
        return Xf86vmode.nXF86VidModeQueryExtension(display, MemoryUtil.memAddress(event_base), MemoryUtil.memAddress(error_base));
    }

    public static int XF86VidModeQueryExtension(long display, IntBuffer event_base, IntBuffer error_base) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)event_base, 1);
            Checks.checkBuffer((Buffer)error_base, 1);
        }
        return Xf86vmode.nXF86VidModeQueryExtension(display, MemoryUtil.memAddress(event_base), MemoryUtil.memAddress(error_base));
    }

    public static native int nXF86VidModeGetGammaRampSize(long var0, int var2, long var3);

    public static int XF86VidModeGetGammaRampSize(long display, int screen, ByteBuffer size) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xf86vmode.nXF86VidModeGetGammaRampSize(display, screen, MemoryUtil.memAddress(size));
    }

    public static int XF86VidModeGetGammaRampSize(long display, int screen, IntBuffer size) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return Xf86vmode.nXF86VidModeGetGammaRampSize(display, screen, MemoryUtil.memAddress(size));
    }

    public static native int nXF86VidModeGetGammaRamp(long var0, int var2, int var3, long var4, long var6, long var8);

    public static int XF86VidModeGetGammaRamp(long display, int screen, int size, ByteBuffer red_array, ByteBuffer green_array, ByteBuffer blue_array) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)red_array, size << 1);
            Checks.checkBuffer((Buffer)green_array, size << 1);
            Checks.checkBuffer((Buffer)blue_array, size << 1);
        }
        return Xf86vmode.nXF86VidModeGetGammaRamp(display, screen, size, MemoryUtil.memAddress(red_array), MemoryUtil.memAddress(green_array), MemoryUtil.memAddress(blue_array));
    }

    public static int XF86VidModeGetGammaRamp(long display, int screen, ShortBuffer red_array, ShortBuffer green_array, ShortBuffer blue_array) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)green_array, red_array.remaining());
            Checks.checkBuffer((Buffer)blue_array, red_array.remaining());
        }
        return Xf86vmode.nXF86VidModeGetGammaRamp(display, screen, red_array.remaining(), MemoryUtil.memAddress(red_array), MemoryUtil.memAddress(green_array), MemoryUtil.memAddress(blue_array));
    }

    public static native int nXF86VidModeSetGammaRamp(long var0, int var2, int var3, long var4, long var6, long var8);

    public static int XF86VidModeSetGammaRamp(long display, int screen, int size, ByteBuffer red_array, ByteBuffer green_array, ByteBuffer blue_array) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)red_array, size << 1);
            Checks.checkBuffer((Buffer)green_array, size << 1);
            Checks.checkBuffer((Buffer)blue_array, size << 1);
        }
        return Xf86vmode.nXF86VidModeSetGammaRamp(display, screen, size, MemoryUtil.memAddress(red_array), MemoryUtil.memAddress(green_array), MemoryUtil.memAddress(blue_array));
    }

    public static int XF86VidModeSetGammaRamp(long display, int screen, ShortBuffer red_array, ShortBuffer green_array, ShortBuffer blue_array) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)green_array, red_array.remaining());
            Checks.checkBuffer((Buffer)blue_array, red_array.remaining());
        }
        return Xf86vmode.nXF86VidModeSetGammaRamp(display, screen, red_array.remaining(), MemoryUtil.memAddress(red_array), MemoryUtil.memAddress(green_array), MemoryUtil.memAddress(blue_array));
    }

    static {
        Sys.touch();
    }
}

