/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.linux.XRRModeInfo;

public final class XRRScreenResources {
    public static final int SIZEOF;
    public static final int TIMESTAMP;
    public static final int CONFIGTIMESTAMP;
    public static final int NCRTC;
    public static final int CRTCS;
    public static final int NOUTPUT;
    public static final int OUTPUTS;
    public static final int NMODE;
    public static final int MODES;

    private XRRScreenResources() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long timestamp, long configTimestamp, int ncrtc, long crtcs, int noutput, long outputs, int nmode, long modes) {
        ByteBuffer xrrscreenresources = XRRScreenResources.malloc();
        XRRScreenResources.timestamp(xrrscreenresources, timestamp);
        XRRScreenResources.configTimestamp(xrrscreenresources, configTimestamp);
        XRRScreenResources.ncrtc(xrrscreenresources, ncrtc);
        XRRScreenResources.crtcs(xrrscreenresources, crtcs);
        XRRScreenResources.noutput(xrrscreenresources, noutput);
        XRRScreenResources.outputs(xrrscreenresources, outputs);
        XRRScreenResources.nmode(xrrscreenresources, nmode);
        XRRScreenResources.modes(xrrscreenresources, modes);
        return xrrscreenresources;
    }

    public static ByteBuffer malloc(long timestamp, long configTimestamp, int ncrtc, ByteBuffer crtcs, int noutput, ByteBuffer outputs, int nmode, ByteBuffer modes) {
        ByteBuffer xrrscreenresources = XRRScreenResources.malloc();
        XRRScreenResources.timestamp(xrrscreenresources, timestamp);
        XRRScreenResources.configTimestamp(xrrscreenresources, configTimestamp);
        XRRScreenResources.ncrtc(xrrscreenresources, ncrtc);
        XRRScreenResources.crtcs(xrrscreenresources, crtcs);
        XRRScreenResources.noutput(xrrscreenresources, noutput);
        XRRScreenResources.outputs(xrrscreenresources, outputs);
        XRRScreenResources.nmode(xrrscreenresources, nmode);
        XRRScreenResources.modes(xrrscreenresources, modes);
        return xrrscreenresources;
    }

    public static void timestamp(ByteBuffer xrrscreenresources, long timestamp) {
        PointerBuffer.put(xrrscreenresources, xrrscreenresources.position() + TIMESTAMP, timestamp);
    }

    public static void configTimestamp(ByteBuffer xrrscreenresources, long configTimestamp) {
        PointerBuffer.put(xrrscreenresources, xrrscreenresources.position() + CONFIGTIMESTAMP, configTimestamp);
    }

    public static void ncrtc(ByteBuffer xrrscreenresources, int ncrtc) {
        xrrscreenresources.putInt(xrrscreenresources.position() + NCRTC, ncrtc);
    }

    public static void crtcs(ByteBuffer xrrscreenresources, long crtcs) {
        PointerBuffer.put(xrrscreenresources, xrrscreenresources.position() + CRTCS, crtcs);
    }

    public static void crtcs(ByteBuffer xrrscreenresources, ByteBuffer crtcs) {
        XRRScreenResources.crtcs(xrrscreenresources, MemoryUtil.memAddress(crtcs));
    }

    public static void noutput(ByteBuffer xrrscreenresources, int noutput) {
        xrrscreenresources.putInt(xrrscreenresources.position() + NOUTPUT, noutput);
    }

    public static void outputs(ByteBuffer xrrscreenresources, long outputs) {
        PointerBuffer.put(xrrscreenresources, xrrscreenresources.position() + OUTPUTS, outputs);
    }

    public static void outputs(ByteBuffer xrrscreenresources, ByteBuffer outputs) {
        XRRScreenResources.outputs(xrrscreenresources, MemoryUtil.memAddress(outputs));
    }

    public static void nmode(ByteBuffer xrrscreenresources, int nmode) {
        xrrscreenresources.putInt(xrrscreenresources.position() + NMODE, nmode);
    }

    public static void modes(ByteBuffer xrrscreenresources, long modes) {
        PointerBuffer.put(xrrscreenresources, xrrscreenresources.position() + MODES, modes);
    }

    public static void modes(ByteBuffer xrrscreenresources, ByteBuffer modes) {
        XRRScreenResources.modes(xrrscreenresources, MemoryUtil.memAddress(modes));
    }

    public static long timestamp(ByteBuffer xrrscreenresources) {
        return PointerBuffer.get(xrrscreenresources, xrrscreenresources.position() + TIMESTAMP);
    }

    public static long configTimestamp(ByteBuffer xrrscreenresources) {
        return PointerBuffer.get(xrrscreenresources, xrrscreenresources.position() + CONFIGTIMESTAMP);
    }

    public static int ncrtc(ByteBuffer xrrscreenresources) {
        return xrrscreenresources.getInt(xrrscreenresources.position() + NCRTC);
    }

    public static long crtcs(ByteBuffer xrrscreenresources) {
        return PointerBuffer.get(xrrscreenresources, xrrscreenresources.position() + CRTCS);
    }

    public static ByteBuffer crtcs(ByteBuffer xrrscreenresources, int size) {
        long address = XRRScreenResources.crtcs(xrrscreenresources);
        return address == 0L ? null : MemoryUtil.memByteBuffer(address, size);
    }

    public static int noutput(ByteBuffer xrrscreenresources) {
        return xrrscreenresources.getInt(xrrscreenresources.position() + NOUTPUT);
    }

    public static long outputs(ByteBuffer xrrscreenresources) {
        return PointerBuffer.get(xrrscreenresources, xrrscreenresources.position() + OUTPUTS);
    }

    public static ByteBuffer outputs(ByteBuffer xrrscreenresources, int size) {
        long address = XRRScreenResources.outputs(xrrscreenresources);
        return address == 0L ? null : MemoryUtil.memByteBuffer(address, size);
    }

    public static int nmode(ByteBuffer xrrscreenresources) {
        return xrrscreenresources.getInt(xrrscreenresources.position() + NMODE);
    }

    public static long modes(ByteBuffer xrrscreenresources) {
        return PointerBuffer.get(xrrscreenresources, xrrscreenresources.position() + MODES);
    }

    public static ByteBuffer modesb(ByteBuffer xrrscreenresources) {
        return MemoryUtil.memByteBuffer(XRRScreenResources.modes(xrrscreenresources), XRRModeInfo.SIZEOF);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(8);
        SIZEOF = XRRScreenResources.offsets(MemoryUtil.memAddress(offsets));
        TIMESTAMP = offsets.get(0);
        CONFIGTIMESTAMP = offsets.get(1);
        NCRTC = offsets.get(2);
        CRTCS = offsets.get(3);
        NOUTPUT = offsets.get(4);
        OUTPUTS = offsets.get(5);
        NMODE = offsets.get(6);
        MODES = offsets.get(7);
    }
}

