/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;

public final class XRRCrtcInfo {
    public static final int SIZEOF;
    public static final int TIMESTAMP;
    public static final int X;
    public static final int Y;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int MODE;
    public static final int ROTATION;
    public static final int NOUTPUT;
    public static final int OUTPUTS;
    public static final int ROTATIONS;
    public static final int NPOSSIBLE;
    public static final int POSSIBLE;

    private XRRCrtcInfo() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long timestamp, int x, int y, int width, int height, long mode, int rotation, int noutput, long outputs, int rotations, int npossible, long possible) {
        ByteBuffer xrrcrtcinfo = XRRCrtcInfo.malloc();
        XRRCrtcInfo.timestamp(xrrcrtcinfo, timestamp);
        XRRCrtcInfo.x(xrrcrtcinfo, x);
        XRRCrtcInfo.y(xrrcrtcinfo, y);
        XRRCrtcInfo.width(xrrcrtcinfo, width);
        XRRCrtcInfo.height(xrrcrtcinfo, height);
        XRRCrtcInfo.mode(xrrcrtcinfo, mode);
        XRRCrtcInfo.rotation(xrrcrtcinfo, rotation);
        XRRCrtcInfo.noutput(xrrcrtcinfo, noutput);
        XRRCrtcInfo.outputs(xrrcrtcinfo, outputs);
        XRRCrtcInfo.rotations(xrrcrtcinfo, rotations);
        XRRCrtcInfo.npossible(xrrcrtcinfo, npossible);
        XRRCrtcInfo.possible(xrrcrtcinfo, possible);
        return xrrcrtcinfo;
    }

    public static ByteBuffer malloc(long timestamp, int x, int y, int width, int height, long mode, int rotation, int noutput, ByteBuffer outputs, int rotations, int npossible, ByteBuffer possible) {
        ByteBuffer xrrcrtcinfo = XRRCrtcInfo.malloc();
        XRRCrtcInfo.timestamp(xrrcrtcinfo, timestamp);
        XRRCrtcInfo.x(xrrcrtcinfo, x);
        XRRCrtcInfo.y(xrrcrtcinfo, y);
        XRRCrtcInfo.width(xrrcrtcinfo, width);
        XRRCrtcInfo.height(xrrcrtcinfo, height);
        XRRCrtcInfo.mode(xrrcrtcinfo, mode);
        XRRCrtcInfo.rotation(xrrcrtcinfo, rotation);
        XRRCrtcInfo.noutput(xrrcrtcinfo, noutput);
        XRRCrtcInfo.outputs(xrrcrtcinfo, outputs);
        XRRCrtcInfo.rotations(xrrcrtcinfo, rotations);
        XRRCrtcInfo.npossible(xrrcrtcinfo, npossible);
        XRRCrtcInfo.possible(xrrcrtcinfo, possible);
        return xrrcrtcinfo;
    }

    public static void timestamp(ByteBuffer xrrcrtcinfo, long timestamp) {
        PointerBuffer.put(xrrcrtcinfo, xrrcrtcinfo.position() + TIMESTAMP, timestamp);
    }

    public static void x(ByteBuffer xrrcrtcinfo, int x) {
        xrrcrtcinfo.putInt(xrrcrtcinfo.position() + X, x);
    }

    public static void y(ByteBuffer xrrcrtcinfo, int y) {
        xrrcrtcinfo.putInt(xrrcrtcinfo.position() + Y, y);
    }

    public static void width(ByteBuffer xrrcrtcinfo, int width) {
        xrrcrtcinfo.putInt(xrrcrtcinfo.position() + WIDTH, width);
    }

    public static void height(ByteBuffer xrrcrtcinfo, int height) {
        xrrcrtcinfo.putInt(xrrcrtcinfo.position() + HEIGHT, height);
    }

    public static void mode(ByteBuffer xrrcrtcinfo, long mode) {
        PointerBuffer.put(xrrcrtcinfo, xrrcrtcinfo.position() + MODE, mode);
    }

    public static void rotation(ByteBuffer xrrcrtcinfo, int rotation) {
        xrrcrtcinfo.putShort(xrrcrtcinfo.position() + ROTATION, (short)rotation);
    }

    public static void noutput(ByteBuffer xrrcrtcinfo, int noutput) {
        xrrcrtcinfo.putInt(xrrcrtcinfo.position() + NOUTPUT, noutput);
    }

    public static void outputs(ByteBuffer xrrcrtcinfo, long outputs) {
        PointerBuffer.put(xrrcrtcinfo, xrrcrtcinfo.position() + OUTPUTS, outputs);
    }

    public static void outputs(ByteBuffer xrrcrtcinfo, ByteBuffer outputs) {
        XRRCrtcInfo.outputs(xrrcrtcinfo, MemoryUtil.memAddress(outputs));
    }

    public static void rotations(ByteBuffer xrrcrtcinfo, int rotations) {
        xrrcrtcinfo.putShort(xrrcrtcinfo.position() + ROTATIONS, (short)rotations);
    }

    public static void npossible(ByteBuffer xrrcrtcinfo, int npossible) {
        xrrcrtcinfo.putInt(xrrcrtcinfo.position() + NPOSSIBLE, npossible);
    }

    public static void possible(ByteBuffer xrrcrtcinfo, long possible) {
        PointerBuffer.put(xrrcrtcinfo, xrrcrtcinfo.position() + POSSIBLE, possible);
    }

    public static void possible(ByteBuffer xrrcrtcinfo, ByteBuffer possible) {
        XRRCrtcInfo.possible(xrrcrtcinfo, MemoryUtil.memAddress(possible));
    }

    public static long timestamp(ByteBuffer xrrcrtcinfo) {
        return PointerBuffer.get(xrrcrtcinfo, xrrcrtcinfo.position() + TIMESTAMP);
    }

    public static int x(ByteBuffer xrrcrtcinfo) {
        return xrrcrtcinfo.getInt(xrrcrtcinfo.position() + X);
    }

    public static int y(ByteBuffer xrrcrtcinfo) {
        return xrrcrtcinfo.getInt(xrrcrtcinfo.position() + Y);
    }

    public static int width(ByteBuffer xrrcrtcinfo) {
        return xrrcrtcinfo.getInt(xrrcrtcinfo.position() + WIDTH);
    }

    public static int height(ByteBuffer xrrcrtcinfo) {
        return xrrcrtcinfo.getInt(xrrcrtcinfo.position() + HEIGHT);
    }

    public static long mode(ByteBuffer xrrcrtcinfo) {
        return PointerBuffer.get(xrrcrtcinfo, xrrcrtcinfo.position() + MODE);
    }

    public static int rotation(ByteBuffer xrrcrtcinfo) {
        return xrrcrtcinfo.getShort(xrrcrtcinfo.position() + ROTATION) & 0xFFFF;
    }

    public static int noutput(ByteBuffer xrrcrtcinfo) {
        return xrrcrtcinfo.getInt(xrrcrtcinfo.position() + NOUTPUT);
    }

    public static long outputs(ByteBuffer xrrcrtcinfo) {
        return PointerBuffer.get(xrrcrtcinfo, xrrcrtcinfo.position() + OUTPUTS);
    }

    public static ByteBuffer outputs(ByteBuffer xrrcrtcinfo, int size) {
        long address = XRRCrtcInfo.outputs(xrrcrtcinfo);
        return address == 0L ? null : MemoryUtil.memByteBuffer(address, size);
    }

    public static int rotations(ByteBuffer xrrcrtcinfo) {
        return xrrcrtcinfo.getShort(xrrcrtcinfo.position() + ROTATIONS) & 0xFFFF;
    }

    public static int npossible(ByteBuffer xrrcrtcinfo) {
        return xrrcrtcinfo.getInt(xrrcrtcinfo.position() + NPOSSIBLE);
    }

    public static long possible(ByteBuffer xrrcrtcinfo) {
        return PointerBuffer.get(xrrcrtcinfo, xrrcrtcinfo.position() + POSSIBLE);
    }

    public static ByteBuffer possible(ByteBuffer xrrcrtcinfo, int size) {
        long address = XRRCrtcInfo.possible(xrrcrtcinfo);
        return address == 0L ? null : MemoryUtil.memByteBuffer(address, size);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(12);
        SIZEOF = XRRCrtcInfo.offsets(MemoryUtil.memAddress(offsets));
        TIMESTAMP = offsets.get(0);
        X = offsets.get(1);
        Y = offsets.get(2);
        WIDTH = offsets.get(3);
        HEIGHT = offsets.get(4);
        MODE = offsets.get(5);
        ROTATION = offsets.get(6);
        NOUTPUT = offsets.get(7);
        OUTPUTS = offsets.get(8);
        ROTATIONS = offsets.get(9);
        NPOSSIBLE = offsets.get(10);
        POSSIBLE = offsets.get(11);
    }
}

