/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;

public final class XPropertyEvent {
    public static final int SIZEOF;
    public static final int TYPE;
    public static final int SERIAL;
    public static final int SEND_EVENT;
    public static final int DISPLAY;
    public static final int WINDOW;
    public static final int ATOM;
    public static final int TIME;
    public static final int STATE;

    private XPropertyEvent() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int type, long serial, int send_event, long display, long window, long atom, long time, int state) {
        ByteBuffer xpropertyevent = XPropertyEvent.malloc();
        XPropertyEvent.type(xpropertyevent, type);
        XPropertyEvent.serial(xpropertyevent, serial);
        XPropertyEvent.send_event(xpropertyevent, send_event);
        XPropertyEvent.display(xpropertyevent, display);
        XPropertyEvent.window(xpropertyevent, window);
        XPropertyEvent.atom(xpropertyevent, atom);
        XPropertyEvent.time(xpropertyevent, time);
        XPropertyEvent.state(xpropertyevent, state);
        return xpropertyevent;
    }

    public static void type(ByteBuffer xpropertyevent, int type) {
        xpropertyevent.putInt(xpropertyevent.position() + TYPE, type);
    }

    public static void serial(ByteBuffer xpropertyevent, long serial) {
        PointerBuffer.put(xpropertyevent, xpropertyevent.position() + SERIAL, serial);
    }

    public static void send_event(ByteBuffer xpropertyevent, int send_event) {
        xpropertyevent.putInt(xpropertyevent.position() + SEND_EVENT, send_event);
    }

    public static void display(ByteBuffer xpropertyevent, long display) {
        PointerBuffer.put(xpropertyevent, xpropertyevent.position() + DISPLAY, display);
    }

    public static void window(ByteBuffer xpropertyevent, long window) {
        PointerBuffer.put(xpropertyevent, xpropertyevent.position() + WINDOW, window);
    }

    public static void atom(ByteBuffer xpropertyevent, long atom) {
        PointerBuffer.put(xpropertyevent, xpropertyevent.position() + ATOM, atom);
    }

    public static void time(ByteBuffer xpropertyevent, long time) {
        PointerBuffer.put(xpropertyevent, xpropertyevent.position() + TIME, time);
    }

    public static void state(ByteBuffer xpropertyevent, int state) {
        xpropertyevent.putInt(xpropertyevent.position() + STATE, state);
    }

    public static int type(ByteBuffer xpropertyevent) {
        return xpropertyevent.getInt(xpropertyevent.position() + TYPE);
    }

    public static long serial(ByteBuffer xpropertyevent) {
        return PointerBuffer.get(xpropertyevent, xpropertyevent.position() + SERIAL);
    }

    public static int send_event(ByteBuffer xpropertyevent) {
        return xpropertyevent.getInt(xpropertyevent.position() + SEND_EVENT);
    }

    public static long display(ByteBuffer xpropertyevent) {
        return PointerBuffer.get(xpropertyevent, xpropertyevent.position() + DISPLAY);
    }

    public static long window(ByteBuffer xpropertyevent) {
        return PointerBuffer.get(xpropertyevent, xpropertyevent.position() + WINDOW);
    }

    public static long atom(ByteBuffer xpropertyevent) {
        return PointerBuffer.get(xpropertyevent, xpropertyevent.position() + ATOM);
    }

    public static long time(ByteBuffer xpropertyevent) {
        return PointerBuffer.get(xpropertyevent, xpropertyevent.position() + TIME);
    }

    public static int state(ByteBuffer xpropertyevent) {
        return xpropertyevent.getInt(xpropertyevent.position() + STATE);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(8);
        SIZEOF = XPropertyEvent.offsets(MemoryUtil.memAddress(offsets));
        TYPE = offsets.get(0);
        SERIAL = offsets.get(1);
        SEND_EVENT = offsets.get(2);
        DISPLAY = offsets.get(3);
        WINDOW = offsets.get(4);
        ATOM = offsets.get(5);
        TIME = offsets.get(6);
        STATE = offsets.get(7);
    }
}

