/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.linux.XkbDescRec;

public final class XKBlib {
    public static final int XkbUseCoreKbd = 256;
    public static final int XkbUseCorePtr = 512;
    public static final int XkbDfltXIClass = 768;
    public static final int XkbDfltXIId = 1024;
    public static final int XkbAllXIClasses = 1280;
    public static final int XkbAllXIIds = 1536;
    public static final int XkbXINone = 65280;
    public static final int XkbNumKbdGroups = 4;
    public static final int XkbNumModifiers = 8;
    public static final int XkbNumVirtualMods = 16;
    public static final int XkbNumIndicators = 32;
    public static final int XkbAllIndicatorsMask = -1;
    public static final int XkbMaxRadioGroups = 32;
    public static final int XkbAllRadioGroupsMask = -1;
    public static final int XkbMaxShiftLevel = 63;
    public static final int XkbMaxSymsPerKey = 252;
    public static final int XkbRGMaxMembers = 12;
    public static final int XkbActionMessageLength = 6;
    public static final int XkbKeyNameLength = 4;
    public static final int XkbMaxRedirectCount = 8;
    public static final int XkbControlsMask = 1;
    public static final int XkbServerMapMask = 2;
    public static final int XkbIClientMapMask = 4;
    public static final int XkbIndicatorMapMask = 8;
    public static final int XkbNamesMask = 16;
    public static final int XkbCompatMapMask = 32;
    public static final int XkbGeometryMask = 64;
    public static final int XkbAllComponentsMask = 127;

    private XKBlib() {
    }

    public static native int nXkbQueryExtension(long var0, long var2, long var4, long var6, long var8, long var10);

    public static int XkbQueryExtension(long display, ByteBuffer opcodeReturn, ByteBuffer eventBaseReturn, ByteBuffer errorBaseReturn, ByteBuffer majorRtrn, ByteBuffer minorRtrn) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)opcodeReturn, 4);
            Checks.checkBuffer((Buffer)eventBaseReturn, 4);
            Checks.checkBuffer((Buffer)errorBaseReturn, 4);
            Checks.checkBuffer((Buffer)majorRtrn, 4);
            Checks.checkBuffer((Buffer)minorRtrn, 4);
        }
        return XKBlib.nXkbQueryExtension(display, MemoryUtil.memAddress(opcodeReturn), MemoryUtil.memAddress(eventBaseReturn), MemoryUtil.memAddress(errorBaseReturn), MemoryUtil.memAddress(majorRtrn), MemoryUtil.memAddress(minorRtrn));
    }

    public static int XkbQueryExtension(long display, IntBuffer opcodeReturn, IntBuffer eventBaseReturn, IntBuffer errorBaseReturn, IntBuffer majorRtrn, IntBuffer minorRtrn) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)opcodeReturn, 1);
            Checks.checkBuffer((Buffer)eventBaseReturn, 1);
            Checks.checkBuffer((Buffer)errorBaseReturn, 1);
            Checks.checkBuffer((Buffer)majorRtrn, 1);
            Checks.checkBuffer((Buffer)minorRtrn, 1);
        }
        return XKBlib.nXkbQueryExtension(display, MemoryUtil.memAddress(opcodeReturn), MemoryUtil.memAddress(eventBaseReturn), MemoryUtil.memAddress(errorBaseReturn), MemoryUtil.memAddress(majorRtrn), MemoryUtil.memAddress(minorRtrn));
    }

    public static native int nXkbSetDetectableAutoRepeat(long var0, int var2, long var3);

    public static int XkbSetDetectableAutoRepeat(long display, int detectable, ByteBuffer supported) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return XKBlib.nXkbSetDetectableAutoRepeat(display, detectable, MemoryUtil.memAddress(supported));
    }

    public static int XkbSetDetectableAutoRepeat(long display, int detectable, IntBuffer supported) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return XKBlib.nXkbSetDetectableAutoRepeat(display, detectable, MemoryUtil.memAddress(supported));
    }

    public static native long nXkbKeycodeToKeysym(long var0, int var2, int var3, int var4);

    public static long XkbKeycodeToKeysym(long display, int kc, int group, int level) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        return XKBlib.nXkbKeycodeToKeysym(display, kc, group, level);
    }

    public static native long nXkbGetKeyboard(long var0, int var2, int var3);

    public static ByteBuffer XkbGetKeyboard(long display, int which, int deviceSpec) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
        }
        long __result = XKBlib.nXkbGetKeyboard(display, which, deviceSpec);
        return MemoryUtil.memByteBuffer(__result, XkbDescRec.SIZEOF);
    }

    public static native void nXkbFreeKeyboard(long var0, int var2, int var3);

    public static void XkbFreeKeyboard(ByteBuffer xkb, int which, int freeDesc) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)xkb, XkbDescRec.SIZEOF);
        }
        XKBlib.nXkbFreeKeyboard(MemoryUtil.memAddress(xkb), which, freeDesc);
    }

    static {
        Sys.touch();
    }
}

