/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.linux.XIEventMask;

public final class XInput2 {
    public static final int XI_DeviceChanged = 1;
    public static final int XI_KeyPress = 2;
    public static final int XI_KeyRelease = 3;
    public static final int XI_ButtonPress = 4;
    public static final int XI_ButtonRelease = 5;
    public static final int XI_Motion = 6;
    public static final int XI_Enter = 7;
    public static final int XI_Leave = 8;
    public static final int XI_FocusIn = 9;
    public static final int XI_FocusOut = 10;
    public static final int XI_HierarchyChanged = 11;
    public static final int XI_PropertyEvent = 12;
    public static final int XI_RawKeyPress = 13;
    public static final int XI_RawKeyRelease = 14;
    public static final int XI_RawButtonPress = 15;
    public static final int XI_RawButtonRelease = 16;
    public static final int XI_RawMotion = 17;
    public static final int XI_TouchBegin = 18;
    public static final int XI_TouchUpdate = 19;
    public static final int XI_TouchEnd = 20;
    public static final int XI_TouchOwnership = 21;
    public static final int XI_RawTouchBegin = 22;
    public static final int XI_RawTouchUpdate = 23;
    public static final int XI_RawTouchEnd = 24;

    private XInput2() {
    }

    public static native int nXIQueryVersion(long var0, long var2, long var4);

    public static int XIQueryVersion(long display, ByteBuffer major_version_inout, ByteBuffer minor_version_inout) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)major_version_inout, 4);
            Checks.checkBuffer((Buffer)minor_version_inout, 4);
        }
        return XInput2.nXIQueryVersion(display, MemoryUtil.memAddress(major_version_inout), MemoryUtil.memAddress(minor_version_inout));
    }

    public static int XIQueryVersion(long display, IntBuffer major_version_inout, IntBuffer minor_version_inout) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)major_version_inout, 1);
            Checks.checkBuffer((Buffer)minor_version_inout, 1);
        }
        return XInput2.nXIQueryVersion(display, MemoryUtil.memAddress(major_version_inout), MemoryUtil.memAddress(minor_version_inout));
    }

    public static native int nXISelectEvents(long var0, long var2, long var4, int var6);

    public static int XISelectEvents(long display, long w, ByteBuffer masks, int num_masks) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)masks, XIEventMask.SIZEOF);
            Checks.checkBuffer((Buffer)masks, num_masks);
        }
        return XInput2.nXISelectEvents(display, w, MemoryUtil.memAddress(masks), num_masks);
    }

    public static int XISelectEvents(long display, long w, ByteBuffer masks) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(display);
            Checks.checkBuffer((Buffer)masks, XIEventMask.SIZEOF);
        }
        return XInput2.nXISelectEvents(display, w, MemoryUtil.memAddress(masks), masks.remaining());
    }

    static {
        Sys.touch();
    }
}

