/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;

public final class XIValuatorState {
    public static final int SIZEOF;
    public static final int MASK_LEN;
    public static final int MASK;
    public static final int VALUES;

    private XIValuatorState() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int mask_len, long mask, long values) {
        ByteBuffer xivaluatorstate = XIValuatorState.malloc();
        XIValuatorState.mask_len(xivaluatorstate, mask_len);
        XIValuatorState.mask(xivaluatorstate, mask);
        XIValuatorState.values(xivaluatorstate, values);
        return xivaluatorstate;
    }

    public static ByteBuffer malloc(int mask_len, ByteBuffer mask, ByteBuffer values) {
        ByteBuffer xivaluatorstate = XIValuatorState.malloc();
        XIValuatorState.mask_len(xivaluatorstate, mask_len);
        XIValuatorState.mask(xivaluatorstate, mask);
        XIValuatorState.values(xivaluatorstate, values);
        return xivaluatorstate;
    }

    public static void mask_len(ByteBuffer xivaluatorstate, int mask_len) {
        xivaluatorstate.putInt(xivaluatorstate.position() + MASK_LEN, mask_len);
    }

    public static void mask(ByteBuffer xivaluatorstate, long mask) {
        PointerBuffer.put(xivaluatorstate, xivaluatorstate.position() + MASK, mask);
    }

    public static void mask(ByteBuffer xivaluatorstate, ByteBuffer mask) {
        XIValuatorState.mask(xivaluatorstate, MemoryUtil.memAddress(mask));
    }

    public static void values(ByteBuffer xivaluatorstate, long values) {
        PointerBuffer.put(xivaluatorstate, xivaluatorstate.position() + VALUES, values);
    }

    public static void values(ByteBuffer xivaluatorstate, ByteBuffer values) {
        XIValuatorState.values(xivaluatorstate, MemoryUtil.memAddress(values));
    }

    public static int mask_len(ByteBuffer xivaluatorstate) {
        return xivaluatorstate.getInt(xivaluatorstate.position() + MASK_LEN);
    }

    public static long mask(ByteBuffer xivaluatorstate) {
        return PointerBuffer.get(xivaluatorstate, xivaluatorstate.position() + MASK);
    }

    public static ByteBuffer mask(ByteBuffer xivaluatorstate, int size) {
        long address = XIValuatorState.mask(xivaluatorstate);
        return address == 0L ? null : MemoryUtil.memByteBuffer(address, size);
    }

    public static long values(ByteBuffer xivaluatorstate) {
        return PointerBuffer.get(xivaluatorstate, xivaluatorstate.position() + VALUES);
    }

    public static ByteBuffer values(ByteBuffer xivaluatorstate, int size) {
        long address = XIValuatorState.values(xivaluatorstate);
        return address == 0L ? null : MemoryUtil.memByteBuffer(address, size);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(3);
        SIZEOF = XIValuatorState.offsets(MemoryUtil.memAddress(offsets));
        MASK_LEN = offsets.get(0);
        MASK = offsets.get(1);
        VALUES = offsets.get(2);
    }
}

