/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;

public final class XIEventMask {
    public static final int SIZEOF;
    public static final int DEVICEID;
    public static final int MASK;
    public static final int MASK_LEN;

    private XIEventMask() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int deviceid, long mask, int mask_len) {
        ByteBuffer xieventmask = XIEventMask.malloc();
        XIEventMask.deviceid(xieventmask, deviceid);
        XIEventMask.mask(xieventmask, mask);
        XIEventMask.mask_len(xieventmask, mask_len);
        return xieventmask;
    }

    public static ByteBuffer malloc(int deviceid, ByteBuffer mask, int mask_len) {
        ByteBuffer xieventmask = XIEventMask.malloc();
        XIEventMask.deviceid(xieventmask, deviceid);
        XIEventMask.mask(xieventmask, mask);
        XIEventMask.mask_len(xieventmask, mask_len);
        return xieventmask;
    }

    public static void deviceid(ByteBuffer xieventmask, int deviceid) {
        xieventmask.putInt(xieventmask.position() + DEVICEID, deviceid);
    }

    public static void mask(ByteBuffer xieventmask, long mask) {
        PointerBuffer.put(xieventmask, xieventmask.position() + MASK, mask);
    }

    public static void mask(ByteBuffer xieventmask, ByteBuffer mask) {
        XIEventMask.mask(xieventmask, MemoryUtil.memAddress(mask));
    }

    public static void mask_len(ByteBuffer xieventmask, int mask_len) {
        xieventmask.putInt(xieventmask.position() + MASK_LEN, mask_len);
    }

    public static int deviceid(ByteBuffer xieventmask) {
        return xieventmask.getInt(xieventmask.position() + DEVICEID);
    }

    public static long mask(ByteBuffer xieventmask) {
        return PointerBuffer.get(xieventmask, xieventmask.position() + MASK);
    }

    public static ByteBuffer mask(ByteBuffer xieventmask, int size) {
        long address = XIEventMask.mask(xieventmask);
        return address == 0L ? null : MemoryUtil.memByteBuffer(address, size);
    }

    public static int mask_len(ByteBuffer xieventmask) {
        return xieventmask.getInt(xieventmask.position() + MASK_LEN);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(3);
        SIZEOF = XIEventMask.offsets(MemoryUtil.memAddress(offsets));
        DEVICEID = offsets.get(0);
        MASK = offsets.get(1);
        MASK_LEN = offsets.get(2);
    }
}

