/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;

public final class XIButtonState {
    public static final int SIZEOF;
    public static final int MASK_LEN;
    public static final int MASK;

    private XIButtonState() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int mask_len, long mask) {
        ByteBuffer xibuttonstate = XIButtonState.malloc();
        XIButtonState.mask_len(xibuttonstate, mask_len);
        XIButtonState.mask(xibuttonstate, mask);
        return xibuttonstate;
    }

    public static ByteBuffer malloc(int mask_len, ByteBuffer mask) {
        ByteBuffer xibuttonstate = XIButtonState.malloc();
        XIButtonState.mask_len(xibuttonstate, mask_len);
        XIButtonState.mask(xibuttonstate, mask);
        return xibuttonstate;
    }

    public static void mask_len(ByteBuffer xibuttonstate, int mask_len) {
        xibuttonstate.putInt(xibuttonstate.position() + MASK_LEN, mask_len);
    }

    public static void mask(ByteBuffer xibuttonstate, long mask) {
        PointerBuffer.put(xibuttonstate, xibuttonstate.position() + MASK, mask);
    }

    public static void mask(ByteBuffer xibuttonstate, ByteBuffer mask) {
        XIButtonState.mask(xibuttonstate, MemoryUtil.memAddress(mask));
    }

    public static int mask_len(ByteBuffer xibuttonstate) {
        return xibuttonstate.getInt(xibuttonstate.position() + MASK_LEN);
    }

    public static long mask(ByteBuffer xibuttonstate) {
        return PointerBuffer.get(xibuttonstate, xibuttonstate.position() + MASK);
    }

    public static ByteBuffer mask(ByteBuffer xibuttonstate, int size) {
        long address = XIButtonState.mask(xibuttonstate);
        return address == 0L ? null : MemoryUtil.memByteBuffer(address, size);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(2);
        SIZEOF = XIButtonState.offsets(MemoryUtil.memAddress(offsets));
        MASK_LEN = offsets.get(0);
        MASK = offsets.get(1);
    }
}

