/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;

public final class XGCValues {
    public static final int SIZEOF;
    public static final int FUNCTION;
    public static final int PLANE_MASK;
    public static final int FOREGROUND;
    public static final int BACKGROUND;
    public static final int LINE_WIDTH;
    public static final int LINE_STYLE;
    public static final int CAP_STYLE;
    public static final int JOIN_STYLE;
    public static final int FILL_STYLE;
    public static final int FILL_RULE;
    public static final int ARC_MODE;
    public static final int TILE;
    public static final int STIPPLE;
    public static final int TS_X_ORIGIN;
    public static final int TS_Y_ORIGIN;
    public static final int FONT;
    public static final int SUBWINDOW_MODE;
    public static final int GRAPHICS_EXPOSURES;
    public static final int CLIP_X_ORIGIN;
    public static final int CLIP_Y_ORIGIN;
    public static final int CLIP_MASK;
    public static final int DASH_OFFSET;
    public static final int DASHES;

    private XGCValues() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int function, long plane_mask, long foreground, long background, int line_width, int line_style, int cap_style, int join_style, int fill_style, int fill_rule, int arc_mode, long tile, long stipple, int ts_x_origin, int ts_y_origin, long font, int subwindow_mode, int graphics_exposures, int clip_x_origin, int clip_y_origin, long clip_mask, int dash_offset, int dashes) {
        ByteBuffer xgcvalues = XGCValues.malloc();
        XGCValues.function(xgcvalues, function);
        XGCValues.plane_mask(xgcvalues, plane_mask);
        XGCValues.foreground(xgcvalues, foreground);
        XGCValues.background(xgcvalues, background);
        XGCValues.line_width(xgcvalues, line_width);
        XGCValues.line_style(xgcvalues, line_style);
        XGCValues.cap_style(xgcvalues, cap_style);
        XGCValues.join_style(xgcvalues, join_style);
        XGCValues.fill_style(xgcvalues, fill_style);
        XGCValues.fill_rule(xgcvalues, fill_rule);
        XGCValues.arc_mode(xgcvalues, arc_mode);
        XGCValues.tile(xgcvalues, tile);
        XGCValues.stipple(xgcvalues, stipple);
        XGCValues.ts_x_origin(xgcvalues, ts_x_origin);
        XGCValues.ts_y_origin(xgcvalues, ts_y_origin);
        XGCValues.font(xgcvalues, font);
        XGCValues.subwindow_mode(xgcvalues, subwindow_mode);
        XGCValues.graphics_exposures(xgcvalues, graphics_exposures);
        XGCValues.clip_x_origin(xgcvalues, clip_x_origin);
        XGCValues.clip_y_origin(xgcvalues, clip_y_origin);
        XGCValues.clip_mask(xgcvalues, clip_mask);
        XGCValues.dash_offset(xgcvalues, dash_offset);
        XGCValues.dashes(xgcvalues, dashes);
        return xgcvalues;
    }

    public static void function(ByteBuffer xgcvalues, int function) {
        xgcvalues.putInt(xgcvalues.position() + FUNCTION, function);
    }

    public static void plane_mask(ByteBuffer xgcvalues, long plane_mask) {
        PointerBuffer.put(xgcvalues, xgcvalues.position() + PLANE_MASK, plane_mask);
    }

    public static void foreground(ByteBuffer xgcvalues, long foreground) {
        PointerBuffer.put(xgcvalues, xgcvalues.position() + FOREGROUND, foreground);
    }

    public static void background(ByteBuffer xgcvalues, long background) {
        PointerBuffer.put(xgcvalues, xgcvalues.position() + BACKGROUND, background);
    }

    public static void line_width(ByteBuffer xgcvalues, int line_width) {
        xgcvalues.putInt(xgcvalues.position() + LINE_WIDTH, line_width);
    }

    public static void line_style(ByteBuffer xgcvalues, int line_style) {
        xgcvalues.putInt(xgcvalues.position() + LINE_STYLE, line_style);
    }

    public static void cap_style(ByteBuffer xgcvalues, int cap_style) {
        xgcvalues.putInt(xgcvalues.position() + CAP_STYLE, cap_style);
    }

    public static void join_style(ByteBuffer xgcvalues, int join_style) {
        xgcvalues.putInt(xgcvalues.position() + JOIN_STYLE, join_style);
    }

    public static void fill_style(ByteBuffer xgcvalues, int fill_style) {
        xgcvalues.putInt(xgcvalues.position() + FILL_STYLE, fill_style);
    }

    public static void fill_rule(ByteBuffer xgcvalues, int fill_rule) {
        xgcvalues.putInt(xgcvalues.position() + FILL_RULE, fill_rule);
    }

    public static void arc_mode(ByteBuffer xgcvalues, int arc_mode) {
        xgcvalues.putInt(xgcvalues.position() + ARC_MODE, arc_mode);
    }

    public static void tile(ByteBuffer xgcvalues, long tile) {
        PointerBuffer.put(xgcvalues, xgcvalues.position() + TILE, tile);
    }

    public static void stipple(ByteBuffer xgcvalues, long stipple) {
        PointerBuffer.put(xgcvalues, xgcvalues.position() + STIPPLE, stipple);
    }

    public static void ts_x_origin(ByteBuffer xgcvalues, int ts_x_origin) {
        xgcvalues.putInt(xgcvalues.position() + TS_X_ORIGIN, ts_x_origin);
    }

    public static void ts_y_origin(ByteBuffer xgcvalues, int ts_y_origin) {
        xgcvalues.putInt(xgcvalues.position() + TS_Y_ORIGIN, ts_y_origin);
    }

    public static void font(ByteBuffer xgcvalues, long font) {
        PointerBuffer.put(xgcvalues, xgcvalues.position() + FONT, font);
    }

    public static void subwindow_mode(ByteBuffer xgcvalues, int subwindow_mode) {
        xgcvalues.putInt(xgcvalues.position() + SUBWINDOW_MODE, subwindow_mode);
    }

    public static void graphics_exposures(ByteBuffer xgcvalues, int graphics_exposures) {
        xgcvalues.putInt(xgcvalues.position() + GRAPHICS_EXPOSURES, graphics_exposures);
    }

    public static void clip_x_origin(ByteBuffer xgcvalues, int clip_x_origin) {
        xgcvalues.putInt(xgcvalues.position() + CLIP_X_ORIGIN, clip_x_origin);
    }

    public static void clip_y_origin(ByteBuffer xgcvalues, int clip_y_origin) {
        xgcvalues.putInt(xgcvalues.position() + CLIP_Y_ORIGIN, clip_y_origin);
    }

    public static void clip_mask(ByteBuffer xgcvalues, long clip_mask) {
        PointerBuffer.put(xgcvalues, xgcvalues.position() + CLIP_MASK, clip_mask);
    }

    public static void dash_offset(ByteBuffer xgcvalues, int dash_offset) {
        xgcvalues.putInt(xgcvalues.position() + DASH_OFFSET, dash_offset);
    }

    public static void dashes(ByteBuffer xgcvalues, int dashes) {
        xgcvalues.put(xgcvalues.position() + DASHES, (byte)dashes);
    }

    public static int function(ByteBuffer xgcvalues) {
        return xgcvalues.getInt(xgcvalues.position() + FUNCTION);
    }

    public static long plane_mask(ByteBuffer xgcvalues) {
        return PointerBuffer.get(xgcvalues, xgcvalues.position() + PLANE_MASK);
    }

    public static long foreground(ByteBuffer xgcvalues) {
        return PointerBuffer.get(xgcvalues, xgcvalues.position() + FOREGROUND);
    }

    public static long background(ByteBuffer xgcvalues) {
        return PointerBuffer.get(xgcvalues, xgcvalues.position() + BACKGROUND);
    }

    public static int line_width(ByteBuffer xgcvalues) {
        return xgcvalues.getInt(xgcvalues.position() + LINE_WIDTH);
    }

    public static int line_style(ByteBuffer xgcvalues) {
        return xgcvalues.getInt(xgcvalues.position() + LINE_STYLE);
    }

    public static int cap_style(ByteBuffer xgcvalues) {
        return xgcvalues.getInt(xgcvalues.position() + CAP_STYLE);
    }

    public static int join_style(ByteBuffer xgcvalues) {
        return xgcvalues.getInt(xgcvalues.position() + JOIN_STYLE);
    }

    public static int fill_style(ByteBuffer xgcvalues) {
        return xgcvalues.getInt(xgcvalues.position() + FILL_STYLE);
    }

    public static int fill_rule(ByteBuffer xgcvalues) {
        return xgcvalues.getInt(xgcvalues.position() + FILL_RULE);
    }

    public static int arc_mode(ByteBuffer xgcvalues) {
        return xgcvalues.getInt(xgcvalues.position() + ARC_MODE);
    }

    public static long tile(ByteBuffer xgcvalues) {
        return PointerBuffer.get(xgcvalues, xgcvalues.position() + TILE);
    }

    public static long stipple(ByteBuffer xgcvalues) {
        return PointerBuffer.get(xgcvalues, xgcvalues.position() + STIPPLE);
    }

    public static int ts_x_origin(ByteBuffer xgcvalues) {
        return xgcvalues.getInt(xgcvalues.position() + TS_X_ORIGIN);
    }

    public static int ts_y_origin(ByteBuffer xgcvalues) {
        return xgcvalues.getInt(xgcvalues.position() + TS_Y_ORIGIN);
    }

    public static long font(ByteBuffer xgcvalues) {
        return PointerBuffer.get(xgcvalues, xgcvalues.position() + FONT);
    }

    public static int subwindow_mode(ByteBuffer xgcvalues) {
        return xgcvalues.getInt(xgcvalues.position() + SUBWINDOW_MODE);
    }

    public static int graphics_exposures(ByteBuffer xgcvalues) {
        return xgcvalues.getInt(xgcvalues.position() + GRAPHICS_EXPOSURES);
    }

    public static int clip_x_origin(ByteBuffer xgcvalues) {
        return xgcvalues.getInt(xgcvalues.position() + CLIP_X_ORIGIN);
    }

    public static int clip_y_origin(ByteBuffer xgcvalues) {
        return xgcvalues.getInt(xgcvalues.position() + CLIP_Y_ORIGIN);
    }

    public static long clip_mask(ByteBuffer xgcvalues) {
        return PointerBuffer.get(xgcvalues, xgcvalues.position() + CLIP_MASK);
    }

    public static int dash_offset(ByteBuffer xgcvalues) {
        return xgcvalues.getInt(xgcvalues.position() + DASH_OFFSET);
    }

    public static int dashes(ByteBuffer xgcvalues) {
        return xgcvalues.get(xgcvalues.position() + DASHES);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(23);
        SIZEOF = XGCValues.offsets(MemoryUtil.memAddress(offsets));
        FUNCTION = offsets.get(0);
        PLANE_MASK = offsets.get(1);
        FOREGROUND = offsets.get(2);
        BACKGROUND = offsets.get(3);
        LINE_WIDTH = offsets.get(4);
        LINE_STYLE = offsets.get(5);
        CAP_STYLE = offsets.get(6);
        JOIN_STYLE = offsets.get(7);
        FILL_STYLE = offsets.get(8);
        FILL_RULE = offsets.get(9);
        ARC_MODE = offsets.get(10);
        TILE = offsets.get(11);
        STIPPLE = offsets.get(12);
        TS_X_ORIGIN = offsets.get(13);
        TS_Y_ORIGIN = offsets.get(14);
        FONT = offsets.get(15);
        SUBWINDOW_MODE = offsets.get(16);
        GRAPHICS_EXPOSURES = offsets.get(17);
        CLIP_X_ORIGIN = offsets.get(18);
        CLIP_Y_ORIGIN = offsets.get(19);
        CLIP_MASK = offsets.get(20);
        DASH_OFFSET = offsets.get(21);
        DASHES = offsets.get(22);
    }
}

