/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.linux.XErrorEvent;

public interface XErrorHandler {
    public int invoke(long var1, long var3);

    public static final class Util {
        private static final String[] X_ERRORS = new String[]{"Success", "BadRequest", "BadValue", "BadWindow", "BadPixmap", "BadAtom", "BadCursor", "BadFont", "BadMatch", "BadDrawable", "BadAccess", "BadAlloc", "BadColor", "BadGC", "BadIDChoice", "BadName", "BadLength", "BadImplementation"};
        static final long CALLBACK = Util.setCallback(APIUtil.apiCallbackMethod(Util.class, Long.TYPE, Long.TYPE));
        private static final XErrorHandler DEFAULT = new BufAdapter(){

            @Override
            public int invoke(long display, ByteBuffer error_event) {
                System.err.println("[LWJGL] X error: " + this.getErrorName(XErrorEvent.error_code(error_event)));
                System.err.printf("\tDisplay: [0x%X]\n", display);
                System.err.println("\tMajor opcode: " + XErrorEvent.request_code(error_event));
                System.err.println("\tMinor opcode: " + XErrorEvent.minor_code(error_event));
                System.err.println("\tSerial number: " + XErrorEvent.serial(error_event));
                System.err.printf("\tResource ID: [0x%X]\n", XErrorEvent.resourceid(error_event));
                return 0;
            }

            private String getErrorName(int error_code) {
                return error_code < X_ERRORS.length ? X_ERRORS[error_code] : String.format("UNKNOWN [0x%X]", error_code);
            }
        };
        private static XErrorHandler callback;

        private Util() {
        }

        private static native long setCallback(Method var0);

        static long register(XErrorHandler handler) {
            callback = handler;
            return handler == null ? 0L : CALLBACK;
        }

        private static void callback(long display, long error_event) {
            callback.invoke(display, error_event);
        }

        public static XErrorHandler getDefault() {
            return DEFAULT;
        }
    }

    public static abstract class BufAdapter
    implements Buf {
        @Override
        public int invoke(long display, long error_event) {
            return this.invoke(display, MemoryUtil.memByteBuffer(error_event, XErrorEvent.SIZEOF));
        }

        @Override
        public int invoke(long display, ByteBuffer error_event) {
            return 0;
        }
    }

    public static interface Buf
    extends XErrorHandler {
        public int invoke(long var1, ByteBuffer var3);
    }
}

