/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;

public final class XConfigureEvent {
    public static final int SIZEOF;
    public static final int TYPE;
    public static final int SERIAL;
    public static final int SEND_EVENT;
    public static final int DISPLAY;
    public static final int EVENT;
    public static final int WINDOW;
    public static final int X;
    public static final int Y;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int BORDER_WIDTH;
    public static final int ABOVE;
    public static final int OVERRIDE_REDIRECT;

    private XConfigureEvent() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int type, long serial, int send_event, long display, long event, long window, int x, int y, int width, int height, int border_width, long above, int override_redirect) {
        ByteBuffer xconfigureevent = XConfigureEvent.malloc();
        XConfigureEvent.type(xconfigureevent, type);
        XConfigureEvent.serial(xconfigureevent, serial);
        XConfigureEvent.send_event(xconfigureevent, send_event);
        XConfigureEvent.display(xconfigureevent, display);
        XConfigureEvent.event(xconfigureevent, event);
        XConfigureEvent.window(xconfigureevent, window);
        XConfigureEvent.x(xconfigureevent, x);
        XConfigureEvent.y(xconfigureevent, y);
        XConfigureEvent.width(xconfigureevent, width);
        XConfigureEvent.height(xconfigureevent, height);
        XConfigureEvent.border_width(xconfigureevent, border_width);
        XConfigureEvent.above(xconfigureevent, above);
        XConfigureEvent.override_redirect(xconfigureevent, override_redirect);
        return xconfigureevent;
    }

    public static void type(ByteBuffer xconfigureevent, int type) {
        xconfigureevent.putInt(xconfigureevent.position() + TYPE, type);
    }

    public static void serial(ByteBuffer xconfigureevent, long serial) {
        PointerBuffer.put(xconfigureevent, xconfigureevent.position() + SERIAL, serial);
    }

    public static void send_event(ByteBuffer xconfigureevent, int send_event) {
        xconfigureevent.putInt(xconfigureevent.position() + SEND_EVENT, send_event);
    }

    public static void display(ByteBuffer xconfigureevent, long display) {
        PointerBuffer.put(xconfigureevent, xconfigureevent.position() + DISPLAY, display);
    }

    public static void event(ByteBuffer xconfigureevent, long event) {
        PointerBuffer.put(xconfigureevent, xconfigureevent.position() + EVENT, event);
    }

    public static void window(ByteBuffer xconfigureevent, long window) {
        PointerBuffer.put(xconfigureevent, xconfigureevent.position() + WINDOW, window);
    }

    public static void x(ByteBuffer xconfigureevent, int x) {
        xconfigureevent.putInt(xconfigureevent.position() + X, x);
    }

    public static void y(ByteBuffer xconfigureevent, int y) {
        xconfigureevent.putInt(xconfigureevent.position() + Y, y);
    }

    public static void width(ByteBuffer xconfigureevent, int width) {
        xconfigureevent.putInt(xconfigureevent.position() + WIDTH, width);
    }

    public static void height(ByteBuffer xconfigureevent, int height) {
        xconfigureevent.putInt(xconfigureevent.position() + HEIGHT, height);
    }

    public static void border_width(ByteBuffer xconfigureevent, int border_width) {
        xconfigureevent.putInt(xconfigureevent.position() + BORDER_WIDTH, border_width);
    }

    public static void above(ByteBuffer xconfigureevent, long above) {
        PointerBuffer.put(xconfigureevent, xconfigureevent.position() + ABOVE, above);
    }

    public static void override_redirect(ByteBuffer xconfigureevent, int override_redirect) {
        xconfigureevent.putInt(xconfigureevent.position() + OVERRIDE_REDIRECT, override_redirect);
    }

    public static int type(ByteBuffer xconfigureevent) {
        return xconfigureevent.getInt(xconfigureevent.position() + TYPE);
    }

    public static long serial(ByteBuffer xconfigureevent) {
        return PointerBuffer.get(xconfigureevent, xconfigureevent.position() + SERIAL);
    }

    public static int send_event(ByteBuffer xconfigureevent) {
        return xconfigureevent.getInt(xconfigureevent.position() + SEND_EVENT);
    }

    public static long display(ByteBuffer xconfigureevent) {
        return PointerBuffer.get(xconfigureevent, xconfigureevent.position() + DISPLAY);
    }

    public static long event(ByteBuffer xconfigureevent) {
        return PointerBuffer.get(xconfigureevent, xconfigureevent.position() + EVENT);
    }

    public static long window(ByteBuffer xconfigureevent) {
        return PointerBuffer.get(xconfigureevent, xconfigureevent.position() + WINDOW);
    }

    public static int x(ByteBuffer xconfigureevent) {
        return xconfigureevent.getInt(xconfigureevent.position() + X);
    }

    public static int y(ByteBuffer xconfigureevent) {
        return xconfigureevent.getInt(xconfigureevent.position() + Y);
    }

    public static int width(ByteBuffer xconfigureevent) {
        return xconfigureevent.getInt(xconfigureevent.position() + WIDTH);
    }

    public static int height(ByteBuffer xconfigureevent) {
        return xconfigureevent.getInt(xconfigureevent.position() + HEIGHT);
    }

    public static int border_width(ByteBuffer xconfigureevent) {
        return xconfigureevent.getInt(xconfigureevent.position() + BORDER_WIDTH);
    }

    public static long above(ByteBuffer xconfigureevent) {
        return PointerBuffer.get(xconfigureevent, xconfigureevent.position() + ABOVE);
    }

    public static int override_redirect(ByteBuffer xconfigureevent) {
        return xconfigureevent.getInt(xconfigureevent.position() + OVERRIDE_REDIRECT);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(13);
        SIZEOF = XConfigureEvent.offsets(MemoryUtil.memAddress(offsets));
        TYPE = offsets.get(0);
        SERIAL = offsets.get(1);
        SEND_EVENT = offsets.get(2);
        DISPLAY = offsets.get(3);
        EVENT = offsets.get(4);
        WINDOW = offsets.get(5);
        X = offsets.get(6);
        Y = offsets.get(7);
        WIDTH = offsets.get(8);
        HEIGHT = offsets.get(9);
        BORDER_WIDTH = offsets.get(10);
        ABOVE = offsets.get(11);
        OVERRIDE_REDIRECT = offsets.get(12);
    }
}

