/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;

public final class XComposeStatus {
    public static final int SIZEOF;
    public static final int COMPOSE_PTR;
    public static final int CHARS_MATCHED;

    private XComposeStatus() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long compose_ptr, int chars_matched) {
        ByteBuffer xcomposestatus = XComposeStatus.malloc();
        XComposeStatus.compose_ptr(xcomposestatus, compose_ptr);
        XComposeStatus.chars_matched(xcomposestatus, chars_matched);
        return xcomposestatus;
    }

    public static ByteBuffer malloc(ByteBuffer compose_ptr, int chars_matched) {
        ByteBuffer xcomposestatus = XComposeStatus.malloc();
        XComposeStatus.compose_ptr(xcomposestatus, compose_ptr);
        XComposeStatus.chars_matched(xcomposestatus, chars_matched);
        return xcomposestatus;
    }

    public static void compose_ptr(ByteBuffer xcomposestatus, long compose_ptr) {
        PointerBuffer.put(xcomposestatus, xcomposestatus.position() + COMPOSE_PTR, compose_ptr);
    }

    public static void compose_ptr(ByteBuffer xcomposestatus, ByteBuffer compose_ptr) {
        XComposeStatus.compose_ptr(xcomposestatus, MemoryUtil.memAddress(compose_ptr));
    }

    public static void chars_matched(ByteBuffer xcomposestatus, int chars_matched) {
        xcomposestatus.putInt(xcomposestatus.position() + CHARS_MATCHED, chars_matched);
    }

    public static long compose_ptr(ByteBuffer xcomposestatus) {
        return PointerBuffer.get(xcomposestatus, xcomposestatus.position() + COMPOSE_PTR);
    }

    public static ByteBuffer compose_ptr(ByteBuffer xcomposestatus, int size) {
        long address = XComposeStatus.compose_ptr(xcomposestatus);
        return address == 0L ? null : MemoryUtil.memByteBuffer(address, size);
    }

    public static int chars_matched(ByteBuffer xcomposestatus) {
        return xcomposestatus.getInt(xcomposestatus.position() + CHARS_MATCHED);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(2);
        SIZEOF = XComposeStatus.offsets(MemoryUtil.memAddress(offsets));
        COMPOSE_PTR = offsets.get(0);
        CHARS_MATCHED = offsets.get(1);
    }
}

