/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;

public final class XColor {
    public static final int SIZEOF;
    public static final int PIXEL;
    public static final int RED;
    public static final int GREEN;
    public static final int BLUE;
    public static final int FLAGS;
    public static final int PAD;

    private XColor() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long pixel, int red, int green, int blue, int flags, int pad) {
        ByteBuffer xcolor = XColor.malloc();
        XColor.pixel(xcolor, pixel);
        XColor.red(xcolor, red);
        XColor.green(xcolor, green);
        XColor.blue(xcolor, blue);
        XColor.flags(xcolor, flags);
        XColor.pad(xcolor, pad);
        return xcolor;
    }

    public static void pixel(ByteBuffer xcolor, long pixel) {
        PointerBuffer.put(xcolor, xcolor.position() + PIXEL, pixel);
    }

    public static void red(ByteBuffer xcolor, int red) {
        xcolor.putShort(xcolor.position() + RED, (short)red);
    }

    public static void green(ByteBuffer xcolor, int green) {
        xcolor.putShort(xcolor.position() + GREEN, (short)green);
    }

    public static void blue(ByteBuffer xcolor, int blue) {
        xcolor.putShort(xcolor.position() + BLUE, (short)blue);
    }

    public static void flags(ByteBuffer xcolor, int flags) {
        xcolor.put(xcolor.position() + FLAGS, (byte)flags);
    }

    public static void pad(ByteBuffer xcolor, int pad) {
        xcolor.put(xcolor.position() + PAD, (byte)pad);
    }

    public static long pixel(ByteBuffer xcolor) {
        return PointerBuffer.get(xcolor, xcolor.position() + PIXEL);
    }

    public static int red(ByteBuffer xcolor) {
        return xcolor.getShort(xcolor.position() + RED) & 0xFFFF;
    }

    public static int green(ByteBuffer xcolor) {
        return xcolor.getShort(xcolor.position() + GREEN) & 0xFFFF;
    }

    public static int blue(ByteBuffer xcolor) {
        return xcolor.getShort(xcolor.position() + BLUE) & 0xFFFF;
    }

    public static int flags(ByteBuffer xcolor) {
        return xcolor.get(xcolor.position() + FLAGS);
    }

    public static int pad(ByteBuffer xcolor) {
        return xcolor.get(xcolor.position() + PAD);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(6);
        SIZEOF = XColor.offsets(MemoryUtil.memAddress(offsets));
        PIXEL = offsets.get(0);
        RED = offsets.get(1);
        GREEN = offsets.get(2);
        BLUE = offsets.get(3);
        FLAGS = offsets.get(4);
        PAD = offsets.get(5);
    }
}

