/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class XClientMessageEvent {
    public static final int SIZEOF;
    public static final int TYPE;
    public static final int SERIAL;
    public static final int SEND_EVENT;
    public static final int DISPLAY;
    public static final int WINDOW;
    public static final int MESSAGE_TYPE;
    public static final int FORMAT;
    public static final int DATA;
    public static final int DATA_B;
    public static final int DATA_S;
    public static final int DATA_L;

    private XClientMessageEvent() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int type, long serial, int send_event, long display, long window, long message_type, int format, long data_b, int data_bBytes, long data_s, int data_sBytes, long data_l, int data_lBytes) {
        ByteBuffer xclientmessageevent = XClientMessageEvent.malloc();
        XClientMessageEvent.type(xclientmessageevent, type);
        XClientMessageEvent.serial(xclientmessageevent, serial);
        XClientMessageEvent.send_event(xclientmessageevent, send_event);
        XClientMessageEvent.display(xclientmessageevent, display);
        XClientMessageEvent.window(xclientmessageevent, window);
        XClientMessageEvent.message_type(xclientmessageevent, message_type);
        XClientMessageEvent.format(xclientmessageevent, format);
        XClientMessageEvent.dataBSet(xclientmessageevent, data_b, data_bBytes);
        XClientMessageEvent.dataSSet(xclientmessageevent, data_s, data_sBytes);
        XClientMessageEvent.dataLSet(xclientmessageevent, data_l, data_lBytes);
        return xclientmessageevent;
    }

    public static ByteBuffer malloc(int type, long serial, int send_event, long display, long window, long message_type, int format, ByteBuffer data_b, ByteBuffer data_s, ByteBuffer data_l) {
        ByteBuffer xclientmessageevent = XClientMessageEvent.malloc();
        XClientMessageEvent.type(xclientmessageevent, type);
        XClientMessageEvent.serial(xclientmessageevent, serial);
        XClientMessageEvent.send_event(xclientmessageevent, send_event);
        XClientMessageEvent.display(xclientmessageevent, display);
        XClientMessageEvent.window(xclientmessageevent, window);
        XClientMessageEvent.message_type(xclientmessageevent, message_type);
        XClientMessageEvent.format(xclientmessageevent, format);
        XClientMessageEvent.dataBSet(xclientmessageevent, data_b);
        XClientMessageEvent.dataSSet(xclientmessageevent, data_s);
        XClientMessageEvent.dataLSet(xclientmessageevent, data_l);
        return xclientmessageevent;
    }

    public static void type(ByteBuffer xclientmessageevent, int type) {
        xclientmessageevent.putInt(xclientmessageevent.position() + TYPE, type);
    }

    public static void serial(ByteBuffer xclientmessageevent, long serial) {
        PointerBuffer.put(xclientmessageevent, xclientmessageevent.position() + SERIAL, serial);
    }

    public static void send_event(ByteBuffer xclientmessageevent, int send_event) {
        xclientmessageevent.putInt(xclientmessageevent.position() + SEND_EVENT, send_event);
    }

    public static void display(ByteBuffer xclientmessageevent, long display) {
        PointerBuffer.put(xclientmessageevent, xclientmessageevent.position() + DISPLAY, display);
    }

    public static void window(ByteBuffer xclientmessageevent, long window) {
        PointerBuffer.put(xclientmessageevent, xclientmessageevent.position() + WINDOW, window);
    }

    public static void message_type(ByteBuffer xclientmessageevent, long message_type) {
        PointerBuffer.put(xclientmessageevent, xclientmessageevent.position() + MESSAGE_TYPE, message_type);
    }

    public static void format(ByteBuffer xclientmessageevent, int format) {
        xclientmessageevent.putInt(xclientmessageevent.position() + FORMAT, format);
    }

    public static void dataBSet(ByteBuffer xclientmessageevent, long b, int bytes) {
        MemoryUtil.memCopy(b, MemoryUtil.memAddress(xclientmessageevent) + (long)DATA_B, bytes);
    }

    public static void dataBSet(ByteBuffer xclientmessageevent, ByteBuffer b) {
        Checks.checkBufferGT(b, 20);
        XClientMessageEvent.dataBSet(xclientmessageevent, MemoryUtil.memAddress(b), b.remaining());
    }

    public static void dataSSet(ByteBuffer xclientmessageevent, long s, int bytes) {
        MemoryUtil.memCopy(s, MemoryUtil.memAddress(xclientmessageevent) + (long)DATA_S, bytes);
    }

    public static void dataSSet(ByteBuffer xclientmessageevent, ByteBuffer s) {
        Checks.checkBufferGT(s, 20);
        XClientMessageEvent.dataSSet(xclientmessageevent, MemoryUtil.memAddress(s), s.remaining());
    }

    public static void dataLSet(ByteBuffer xclientmessageevent, long l, int bytes) {
        MemoryUtil.memCopy(l, MemoryUtil.memAddress(xclientmessageevent) + (long)DATA_L, bytes);
    }

    public static void dataLSet(ByteBuffer xclientmessageevent, ByteBuffer l) {
        Checks.checkBufferGT(l, 40);
        XClientMessageEvent.dataLSet(xclientmessageevent, MemoryUtil.memAddress(l), l.remaining());
    }

    public static int type(ByteBuffer xclientmessageevent) {
        return xclientmessageevent.getInt(xclientmessageevent.position() + TYPE);
    }

    public static long serial(ByteBuffer xclientmessageevent) {
        return PointerBuffer.get(xclientmessageevent, xclientmessageevent.position() + SERIAL);
    }

    public static int send_event(ByteBuffer xclientmessageevent) {
        return xclientmessageevent.getInt(xclientmessageevent.position() + SEND_EVENT);
    }

    public static long display(ByteBuffer xclientmessageevent) {
        return PointerBuffer.get(xclientmessageevent, xclientmessageevent.position() + DISPLAY);
    }

    public static long window(ByteBuffer xclientmessageevent) {
        return PointerBuffer.get(xclientmessageevent, xclientmessageevent.position() + WINDOW);
    }

    public static long message_type(ByteBuffer xclientmessageevent) {
        return PointerBuffer.get(xclientmessageevent, xclientmessageevent.position() + MESSAGE_TYPE);
    }

    public static int format(ByteBuffer xclientmessageevent) {
        return xclientmessageevent.getInt(xclientmessageevent.position() + FORMAT);
    }

    public static void dataBGet(ByteBuffer xclientmessageevent, long b, int bytes) {
        MemoryUtil.memCopy(MemoryUtil.memAddress(xclientmessageevent) + (long)DATA_B, b, bytes);
    }

    public static void dataBGet(ByteBuffer xclientmessageevent, ByteBuffer b) {
        Checks.checkBufferGT(b, 20);
        XClientMessageEvent.dataBGet(xclientmessageevent, MemoryUtil.memAddress(b), b.remaining());
    }

    public static void dataSGet(ByteBuffer xclientmessageevent, long s, int bytes) {
        MemoryUtil.memCopy(MemoryUtil.memAddress(xclientmessageevent) + (long)DATA_S, s, bytes);
    }

    public static void dataSGet(ByteBuffer xclientmessageevent, ByteBuffer s) {
        Checks.checkBufferGT(s, 20);
        XClientMessageEvent.dataSGet(xclientmessageevent, MemoryUtil.memAddress(s), s.remaining());
    }

    public static void dataLGet(ByteBuffer xclientmessageevent, long l, int bytes) {
        MemoryUtil.memCopy(MemoryUtil.memAddress(xclientmessageevent) + (long)DATA_L, l, bytes);
    }

    public static void dataLGet(ByteBuffer xclientmessageevent, ByteBuffer l) {
        Checks.checkBufferGT(l, 40);
        XClientMessageEvent.dataLGet(xclientmessageevent, MemoryUtil.memAddress(l), l.remaining());
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(11);
        SIZEOF = XClientMessageEvent.offsets(MemoryUtil.memAddress(offsets));
        TYPE = offsets.get(0);
        SERIAL = offsets.get(1);
        SEND_EVENT = offsets.get(2);
        DISPLAY = offsets.get(3);
        WINDOW = offsets.get(4);
        MESSAGE_TYPE = offsets.get(5);
        FORMAT = offsets.get(6);
        DATA = offsets.get(7);
        DATA_B = offsets.get(8);
        DATA_S = offsets.get(9);
        DATA_L = offsets.get(10);
    }
}

