/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class XClassHint {
    public static final int SIZEOF;
    public static final int RES_NAME;
    public static final int RES_CLASS;

    private XClassHint() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long res_name, long res_class) {
        ByteBuffer xclasshint = XClassHint.malloc();
        XClassHint.res_name(xclasshint, res_name);
        XClassHint.res_class(xclasshint, res_class);
        return xclasshint;
    }

    public static ByteBuffer malloc(ByteBuffer res_name, ByteBuffer res_class) {
        ByteBuffer xclasshint = XClassHint.malloc();
        XClassHint.res_nameSet(xclasshint, res_name);
        XClassHint.res_classSet(xclasshint, res_class);
        return xclasshint;
    }

    public static ByteBuffer malloc(CharSequence res_name, CharSequence res_class) {
        ByteBuffer xclasshint = XClassHint.malloc();
        XClassHint.res_nameSet(xclasshint, res_name);
        XClassHint.res_classSet(xclasshint, res_class);
        return xclasshint;
    }

    public static void res_name(ByteBuffer xclasshint, long res_name) {
        PointerBuffer.put(xclasshint, xclasshint.position() + RES_NAME, res_name);
    }

    public static void res_nameSet(ByteBuffer xclasshint, ByteBuffer res_name) {
        XClassHint.res_name(xclasshint, res_name == null ? 0L : MemoryUtil.memAddress(Checks.checkNT1(res_name)));
    }

    public static void res_nameSet(ByteBuffer xclasshint, CharSequence res_name) {
        long l;
        if (res_name == null) {
            l = 0L;
        } else {
            ByteBuffer res_nameEncoded = MemoryUtil.memEncodeASCII(res_name);
            l = MemoryUtil.memAddress(res_nameEncoded);
        }
        XClassHint.res_name(xclasshint, l);
    }

    public static void res_class(ByteBuffer xclasshint, long res_class) {
        PointerBuffer.put(xclasshint, xclasshint.position() + RES_CLASS, res_class);
    }

    public static void res_classSet(ByteBuffer xclasshint, ByteBuffer res_class) {
        XClassHint.res_class(xclasshint, res_class == null ? 0L : MemoryUtil.memAddress(Checks.checkNT1(res_class)));
    }

    public static void res_classSet(ByteBuffer xclasshint, CharSequence res_class) {
        long l;
        if (res_class == null) {
            l = 0L;
        } else {
            ByteBuffer res_classEncoded = MemoryUtil.memEncodeASCII(res_class);
            l = MemoryUtil.memAddress(res_classEncoded);
        }
        XClassHint.res_class(xclasshint, l);
    }

    public static long res_name(ByteBuffer xclasshint) {
        return PointerBuffer.get(xclasshint, xclasshint.position() + RES_NAME);
    }

    public static ByteBuffer res_nameGetb(ByteBuffer xclasshint) {
        long address = XClassHint.res_name(xclasshint);
        return address == 0L ? null : MemoryUtil.memByteBufferNT1(address);
    }

    public static String res_nameGets(ByteBuffer xclasshint) {
        long address = XClassHint.res_name(xclasshint);
        return address == 0L ? null : MemoryUtil.memDecodeASCII(address);
    }

    public static long res_class(ByteBuffer xclasshint) {
        return PointerBuffer.get(xclasshint, xclasshint.position() + RES_CLASS);
    }

    public static ByteBuffer res_classGetb(ByteBuffer xclasshint) {
        long address = XClassHint.res_class(xclasshint);
        return address == 0L ? null : MemoryUtil.memByteBufferNT1(address);
    }

    public static String res_classGets(ByteBuffer xclasshint) {
        long address = XClassHint.res_class(xclasshint);
        return address == 0L ? null : MemoryUtil.memDecodeASCII(address);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(2);
        SIZEOF = XClassHint.offsets(MemoryUtil.memAddress(offsets));
        RES_NAME = offsets.get(0);
        RES_CLASS = offsets.get(1);
    }
}

