/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.linux.timeval;

public final class SysSelect {
    private SysSelect() {
    }

    public static native void nFD_CLR(int var0, long var1);

    public static void FD_CLR(int fd, long set) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(set);
        }
        SysSelect.nFD_CLR(fd, set);
    }

    public static native int nFD_ISSET(int var0, long var1);

    public static int FD_ISSET(int fd, long set) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(set);
        }
        return SysSelect.nFD_ISSET(fd, set);
    }

    public static native void nFD_SET(int var0, long var1);

    public static void FD_SET(int fd, long set) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(set);
        }
        SysSelect.nFD_SET(fd, set);
    }

    public static native void nFD_ZERO(long var0);

    public static void FD_ZERO(long set) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(set);
        }
        SysSelect.nFD_ZERO(set);
    }

    public static native int nselect(int var0, long var1, long var3, long var5, long var7);

    public static int select(int nfds, long readfds, long writefds, long exceptfds, ByteBuffer timeout) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(readfds);
            Checks.checkPointer(writefds);
            Checks.checkPointer(exceptfds);
            if (timeout != null) {
                Checks.checkBuffer((Buffer)timeout, timeval.SIZEOF);
            }
        }
        return SysSelect.nselect(nfds, readfds, writefds, exceptfds, MemoryUtil.memAddressSafe(timeout));
    }

    static {
        Sys.touch();
    }
}

