/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.lwjgl.system.DynamicLinkLibrary;
import org.lwjgl.system.linux.DynamicLinkLoader;

public class LinuxLibrary
extends DynamicLinkLibrary.Default {
    private final String name;
    private final long handle;

    public LinuxLibrary(String name) {
        this.name = name;
        long handle = DynamicLinkLoader.dlopen(name, 257);
        if (handle == 0L && name.endsWith(".so")) {
            handle = DynamicLinkLoader.dlopen(name + ".1", 257);
        }
        if (handle == 0L) {
            throw new RuntimeException("Failed to dynamically load library: " + name);
        }
        this.handle = handle;
    }

    @Override
    public long getPointer() {
        return this.handle;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getFunctionAddress(ByteBuffer name) {
        return DynamicLinkLoader.dlsym(this.handle, name);
    }

    @Override
    public long getFunctionAddress(CharSequence name) {
        return DynamicLinkLoader.dlsym(this.handle, name);
    }

    @Override
    protected void destroy() {
        DynamicLinkLoader.dlclose(this.handle);
    }
}

