/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.ByteBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class DynamicLinkLoader {
    public static final int RTLD_LAZY = 1;
    public static final int RTLD_NOW = 2;
    public static final int RTLD_BINDING_MASK = 3;
    public static final int RTLD_NOLOAD = 4;
    public static final int RTLD_DEEPBIND = 8;
    public static final int RTLD_GLOBAL = 256;
    public static final int RTLD_LOCAL = 0;
    public static final int RTLD_NODELETE = 4096;

    private DynamicLinkLoader() {
    }

    public static native long ndlopen(long var0, int var2);

    public static long dlopen(ByteBuffer filename, int mode) {
        if (LWJGLUtil.CHECKS && filename != null) {
            Checks.checkNT1(filename);
        }
        return DynamicLinkLoader.ndlopen(MemoryUtil.memAddressSafe(filename), mode);
    }

    public static long dlopen(CharSequence filename, int mode) {
        ByteBuffer filenameEncoded = MemoryUtil.memEncodeASCII(filename);
        return DynamicLinkLoader.ndlopen(MemoryUtil.memAddressSafe(filenameEncoded), mode);
    }

    public static native long ndlerror();

    public static String dlerror() {
        long __result = DynamicLinkLoader.ndlerror();
        return MemoryUtil.memDecodeASCII(__result);
    }

    public static native long ndlsym(long var0, long var2);

    public static long dlsym(long handle, ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(handle);
            Checks.checkNT1(name);
        }
        return DynamicLinkLoader.ndlsym(handle, MemoryUtil.memAddress(name));
    }

    public static long dlsym(long handle, CharSequence name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(handle);
        }
        ByteBuffer nameEncoded = MemoryUtil.memEncodeASCII(name);
        return DynamicLinkLoader.ndlsym(handle, MemoryUtil.memAddress(nameEncoded));
    }

    public static native int ndlclose(long var0);

    public static int dlclose(long handle) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(handle);
        }
        return DynamicLinkLoader.ndlclose(handle);
    }

    static {
        Sys.touch();
    }
}

