/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.libffi;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;

public final class ffi_type {
    public static final int SIZEOF;
    public static final int SIZE;
    public static final int ALIGNMENT;
    public static final int TYPE;
    public static final int ELEMENTS;

    private ffi_type() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long size, int alignment, int type, long elements) {
        ByteBuffer ffi_type2 = ffi_type.malloc();
        ffi_type.size(ffi_type2, size);
        ffi_type.alignment(ffi_type2, alignment);
        ffi_type.type(ffi_type2, type);
        ffi_type.elements(ffi_type2, elements);
        return ffi_type2;
    }

    public static ByteBuffer malloc(long size, int alignment, int type, ByteBuffer elements) {
        ByteBuffer ffi_type2 = ffi_type.malloc();
        ffi_type.size(ffi_type2, size);
        ffi_type.alignment(ffi_type2, alignment);
        ffi_type.type(ffi_type2, type);
        ffi_type.elements(ffi_type2, elements);
        return ffi_type2;
    }

    public static void size(ByteBuffer ffi_type2, long size) {
        PointerBuffer.put(ffi_type2, ffi_type2.position() + SIZE, size);
    }

    public static void alignment(ByteBuffer ffi_type2, int alignment) {
        ffi_type2.putShort(ffi_type2.position() + ALIGNMENT, (short)alignment);
    }

    public static void type(ByteBuffer ffi_type2, int type) {
        ffi_type2.putShort(ffi_type2.position() + TYPE, (short)type);
    }

    public static void elements(ByteBuffer ffi_type2, long elements) {
        PointerBuffer.put(ffi_type2, ffi_type2.position() + ELEMENTS, elements);
    }

    public static void elements(ByteBuffer ffi_type2, ByteBuffer elements) {
        ffi_type.elements(ffi_type2, MemoryUtil.memAddress(elements));
    }

    public static long size(ByteBuffer ffi_type2) {
        return PointerBuffer.get(ffi_type2, ffi_type2.position() + SIZE);
    }

    public static int alignment(ByteBuffer ffi_type2) {
        return ffi_type2.getShort(ffi_type2.position() + ALIGNMENT) & 0xFFFF;
    }

    public static int type(ByteBuffer ffi_type2) {
        return ffi_type2.getShort(ffi_type2.position() + TYPE) & 0xFFFF;
    }

    public static long elements(ByteBuffer ffi_type2) {
        return PointerBuffer.get(ffi_type2, ffi_type2.position() + ELEMENTS);
    }

    public static ByteBuffer elements(ByteBuffer ffi_type2, int size) {
        long address = ffi_type.elements(ffi_type2);
        return address == 0L ? null : MemoryUtil.memByteBuffer(address, size);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(4);
        SIZEOF = ffi_type.offsets(MemoryUtil.memAddress(offsets));
        SIZE = offsets.get(0);
        ALIGNMENT = offsets.get(1);
        TYPE = offsets.get(2);
        ELEMENTS = offsets.get(3);
    }
}

