/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.libffi;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.libffi.ffi_type;

public final class ffi_cif {
    public static final int SIZEOF;
    public static final int ABI;
    public static final int NARGS;
    public static final int ARG_TYPES;
    public static final int RTYPE;
    public static final int BYTES;
    public static final int FLAGS;

    private ffi_cif() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int abi, int nargs, long arg_types, long rtype, int bytes, int flags) {
        ByteBuffer ffi_cif2 = ffi_cif.malloc();
        ffi_cif.abi(ffi_cif2, abi);
        ffi_cif.nargs(ffi_cif2, nargs);
        ffi_cif.arg_types(ffi_cif2, arg_types);
        ffi_cif.rtype(ffi_cif2, rtype);
        ffi_cif.bytes(ffi_cif2, bytes);
        ffi_cif.flags(ffi_cif2, flags);
        return ffi_cif2;
    }

    public static ByteBuffer malloc(int abi, int nargs, ByteBuffer arg_types, ByteBuffer rtype, int bytes, int flags) {
        ByteBuffer ffi_cif2 = ffi_cif.malloc();
        ffi_cif.abi(ffi_cif2, abi);
        ffi_cif.nargs(ffi_cif2, nargs);
        ffi_cif.arg_types(ffi_cif2, arg_types);
        ffi_cif.rtype(ffi_cif2, rtype);
        ffi_cif.bytes(ffi_cif2, bytes);
        ffi_cif.flags(ffi_cif2, flags);
        return ffi_cif2;
    }

    public static void abi(ByteBuffer ffi_cif2, int abi) {
        ffi_cif2.putInt(ffi_cif2.position() + ABI, abi);
    }

    public static void nargs(ByteBuffer ffi_cif2, int nargs) {
        ffi_cif2.putInt(ffi_cif2.position() + NARGS, nargs);
    }

    public static void arg_types(ByteBuffer ffi_cif2, long arg_types) {
        PointerBuffer.put(ffi_cif2, ffi_cif2.position() + ARG_TYPES, arg_types);
    }

    public static void arg_types(ByteBuffer ffi_cif2, ByteBuffer arg_types) {
        ffi_cif.arg_types(ffi_cif2, MemoryUtil.memAddress(arg_types));
    }

    public static void rtype(ByteBuffer ffi_cif2, long rtype) {
        PointerBuffer.put(ffi_cif2, ffi_cif2.position() + RTYPE, rtype);
    }

    public static void rtype(ByteBuffer ffi_cif2, ByteBuffer rtype) {
        ffi_cif.rtype(ffi_cif2, MemoryUtil.memAddress(rtype));
    }

    public static void bytes(ByteBuffer ffi_cif2, int bytes) {
        ffi_cif2.putInt(ffi_cif2.position() + BYTES, bytes);
    }

    public static void flags(ByteBuffer ffi_cif2, int flags) {
        ffi_cif2.putInt(ffi_cif2.position() + FLAGS, flags);
    }

    public static int abi(ByteBuffer ffi_cif2) {
        return ffi_cif2.getInt(ffi_cif2.position() + ABI);
    }

    public static int nargs(ByteBuffer ffi_cif2) {
        return ffi_cif2.getInt(ffi_cif2.position() + NARGS);
    }

    public static long arg_types(ByteBuffer ffi_cif2) {
        return PointerBuffer.get(ffi_cif2, ffi_cif2.position() + ARG_TYPES);
    }

    public static ByteBuffer arg_types(ByteBuffer ffi_cif2, int size) {
        long address = ffi_cif.arg_types(ffi_cif2);
        return address == 0L ? null : MemoryUtil.memByteBuffer(address, size);
    }

    public static long rtype(ByteBuffer ffi_cif2) {
        return PointerBuffer.get(ffi_cif2, ffi_cif2.position() + RTYPE);
    }

    public static ByteBuffer rtypeb(ByteBuffer ffi_cif2) {
        return MemoryUtil.memByteBuffer(ffi_cif.rtype(ffi_cif2), ffi_type.SIZEOF);
    }

    public static int bytes(ByteBuffer ffi_cif2) {
        return ffi_cif2.getInt(ffi_cif2.position() + BYTES);
    }

    public static int flags(ByteBuffer ffi_cif2) {
        return ffi_cif2.getInt(ffi_cif2.position() + FLAGS);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(6);
        SIZEOF = ffi_cif.offsets(MemoryUtil.memAddress(offsets));
        ABI = offsets.get(0);
        NARGS = offsets.get(1);
        ARG_TYPES = offsets.get(2);
        RTYPE = offsets.get(3);
        BYTES = offsets.get(4);
        FLAGS = offsets.get(5);
    }
}

