/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.libffi;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.Sys;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.libffi.LibFFIConstants;
import org.lwjgl.system.libffi.ffi_cif;
import org.lwjgl.system.libffi.ffi_type;

public final class LibFFI {
    public static final int FFI_TYPE_VOID = 0;
    public static final int FFI_TYPE_INT = 1;
    public static final int FFI_TYPE_FLOAT = 2;
    public static final int FFI_TYPE_DOUBLE = 3;
    public static final int FFI_TYPE_LONGDOUBLE = LibFFIConstants.FFI_TYPE_DOUBLE();
    public static final int FFI_TYPE_UINT8 = 5;
    public static final int FFI_TYPE_SINT8 = 6;
    public static final int FFI_TYPE_UINT16 = 7;
    public static final int FFI_TYPE_SINT16 = 8;
    public static final int FFI_TYPE_UINT32 = 9;
    public static final int FFI_TYPE_SINT32 = 10;
    public static final int FFI_TYPE_UINT64 = 11;
    public static final int FFI_TYPE_SINT64 = 12;
    public static final int FFI_TYPE_STRUCT = 13;
    public static final int FFI_TYPE_POINTER = 14;
    public static final int FFI_SYSV = 1;
    public static final int FFI_STDCALL = 2;
    public static final int FFI_THISCALL = 3;
    public static final int FFI_FASTCALL = 4;
    public static final int FFI_MS_CDECL = 5;
    public static final int FFI_WIN64 = 1;
    public static final int FFI_UNIX64 = 2;
    public static final int FFI_DEFAULT_ABI = LibFFIConstants.FFI_DEFAULT_ABI();
    public static final int FFI_OK = 0;
    public static final int FFI_BAD_TYPEDEF = 1;
    public static final int FFI_BAD_ABI = 2;
    public static final long ffi_type_void = LibFFIConstants.ffi_type_void();
    public static final long ffi_type_uint8 = LibFFIConstants.ffi_type_uint8();
    public static final long ffi_type_sint8 = LibFFIConstants.ffi_type_sint8();
    public static final long ffi_type_uint16 = LibFFIConstants.ffi_type_uint16();
    public static final long ffi_type_sint16 = LibFFIConstants.ffi_type_sint16();
    public static final long ffi_type_uint32 = LibFFIConstants.ffi_type_uint32();
    public static final long ffi_type_sint32 = LibFFIConstants.ffi_type_sint32();
    public static final long ffi_type_uint64 = LibFFIConstants.ffi_type_uint64();
    public static final long ffi_type_sint64 = LibFFIConstants.ffi_type_sint64();
    public static final long ffi_type_uchar = LibFFIConstants.ffi_type_uchar();
    public static final long ffi_type_schar = LibFFIConstants.ffi_type_schar();
    public static final long ffi_type_sshort = LibFFIConstants.ffi_type_sshort();
    public static final long ffi_type_ushort = LibFFIConstants.ffi_type_ushort();
    public static final long ffi_type_uint = LibFFIConstants.ffi_type_uint();
    public static final long ffi_type_sint = LibFFIConstants.ffi_type_sint();
    public static final long ffi_type_ulong = LibFFIConstants.ffi_type_ulong();
    public static final long ffi_type_slong = LibFFIConstants.ffi_type_slong();
    public static final long ffi_type_float = LibFFIConstants.ffi_type_float();
    public static final long ffi_type_double = LibFFIConstants.ffi_type_double();
    public static final long ffi_type_longdouble = LibFFIConstants.ffi_type_longdouble();
    public static final long ffi_type_pointer = LibFFIConstants.ffi_type_pointer();

    private LibFFI() {
    }

    public static native int nffi_prep_cif(long var0, int var2, int var3, long var4, long var6);

    public static int ffi_prep_cif(ByteBuffer cif, int abi, int nargs, ByteBuffer rtype, ByteBuffer atypes) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)cif, ffi_cif.SIZEOF);
            if (atypes != null) {
                Checks.checkBuffer((Buffer)atypes, nargs << Pointer.POINTER_SHIFT);
            }
            Checks.checkBuffer((Buffer)rtype, ffi_type.SIZEOF);
        }
        return LibFFI.nffi_prep_cif(MemoryUtil.memAddress(cif), abi, nargs, MemoryUtil.memAddress(rtype), MemoryUtil.memAddressSafe(atypes));
    }

    public static int ffi_prep_cif(ByteBuffer cif, int abi, ByteBuffer rtype, PointerBuffer atypes) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)cif, ffi_cif.SIZEOF);
            Checks.checkBuffer((Buffer)rtype, ffi_type.SIZEOF);
        }
        return LibFFI.nffi_prep_cif(MemoryUtil.memAddress(cif), abi, atypes == null ? 0 : atypes.remaining(), MemoryUtil.memAddress(rtype), MemoryUtil.memAddressSafe(atypes));
    }

    public static native int nffi_prep_cif_var(long var0, int var2, int var3, int var4, long var5, long var7);

    public static int ffi_prep_cif_var(ByteBuffer cif, int abi, int nfixedargs, int ntotalargs, ByteBuffer rtype, ByteBuffer atypes) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)cif, ffi_cif.SIZEOF);
            Checks.checkBuffer((Buffer)atypes, ntotalargs << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)rtype, ffi_type.SIZEOF);
        }
        return LibFFI.nffi_prep_cif_var(MemoryUtil.memAddress(cif), abi, nfixedargs, ntotalargs, MemoryUtil.memAddress(rtype), MemoryUtil.memAddress(atypes));
    }

    public static int ffi_prep_cif_var(ByteBuffer cif, int abi, int nfixedargs, ByteBuffer rtype, PointerBuffer atypes) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)cif, ffi_cif.SIZEOF);
            Checks.checkBuffer((Buffer)rtype, ffi_type.SIZEOF);
        }
        return LibFFI.nffi_prep_cif_var(MemoryUtil.memAddress(cif), abi, nfixedargs, atypes.remaining(), MemoryUtil.memAddress(rtype), MemoryUtil.memAddress(atypes));
    }

    public static native void nffi_call(long var0, long var2, long var4, long var6);

    public static void ffi_call(ByteBuffer cif, long fn, ByteBuffer rvalue, ByteBuffer avalue) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)cif, ffi_cif.SIZEOF);
            Checks.checkPointer(fn);
        }
        LibFFI.nffi_call(MemoryUtil.memAddress(cif), fn, MemoryUtil.memAddressSafe(rvalue), MemoryUtil.memAddressSafe(avalue));
    }

    public static void ffi_call(ByteBuffer cif, long fn, ByteBuffer rvalue, PointerBuffer avalue) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)cif, ffi_cif.SIZEOF);
            Checks.checkPointer(fn);
        }
        LibFFI.nffi_call(MemoryUtil.memAddress(cif), fn, MemoryUtil.memAddressSafe(rvalue), MemoryUtil.memAddressSafe(avalue));
    }

    static {
        Sys.touch();
    }
}

