/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.glfw;

import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.PhasedBackoffWaitStrategy;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.Sequence;
import com.lmax.disruptor.SequenceBarrier;
import com.lmax.disruptor.WaitStrategy;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.lwjgl.BufferUtils;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.glfw.WindowCallback;

final class WindowCallbackMacOSX
extends WindowCallback {
    private static final int BUFFER_SIZE = 32;
    private static final RingBuffer<AsyncEvent> ringBuffer = RingBuffer.createSingleProducer((EventFactory)new EventFactory<AsyncEvent>(){

        public AsyncEvent newInstance() {
            return new AsyncEvent();
        }
    }, (int)32, (WaitStrategy)PhasedBackoffWaitStrategy.withSleep((long)1L, (long)1L, (TimeUnit)TimeUnit.MILLISECONDS));
    private static final SequenceBarrier publishBarrier = ringBuffer.newBarrier(new Sequence[0]);
    private static final Sequence consumeSequence = new Sequence(-1L);
    private final WindowCallback target;

    WindowCallbackMacOSX(WindowCallback target) {
        this.target = target;
    }

    private static void offer(WindowCallback target, WindowCallback.Event event, long window, long x, long y) {
        WindowCallbackMacOSX.offer(target, event, window, x, y, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void offer(WindowCallback target, WindowCallback.Event event, long window, long x, long y, ByteBuffer data) {
        long next = ringBuffer.next();
        try {
            AsyncEvent asyncEvent = (AsyncEvent)ringBuffer.get(next);
            asyncEvent.target = target;
            asyncEvent.event = event;
            asyncEvent.window = window;
            asyncEvent.a = x;
            asyncEvent.b = y;
            asyncEvent.data = data;
        }
        finally {
            ringBuffer.publish(next);
        }
    }

    private static void offer(WindowCallback target, WindowCallback.Event event, long window) {
        WindowCallbackMacOSX.offer(target, event, window, 0L, 0L);
    }

    private static void offer(WindowCallback target, WindowCallback.Event event, long window, long x) {
        WindowCallbackMacOSX.offer(target, event, window, x, 0L);
    }

    @Override
    public void windowPos(long window, int xpos, int ypos) {
        WindowCallbackMacOSX.offer(this.target, WindowCallback.Event.WINDOW_POS, window, xpos, ypos);
    }

    @Override
    public void windowSize(long window, int width, int height) {
        WindowCallbackMacOSX.offer(this.target, WindowCallback.Event.WINDOW_SIZE, window, width, height);
    }

    @Override
    public void windowClose(long window) {
        WindowCallbackMacOSX.offer(this.target, WindowCallback.Event.WINDOW_CLOSE, window);
    }

    @Override
    public void windowRefresh(long window) {
        WindowCallbackMacOSX.offer(this.target, WindowCallback.Event.WINDOW_REFRESH, window);
    }

    @Override
    public void windowFocus(long window, int focused) {
        WindowCallbackMacOSX.offer(this.target, WindowCallback.Event.WINDOW_FOCUS, window, focused);
    }

    @Override
    public void windowIconify(long window, int iconified) {
        WindowCallbackMacOSX.offer(this.target, WindowCallback.Event.WINDOW_ICONIFY, window, iconified);
    }

    @Override
    public void framebufferSize(long window, int width, int height) {
        WindowCallbackMacOSX.offer(this.target, WindowCallback.Event.FRAMEBUFFER_SIZE, window, width, height);
    }

    @Override
    public void key(long window, int key, int scancode, int action, int mods) {
        long x = (long)key << 32 | (long)scancode;
        long y = (long)action << 32 | (long)mods;
        WindowCallbackMacOSX.offer(this.target, WindowCallback.Event.KEY, window, x, y);
    }

    @Override
    public void character(long window, int codepoint) {
        WindowCallbackMacOSX.offer(this.target, WindowCallback.Event.CHARACTER, window, codepoint);
    }

    @Override
    public void charMods(long window, int codepoint, int mods) {
        WindowCallbackMacOSX.offer(this.target, WindowCallback.Event.CHARMODS, window, codepoint, mods);
    }

    @Override
    public void mouseButton(long window, int button, int action, int mods) {
        long x = button;
        long y = (long)action << 32 | (long)mods;
        WindowCallbackMacOSX.offer(this.target, WindowCallback.Event.MOUSE_BUTTON, window, x, y);
    }

    @Override
    public void cursorPos(long window, double xpos, double ypos) {
        long x = Double.doubleToRawLongBits(xpos);
        long y = Double.doubleToRawLongBits(ypos);
        WindowCallbackMacOSX.offer(this.target, WindowCallback.Event.CURSOR_POS, window, x, y);
    }

    @Override
    public void cursorEnter(long window, int entered) {
        WindowCallbackMacOSX.offer(this.target, WindowCallback.Event.CURSOR_ENTER, window, entered);
    }

    @Override
    public void scroll(long window, double xoffset, double yoffset) {
        long x = Double.doubleToRawLongBits(xoffset);
        long y = Double.doubleToRawLongBits(yoffset);
        WindowCallbackMacOSX.offer(this.target, WindowCallback.Event.SCROLL, window, x, y);
    }

    @Override
    public void drop(long window, int count, long names) {
        int[] lengths = new int[count];
        int totalLength = 0;
        for (int i = 0; i < count; ++i) {
            long a = MemoryUtil.memGetAddress(names + (long)(i * Pointer.POINTER_SIZE));
            int length = 1;
            while (MemoryUtil.memGetByte(a++) != 0) {
                ++length;
            }
            lengths[i] = length;
            totalLength += length;
        }
        ByteBuffer copy = BufferUtils.createByteBuffer(count * Pointer.POINTER_SIZE + totalLength);
        long BASE = MemoryUtil.memAddress(copy);
        long offset = BASE + (long)(count * Pointer.POINTER_SIZE);
        for (int i = 0; i < count; ++i) {
            PointerBuffer.put(copy, i * Pointer.POINTER_SIZE, offset);
            MemoryUtil.memCopy(MemoryUtil.memGetAddress(names + (long)(i * Pointer.POINTER_SIZE)), offset, lengths[i]);
            offset += (long)lengths[i];
        }
        WindowCallbackMacOSX.offer(this.target, WindowCallback.Event.DROP, window, count, BASE, copy);
    }

    static void pollEvents() {
        long consumeMax;
        long consumeNext = consumeSequence.get() + 1L;
        if (consumeNext <= (consumeMax = publishBarrier.getCursor())) {
            do {
                ((AsyncEvent)ringBuffer.get(consumeNext)).fire();
            } while (++consumeNext <= consumeMax);
            consumeSequence.set(consumeMax);
        }
    }

    static void waitEvents() {
        try {
            publishBarrier.waitFor(consumeSequence.get() + 1L);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        WindowCallbackMacOSX.pollEvents();
    }

    static {
        ringBuffer.addGatingSequences(new Sequence[]{consumeSequence});
    }

    private static class AsyncEvent {
        WindowCallback target;
        WindowCallback.Event event;
        long window;
        long a;
        long b;
        ByteBuffer data;

        private AsyncEvent() {
        }

        static int hi(long v) {
            return (int)(v >>> 32);
        }

        static int lo(long v) {
            return (int)v;
        }

        void fire() {
            switch (this.event) {
                case WINDOW_POS: {
                    this.target.windowPos(this.window, (int)this.a, (int)this.b);
                    break;
                }
                case WINDOW_SIZE: {
                    this.target.windowSize(this.window, (int)this.a, (int)this.b);
                    break;
                }
                case WINDOW_CLOSE: {
                    this.target.windowClose(this.window);
                    break;
                }
                case WINDOW_REFRESH: {
                    this.target.windowRefresh(this.window);
                    break;
                }
                case WINDOW_FOCUS: {
                    this.target.windowFocus(this.window, (int)this.a);
                    break;
                }
                case WINDOW_ICONIFY: {
                    this.target.windowIconify(this.window, (int)this.a);
                    break;
                }
                case FRAMEBUFFER_SIZE: {
                    this.target.framebufferSize(this.window, (int)this.a, (int)this.b);
                    break;
                }
                case KEY: {
                    this.target.key(this.window, AsyncEvent.hi(this.a), AsyncEvent.lo(this.a), AsyncEvent.hi(this.b), AsyncEvent.lo(this.b));
                    break;
                }
                case CHARACTER: {
                    this.target.character(this.window, (int)this.a);
                    break;
                }
                case CHARMODS: {
                    this.target.charMods(this.window, (int)this.a, (int)this.b);
                    break;
                }
                case MOUSE_BUTTON: {
                    this.target.mouseButton(this.window, (int)this.a, AsyncEvent.hi(this.b), AsyncEvent.lo(this.b));
                    break;
                }
                case CURSOR_POS: {
                    this.target.cursorPos(this.window, Double.longBitsToDouble(this.a), Double.longBitsToDouble(this.b));
                    break;
                }
                case CURSOR_ENTER: {
                    this.target.cursorEnter(this.window, (int)this.a);
                    break;
                }
                case SCROLL: {
                    this.target.scroll(this.window, Double.longBitsToDouble(this.a), Double.longBitsToDouble(this.b));
                    break;
                }
                case DROP: {
                    this.target.drop(this.window, (int)this.a, this.b);
                    this.data = null;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported event type: " + this.event.name());
                }
            }
        }
    }
}

