/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.glfw;

import java.lang.reflect.Method;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.glfw.GLFW;
import org.lwjgl.system.glfw.WindowCallbackAdapter;
import org.lwjgl.system.glfw.WindowCallbackMacOSX;
import org.lwjgl.system.macosx.EventLoop;

public abstract class WindowCallback {
    static final long[] CALLBACKS;
    public static final EnumSet<Event> ALL;
    private static final Set<Long> windows;
    private EnumSet<Event> eventTypes = EnumSet.noneOf(Event.class);

    protected WindowCallback() {
    }

    private static native void setCallbacks(Method[] var0, long var1);

    public static void set(long window, WindowCallback proc) {
        WindowCallback.set(window, proc, ALL);
    }

    public static void set(long window, WindowCallback proc, EnumSet<Event> eventTypes) {
        long oldRef = GLFW.glfwGetWindowUserPointer(window);
        if (oldRef != 0L) {
            WindowCallback.cleanup(window, oldRef);
            windows.remove(window);
        }
        if (proc != null) {
            if (LWJGLUtil.getPlatform() == LWJGLUtil.Platform.MACOSX && !EventLoop.STARTED_ON_FIRST_THREAD) {
                proc = new WindowCallbackMacOSX(proc);
                eventTypes = ALL;
            }
            windows.add(window);
            GLFW.glfwSetWindowUserPointer(window, MemoryUtil.memGlobalRefNew(proc));
            proc.eventTypes.clear();
            proc.eventTypes.addAll(eventTypes);
            WindowCallback.configEvents(window, eventTypes, 1L);
        }
    }

    private static void cleanup(long window, long oldRef) {
        WindowCallback old = (WindowCallback)MemoryUtil.memGlobalRefToObject(oldRef);
        WindowCallback.configEvents(window, old.eventTypes, 0L);
        GLFW.glfwSetWindowUserPointer(window, 0L);
        MemoryUtil.memGlobalRefDelete(oldRef);
    }

    private static void configEvents(long window, EnumSet<Event> eventTypes, long enable) {
        block17: for (Event event : eventTypes) {
            long callback = CALLBACKS[event.ordinal()] * enable;
            switch (event) {
                case WINDOW_POS: {
                    GLFW.glfwSetWindowPosCallback(window, callback);
                    continue block17;
                }
                case WINDOW_SIZE: {
                    GLFW.glfwSetWindowSizeCallback(window, callback);
                    continue block17;
                }
                case WINDOW_CLOSE: {
                    GLFW.glfwSetWindowCloseCallback(window, callback);
                    continue block17;
                }
                case WINDOW_REFRESH: {
                    GLFW.glfwSetWindowRefreshCallback(window, callback);
                    continue block17;
                }
                case WINDOW_FOCUS: {
                    GLFW.glfwSetWindowFocusCallback(window, callback);
                    continue block17;
                }
                case WINDOW_ICONIFY: {
                    GLFW.glfwSetWindowIconifyCallback(window, callback);
                    continue block17;
                }
                case FRAMEBUFFER_SIZE: {
                    GLFW.glfwSetFramebufferSizeCallback(window, callback);
                    continue block17;
                }
                case KEY: {
                    GLFW.glfwSetKeyCallback(window, callback);
                    continue block17;
                }
                case CHARACTER: {
                    GLFW.glfwSetCharCallback(window, callback);
                    continue block17;
                }
                case CHARMODS: {
                    GLFW.glfwSetCharModsCallback(window, callback);
                    continue block17;
                }
                case MOUSE_BUTTON: {
                    GLFW.glfwSetMouseButtonCallback(window, callback);
                    continue block17;
                }
                case CURSOR_POS: {
                    GLFW.glfwSetCursorPosCallback(window, callback);
                    continue block17;
                }
                case CURSOR_ENTER: {
                    GLFW.glfwSetCursorEnterCallback(window, callback);
                    continue block17;
                }
                case SCROLL: {
                    GLFW.glfwSetScrollCallback(window, callback);
                    continue block17;
                }
                case DROP: {
                    GLFW.glfwSetDropCallback(window, callback);
                    continue block17;
                }
            }
            throw new IllegalStateException("Unsupported event type: " + event.name());
        }
    }

    static void clearAll() {
        for (Long window : windows) {
            WindowCallback.cleanup(window, GLFW.glfwGetWindowUserPointer(window));
        }
        windows.clear();
    }

    public abstract void windowPos(long var1, int var3, int var4);

    public abstract void windowSize(long var1, int var3, int var4);

    public abstract void windowClose(long var1);

    public abstract void windowRefresh(long var1);

    public abstract void windowFocus(long var1, int var3);

    public abstract void windowIconify(long var1, int var3);

    public abstract void framebufferSize(long var1, int var3, int var4);

    public abstract void key(long var1, int var3, int var4, int var5, int var6);

    public abstract void character(long var1, int var3);

    public abstract void charMods(long var1, int var3, int var4);

    public abstract void mouseButton(long var1, int var3, int var4, int var5);

    public abstract void cursorPos(long var1, double var3, double var5);

    public abstract void cursorEnter(long var1, int var3);

    public abstract void scroll(long var1, double var3, double var5);

    public abstract void drop(long var1, int var3, long var4);

    static void windowCreated(long window) {
        if (LWJGLUtil.getPlatform() == LWJGLUtil.Platform.MACOSX && !EventLoop.STARTED_ON_FIRST_THREAD) {
            WindowCallback.set(window, new WindowCallbackAdapter());
        }
    }

    static boolean pollEventsOverride() {
        if (LWJGLUtil.getPlatform() == LWJGLUtil.Platform.MACOSX && !EventLoop.STARTED_ON_FIRST_THREAD) {
            WindowCallbackMacOSX.pollEvents();
            return true;
        }
        return false;
    }

    static boolean waitEventsOverride() {
        if (LWJGLUtil.getPlatform() == LWJGLUtil.Platform.MACOSX && !EventLoop.STARTED_ON_FIRST_THREAD) {
            WindowCallbackMacOSX.waitEvents();
            return true;
        }
        return false;
    }

    static {
        ALL = EnumSet.allOf(Event.class);
        try {
            Event[] events = Event.values();
            Method[] callbacks = new Method[events.length];
            for (Event e : events) {
                callbacks[e.ordinal()] = WindowCallback.class.getMethod(e.method, e.parameterTypes);
            }
            PointerBuffer procs = BufferUtils.createPointerBuffer(callbacks.length);
            WindowCallback.setCallbacks(callbacks, MemoryUtil.memAddress(procs));
            CALLBACKS = new long[callbacks.length];
            for (int i = 0; i < CALLBACKS.length; ++i) {
                WindowCallback.CALLBACKS[i] = procs.get(i);
                if (CALLBACKS[i] != 0L) continue;
                throw new IllegalStateException();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        windows = new HashSet<Long>();
    }

    public static enum Event {
        WINDOW_POS("windowPos", Long.TYPE, Integer.TYPE, Integer.TYPE),
        WINDOW_SIZE("windowSize", Long.TYPE, Integer.TYPE, Integer.TYPE),
        WINDOW_CLOSE("windowClose", Long.TYPE),
        WINDOW_REFRESH("windowRefresh", Long.TYPE),
        WINDOW_FOCUS("windowFocus", Long.TYPE, Integer.TYPE),
        WINDOW_ICONIFY("windowIconify", Long.TYPE, Integer.TYPE),
        FRAMEBUFFER_SIZE("framebufferSize", Long.TYPE, Integer.TYPE, Integer.TYPE),
        KEY("key", Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE),
        CHARACTER("character", Long.TYPE, Integer.TYPE),
        CHARMODS("charMods", Long.TYPE, Integer.TYPE, Integer.TYPE),
        MOUSE_BUTTON("mouseButton", Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE),
        CURSOR_POS("cursorPos", Long.TYPE, Double.TYPE, Double.TYPE),
        CURSOR_ENTER("cursorEnter", Long.TYPE, Integer.TYPE),
        SCROLL("scroll", Long.TYPE, Double.TYPE, Double.TYPE),
        DROP("drop", Long.TYPE, Integer.TYPE, Long.TYPE);

        private final String method;
        private final Class<?>[] parameterTypes;

        private Event(String method, Class<?> ... parameterTypes) {
            this.method = method;
            this.parameterTypes = parameterTypes;
        }
    }
}

