/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.glfw;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;

public final class GLFWimage {
    public static final int SIZEOF;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int PIXELS;

    private GLFWimage() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int width, int height, long pixels) {
        ByteBuffer glfwimage = GLFWimage.malloc();
        GLFWimage.width(glfwimage, width);
        GLFWimage.height(glfwimage, height);
        GLFWimage.pixels(glfwimage, pixels);
        return glfwimage;
    }

    public static ByteBuffer malloc(int width, int height, ByteBuffer pixels) {
        ByteBuffer glfwimage = GLFWimage.malloc();
        GLFWimage.width(glfwimage, width);
        GLFWimage.height(glfwimage, height);
        GLFWimage.pixels(glfwimage, pixels);
        return glfwimage;
    }

    public static void width(ByteBuffer glfwimage, int width) {
        glfwimage.putInt(glfwimage.position() + WIDTH, width);
    }

    public static void height(ByteBuffer glfwimage, int height) {
        glfwimage.putInt(glfwimage.position() + HEIGHT, height);
    }

    public static void pixels(ByteBuffer glfwimage, long pixels) {
        PointerBuffer.put(glfwimage, glfwimage.position() + PIXELS, pixels);
    }

    public static void pixels(ByteBuffer glfwimage, ByteBuffer pixels) {
        GLFWimage.pixels(glfwimage, MemoryUtil.memAddress(pixels));
    }

    public static int width(ByteBuffer glfwimage) {
        return glfwimage.getInt(glfwimage.position() + WIDTH);
    }

    public static int height(ByteBuffer glfwimage) {
        return glfwimage.getInt(glfwimage.position() + HEIGHT);
    }

    public static long pixels(ByteBuffer glfwimage) {
        return PointerBuffer.get(glfwimage, glfwimage.position() + PIXELS);
    }

    public static ByteBuffer pixels(ByteBuffer glfwimage, int size) {
        long address = GLFWimage.pixels(glfwimage);
        return address == 0L ? null : MemoryUtil.memByteBuffer(address, size);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(3);
        SIZEOF = GLFWimage.offsets(MemoryUtil.memAddress(offsets));
        WIDTH = offsets.get(0);
        HEIGHT = offsets.get(1);
        PIXELS = offsets.get(2);
    }
}

