/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.glfw;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryUtil;

public final class GLFWgammaramp {
    public static final int SIZEOF;
    public static final int RED;
    public static final int GREEN;
    public static final int BLUE;
    public static final int SIZE;

    private GLFWgammaramp() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long red, long green, long blue, int size) {
        ByteBuffer glfwgammaramp = GLFWgammaramp.malloc();
        GLFWgammaramp.red(glfwgammaramp, red);
        GLFWgammaramp.green(glfwgammaramp, green);
        GLFWgammaramp.blue(glfwgammaramp, blue);
        GLFWgammaramp.size(glfwgammaramp, size);
        return glfwgammaramp;
    }

    public static ByteBuffer malloc(ByteBuffer red, ByteBuffer green, ByteBuffer blue, int size) {
        ByteBuffer glfwgammaramp = GLFWgammaramp.malloc();
        GLFWgammaramp.red(glfwgammaramp, red);
        GLFWgammaramp.green(glfwgammaramp, green);
        GLFWgammaramp.blue(glfwgammaramp, blue);
        GLFWgammaramp.size(glfwgammaramp, size);
        return glfwgammaramp;
    }

    public static void red(ByteBuffer glfwgammaramp, long red) {
        PointerBuffer.put(glfwgammaramp, glfwgammaramp.position() + RED, red);
    }

    public static void red(ByteBuffer glfwgammaramp, ByteBuffer red) {
        GLFWgammaramp.red(glfwgammaramp, MemoryUtil.memAddress(red));
    }

    public static void green(ByteBuffer glfwgammaramp, long green) {
        PointerBuffer.put(glfwgammaramp, glfwgammaramp.position() + GREEN, green);
    }

    public static void green(ByteBuffer glfwgammaramp, ByteBuffer green) {
        GLFWgammaramp.green(glfwgammaramp, MemoryUtil.memAddress(green));
    }

    public static void blue(ByteBuffer glfwgammaramp, long blue) {
        PointerBuffer.put(glfwgammaramp, glfwgammaramp.position() + BLUE, blue);
    }

    public static void blue(ByteBuffer glfwgammaramp, ByteBuffer blue) {
        GLFWgammaramp.blue(glfwgammaramp, MemoryUtil.memAddress(blue));
    }

    public static void size(ByteBuffer glfwgammaramp, int size) {
        glfwgammaramp.putInt(glfwgammaramp.position() + SIZE, size);
    }

    public static long red(ByteBuffer glfwgammaramp) {
        return PointerBuffer.get(glfwgammaramp, glfwgammaramp.position() + RED);
    }

    public static ByteBuffer red(ByteBuffer glfwgammaramp, int size) {
        long address = GLFWgammaramp.red(glfwgammaramp);
        return address == 0L ? null : MemoryUtil.memByteBuffer(address, size);
    }

    public static long green(ByteBuffer glfwgammaramp) {
        return PointerBuffer.get(glfwgammaramp, glfwgammaramp.position() + GREEN);
    }

    public static ByteBuffer green(ByteBuffer glfwgammaramp, int size) {
        long address = GLFWgammaramp.green(glfwgammaramp);
        return address == 0L ? null : MemoryUtil.memByteBuffer(address, size);
    }

    public static long blue(ByteBuffer glfwgammaramp) {
        return PointerBuffer.get(glfwgammaramp, glfwgammaramp.position() + BLUE);
    }

    public static ByteBuffer blue(ByteBuffer glfwgammaramp, int size) {
        long address = GLFWgammaramp.blue(glfwgammaramp);
        return address == 0L ? null : MemoryUtil.memByteBuffer(address, size);
    }

    public static int size(ByteBuffer glfwgammaramp) {
        return glfwgammaramp.getInt(glfwgammaramp.position() + SIZE);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(4);
        SIZEOF = GLFWgammaramp.offsets(MemoryUtil.memAddress(offsets));
        RED = offsets.get(0);
        GREEN = offsets.get(1);
        BLUE = offsets.get(2);
        SIZE = offsets.get(3);
    }
}

