/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.glfw;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.Sys;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.glfw.ErrorCallback;
import org.lwjgl.system.glfw.GLFWgammaramp;
import org.lwjgl.system.glfw.GLFWimage;
import org.lwjgl.system.glfw.GLFWvidmode;
import org.lwjgl.system.glfw.MonitorCallback;
import org.lwjgl.system.glfw.WindowCallback;
import org.lwjgl.system.macosx.EventLoop;

public final class GLFW {
    public static final int GLFW_VERSION_MAJOR = 3;
    public static final int GLFW_VERSION_MINOR = 1;
    public static final int GLFW_VERSION_REVISION = 0;
    public static final int GLFW_RELEASE = 0;
    public static final int GLFW_PRESS = 1;
    public static final int GLFW_REPEAT = 2;
    public static final int GLFW_KEY_UNKNOWN = -1;
    public static final int GLFW_KEY_SPACE = 32;
    public static final int GLFW_KEY_APOSTROPHE = 39;
    public static final int GLFW_KEY_COMMA = 44;
    public static final int GLFW_KEY_MINUS = 45;
    public static final int GLFW_KEY_PERIOD = 46;
    public static final int GLFW_KEY_SLASH = 47;
    public static final int GLFW_KEY_0 = 48;
    public static final int GLFW_KEY_1 = 49;
    public static final int GLFW_KEY_2 = 50;
    public static final int GLFW_KEY_3 = 51;
    public static final int GLFW_KEY_4 = 52;
    public static final int GLFW_KEY_5 = 53;
    public static final int GLFW_KEY_6 = 54;
    public static final int GLFW_KEY_7 = 55;
    public static final int GLFW_KEY_8 = 56;
    public static final int GLFW_KEY_9 = 57;
    public static final int GLFW_KEY_SEMICOLON = 59;
    public static final int GLFW_KEY_EQUAL = 61;
    public static final int GLFW_KEY_A = 65;
    public static final int GLFW_KEY_B = 66;
    public static final int GLFW_KEY_C = 67;
    public static final int GLFW_KEY_D = 68;
    public static final int GLFW_KEY_E = 69;
    public static final int GLFW_KEY_F = 70;
    public static final int GLFW_KEY_G = 71;
    public static final int GLFW_KEY_H = 72;
    public static final int GLFW_KEY_I = 73;
    public static final int GLFW_KEY_J = 74;
    public static final int GLFW_KEY_K = 75;
    public static final int GLFW_KEY_L = 76;
    public static final int GLFW_KEY_M = 77;
    public static final int GLFW_KEY_N = 78;
    public static final int GLFW_KEY_O = 79;
    public static final int GLFW_KEY_P = 80;
    public static final int GLFW_KEY_Q = 81;
    public static final int GLFW_KEY_R = 82;
    public static final int GLFW_KEY_S = 83;
    public static final int GLFW_KEY_T = 84;
    public static final int GLFW_KEY_U = 85;
    public static final int GLFW_KEY_V = 86;
    public static final int GLFW_KEY_W = 87;
    public static final int GLFW_KEY_X = 88;
    public static final int GLFW_KEY_Y = 89;
    public static final int GLFW_KEY_Z = 90;
    public static final int GLFW_KEY_LEFT_BRACKET = 91;
    public static final int GLFW_KEY_BACKSLASH = 92;
    public static final int GLFW_KEY_RIGHT_BRACKET = 93;
    public static final int GLFW_KEY_GRAVE_ACCENT = 96;
    public static final int GLFW_KEY_WORLD_1 = 161;
    public static final int GLFW_KEY_WORLD_2 = 162;
    public static final int GLFW_KEY_ESCAPE = 256;
    public static final int GLFW_KEY_ENTER = 257;
    public static final int GLFW_KEY_TAB = 258;
    public static final int GLFW_KEY_BACKSPACE = 259;
    public static final int GLFW_KEY_INSERT = 260;
    public static final int GLFW_KEY_DELETE = 261;
    public static final int GLFW_KEY_RIGHT = 262;
    public static final int GLFW_KEY_LEFT = 263;
    public static final int GLFW_KEY_DOWN = 264;
    public static final int GLFW_KEY_UP = 265;
    public static final int GLFW_KEY_PAGE_UP = 266;
    public static final int GLFW_KEY_PAGE_DOWN = 267;
    public static final int GLFW_KEY_HOME = 268;
    public static final int GLFW_KEY_END = 269;
    public static final int GLFW_KEY_CAPS_LOCK = 280;
    public static final int GLFW_KEY_SCROLL_LOCK = 281;
    public static final int GLFW_KEY_NUM_LOCK = 282;
    public static final int GLFW_KEY_PRINT_SCREEN = 283;
    public static final int GLFW_KEY_PAUSE = 284;
    public static final int GLFW_KEY_F1 = 290;
    public static final int GLFW_KEY_F2 = 291;
    public static final int GLFW_KEY_F3 = 292;
    public static final int GLFW_KEY_F4 = 293;
    public static final int GLFW_KEY_F5 = 294;
    public static final int GLFW_KEY_F6 = 295;
    public static final int GLFW_KEY_F7 = 296;
    public static final int GLFW_KEY_F8 = 297;
    public static final int GLFW_KEY_F9 = 298;
    public static final int GLFW_KEY_F10 = 299;
    public static final int GLFW_KEY_F11 = 300;
    public static final int GLFW_KEY_F12 = 301;
    public static final int GLFW_KEY_F13 = 302;
    public static final int GLFW_KEY_F14 = 303;
    public static final int GLFW_KEY_F15 = 304;
    public static final int GLFW_KEY_F16 = 305;
    public static final int GLFW_KEY_F17 = 306;
    public static final int GLFW_KEY_F18 = 307;
    public static final int GLFW_KEY_F19 = 308;
    public static final int GLFW_KEY_F20 = 309;
    public static final int GLFW_KEY_F21 = 310;
    public static final int GLFW_KEY_F22 = 311;
    public static final int GLFW_KEY_F23 = 312;
    public static final int GLFW_KEY_F24 = 313;
    public static final int GLFW_KEY_F25 = 314;
    public static final int GLFW_KEY_KP_0 = 320;
    public static final int GLFW_KEY_KP_1 = 321;
    public static final int GLFW_KEY_KP_2 = 322;
    public static final int GLFW_KEY_KP_3 = 323;
    public static final int GLFW_KEY_KP_4 = 324;
    public static final int GLFW_KEY_KP_5 = 325;
    public static final int GLFW_KEY_KP_6 = 326;
    public static final int GLFW_KEY_KP_7 = 327;
    public static final int GLFW_KEY_KP_8 = 328;
    public static final int GLFW_KEY_KP_9 = 329;
    public static final int GLFW_KEY_KP_DECIMAL = 330;
    public static final int GLFW_KEY_KP_DIVIDE = 331;
    public static final int GLFW_KEY_KP_MULTIPLY = 332;
    public static final int GLFW_KEY_KP_SUBTRACT = 333;
    public static final int GLFW_KEY_KP_ADD = 334;
    public static final int GLFW_KEY_KP_ENTER = 335;
    public static final int GLFW_KEY_KP_EQUAL = 336;
    public static final int GLFW_KEY_LEFT_SHIFT = 340;
    public static final int GLFW_KEY_LEFT_CONTROL = 341;
    public static final int GLFW_KEY_LEFT_ALT = 342;
    public static final int GLFW_KEY_LEFT_SUPER = 343;
    public static final int GLFW_KEY_RIGHT_SHIFT = 344;
    public static final int GLFW_KEY_RIGHT_CONTROL = 345;
    public static final int GLFW_KEY_RIGHT_ALT = 346;
    public static final int GLFW_KEY_RIGHT_SUPER = 347;
    public static final int GLFW_KEY_MENU = 348;
    public static final int GLFW_KEY_LAST = 348;
    public static final int GLFW_MOD_SHIFT = 1;
    public static final int GLFW_MOD_CONTROL = 2;
    public static final int GLFW_MOD_ALT = 4;
    public static final int GLFW_MOD_SUPER = 8;
    public static final int GLFW_MOUSE_BUTTON_1 = 0;
    public static final int GLFW_MOUSE_BUTTON_2 = 1;
    public static final int GLFW_MOUSE_BUTTON_3 = 2;
    public static final int GLFW_MOUSE_BUTTON_4 = 3;
    public static final int GLFW_MOUSE_BUTTON_5 = 4;
    public static final int GLFW_MOUSE_BUTTON_6 = 5;
    public static final int GLFW_MOUSE_BUTTON_7 = 6;
    public static final int GLFW_MOUSE_BUTTON_8 = 7;
    public static final int GLFW_MOUSE_BUTTON_LAST = 7;
    public static final int GLFW_MOUSE_BUTTON_LEFT = 0;
    public static final int GLFW_MOUSE_BUTTON_RIGHT = 1;
    public static final int GLFW_MOUSE_BUTTON_MIDDLE = 2;
    public static final int GLFW_JOYSTICK_1 = 0;
    public static final int GLFW_JOYSTICK_2 = 1;
    public static final int GLFW_JOYSTICK_3 = 2;
    public static final int GLFW_JOYSTICK_4 = 3;
    public static final int GLFW_JOYSTICK_5 = 4;
    public static final int GLFW_JOYSTICK_6 = 5;
    public static final int GLFW_JOYSTICK_7 = 6;
    public static final int GLFW_JOYSTICK_8 = 7;
    public static final int GLFW_JOYSTICK_9 = 8;
    public static final int GLFW_JOYSTICK_10 = 9;
    public static final int GLFW_JOYSTICK_11 = 10;
    public static final int GLFW_JOYSTICK_12 = 11;
    public static final int GLFW_JOYSTICK_13 = 12;
    public static final int GLFW_JOYSTICK_14 = 13;
    public static final int GLFW_JOYSTICK_15 = 14;
    public static final int GLFW_JOYSTICK_16 = 15;
    public static final int GLFW_JOYSTICK_LAST = 15;
    public static final int GLFW_NOT_INITIALIZED = 65537;
    public static final int GLFW_NO_CURRENT_CONTEXT = 65538;
    public static final int GLFW_INVALID_ENUM = 65539;
    public static final int GLFW_INVALID_VALUE = 65540;
    public static final int GLFW_OUT_OF_MEMORY = 65541;
    public static final int GLFW_API_UNAVAILABLE = 65542;
    public static final int GLFW_VERSION_UNAVAILABLE = 65543;
    public static final int GLFW_PLATFORM_ERROR = 65544;
    public static final int GLFW_FORMAT_UNAVAILABLE = 65545;
    public static final int GLFW_FOCUSED = 131073;
    public static final int GLFW_ICONIFIED = 131074;
    public static final int GLFW_RESIZABLE = 131075;
    public static final int GLFW_VISIBLE = 131076;
    public static final int GLFW_DECORATED = 131077;
    public static final int GLFW_AUTO_ICONIFY = 131078;
    public static final int GLFW_FLOATING = 131079;
    public static final int GLFW_CURSOR = 208897;
    public static final int GLFW_STICKY_KEYS = 208898;
    public static final int GLFW_STICKY_MOUSE_BUTTONS = 208899;
    public static final int GLFW_CURSOR_NORMAL = 212993;
    public static final int GLFW_CURSOR_HIDDEN = 212994;
    public static final int GLFW_CURSOR_DISABLED = 212995;
    public static final int GLFW_CONNECTED = 262145;
    public static final int GLFW_DISCONNECTED = 262146;
    public static final int GLFW_DONT_CARE = -1;
    public static final int GLFW_RED_BITS = 135169;
    public static final int GLFW_GREEN_BITS = 135170;
    public static final int GLFW_BLUE_BITS = 135171;
    public static final int GLFW_ALPHA_BITS = 135172;
    public static final int GLFW_DEPTH_BITS = 135173;
    public static final int GLFW_STENCIL_BITS = 135174;
    public static final int GLFW_ACCUM_RED_BITS = 135175;
    public static final int GLFW_ACCUM_GREEN_BITS = 135176;
    public static final int GLFW_ACCUM_BLUE_BITS = 135177;
    public static final int GLFW_ACCUM_ALPHA_BITS = 135178;
    public static final int GLFW_AUX_BUFFERS = 135179;
    public static final int GLFW_STEREO = 135180;
    public static final int GLFW_SAMPLES = 135181;
    public static final int GLFW_SRGB_CAPABLE = 135182;
    public static final int GLFW_REFRESH_RATE = 135183;
    public static final int GLFW_DOUBLE_BUFFER = 135184;
    public static final int GLFW_CLIENT_API = 139265;
    public static final int GLFW_CONTEXT_VERSION_MAJOR = 139266;
    public static final int GLFW_CONTEXT_VERSION_MINOR = 139267;
    public static final int GLFW_CONTEXT_REVISION = 139268;
    public static final int GLFW_CONTEXT_ROBUSTNESS = 139269;
    public static final int GLFW_OPENGL_FORWARD_COMPAT = 139270;
    public static final int GLFW_OPENGL_DEBUG_CONTEXT = 139271;
    public static final int GLFW_OPENGL_PROFILE = 139272;
    public static final int GLFW_CONTEXT_RELEASE_BEHAVIOR = 139273;
    public static final int GLFW_OPENGL_API = 196609;
    public static final int GLFW_OPENGL_ES_API = 196610;
    public static final int GLFW_NO_ROBUSTNESS = 0;
    public static final int GLFW_NO_RESET_NOTIFICATION = 200705;
    public static final int GLFW_LOSE_CONTEXT_ON_RESET = 200706;
    public static final int GLFW_OPENGL_ANY_PROFILE = 0;
    public static final int GLFW_OPENGL_CORE_PROFILE = 204801;
    public static final int GLFW_OPENGL_COMPAT_PROFILE = 204802;
    public static final int GLFW_ANY_RELEASE_BEHAVIOR = 0;
    public static final int GLFW_RELEASE_BEHAVIOR_FLUSH = 217089;
    public static final int GLFW_RELEASE_BEHAVIOR_NONE = 217090;

    private GLFW() {
    }

    public static native int nglfwInit();

    public static int glfwInit() {
        if (LWJGLUtil.getPlatform() == LWJGLUtil.Platform.MACOSX) {
            EventLoop.initSharedApplication();
        }
        return GLFW.nglfwInit();
    }

    public static native void nglfwTerminate();

    public static void glfwTerminate() {
        WindowCallback.clearAll();
        GLFW.nglfwTerminate();
    }

    public static native void nglfwGetVersion(long var0, long var2, long var4);

    public static void glfwGetVersion(ByteBuffer major, ByteBuffer minor, ByteBuffer rev) {
        if (LWJGLUtil.CHECKS) {
            if (major != null) {
                Checks.checkBuffer((Buffer)major, 4);
            }
            if (minor != null) {
                Checks.checkBuffer((Buffer)minor, 4);
            }
            if (rev != null) {
                Checks.checkBuffer((Buffer)rev, 4);
            }
        }
        GLFW.nglfwGetVersion(MemoryUtil.memAddressSafe(major), MemoryUtil.memAddressSafe(minor), MemoryUtil.memAddressSafe(rev));
    }

    public static void glfwGetVersion(IntBuffer major, IntBuffer minor, IntBuffer rev) {
        if (LWJGLUtil.CHECKS) {
            if (major != null) {
                Checks.checkBuffer((Buffer)major, 1);
            }
            if (minor != null) {
                Checks.checkBuffer((Buffer)minor, 1);
            }
            if (rev != null) {
                Checks.checkBuffer((Buffer)rev, 1);
            }
        }
        GLFW.nglfwGetVersion(MemoryUtil.memAddressSafe(major), MemoryUtil.memAddressSafe(minor), MemoryUtil.memAddressSafe(rev));
    }

    public static native long nglfwGetVersionString();

    public static String glfwGetVersionString() {
        long __result = GLFW.nglfwGetVersionString();
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static native long nglfwSetErrorCallback(long var0);

    public static long glfwSetErrorCallback(long cbfun) {
        return GLFW.nglfwSetErrorCallback(cbfun);
    }

    public static long glfwSetErrorCallback(ErrorCallback cbfun) {
        return GLFW.nglfwSetErrorCallback(ErrorCallback.Util.register(cbfun));
    }

    public static native long nglfwGetMonitors(long var0);

    public static PointerBuffer glfwGetMonitors() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int count = __buffer.intParam();
        long __result = GLFW.nglfwGetMonitors(__buffer.address() + (long)count);
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(count));
    }

    public static native long glfwGetPrimaryMonitor();

    public static native void nglfwGetMonitorPos(long var0, long var2, long var4);

    public static void glfwGetMonitorPos(long monitor, ByteBuffer xpos, ByteBuffer ypos) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(monitor);
            if (xpos != null) {
                Checks.checkBuffer((Buffer)xpos, 4);
            }
            if (ypos != null) {
                Checks.checkBuffer((Buffer)ypos, 4);
            }
        }
        GLFW.nglfwGetMonitorPos(monitor, MemoryUtil.memAddressSafe(xpos), MemoryUtil.memAddressSafe(ypos));
    }

    public static void glfwGetMonitorPos(long monitor, IntBuffer xpos, IntBuffer ypos) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(monitor);
            if (xpos != null) {
                Checks.checkBuffer((Buffer)xpos, 1);
            }
            if (ypos != null) {
                Checks.checkBuffer((Buffer)ypos, 1);
            }
        }
        GLFW.nglfwGetMonitorPos(monitor, MemoryUtil.memAddressSafe(xpos), MemoryUtil.memAddressSafe(ypos));
    }

    public static native void nglfwGetMonitorPhysicalSize(long var0, long var2, long var4);

    public static void glfwGetMonitorPhysicalSize(long monitor, ByteBuffer width, ByteBuffer height) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(monitor);
            if (width != null) {
                Checks.checkBuffer((Buffer)width, 4);
            }
            if (height != null) {
                Checks.checkBuffer((Buffer)height, 4);
            }
        }
        GLFW.nglfwGetMonitorPhysicalSize(monitor, MemoryUtil.memAddressSafe(width), MemoryUtil.memAddressSafe(height));
    }

    public static void glfwGetMonitorPhysicalSize(long monitor, IntBuffer width, IntBuffer height) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(monitor);
            if (width != null) {
                Checks.checkBuffer((Buffer)width, 1);
            }
            if (height != null) {
                Checks.checkBuffer((Buffer)height, 1);
            }
        }
        GLFW.nglfwGetMonitorPhysicalSize(monitor, MemoryUtil.memAddressSafe(width), MemoryUtil.memAddressSafe(height));
    }

    public static native long nglfwGetMonitorName(long var0);

    public static String glfwGetMonitorName(long monitor) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(monitor);
        }
        long __result = GLFW.nglfwGetMonitorName(monitor);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static native long nglfwSetMonitorCallback(long var0);

    public static long glfwSetMonitorCallback(long cbfun) {
        return GLFW.nglfwSetMonitorCallback(cbfun);
    }

    public static long glfwSetMonitorCallback(MonitorCallback cbfun) {
        return GLFW.nglfwSetMonitorCallback(MonitorCallback.Util.register(cbfun));
    }

    public static native long nglfwGetVideoModes(long var0, long var2);

    public static ByteBuffer glfwGetVideoModes(long monitor, ByteBuffer count) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(monitor);
            Checks.checkBuffer((Buffer)count, 4);
        }
        long __result = GLFW.nglfwGetVideoModes(monitor, MemoryUtil.memAddress(count));
        return MemoryUtil.memByteBuffer(__result, count.getInt(count.position()) * GLFWvidmode.SIZEOF);
    }

    public static ByteBuffer glfwGetVideoModes(long monitor, IntBuffer count) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(monitor);
            Checks.checkBuffer((Buffer)count, 1);
        }
        long __result = GLFW.nglfwGetVideoModes(monitor, MemoryUtil.memAddress(count));
        return MemoryUtil.memByteBuffer(__result, count.get(count.position()) * GLFWvidmode.SIZEOF);
    }

    public static native long nglfwGetVideoMode(long var0);

    public static ByteBuffer glfwGetVideoMode(long monitor) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(monitor);
        }
        long __result = GLFW.nglfwGetVideoMode(monitor);
        return MemoryUtil.memByteBuffer(__result, GLFWvidmode.SIZEOF);
    }

    public static native void nglfwSetGamma(long var0, float var2);

    public static void glfwSetGamma(long monitor, float gamma) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(monitor);
        }
        GLFW.nglfwSetGamma(monitor, gamma);
    }

    public static native long nglfwGetGammaRamp(long var0);

    public static ByteBuffer glfwGetGammaRamp(long monitor) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(monitor);
        }
        long __result = GLFW.nglfwGetGammaRamp(monitor);
        return MemoryUtil.memByteBuffer(__result, GLFWgammaramp.SIZEOF);
    }

    public static native void nglfwSetGammaRamp(long var0, long var2);

    public static void glfwSetGammaRamp(long monitor, ByteBuffer ramp) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(monitor);
            Checks.checkBuffer((Buffer)ramp, GLFWgammaramp.SIZEOF);
        }
        GLFW.nglfwSetGammaRamp(monitor, MemoryUtil.memAddress(ramp));
    }

    public static native void glfwDefaultWindowHints();

    public static native void glfwWindowHint(int var0, int var1);

    public static native long nglfwCreateWindow(int var0, int var1, long var2, long var4, long var6);

    public static long glfwCreateWindow(int width, int height, ByteBuffer title, long monitor, long share) {
        long __result;
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(title);
        }
        if ((__result = GLFW.nglfwCreateWindow(width, height, MemoryUtil.memAddress(title), monitor, share)) != 0L) {
            WindowCallback.windowCreated(__result);
        }
        return __result;
    }

    public static long glfwCreateWindow(int width, int height, CharSequence title, long monitor, long share) {
        ByteBuffer titleEncoded = MemoryUtil.memEncodeUTF8(title);
        long __result = GLFW.nglfwCreateWindow(width, height, MemoryUtil.memAddress(titleEncoded), monitor, share);
        if (__result != 0L) {
            WindowCallback.windowCreated(__result);
        }
        return __result;
    }

    public static native void nglfwDestroyWindow(long var0);

    public static void glfwDestroyWindow(long window) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        WindowCallback.set(window, null);
        GLFW.nglfwDestroyWindow(window);
    }

    public static native int nglfwWindowShouldClose(long var0);

    public static int glfwWindowShouldClose(long window) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        return GLFW.nglfwWindowShouldClose(window);
    }

    public static native void nglfwSetWindowShouldClose(long var0, int var2);

    public static void glfwSetWindowShouldClose(long window, int value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        GLFW.nglfwSetWindowShouldClose(window, value);
    }

    public static native void nglfwSetWindowTitle(long var0, long var2);

    public static void glfwSetWindowTitle(long window, ByteBuffer title) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
            Checks.checkNT1(title);
        }
        GLFW.nglfwSetWindowTitle(window, MemoryUtil.memAddress(title));
    }

    public static void glfwSetWindowTitle(long window, CharSequence title) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        ByteBuffer titleEncoded = MemoryUtil.memEncodeUTF8(title);
        GLFW.nglfwSetWindowTitle(window, MemoryUtil.memAddress(titleEncoded));
    }

    public static native void nglfwGetWindowPos(long var0, long var2, long var4);

    public static void glfwGetWindowPos(long window, ByteBuffer xpos, ByteBuffer ypos) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
            if (xpos != null) {
                Checks.checkBuffer((Buffer)xpos, 4);
            }
            if (ypos != null) {
                Checks.checkBuffer((Buffer)ypos, 4);
            }
        }
        GLFW.nglfwGetWindowPos(window, MemoryUtil.memAddressSafe(xpos), MemoryUtil.memAddressSafe(ypos));
    }

    public static void glfwGetWindowPos(long window, IntBuffer xpos, IntBuffer ypos) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
            if (xpos != null) {
                Checks.checkBuffer((Buffer)xpos, 1);
            }
            if (ypos != null) {
                Checks.checkBuffer((Buffer)ypos, 1);
            }
        }
        GLFW.nglfwGetWindowPos(window, MemoryUtil.memAddressSafe(xpos), MemoryUtil.memAddressSafe(ypos));
    }

    public static native void nglfwSetWindowPos(long var0, int var2, int var3);

    public static void glfwSetWindowPos(long window, int xpos, int ypos) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        GLFW.nglfwSetWindowPos(window, xpos, ypos);
    }

    public static native void nglfwGetWindowSize(long var0, long var2, long var4);

    public static void glfwGetWindowSize(long window, ByteBuffer width, ByteBuffer height) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
            if (width != null) {
                Checks.checkBuffer((Buffer)width, 4);
            }
            if (height != null) {
                Checks.checkBuffer((Buffer)height, 4);
            }
        }
        GLFW.nglfwGetWindowSize(window, MemoryUtil.memAddressSafe(width), MemoryUtil.memAddressSafe(height));
    }

    public static void glfwGetWindowSize(long window, IntBuffer width, IntBuffer height) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
            if (width != null) {
                Checks.checkBuffer((Buffer)width, 1);
            }
            if (height != null) {
                Checks.checkBuffer((Buffer)height, 1);
            }
        }
        GLFW.nglfwGetWindowSize(window, MemoryUtil.memAddressSafe(width), MemoryUtil.memAddressSafe(height));
    }

    public static native void nglfwSetWindowSize(long var0, int var2, int var3);

    public static void glfwSetWindowSize(long window, int width, int height) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        GLFW.nglfwSetWindowSize(window, width, height);
    }

    public static native void nglfwGetFramebufferSize(long var0, long var2, long var4);

    public static void glfwGetFramebufferSize(long window, ByteBuffer width, ByteBuffer height) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
            if (width != null) {
                Checks.checkBuffer((Buffer)width, 4);
            }
            if (height != null) {
                Checks.checkBuffer((Buffer)height, 4);
            }
        }
        GLFW.nglfwGetFramebufferSize(window, MemoryUtil.memAddressSafe(width), MemoryUtil.memAddressSafe(height));
    }

    public static void glfwGetFramebufferSize(long window, IntBuffer width, IntBuffer height) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
            if (width != null) {
                Checks.checkBuffer((Buffer)width, 1);
            }
            if (height != null) {
                Checks.checkBuffer((Buffer)height, 1);
            }
        }
        GLFW.nglfwGetFramebufferSize(window, MemoryUtil.memAddressSafe(width), MemoryUtil.memAddressSafe(height));
    }

    public static native void nglfwGetWindowFrameSize(long var0, long var2, long var4, long var6, long var8);

    public static void glfwGetWindowFrameSize(long window, ByteBuffer left, ByteBuffer top, ByteBuffer right, ByteBuffer bottom) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
            Checks.checkBuffer((Buffer)left, 4);
            Checks.checkBuffer((Buffer)top, 4);
            Checks.checkBuffer((Buffer)right, 4);
            Checks.checkBuffer((Buffer)bottom, 4);
        }
        GLFW.nglfwGetWindowFrameSize(window, MemoryUtil.memAddress(left), MemoryUtil.memAddress(top), MemoryUtil.memAddress(right), MemoryUtil.memAddress(bottom));
    }

    public static void glfwGetWindowFrameSize(long window, IntBuffer left, IntBuffer top, IntBuffer right, IntBuffer bottom) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
            Checks.checkBuffer((Buffer)left, 1);
            Checks.checkBuffer((Buffer)top, 1);
            Checks.checkBuffer((Buffer)right, 1);
            Checks.checkBuffer((Buffer)bottom, 1);
        }
        GLFW.nglfwGetWindowFrameSize(window, MemoryUtil.memAddress(left), MemoryUtil.memAddress(top), MemoryUtil.memAddress(right), MemoryUtil.memAddress(bottom));
    }

    public static native void nglfwIconifyWindow(long var0);

    public static void glfwIconifyWindow(long window) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        GLFW.nglfwIconifyWindow(window);
    }

    public static native void nglfwRestoreWindow(long var0);

    public static void glfwRestoreWindow(long window) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        GLFW.nglfwRestoreWindow(window);
    }

    public static native void nglfwShowWindow(long var0);

    public static void glfwShowWindow(long window) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        GLFW.nglfwShowWindow(window);
    }

    public static native void nglfwHideWindow(long var0);

    public static void glfwHideWindow(long window) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        GLFW.nglfwHideWindow(window);
    }

    public static native long nglfwGetWindowMonitor(long var0);

    public static long glfwGetWindowMonitor(long window) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        return GLFW.nglfwGetWindowMonitor(window);
    }

    public static native int nglfwGetWindowAttrib(long var0, int var2);

    public static int glfwGetWindowAttrib(long window, int attrib) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        return GLFW.nglfwGetWindowAttrib(window, attrib);
    }

    public static native void nglfwSetWindowUserPointer(long var0, long var2);

    public static void glfwSetWindowUserPointer(long window, long pointer) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        GLFW.nglfwSetWindowUserPointer(window, pointer);
    }

    public static native long nglfwGetWindowUserPointer(long var0);

    public static long glfwGetWindowUserPointer(long window) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        return GLFW.nglfwGetWindowUserPointer(window);
    }

    public static native long nglfwSetWindowPosCallback(long var0, long var2);

    public static long glfwSetWindowPosCallback(long window, long cbfun) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        return GLFW.nglfwSetWindowPosCallback(window, cbfun);
    }

    public static native long nglfwSetWindowSizeCallback(long var0, long var2);

    public static long glfwSetWindowSizeCallback(long window, long cbfun) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        return GLFW.nglfwSetWindowSizeCallback(window, cbfun);
    }

    public static native long nglfwSetWindowCloseCallback(long var0, long var2);

    public static long glfwSetWindowCloseCallback(long window, long cbfun) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        return GLFW.nglfwSetWindowCloseCallback(window, cbfun);
    }

    public static native long nglfwSetWindowRefreshCallback(long var0, long var2);

    public static long glfwSetWindowRefreshCallback(long window, long cbfun) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        return GLFW.nglfwSetWindowRefreshCallback(window, cbfun);
    }

    public static native long nglfwSetWindowFocusCallback(long var0, long var2);

    public static long glfwSetWindowFocusCallback(long window, long cbfun) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        return GLFW.nglfwSetWindowFocusCallback(window, cbfun);
    }

    public static native long nglfwSetWindowIconifyCallback(long var0, long var2);

    public static long glfwSetWindowIconifyCallback(long window, long cbfun) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        return GLFW.nglfwSetWindowIconifyCallback(window, cbfun);
    }

    public static native long nglfwSetFramebufferSizeCallback(long var0, long var2);

    public static long glfwSetFramebufferSizeCallback(long window, long cbfun) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        return GLFW.nglfwSetFramebufferSizeCallback(window, cbfun);
    }

    public static native void nglfwPollEvents();

    public static void glfwPollEvents() {
        if (WindowCallback.pollEventsOverride()) {
            return;
        }
        GLFW.nglfwPollEvents();
    }

    public static native void nglfwWaitEvents();

    public static void glfwWaitEvents() {
        if (WindowCallback.waitEventsOverride()) {
            return;
        }
        GLFW.nglfwWaitEvents();
    }

    public static native void glfwPostEmptyEvent();

    public static native int nglfwGetInputMode(long var0, int var2);

    public static int glfwGetInputMode(long window, int mode) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        return GLFW.nglfwGetInputMode(window, mode);
    }

    public static native void nglfwSetInputMode(long var0, int var2, int var3);

    public static void glfwSetInputMode(long window, int mode, int value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        GLFW.nglfwSetInputMode(window, mode, value);
    }

    public static native int nglfwGetKey(long var0, int var2);

    public static int glfwGetKey(long window, int key) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        return GLFW.nglfwGetKey(window, key);
    }

    public static native int nglfwGetMouseButton(long var0, int var2);

    public static int glfwGetMouseButton(long window, int button) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        return GLFW.nglfwGetMouseButton(window, button);
    }

    public static native void nglfwGetCursorPos(long var0, long var2, long var4);

    public static void glfwGetCursorPos(long window, ByteBuffer xpos, ByteBuffer ypos) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
            if (xpos != null) {
                Checks.checkBuffer((Buffer)xpos, 8);
            }
            if (ypos != null) {
                Checks.checkBuffer((Buffer)ypos, 8);
            }
        }
        GLFW.nglfwGetCursorPos(window, MemoryUtil.memAddressSafe(xpos), MemoryUtil.memAddressSafe(ypos));
    }

    public static void glfwGetCursorPos(long window, DoubleBuffer xpos, DoubleBuffer ypos) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
            if (xpos != null) {
                Checks.checkBuffer((Buffer)xpos, 1);
            }
            if (ypos != null) {
                Checks.checkBuffer((Buffer)ypos, 1);
            }
        }
        GLFW.nglfwGetCursorPos(window, MemoryUtil.memAddressSafe(xpos), MemoryUtil.memAddressSafe(ypos));
    }

    public static native void nglfwSetCursorPos(long var0, double var2, double var4);

    public static void glfwSetCursorPos(long window, double xpos, double ypos) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        GLFW.nglfwSetCursorPos(window, xpos, ypos);
    }

    public static native long nglfwCreateCursor(long var0, int var2, int var3);

    public static long glfwCreateCursor(ByteBuffer image, int xhot, int yhot) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)image, GLFWimage.SIZEOF);
        }
        return GLFW.nglfwCreateCursor(MemoryUtil.memAddress(image), xhot, yhot);
    }

    public static native void nglfwDestroyCursor(long var0);

    public static void glfwDestroyCursor(long cursor) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(cursor);
        }
        GLFW.nglfwDestroyCursor(cursor);
    }

    public static native void nglfwSetCursor(long var0, long var2);

    public static void glfwSetCursor(long window, long cursor) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
            Checks.checkPointer(cursor);
        }
        GLFW.nglfwSetCursor(window, cursor);
    }

    public static native long nglfwSetKeyCallback(long var0, long var2);

    public static long glfwSetKeyCallback(long window, long cbfun) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        return GLFW.nglfwSetKeyCallback(window, cbfun);
    }

    public static native long nglfwSetCharCallback(long var0, long var2);

    public static long glfwSetCharCallback(long window, long cbfun) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        return GLFW.nglfwSetCharCallback(window, cbfun);
    }

    public static native long nglfwSetCharModsCallback(long var0, long var2);

    public static long glfwSetCharModsCallback(long window, long cbfun) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        return GLFW.nglfwSetCharModsCallback(window, cbfun);
    }

    public static native long nglfwSetMouseButtonCallback(long var0, long var2);

    public static long glfwSetMouseButtonCallback(long window, long cbfun) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        return GLFW.nglfwSetMouseButtonCallback(window, cbfun);
    }

    public static native long nglfwSetCursorPosCallback(long var0, long var2);

    public static long glfwSetCursorPosCallback(long window, long cbfun) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        return GLFW.nglfwSetCursorPosCallback(window, cbfun);
    }

    public static native long nglfwSetCursorEnterCallback(long var0, long var2);

    public static long glfwSetCursorEnterCallback(long window, long cbfun) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        return GLFW.nglfwSetCursorEnterCallback(window, cbfun);
    }

    public static native long nglfwSetScrollCallback(long var0, long var2);

    public static long glfwSetScrollCallback(long window, long cbfun) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        return GLFW.nglfwSetScrollCallback(window, cbfun);
    }

    public static native long nglfwSetDropCallback(long var0, long var2);

    public static long glfwSetDropCallback(long window, long cbfun) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        return GLFW.nglfwSetDropCallback(window, cbfun);
    }

    public static native int glfwJoystickPresent(int var0);

    public static native long nglfwGetJoystickAxes(int var0, long var1);

    public static FloatBuffer glfwGetJoystickAxes(int joy) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int count = __buffer.intParam();
        long __result = GLFW.nglfwGetJoystickAxes(joy, __buffer.address() + (long)count);
        return MemoryUtil.memFloatBuffer(__result, __buffer.intValue(count));
    }

    public static native long nglfwGetJoystickButtons(int var0, long var1);

    public static ByteBuffer glfwGetJoystickButtons(int joy) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int count = __buffer.intParam();
        long __result = GLFW.nglfwGetJoystickButtons(joy, __buffer.address() + (long)count);
        return MemoryUtil.memByteBuffer(__result, __buffer.intValue(count));
    }

    public static native long nglfwGetJoystickName(int var0);

    public static String glfwGetJoystickName(int joy) {
        long __result = GLFW.nglfwGetJoystickName(joy);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static native void nglfwSetClipboardString(long var0, long var2);

    public static void glfwSetClipboardString(long window, ByteBuffer string) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
            Checks.checkNT1(string);
        }
        GLFW.nglfwSetClipboardString(window, MemoryUtil.memAddress(string));
    }

    public static void glfwSetClipboardString(long window, CharSequence string) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        ByteBuffer stringEncoded = MemoryUtil.memEncodeUTF8(string);
        GLFW.nglfwSetClipboardString(window, MemoryUtil.memAddress(stringEncoded));
    }

    public static native long nglfwGetClipboardString(long var0);

    public static String glfwGetClipboardString(long window) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        long __result = GLFW.nglfwGetClipboardString(window);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static native double glfwGetTime();

    public static native void glfwSetTime(double var0);

    public static native void nglfwMakeContextCurrent(long var0);

    public static void glfwMakeContextCurrent(long window) {
        GLFW.nglfwMakeContextCurrent(window);
    }

    public static native long glfwGetCurrentContext();

    public static native void nglfwSwapBuffers(long var0);

    public static void glfwSwapBuffers(long window) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkPointer(window);
        }
        GLFW.nglfwSwapBuffers(window);
    }

    public static native void glfwSwapInterval(int var0);

    public static native int nglfwExtensionSupported(long var0);

    public static int glfwExtensionSupported(ByteBuffer extension) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(extension);
        }
        return GLFW.nglfwExtensionSupported(MemoryUtil.memAddress(extension));
    }

    public static int glfwExtensionSupported(CharSequence extension) {
        ByteBuffer extensionEncoded = MemoryUtil.memEncodeASCII(extension);
        return GLFW.nglfwExtensionSupported(MemoryUtil.memAddress(extensionEncoded));
    }

    public static native long nglfwGetProcAddress(long var0);

    public static long glfwGetProcAddress(ByteBuffer procname) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(procname);
        }
        return GLFW.nglfwGetProcAddress(MemoryUtil.memAddress(procname));
    }

    public static long glfwGetProcAddress(CharSequence procname) {
        ByteBuffer procnameEncoded = MemoryUtil.memEncodeASCII(procname);
        return GLFW.nglfwGetProcAddress(MemoryUtil.memAddress(procnameEncoded));
    }

    static {
        Sys.touch();
    }
}

