/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.glfw;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.MemoryUtil;

public interface ErrorCallback {
    public void invoke(int var1, long var2);

    public static final class Util {
        static final long CALLBACK = Util.setCallback(APIUtil.apiCallbackMethod(Util.class, Integer.TYPE, Long.TYPE));
        private static final ErrorCallback DEFAULT = new StrAdapter(){

            @Override
            public void invoke(int error, String description) {
                System.err.print("[LWJGL] GLFW error");
                System.err.printf("\tCode: 0x%X\n", error);
                System.err.println("\tDescription: " + description);
                System.err.println("\tStacktrace:");
                StackTraceElement[] stack = Thread.currentThread().getStackTrace();
                for (int i = 4; i < stack.length; ++i) {
                    System.err.print("\t\t");
                    System.err.println(stack[i].toString());
                }
            }
        };
        private static ErrorCallback callback;

        private Util() {
        }

        private static native long setCallback(Method var0);

        static long register(ErrorCallback proc) {
            callback = proc;
            return proc == null ? 0L : CALLBACK;
        }

        private static void invoke(int error, long description) {
            callback.invoke(error, description);
        }

        public static ErrorCallback getDefault() {
            return DEFAULT;
        }
    }

    public static abstract class StrAdapter
    implements Str {
        @Override
        public void invoke(int error, long description) {
            this.invoke(error, MemoryUtil.memByteBufferNT1(description));
        }

        public void invoke(int error, ByteBuffer description) {
            this.invoke(error, MemoryUtil.memDecodeUTF8(description));
        }

        @Override
        public void invoke(int error, String description) {
        }
    }

    public static interface Str
    extends ErrorCallback {
        public void invoke(int var1, String var2);
    }
}

