/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.Sys;
import org.lwjgl.system.CharSequenceNT;
import org.lwjgl.system.MemoryAccess;

public final class MemoryUtil {
    public static final long NULL = 0L;
    private static final Charset UTF8;
    private static final MemoryAccess.MemoryAccessor ACCESSOR;
    public static final int PAGE_SIZE;

    private MemoryUtil() {
    }

    public static long memAddress0(Buffer buffer) {
        return ACCESSOR.getAddress(buffer);
    }

    public static long memAddress0Safe(Buffer buffer) {
        return buffer == null ? 0L : ACCESSOR.getAddress(buffer);
    }

    public static long memAddress0(PointerBuffer buffer) {
        return ACCESSOR.getAddress(buffer.getBuffer());
    }

    public static long memAddress0Safe(PointerBuffer buffer) {
        return buffer == null ? 0L : ACCESSOR.getAddress(buffer.getBuffer());
    }

    public static long memAddress(ByteBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(ByteBuffer buffer, int position) {
        return MemoryUtil.memAddress0(buffer) + (long)position;
    }

    public static long memAddress(ShortBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(ShortBuffer buffer, int position) {
        return MemoryUtil.memAddress0(buffer) + (long)(position << 1);
    }

    public static long memAddress(CharBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(CharBuffer buffer, int position) {
        return MemoryUtil.memAddress0(buffer) + (long)(position << 1);
    }

    public static long memAddress(IntBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(IntBuffer buffer, int position) {
        return MemoryUtil.memAddress0(buffer) + (long)(position << 2);
    }

    public static long memAddress(FloatBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(FloatBuffer buffer, int position) {
        return MemoryUtil.memAddress0(buffer) + (long)(position << 2);
    }

    public static long memAddress(LongBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(LongBuffer buffer, int position) {
        return MemoryUtil.memAddress0(buffer) + (long)(position << 3);
    }

    public static long memAddress(DoubleBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(DoubleBuffer buffer, int position) {
        return MemoryUtil.memAddress0(buffer) + (long)(position << 3);
    }

    public static long memAddress(PointerBuffer buffer) {
        return MemoryUtil.memAddress(buffer, buffer.position());
    }

    public static long memAddress(PointerBuffer buffer, int position) {
        return MemoryUtil.memAddress0(buffer) + (long)(position * Pointer.POINTER_SIZE);
    }

    public static long memAddressSafe(ByteBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(ByteBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(ShortBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(ShortBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(CharBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(CharBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(IntBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(IntBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(FloatBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(FloatBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(LongBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(LongBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(DoubleBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(DoubleBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static long memAddressSafe(PointerBuffer buffer) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer);
    }

    public static long memAddressSafe(PointerBuffer buffer, int position) {
        return buffer == null ? 0L : MemoryUtil.memAddress(buffer, position);
    }

    public static ByteBuffer memByteBuffer(long address, int capacity) {
        if (LWJGLUtil.DEBUG && (address == 0L || capacity < 0)) {
            throw new IllegalArgumentException();
        }
        return ACCESSOR.newByteBuffer(address, capacity);
    }

    public static ByteBuffer memByteBuffer(long address, long capacity) {
        return MemoryUtil.memByteBuffer(address, (int)capacity);
    }

    public static ByteBuffer memByteBufferNT1(long address) {
        if (address == 0L) {
            return null;
        }
        ByteBuffer infPointer = ACCESSOR.newByteBuffer(address, Integer.MAX_VALUE);
        return MemoryUtil.memSetupBuffer(infPointer, address, MemoryUtil.memStrLen1(infPointer, 0));
    }

    public static ByteBuffer memByteBufferNT2(long address) {
        if (address == 0L) {
            return null;
        }
        ByteBuffer infPointer = ACCESSOR.newByteBuffer(address, Integer.MAX_VALUE);
        return MemoryUtil.memSetupBuffer(infPointer, address, MemoryUtil.memStrLen2(infPointer, 0));
    }

    public static ShortBuffer memShortBuffer(long address, int capacity) {
        if (LWJGLUtil.DEBUG && (address == 0L || capacity < 0)) {
            throw new IllegalArgumentException();
        }
        return ACCESSOR.newShortBuffer(address, capacity);
    }

    public static CharBuffer memCharBuffer(long address, int capacity) {
        if (LWJGLUtil.DEBUG && (address == 0L || capacity < 0)) {
            throw new IllegalArgumentException();
        }
        return ACCESSOR.newCharBuffer(address, capacity);
    }

    public static IntBuffer memIntBuffer(long address, int capacity) {
        if (LWJGLUtil.DEBUG && (address == 0L || capacity < 0)) {
            throw new IllegalArgumentException();
        }
        return ACCESSOR.newIntBuffer(address, capacity);
    }

    public static LongBuffer memLongBuffer(long address, int capacity) {
        if (LWJGLUtil.DEBUG && (address == 0L || capacity < 0)) {
            throw new IllegalArgumentException();
        }
        return ACCESSOR.newLongBuffer(address, capacity);
    }

    public static FloatBuffer memFloatBuffer(long address, int capacity) {
        if (LWJGLUtil.DEBUG && (address == 0L || capacity < 0)) {
            throw new IllegalArgumentException();
        }
        return ACCESSOR.newFloatBuffer(address, capacity);
    }

    public static DoubleBuffer memDoubleBuffer(long address, int capacity) {
        if (LWJGLUtil.DEBUG && (address == 0L || capacity < 0)) {
            throw new IllegalArgumentException();
        }
        return ACCESSOR.newDoubleBuffer(address, capacity);
    }

    public static PointerBuffer memPointerBuffer(long address, int capacity) {
        return new PointerBuffer(address, capacity);
    }

    public static ByteBuffer memSetupBuffer(ByteBuffer buffer, long address, int capacity) {
        if (LWJGLUtil.DEBUG && (address == 0L || capacity < 0)) {
            throw new IllegalArgumentException();
        }
        return ACCESSOR.setupBuffer(buffer, address, capacity);
    }

    public static ShortBuffer memSetupBuffer(ShortBuffer buffer, long address, int capacity) {
        if (LWJGLUtil.DEBUG && (address == 0L || capacity < 0)) {
            throw new IllegalArgumentException();
        }
        return ACCESSOR.setupBuffer(buffer, address, capacity);
    }

    public static CharBuffer memSetupBuffer(CharBuffer buffer, long address, int capacity) {
        if (LWJGLUtil.DEBUG && (address == 0L || capacity < 0)) {
            throw new IllegalArgumentException();
        }
        return ACCESSOR.setupBuffer(buffer, address, capacity);
    }

    public static IntBuffer memSetupBuffer(IntBuffer buffer, long address, int capacity) {
        if (LWJGLUtil.DEBUG && (address == 0L || capacity < 0)) {
            throw new IllegalArgumentException();
        }
        return ACCESSOR.setupBuffer(buffer, address, capacity);
    }

    public static LongBuffer memSetupBuffer(LongBuffer buffer, long address, int capacity) {
        if (LWJGLUtil.DEBUG && (address == 0L || capacity < 0)) {
            throw new IllegalArgumentException();
        }
        return ACCESSOR.setupBuffer(buffer, address, capacity);
    }

    public static FloatBuffer memSetupBuffer(FloatBuffer buffer, long address, int capacity) {
        if (LWJGLUtil.DEBUG && (address == 0L || capacity < 0)) {
            throw new IllegalArgumentException();
        }
        return ACCESSOR.setupBuffer(buffer, address, capacity);
    }

    public static DoubleBuffer memSetupBuffer(DoubleBuffer buffer, long address, int capacity) {
        if (LWJGLUtil.DEBUG && (address == 0L || capacity < 0)) {
            throw new IllegalArgumentException();
        }
        return ACCESSOR.setupBuffer(buffer, address, capacity);
    }

    public static void memSet(long ptr, int value, int bytes) {
        if (LWJGLUtil.DEBUG && ptr == 0L) {
            throw new IllegalArgumentException();
        }
        ACCESSOR.memSet(ptr, value, bytes);
    }

    public static void memCopy(long src, long dst, int bytes) {
        if (LWJGLUtil.DEBUG && (src == 0L || dst == 0L || bytes < 0)) {
            throw new IllegalArgumentException();
        }
        ACCESSOR.memCopy(src, dst, bytes);
    }

    public static byte memGetByte(long ptr) {
        return ACCESSOR.memGetByte(ptr);
    }

    public static short memGetShort(long ptr) {
        return ACCESSOR.memGetShort(ptr);
    }

    public static int memGetInt(long ptr) {
        return ACCESSOR.memGetInt(ptr);
    }

    public static long memGetLong(long ptr) {
        return ACCESSOR.memGetLong(ptr);
    }

    public static float memGetFloat(long ptr) {
        return ACCESSOR.memGetFloat(ptr);
    }

    public static double memGetDouble(long ptr) {
        return ACCESSOR.memGetDouble(ptr);
    }

    public static long memGetAddress(long ptr) {
        return ACCESSOR.memGetAddress(ptr);
    }

    public static void memPutByte(long ptr, byte value) {
        ACCESSOR.memPutByte(ptr, value);
    }

    public static void memPutShort(long ptr, short value) {
        ACCESSOR.memPutShort(ptr, value);
    }

    public static void memPutInt(long ptr, int value) {
        ACCESSOR.memPutInt(ptr, value);
    }

    public static void memPutLong(long ptr, long value) {
        ACCESSOR.memPutLong(ptr, value);
    }

    public static void memPutFloat(long ptr, float value) {
        ACCESSOR.memPutFloat(ptr, value);
    }

    public static void memPutDouble(long ptr, double value) {
        ACCESSOR.memPutDouble(ptr, value);
    }

    public static void memPutAddress(long ptr, long value) {
        ACCESSOR.memPutAddress(ptr, value);
    }

    public static native int memPointerSize();

    public static native <T> T memGlobalRefToObject(long var0);

    public static native long memGlobalRefNew(Object var0);

    public static native void memGlobalRefDelete(long var0);

    public static native long memGlobalRefNewWeak(Object var0);

    public static native void memGlobalRefDeleteWeak(long var0);

    static native void nMemSet(long var0, int var2, long var3);

    static native void nMemCopy(long var0, long var2, long var4);

    static native byte nMemGetByte(long var0);

    static native short nMemGetShort(long var0);

    static native int nMemGetInt(long var0);

    static native long nMemGetLong(long var0);

    static native float nMemGetFloat(long var0);

    static native double nMemGetDouble(long var0);

    static native long nMemGetAddress(long var0);

    static native void nMemPutByte(long var0, byte var2);

    static native void nMemPutShort(long var0, short var2);

    static native void nMemPutInt(long var0, int var2);

    static native void nMemPutLong(long var0, long var2);

    static native void nMemPutFloat(long var0, float var2);

    static native void nMemPutDouble(long var0, double var2);

    static native void nMemPutAddress(long var0, long var2);

    static native long nGetAddress(Buffer var0);

    static native ByteBuffer nNewBuffer(long var0, int var2);

    public static ByteBuffer memEncodeASCII(CharSequence text) {
        return MemoryUtil.memEncodeASCII(text, true);
    }

    public static ByteBuffer memEncodeASCII(CharSequence text, boolean nullTerminated) {
        if (text == null) {
            return null;
        }
        ByteBuffer buffer = BufferUtils.createByteBuffer(text.length() + (nullTerminated ? 1 : 0));
        for (int i = 0; i < text.length(); ++i) {
            buffer.put(i, (byte)text.charAt(i));
        }
        if (nullTerminated) {
            buffer.put(text.length(), (byte)0);
        }
        return buffer;
    }

    public static ByteBuffer memEncodeUTF8(CharSequence text) {
        return MemoryUtil.memEncodeUTF8(text, true);
    }

    public static ByteBuffer memEncodeUTF8(CharSequence text, boolean nullTerminated) {
        return MemoryUtil.memEncode(text, UTF8, nullTerminated);
    }

    public static ByteBuffer memEncodeUTF16(CharSequence text) {
        return MemoryUtil.memEncodeUTF16(text, true);
    }

    public static ByteBuffer memEncodeUTF16(CharSequence text, boolean nullTerminated) {
        if (text == null) {
            return null;
        }
        ByteBuffer buffer = BufferUtils.createByteBuffer(text.length() + (nullTerminated ? 1 : 0) << 1);
        MemoryUtil.memEncodeUTF16(text, nullTerminated, buffer);
        return buffer;
    }

    public static void memEncodeUTF16(CharSequence text, boolean nullTerminated, ByteBuffer target) {
        for (int i = 0; i < text.length(); ++i) {
            target.putChar(i << 1, text.charAt(i));
        }
        if (nullTerminated) {
            target.putChar(target.capacity() - 2, '\u0000');
        }
    }

    public static ByteBuffer memEncode(CharSequence text, Charset charset) {
        return MemoryUtil.memEncode(text, charset, true);
    }

    public static ByteBuffer memEncode(CharSequence text, Charset charset, boolean nullTerminated) {
        if (text == null) {
            return null;
        }
        return MemoryUtil.encode(CharBuffer.wrap(nullTerminated ? new CharSequenceNT(text) : text), charset);
    }

    private static ByteBuffer encode(CharBuffer in, Charset charset) {
        CharsetEncoder encoder = charset.newEncoder();
        int n = (int)((float)in.remaining() * encoder.averageBytesPerChar());
        ByteBuffer out = BufferUtils.createByteBuffer(n);
        if (n == 0 && in.remaining() == 0) {
            return out;
        }
        encoder.reset();
        while (true) {
            CoderResult cr;
            CoderResult coderResult = cr = in.hasRemaining() ? encoder.encode(in, out, true) : CoderResult.UNDERFLOW;
            if (cr.isUnderflow()) {
                cr = encoder.flush(out);
            }
            if (cr.isUnderflow()) break;
            if (cr.isOverflow()) {
                n = 2 * n + 1;
                ByteBuffer o = BufferUtils.createByteBuffer(n);
                out.flip();
                o.put(out);
                out = o;
                continue;
            }
            try {
                cr.throwException();
            }
            catch (CharacterCodingException e) {
                throw new RuntimeException(e);
            }
        }
        out.flip();
        return out;
    }

    public static int memStrLen1(ByteBuffer buffer) {
        return MemoryUtil.memStrLen1(buffer, buffer.position());
    }

    public static int memStrLen1(ByteBuffer buffer, int from) {
        int to;
        for (to = from; to < buffer.remaining() && buffer.get(to) != 0; ++to) {
        }
        return to - from;
    }

    public static int memStrLen2(ByteBuffer buffer) {
        return MemoryUtil.memStrLen2(buffer, buffer.position());
    }

    public static int memStrLen2(ByteBuffer buffer, int from) {
        int to;
        for (to = from; to < buffer.remaining() && buffer.getChar(to) != '\u0000'; to += 2) {
        }
        return to - from;
    }

    public static String memDecodeASCII(long address) {
        return MemoryUtil.memDecodeASCII(MemoryUtil.memByteBufferNT1(address));
    }

    public static String memDecodeASCII(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        return MemoryUtil.memDecodeASCII(buffer, buffer.remaining());
    }

    public static String memDecodeASCII(ByteBuffer buffer, int length) {
        return MemoryUtil.memDecodeASCII(buffer, length, buffer.position());
    }

    public static String memDecodeASCII(ByteBuffer buffer, int length, int offset) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)buffer.get(offset + i);
        }
        return new String(chars);
    }

    public static String memDecodeUTF8(long address) {
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBufferNT1(address));
    }

    public static String memDecodeUTF8(ByteBuffer buffer) {
        return MemoryUtil.memDecode(buffer, UTF8);
    }

    public static String memDecodeUTF8(ByteBuffer buffer, int length) {
        return MemoryUtil.memDecode(buffer, UTF8, length);
    }

    public static String memDecodeUTF8(ByteBuffer buffer, int length, int offset) {
        return MemoryUtil.memDecode(buffer, UTF8, length, offset);
    }

    public static String memDecodeUTF16(long address) {
        return MemoryUtil.memDecodeUTF16(MemoryUtil.memByteBufferNT2(address));
    }

    public static String memDecodeUTF16(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        return MemoryUtil.memDecodeUTF16(buffer, buffer.remaining());
    }

    public static String memDecodeUTF16(ByteBuffer buffer, int length) {
        return MemoryUtil.memDecodeUTF16(buffer, length, buffer.position());
    }

    public static String memDecodeUTF16(ByteBuffer buffer, int length, int offset) {
        char[] chars = new char[length >> 1];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = buffer.getChar(offset + (i << 1));
        }
        return new String(chars);
    }

    public static String memDecode(ByteBuffer buffer, Charset charset) {
        if (buffer == null) {
            return null;
        }
        return MemoryUtil.memDecode(buffer, charset, buffer.remaining());
    }

    public static String memDecode(ByteBuffer buffer, Charset charset, int length) {
        return MemoryUtil.memDecode(buffer, charset, length, buffer.position());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String memDecode(ByteBuffer buffer, Charset charset, int length, int offset) {
        int position = buffer.position();
        int limit = buffer.limit();
        try {
            buffer.position(offset);
            buffer.limit(offset + length);
            String string = MemoryUtil.decodeImpl(buffer, charset);
            return string;
        }
        finally {
            buffer.limit(limit);
            buffer.position(position);
        }
    }

    private static String decodeImpl(ByteBuffer in, Charset charset) {
        CharsetDecoder decoder = charset.newDecoder();
        int n = (int)((float)in.remaining() * decoder.averageCharsPerByte());
        CharBuffer out = BufferUtils.createCharBuffer(n);
        if (n == 0 && in.remaining() == 0) {
            return "";
        }
        decoder.reset();
        while (true) {
            CoderResult cr;
            CoderResult coderResult = cr = in.hasRemaining() ? decoder.decode(in, out, true) : CoderResult.UNDERFLOW;
            if (cr.isUnderflow()) {
                cr = decoder.flush(out);
            }
            if (cr.isUnderflow()) break;
            if (cr.isOverflow()) {
                n = 2 * n + 1;
                CharBuffer o = BufferUtils.createCharBuffer(n);
                out.flip();
                o.put(out);
                out = o;
                continue;
            }
            try {
                cr.throwException();
            }
            catch (CharacterCodingException e) {
                throw new RuntimeException(e);
            }
        }
        out.flip();
        return out.toString();
    }

    static {
        Sys.touch();
        UTF8 = Charset.forName("UTF-8");
        ACCESSOR = MemoryAccess.getInstance();
        PAGE_SIZE = ACCESSOR.getPageSize();
        LWJGLUtil.log("MemoryUtil MemoryAccessor: " + ACCESSOR.getClass().getSimpleName());
    }
}

