/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GPU_DEVICE;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class WGLNVGPUAffinity {
    public static final int ERROR_INCOMPATIBLE_AFFINITY_MASKS_NV = 8400;
    public static final int WGL_ERROR_MISSING_AFFINITY_MASK_NV = 8401;
    public final long EnumGpusNV;
    public final long EnumGpuDevicesNV;
    public final long CreateAffinityDCNV;
    public final long EnumGpusFromAffinityDCNV;
    public final long DeleteDCNV;

    public WGLNVGPUAffinity(FunctionProvider provider) {
        this.EnumGpusNV = provider.getFunctionAddress("wglEnumGpusNV");
        this.EnumGpuDevicesNV = provider.getFunctionAddress("wglEnumGpuDevicesNV");
        this.CreateAffinityDCNV = provider.getFunctionAddress("wglCreateAffinityDCNV");
        this.EnumGpusFromAffinityDCNV = provider.getFunctionAddress("wglEnumGpusFromAffinityDCNV");
        this.DeleteDCNV = provider.getFunctionAddress("wglDeleteDCNV");
    }

    public static WGLNVGPUAffinity getInstance() {
        return GL.getCapabilities().__WGLNVGPUAffinity;
    }

    static WGLNVGPUAffinity create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("WGL_NV_gpu_affinity")) {
            return null;
        }
        WGLNVGPUAffinity funcs = new WGLNVGPUAffinity(provider);
        boolean supported = Checks.checkFunctions(funcs.EnumGpusNV, funcs.EnumGpuDevicesNV, funcs.CreateAffinityDCNV, funcs.EnumGpusFromAffinityDCNV, funcs.DeleteDCNV);
        return GL.checkExtension("WGL_NV_gpu_affinity", funcs, supported);
    }

    public static native int nwglEnumGpusNV(int var0, long var1, long var3);

    public static int nwglEnumGpusNV(int gpuIndex, long gpu) {
        long __functionAddress = WGLNVGPUAffinity.getInstance().EnumGpusNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return WGLNVGPUAffinity.nwglEnumGpusNV(gpuIndex, gpu, __functionAddress);
    }

    public static int wglEnumGpusNV(int gpuIndex, ByteBuffer gpu) {
        return WGLNVGPUAffinity.nwglEnumGpusNV(gpuIndex, MemoryUtil.memAddress(gpu));
    }

    public static int wglEnumGpusNV(int gpuIndex, PointerBuffer gpu) {
        return WGLNVGPUAffinity.nwglEnumGpusNV(gpuIndex, MemoryUtil.memAddress(gpu));
    }

    public static native int nwglEnumGpuDevicesNV(long var0, int var2, long var3, long var5);

    public static int nwglEnumGpuDevicesNV(long gpu, int deviceIndex, long gpuDevice) {
        long __functionAddress = WGLNVGPUAffinity.getInstance().EnumGpuDevicesNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(gpu);
        }
        return WGLNVGPUAffinity.nwglEnumGpuDevicesNV(gpu, deviceIndex, gpuDevice, __functionAddress);
    }

    public static int wglEnumGpuDevicesNV(long gpu, int deviceIndex, ByteBuffer gpuDevice) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)gpuDevice, GPU_DEVICE.SIZEOF);
        }
        return WGLNVGPUAffinity.nwglEnumGpuDevicesNV(gpu, deviceIndex, MemoryUtil.memAddress(gpuDevice));
    }

    public static native long nwglCreateAffinityDCNV(long var0, long var2);

    public static long nwglCreateAffinityDCNV(long gpuList) {
        long __functionAddress = WGLNVGPUAffinity.getInstance().CreateAffinityDCNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return WGLNVGPUAffinity.nwglCreateAffinityDCNV(gpuList, __functionAddress);
    }

    public static long wglCreateAffinityDCNV(ByteBuffer gpuList) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(gpuList);
        }
        return WGLNVGPUAffinity.nwglCreateAffinityDCNV(MemoryUtil.memAddress(gpuList));
    }

    public static long wglCreateAffinityDCNV(PointerBuffer gpuList) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT(gpuList);
        }
        return WGLNVGPUAffinity.nwglCreateAffinityDCNV(MemoryUtil.memAddress(gpuList));
    }

    public static native int nwglEnumGpusFromAffinityDCNV(long var0, int var2, long var3, long var5);

    public static int nwglEnumGpusFromAffinityDCNV(long affinityDC, int gpuIndex, long gpu) {
        long __functionAddress = WGLNVGPUAffinity.getInstance().EnumGpusFromAffinityDCNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(affinityDC);
        }
        return WGLNVGPUAffinity.nwglEnumGpusFromAffinityDCNV(affinityDC, gpuIndex, gpu, __functionAddress);
    }

    public static int wglEnumGpusFromAffinityDCNV(long affinityDC, int gpuIndex, ByteBuffer gpu) {
        return WGLNVGPUAffinity.nwglEnumGpusFromAffinityDCNV(affinityDC, gpuIndex, MemoryUtil.memAddress(gpu));
    }

    public static int wglEnumGpusFromAffinityDCNV(long affinityDC, int gpuIndex, PointerBuffer gpu) {
        return WGLNVGPUAffinity.nwglEnumGpusFromAffinityDCNV(affinityDC, gpuIndex, MemoryUtil.memAddress(gpu));
    }

    public static native int nwglDeleteDCNV(long var0, long var2);

    public static int wglDeleteDCNV(long hdc) {
        long __functionAddress = WGLNVGPUAffinity.getInstance().DeleteDCNV;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(hdc);
        }
        return WGLNVGPUAffinity.nwglDeleteDCNV(hdc, __functionAddress);
    }
}

