/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class WGLARBPbuffer {
    public static final int WGL_DRAW_TO_PBUFFER_ARB = 8237;
    public static final int WGL_MAX_PBUFFER_PIXELS_ARB = 8238;
    public static final int WGL_MAX_PBUFFER_WIDTH_ARB = 8239;
    public static final int WGL_MAX_PBUFFER_HEIGHT_ARB = 8240;
    public static final int WGL_PBUFFER_LARGEST_ARB = 8243;
    public static final int WGL_PBUFFER_WIDTH_ARB = 8244;
    public static final int WGL_PBUFFER_HEIGHT_ARB = 8245;
    public static final int WGL_PBUFFER_LOST_ARB = 8246;
    public final long CreatePbufferARB;
    public final long GetPbufferDCARB;
    public final long ReleasePbufferDCARB;
    public final long DestroyPbufferARB;
    public final long QueryPbufferARB;

    public WGLARBPbuffer(FunctionProvider provider) {
        this.CreatePbufferARB = provider.getFunctionAddress("wglCreatePbufferARB");
        this.GetPbufferDCARB = provider.getFunctionAddress("wglGetPbufferDCARB");
        this.ReleasePbufferDCARB = provider.getFunctionAddress("wglReleasePbufferDCARB");
        this.DestroyPbufferARB = provider.getFunctionAddress("wglDestroyPbufferARB");
        this.QueryPbufferARB = provider.getFunctionAddress("wglQueryPbufferARB");
    }

    public static WGLARBPbuffer getInstance() {
        return GL.getCapabilities().__WGLARBPbuffer;
    }

    static WGLARBPbuffer create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("WGL_ARB_pbuffer")) {
            return null;
        }
        WGLARBPbuffer funcs = new WGLARBPbuffer(provider);
        boolean supported = Checks.checkFunctions(funcs.CreatePbufferARB, funcs.GetPbufferDCARB, funcs.ReleasePbufferDCARB, funcs.DestroyPbufferARB, funcs.QueryPbufferARB);
        return GL.checkExtension("WGL_ARB_pbuffer", funcs, supported);
    }

    public static native long nwglCreatePbufferARB(long var0, int var2, int var3, int var4, long var5, long var7);

    public static long nwglCreatePbufferARB(long hdc, int pixelFormat, int width, int height, long attribList) {
        long __functionAddress = WGLARBPbuffer.getInstance().CreatePbufferARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(hdc);
        }
        return WGLARBPbuffer.nwglCreatePbufferARB(hdc, pixelFormat, width, height, attribList, __functionAddress);
    }

    public static long wglCreatePbufferARB(long hdc, int pixelFormat, int width, int height, ByteBuffer attribList) {
        if (LWJGLUtil.CHECKS && attribList != null) {
            Checks.checkNT4(attribList);
        }
        return WGLARBPbuffer.nwglCreatePbufferARB(hdc, pixelFormat, width, height, MemoryUtil.memAddressSafe(attribList));
    }

    public static long wglCreatePbufferARB(long hdc, int pixelFormat, int width, int height, IntBuffer attribList) {
        if (LWJGLUtil.CHECKS && attribList != null) {
            Checks.checkNT(attribList);
        }
        return WGLARBPbuffer.nwglCreatePbufferARB(hdc, pixelFormat, width, height, MemoryUtil.memAddressSafe(attribList));
    }

    public static native long nwglGetPbufferDCARB(long var0, long var2);

    public static long wglGetPbufferDCARB(long pbuffer) {
        long __functionAddress = WGLARBPbuffer.getInstance().GetPbufferDCARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(pbuffer);
        }
        return WGLARBPbuffer.nwglGetPbufferDCARB(pbuffer, __functionAddress);
    }

    public static native int nwglReleasePbufferDCARB(long var0, long var2, long var4);

    public static int wglReleasePbufferDCARB(long pbuffer, long hdc) {
        long __functionAddress = WGLARBPbuffer.getInstance().ReleasePbufferDCARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(pbuffer);
            Checks.checkPointer(hdc);
        }
        return WGLARBPbuffer.nwglReleasePbufferDCARB(pbuffer, hdc, __functionAddress);
    }

    public static native int nwglDestroyPbufferARB(long var0, long var2);

    public static int wglDestroyPbufferARB(long pbuffer) {
        long __functionAddress = WGLARBPbuffer.getInstance().DestroyPbufferARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(pbuffer);
        }
        return WGLARBPbuffer.nwglDestroyPbufferARB(pbuffer, __functionAddress);
    }

    public static native int nwglQueryPbufferARB(long var0, int var2, long var3, long var5);

    public static int nwglQueryPbufferARB(long pbuffer, int attribute, long value) {
        long __functionAddress = WGLARBPbuffer.getInstance().QueryPbufferARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(pbuffer);
        }
        return WGLARBPbuffer.nwglQueryPbufferARB(pbuffer, attribute, value, __functionAddress);
    }

    public static int wglQueryPbufferARB(long pbuffer, int attribute, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        return WGLARBPbuffer.nwglQueryPbufferARB(pbuffer, attribute, MemoryUtil.memAddress(value));
    }

    public static int wglQueryPbufferARB(long pbuffer, int attribute, IntBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        return WGLARBPbuffer.nwglQueryPbufferARB(pbuffer, attribute, MemoryUtil.memAddress(value));
    }
}

