/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class WGLARBCreateContext {
    public static final int WGL_CONTEXT_MAJOR_VERSION_ARB = 8337;
    public static final int WGL_CONTEXT_MINOR_VERSION_ARB = 8338;
    public static final int WGL_CONTEXT_LAYER_PLANE_ARB = 8339;
    public static final int WGL_CONTEXT_FLAGS_ARB = 8340;
    public static final int WGL_CONTEXT_DEBUG_BIT_ARB = 1;
    public static final int WGL_CONTEXT_FORWARD_COMPATIBLE_BIT_ARB = 2;
    public static final int ERROR_INVALID_VERSION_ARB = 8341;
    public final long CreateContextAttribsARB;

    public WGLARBCreateContext(FunctionProvider provider) {
        this.CreateContextAttribsARB = provider.getFunctionAddress("wglCreateContextAttribsARB");
    }

    public static WGLARBCreateContext getInstance() {
        return GL.getCapabilities().__WGLARBCreateContext;
    }

    static WGLARBCreateContext create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("WGL_ARB_create_context")) {
            return null;
        }
        WGLARBCreateContext funcs = new WGLARBCreateContext(provider);
        boolean supported = Checks.checkFunctions(funcs.CreateContextAttribsARB);
        return GL.checkExtension("WGL_ARB_create_context", funcs, supported);
    }

    public static native long nwglCreateContextAttribsARB(long var0, long var2, long var4, long var6);

    public static long nwglCreateContextAttribsARB(long hdc, long shareContext, long attribList) {
        long __functionAddress = WGLARBCreateContext.getInstance().CreateContextAttribsARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(hdc);
        }
        return WGLARBCreateContext.nwglCreateContextAttribsARB(hdc, shareContext, attribList, __functionAddress);
    }

    public static long wglCreateContextAttribsARB(long hdc, long shareContext, ByteBuffer attribList) {
        if (LWJGLUtil.CHECKS && attribList != null) {
            Checks.checkNT4(attribList);
        }
        return WGLARBCreateContext.nwglCreateContextAttribsARB(hdc, shareContext, MemoryUtil.memAddressSafe(attribList));
    }

    public static long wglCreateContextAttribsARB(long hdc, long shareContext, IntBuffer attribList) {
        if (LWJGLUtil.CHECKS && attribList != null) {
            Checks.checkNT(attribList);
        }
        return WGLARBCreateContext.nwglCreateContextAttribsARB(hdc, shareContext, MemoryUtil.memAddressSafe(attribList));
    }
}

