/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.windows.RECT;

public final class GPU_DEVICE {
    public static final int SIZEOF;
    public static final int CB;
    public static final int DEVICENAME;
    public static final int DEVICESTRING;
    public static final int FLAGS;
    public static final int VIRTUALSCREEN;

    private GPU_DEVICE() {
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int cb, long DeviceName, int DeviceNameBytes, long DeviceString, int DeviceStringBytes, int Flags, long virtualScreen) {
        ByteBuffer gpu_device = GPU_DEVICE.malloc();
        GPU_DEVICE.cb(gpu_device, cb);
        GPU_DEVICE.DeviceNameSet(gpu_device, DeviceName, DeviceNameBytes);
        GPU_DEVICE.DeviceStringSet(gpu_device, DeviceString, DeviceStringBytes);
        GPU_DEVICE.Flags(gpu_device, Flags);
        GPU_DEVICE.virtualScreenSet(gpu_device, virtualScreen);
        return gpu_device;
    }

    public static ByteBuffer malloc(int cb, ByteBuffer DeviceName, ByteBuffer DeviceString, int Flags, ByteBuffer virtualScreen) {
        ByteBuffer gpu_device = GPU_DEVICE.malloc();
        GPU_DEVICE.cb(gpu_device, cb);
        GPU_DEVICE.DeviceNameSet(gpu_device, DeviceName);
        GPU_DEVICE.DeviceStringSet(gpu_device, DeviceString);
        GPU_DEVICE.Flags(gpu_device, Flags);
        GPU_DEVICE.virtualScreenSet(gpu_device, virtualScreen);
        return gpu_device;
    }

    public static ByteBuffer malloc(int cb, CharSequence DeviceName, CharSequence DeviceString, int Flags, ByteBuffer virtualScreen) {
        ByteBuffer gpu_device = GPU_DEVICE.malloc();
        GPU_DEVICE.cb(gpu_device, cb);
        GPU_DEVICE.DeviceNameSet(gpu_device, DeviceName);
        GPU_DEVICE.DeviceStringSet(gpu_device, DeviceString);
        GPU_DEVICE.Flags(gpu_device, Flags);
        GPU_DEVICE.virtualScreenSet(gpu_device, virtualScreen);
        return gpu_device;
    }

    public static void cb(ByteBuffer gpu_device, int cb) {
        gpu_device.putInt(gpu_device.position() + CB, cb);
    }

    public static void DeviceNameSet(ByteBuffer gpu_device, long DeviceName, int bytes) {
        MemoryUtil.memCopy(DeviceName, MemoryUtil.memAddress(gpu_device) + (long)DEVICENAME, bytes);
    }

    public static void DeviceNameSet(ByteBuffer gpu_device, ByteBuffer DeviceName) {
        Checks.checkNT2(DeviceName);
        Checks.checkBufferGT(DeviceName, 64);
        GPU_DEVICE.DeviceNameSet(gpu_device, MemoryUtil.memAddress(DeviceName), DeviceName.remaining());
    }

    public static void DeviceNameSet(ByteBuffer gpu_device, CharSequence DeviceName) {
        ByteBuffer buffer = MemoryUtil.memEncodeUTF16(DeviceName, true);
        GPU_DEVICE.DeviceNameSet(gpu_device, MemoryUtil.memAddress(buffer), buffer.capacity());
    }

    public static void DeviceStringSet(ByteBuffer gpu_device, long DeviceString, int bytes) {
        MemoryUtil.memCopy(DeviceString, MemoryUtil.memAddress(gpu_device) + (long)DEVICESTRING, bytes);
    }

    public static void DeviceStringSet(ByteBuffer gpu_device, ByteBuffer DeviceString) {
        Checks.checkNT2(DeviceString);
        Checks.checkBufferGT(DeviceString, 256);
        GPU_DEVICE.DeviceStringSet(gpu_device, MemoryUtil.memAddress(DeviceString), DeviceString.remaining());
    }

    public static void DeviceStringSet(ByteBuffer gpu_device, CharSequence DeviceString) {
        ByteBuffer buffer = MemoryUtil.memEncodeUTF16(DeviceString, true);
        GPU_DEVICE.DeviceStringSet(gpu_device, MemoryUtil.memAddress(buffer), buffer.capacity());
    }

    public static void Flags(ByteBuffer gpu_device, int Flags) {
        gpu_device.putInt(gpu_device.position() + FLAGS, Flags);
    }

    public static void virtualScreenSet(ByteBuffer gpu_device, long virtualScreen) {
        if (virtualScreen != 0L) {
            MemoryUtil.memCopy(virtualScreen, MemoryUtil.memAddress(gpu_device) + (long)VIRTUALSCREEN, RECT.SIZEOF);
        }
    }

    public static void virtualScreenSet(ByteBuffer gpu_device, ByteBuffer virtualScreen) {
        GPU_DEVICE.virtualScreenSet(gpu_device, MemoryUtil.memAddressSafe(virtualScreen));
    }

    public static void virtualScreenLeft(ByteBuffer gpu_device, int left) {
        gpu_device.putInt(gpu_device.position() + VIRTUALSCREEN + RECT.LEFT, left);
    }

    public static void virtualScreenTop(ByteBuffer gpu_device, int top) {
        gpu_device.putInt(gpu_device.position() + VIRTUALSCREEN + RECT.TOP, top);
    }

    public static void virtualScreenRight(ByteBuffer gpu_device, int right) {
        gpu_device.putInt(gpu_device.position() + VIRTUALSCREEN + RECT.RIGHT, right);
    }

    public static void virtualScreenBottom(ByteBuffer gpu_device, int bottom) {
        gpu_device.putInt(gpu_device.position() + VIRTUALSCREEN + RECT.BOTTOM, bottom);
    }

    public static int cb(ByteBuffer gpu_device) {
        return gpu_device.getInt(gpu_device.position() + CB);
    }

    public static void DeviceNameGet(ByteBuffer gpu_device, long DeviceName, int bytes) {
        MemoryUtil.memCopy(MemoryUtil.memAddress(gpu_device) + (long)DEVICENAME, DeviceName, bytes);
    }

    public static void DeviceNameGet(ByteBuffer gpu_device, ByteBuffer DeviceName) {
        Checks.checkBufferGT(DeviceName, 64);
        GPU_DEVICE.DeviceNameGet(gpu_device, MemoryUtil.memAddress(DeviceName), DeviceName.remaining());
    }

    public static String DeviceNameGets(ByteBuffer gpu_device) {
        return MemoryUtil.memDecodeUTF16(gpu_device, MemoryUtil.memStrLen2(gpu_device, DEVICENAME), DEVICENAME);
    }

    public static String DeviceNameGets(ByteBuffer gpu_device, int size) {
        return MemoryUtil.memDecodeUTF16(gpu_device, size, DEVICENAME);
    }

    public static void DeviceStringGet(ByteBuffer gpu_device, long DeviceString, int bytes) {
        MemoryUtil.memCopy(MemoryUtil.memAddress(gpu_device) + (long)DEVICESTRING, DeviceString, bytes);
    }

    public static void DeviceStringGet(ByteBuffer gpu_device, ByteBuffer DeviceString) {
        Checks.checkBufferGT(DeviceString, 256);
        GPU_DEVICE.DeviceStringGet(gpu_device, MemoryUtil.memAddress(DeviceString), DeviceString.remaining());
    }

    public static String DeviceStringGets(ByteBuffer gpu_device) {
        return MemoryUtil.memDecodeUTF16(gpu_device, MemoryUtil.memStrLen2(gpu_device, DEVICESTRING), DEVICESTRING);
    }

    public static String DeviceStringGets(ByteBuffer gpu_device, int size) {
        return MemoryUtil.memDecodeUTF16(gpu_device, size, DEVICESTRING);
    }

    public static int Flags(ByteBuffer gpu_device) {
        return gpu_device.getInt(gpu_device.position() + FLAGS);
    }

    public static void virtualScreenGet(ByteBuffer gpu_device, long virtualScreen) {
        MemoryUtil.memCopy(MemoryUtil.memAddress(gpu_device) + (long)VIRTUALSCREEN, virtualScreen, RECT.SIZEOF);
    }

    public static void virtualScreenGet(ByteBuffer gpu_device, ByteBuffer virtualScreen) {
        Checks.checkBuffer((Buffer)virtualScreen, RECT.SIZEOF);
        GPU_DEVICE.virtualScreenGet(gpu_device, MemoryUtil.memAddress(virtualScreen));
    }

    public static int virtualScreenLeft(ByteBuffer gpu_device) {
        return gpu_device.getInt(gpu_device.position() + VIRTUALSCREEN + RECT.LEFT);
    }

    public static int virtualScreenTop(ByteBuffer gpu_device) {
        return gpu_device.getInt(gpu_device.position() + VIRTUALSCREEN + RECT.TOP);
    }

    public static int virtualScreenRight(ByteBuffer gpu_device) {
        return gpu_device.getInt(gpu_device.position() + VIRTUALSCREEN + RECT.RIGHT);
    }

    public static int virtualScreenBottom(ByteBuffer gpu_device) {
        return gpu_device.getInt(gpu_device.position() + VIRTUALSCREEN + RECT.BOTTOM);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(5);
        SIZEOF = GPU_DEVICE.offsets(MemoryUtil.memAddress(offsets));
        CB = offsets.get(0);
        DEVICENAME = offsets.get(1);
        DEVICESTRING = offsets.get(2);
        FLAGS = offsets.get(3);
        VIRTUALSCREEN = offsets.get(4);
    }
}

