/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class GLXSGIXSwapBarrier {
    public final long BindSwapBarrierSGIX;
    public final long QueryMaxSwapBarriersSGIX;

    public GLXSGIXSwapBarrier(FunctionProvider provider) {
        this.BindSwapBarrierSGIX = provider.getFunctionAddress("glXBindSwapBarrierSGIX");
        this.QueryMaxSwapBarriersSGIX = provider.getFunctionAddress("glXQueryMaxSwapBarriersSGIX");
    }

    public static GLXSGIXSwapBarrier getInstance() {
        return GL.getCapabilities().__GLXSGIXSwapBarrier;
    }

    static GLXSGIXSwapBarrier create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GLX_SGIX_swap_barrier")) {
            return null;
        }
        GLXSGIXSwapBarrier funcs = new GLXSGIXSwapBarrier(provider);
        boolean supported = Checks.checkFunctions(funcs.BindSwapBarrierSGIX, funcs.QueryMaxSwapBarriersSGIX);
        return GL.checkExtension("GLX_SGIX_swap_barrier", funcs, supported);
    }

    public static native void nglXBindSwapBarrierSGIX(long var0, long var2, int var4, long var5);

    public static void glXBindSwapBarrierSGIX(long display, long drawable, int barrier) {
        long __functionAddress = GLXSGIXSwapBarrier.getInstance().BindSwapBarrierSGIX;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(drawable);
        }
        GLXSGIXSwapBarrier.nglXBindSwapBarrierSGIX(display, drawable, barrier, __functionAddress);
    }

    public static native int nglXQueryMaxSwapBarriersSGIX(long var0, int var2, long var3, long var5);

    public static int nglXQueryMaxSwapBarriersSGIX(long display, int screen, long max) {
        long __functionAddress = GLXSGIXSwapBarrier.getInstance().QueryMaxSwapBarriersSGIX;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
        }
        return GLXSGIXSwapBarrier.nglXQueryMaxSwapBarriersSGIX(display, screen, max, __functionAddress);
    }

    public static int glXQueryMaxSwapBarriersSGIX(long display, int screen, ByteBuffer max) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)max, 4);
        }
        return GLXSGIXSwapBarrier.nglXQueryMaxSwapBarriersSGIX(display, screen, MemoryUtil.memAddress(max));
    }

    public static int glXQueryMaxSwapBarriersSGIX(long display, int screen, IntBuffer max) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)max, 1);
        }
        return GLXSGIXSwapBarrier.nglXQueryMaxSwapBarriersSGIX(display, screen, MemoryUtil.memAddress(max));
    }
}

