/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.linux.XVisualInfo;

public final class GLX13 {
    public static final int GLX_WINDOW_BIT = 1;
    public static final int GLX_PIXMAP_BIT = 2;
    public static final int GLX_PBUFFER_BIT = 4;
    public static final int GLX_RGBA_BIT = 1;
    public static final int GLX_COLOR_INDEX_BIT = 2;
    public static final int GLX_PBUFFER_CLOBBER_MASK = 0x8000000;
    public static final int GLX_FRONT_LEFT_BUFFER_BIT = 1;
    public static final int GLX_FRONT_RIGHT_BUFFER_BIT = 2;
    public static final int GLX_BACK_LEFT_BUFFER_BIT = 4;
    public static final int GLX_BACK_RIGHT_BUFFER_BIT = 8;
    public static final int GLX_AUX_BUFFERS_BIT = 16;
    public static final int GLX_DEPTH_BUFFER_BIT = 32;
    public static final int GLX_STENCIL_BUFFER_BIT = 64;
    public static final int GLX_ACCUM_BUFFER_BIT = 128;
    public static final int GLX_CONFIG_CAVEAT = 32;
    public static final int GLX_X_VISUAL_TYPE = 34;
    public static final int GLX_TRANSPARENT_TYPE = 35;
    public static final int GLX_TRANSPARENT_INDEX_VALUE = 36;
    public static final int GLX_TRANSPARENT_RED_VALUE = 37;
    public static final int GLX_TRANSPARENT_GREEN_VALUE = 38;
    public static final int GLX_TRANSPARENT_BLUE_VALUE = 39;
    public static final int GLX_TRANSPARENT_ALPHA_VALUE = 40;
    public static final int GLX_DONT_CARE = -1;
    public static final int GLX_NONE = 32768;
    public static final int GLX_SLOW_CONFIG = 32769;
    public static final int GLX_TRUE_COLOR = 32770;
    public static final int GLX_DIRECT_COLOR = 32771;
    public static final int GLX_PSEUDO_COLOR = 32772;
    public static final int GLX_STATIC_COLOR = 32773;
    public static final int GLX_GRAY_SCALE = 32774;
    public static final int GLX_STATIC_GRAY = 32775;
    public static final int GLX_TRANSPARENT_RGB = 32776;
    public static final int GLX_TRANSPARENT_INDEX = 32777;
    public static final int GLX_VISUAL_ID = 32779;
    public static final int GLX_SCREEN = 32780;
    public static final int GLX_NON_CONFORMANT_CONFIG = 32781;
    public static final int GLX_DRAWABLE_TYPE = 32784;
    public static final int GLX_RENDER_TYPE = 32785;
    public static final int GLX_X_RENDERABLE = 32786;
    public static final int GLX_FBCONFIG_ID = 32787;
    public static final int GLX_RGBA_TYPE = 32788;
    public static final int GLX_COLOR_INDEX_TYPE = 32789;
    public static final int GLX_MAX_PBUFFER_WIDTH = 32790;
    public static final int GLX_MAX_PBUFFER_HEIGHT = 32791;
    public static final int GLX_MAX_PBUFFER_PIXELS = 32792;
    public static final int GLX_PRESERVED_CONTENTS = 32795;
    public static final int GLX_LARGEST_PBUFFER = 32796;
    public static final int GLX_WIDTH = 32797;
    public static final int GLX_HEIGHT = 32798;
    public static final int GLX_EVENT_MASK = 32799;
    public static final int GLX_DAMAGED = 32800;
    public static final int GLX_SAVED = 32801;
    public static final int GLX_WINDOW = 32802;
    public static final int GLX_PBUFFER = 32803;
    public static final int GLX_PBUFFER_HEIGHT = 32832;
    public static final int GLX_PBUFFER_WIDTH = 32833;
    public final long GetFBConfigs;
    public final long ChooseFBConfig;
    public final long GetFBConfigAttrib;
    public final long GetVisualFromFBConfig;
    public final long CreateWindow;
    public final long CreatePixmap;
    public final long DestroyPixmap;
    public final long CreatePbuffer;
    public final long DestroyPbuffer;
    public final long QueryDrawable;
    public final long CreateNewContext;
    public final long MakeContextCurrent;
    public final long GetCurrentReadDrawable;
    public final long QueryContext;
    public final long SelectEvent;
    public final long GetSelectedEvent;

    public GLX13(FunctionProvider provider) {
        this.GetFBConfigs = provider.getFunctionAddress("glXGetFBConfigs");
        this.ChooseFBConfig = provider.getFunctionAddress("glXChooseFBConfig");
        this.GetFBConfigAttrib = provider.getFunctionAddress("glXGetFBConfigAttrib");
        this.GetVisualFromFBConfig = provider.getFunctionAddress("glXGetVisualFromFBConfig");
        this.CreateWindow = provider.getFunctionAddress("glXCreateWindow");
        this.CreatePixmap = provider.getFunctionAddress("glXCreatePixmap");
        this.DestroyPixmap = provider.getFunctionAddress("glXDestroyPixmap");
        this.CreatePbuffer = provider.getFunctionAddress("glXCreatePbuffer");
        this.DestroyPbuffer = provider.getFunctionAddress("glXDestroyPbuffer");
        this.QueryDrawable = provider.getFunctionAddress("glXQueryDrawable");
        this.CreateNewContext = provider.getFunctionAddress("glXCreateNewContext");
        this.MakeContextCurrent = provider.getFunctionAddress("glXMakeContextCurrent");
        this.GetCurrentReadDrawable = provider.getFunctionAddress("glXGetCurrentReadDrawable");
        this.QueryContext = provider.getFunctionAddress("glXQueryContext");
        this.SelectEvent = provider.getFunctionAddress("glXSelectEvent");
        this.GetSelectedEvent = provider.getFunctionAddress("glXGetSelectedEvent");
    }

    public static GLX13 getInstance() {
        return GL.getCapabilities().__GLX13;
    }

    static GLX13 create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GLX_13")) {
            return null;
        }
        GLX13 funcs = new GLX13(provider);
        boolean supported = Checks.checkFunctions(funcs.GetFBConfigs, funcs.ChooseFBConfig, funcs.GetFBConfigAttrib, funcs.GetVisualFromFBConfig, funcs.CreateWindow, funcs.CreatePixmap, funcs.DestroyPixmap, funcs.CreatePbuffer, funcs.DestroyPbuffer, funcs.QueryDrawable, funcs.CreateNewContext, funcs.MakeContextCurrent, funcs.GetCurrentReadDrawable, funcs.QueryContext, funcs.SelectEvent, funcs.GetSelectedEvent);
        return GL.checkExtension("GLX_13", funcs, supported);
    }

    public static native long nglXGetFBConfigs(long var0, int var2, long var3, long var5);

    public static long nglXGetFBConfigs(long display, int screen, long nelements) {
        long __functionAddress = GLX13.getInstance().GetFBConfigs;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
        }
        return GLX13.nglXGetFBConfigs(display, screen, nelements, __functionAddress);
    }

    public static PointerBuffer glXGetFBConfigs(long display, int screen) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nelements = __buffer.intParam();
        long __result = GLX13.nglXGetFBConfigs(display, screen, __buffer.address() + (long)nelements);
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(nelements));
    }

    public static native long nglXChooseFBConfig(long var0, int var2, long var3, long var5, long var7);

    public static long nglXChooseFBConfig(long display, int screen, long attrib_list, long nelements) {
        long __functionAddress = GLX13.getInstance().ChooseFBConfig;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
        }
        return GLX13.nglXChooseFBConfig(display, screen, attrib_list, nelements, __functionAddress);
    }

    public static PointerBuffer glXChooseFBConfig(long display, int screen, ByteBuffer attrib_list) {
        if (LWJGLUtil.CHECKS && attrib_list != null) {
            Checks.checkNT4(attrib_list);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nelements = __buffer.intParam();
        long __result = GLX13.nglXChooseFBConfig(display, screen, MemoryUtil.memAddressSafe(attrib_list), __buffer.address() + (long)nelements);
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(nelements));
    }

    public static PointerBuffer glXChooseFBConfig(long display, int screen, IntBuffer attrib_list) {
        if (LWJGLUtil.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nelements = __buffer.intParam();
        long __result = GLX13.nglXChooseFBConfig(display, screen, MemoryUtil.memAddressSafe(attrib_list), __buffer.address() + (long)nelements);
        return MemoryUtil.memPointerBuffer(__result, __buffer.intValue(nelements));
    }

    public static native int nglXGetFBConfigAttrib(long var0, long var2, int var4, long var5, long var7);

    public static int nglXGetFBConfigAttrib(long display, long config, int attribute, long value) {
        long __functionAddress = GLX13.getInstance().GetFBConfigAttrib;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(config);
        }
        return GLX13.nglXGetFBConfigAttrib(display, config, attribute, value, __functionAddress);
    }

    public static int glXGetFBConfigAttrib(long display, long config, int attribute, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        return GLX13.nglXGetFBConfigAttrib(display, config, attribute, MemoryUtil.memAddress(value));
    }

    public static int glXGetFBConfigAttrib(long display, long config, int attribute, IntBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        return GLX13.nglXGetFBConfigAttrib(display, config, attribute, MemoryUtil.memAddress(value));
    }

    public static native long nglXGetVisualFromFBConfig(long var0, long var2, long var4);

    public static long nglXGetVisualFromFBConfig(long display, long config) {
        long __functionAddress = GLX13.getInstance().GetVisualFromFBConfig;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(config);
        }
        return GLX13.nglXGetVisualFromFBConfig(display, config, __functionAddress);
    }

    public static ByteBuffer glXGetVisualFromFBConfig(long display, long config) {
        long __result = GLX13.nglXGetVisualFromFBConfig(display, config);
        return MemoryUtil.memByteBuffer(__result, XVisualInfo.SIZEOF);
    }

    public static native long nglXCreateWindow(long var0, long var2, long var4, long var6, long var8);

    public static long nglXCreateWindow(long display, long config, long win, long attrib_list) {
        long __functionAddress = GLX13.getInstance().CreateWindow;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(config);
        }
        return GLX13.nglXCreateWindow(display, config, win, attrib_list, __functionAddress);
    }

    public static long glXCreateWindow(long display, long config, long win, ByteBuffer attrib_list) {
        if (LWJGLUtil.CHECKS && attrib_list != null) {
            Checks.checkNT4(attrib_list);
        }
        return GLX13.nglXCreateWindow(display, config, win, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long glXCreateWindow(long display, long config, long win, IntBuffer attrib_list) {
        if (LWJGLUtil.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list);
        }
        return GLX13.nglXCreateWindow(display, config, win, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static native long nglXCreatePixmap(long var0, long var2, long var4, long var6, long var8);

    public static long nglXCreatePixmap(long display, long config, long pixmap, long attrib_list) {
        long __functionAddress = GLX13.getInstance().CreatePixmap;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(config);
        }
        return GLX13.nglXCreatePixmap(display, config, pixmap, attrib_list, __functionAddress);
    }

    public static long glXCreatePixmap(long display, long config, long pixmap, ByteBuffer attrib_list) {
        if (LWJGLUtil.CHECKS && attrib_list != null) {
            Checks.checkNT4(attrib_list);
        }
        return GLX13.nglXCreatePixmap(display, config, pixmap, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long glXCreatePixmap(long display, long config, long pixmap, IntBuffer attrib_list) {
        if (LWJGLUtil.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list);
        }
        return GLX13.nglXCreatePixmap(display, config, pixmap, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static native void nglXDestroyPixmap(long var0, long var2, long var4);

    public static void glXDestroyPixmap(long display, long pixmap) {
        long __functionAddress = GLX13.getInstance().DestroyPixmap;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(pixmap);
        }
        GLX13.nglXDestroyPixmap(display, pixmap, __functionAddress);
    }

    public static native long nglXCreatePbuffer(long var0, long var2, long var4, long var6);

    public static long nglXCreatePbuffer(long display, long config, long attrib_list) {
        long __functionAddress = GLX13.getInstance().CreatePbuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(config);
        }
        return GLX13.nglXCreatePbuffer(display, config, attrib_list, __functionAddress);
    }

    public static long glXCreatePbuffer(long display, long config, ByteBuffer attrib_list) {
        if (LWJGLUtil.CHECKS && attrib_list != null) {
            Checks.checkNT4(attrib_list);
        }
        return GLX13.nglXCreatePbuffer(display, config, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long glXCreatePbuffer(long display, long config, IntBuffer attrib_list) {
        if (LWJGLUtil.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list);
        }
        return GLX13.nglXCreatePbuffer(display, config, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static native void nglXDestroyPbuffer(long var0, long var2, long var4);

    public static void glXDestroyPbuffer(long display, long pbuf) {
        long __functionAddress = GLX13.getInstance().DestroyPbuffer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(pbuf);
        }
        GLX13.nglXDestroyPbuffer(display, pbuf, __functionAddress);
    }

    public static native void nglXQueryDrawable(long var0, long var2, int var4, long var5, long var7);

    public static void nglXQueryDrawable(long display, long draw, int attribute, long value) {
        long __functionAddress = GLX13.getInstance().QueryDrawable;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(draw);
        }
        GLX13.nglXQueryDrawable(display, draw, attribute, value, __functionAddress);
    }

    public static void glXQueryDrawable(long display, long draw, int attribute, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        GLX13.nglXQueryDrawable(display, draw, attribute, MemoryUtil.memAddress(value));
    }

    public static void glXQueryDrawable(long display, long draw, int attribute, IntBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        GLX13.nglXQueryDrawable(display, draw, attribute, MemoryUtil.memAddress(value));
    }

    public static native long nglXCreateNewContext(long var0, long var2, int var4, long var5, int var7, long var8);

    public static long glXCreateNewContext(long display, long config, int render_type, long share_list, int direct) {
        long __functionAddress = GLX13.getInstance().CreateNewContext;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(config);
        }
        return GLX13.nglXCreateNewContext(display, config, render_type, share_list, direct, __functionAddress);
    }

    public static native int nglXMakeContextCurrent(long var0, long var2, long var4, long var6, long var8);

    public static int glXMakeContextCurrent(long display, long draw, long read, long ctx) {
        long __functionAddress = GLX13.getInstance().MakeContextCurrent;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
        }
        return GLX13.nglXMakeContextCurrent(display, draw, read, ctx, __functionAddress);
    }

    public static native long nglXGetCurrentReadDrawable(long var0);

    public static long glXGetCurrentReadDrawable() {
        long __functionAddress = GLX13.getInstance().GetCurrentReadDrawable;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GLX13.nglXGetCurrentReadDrawable(__functionAddress);
    }

    public static native int nglXQueryContext(long var0, long var2, int var4, long var5, long var7);

    public static int nglXQueryContext(long display, long ctx, int attribute, long value) {
        long __functionAddress = GLX13.getInstance().QueryContext;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(ctx);
        }
        return GLX13.nglXQueryContext(display, ctx, attribute, value, __functionAddress);
    }

    public static int glXQueryContext(long display, long ctx, int attribute, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        return GLX13.nglXQueryContext(display, ctx, attribute, MemoryUtil.memAddress(value));
    }

    public static int glXQueryContext(long display, long ctx, int attribute, IntBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        return GLX13.nglXQueryContext(display, ctx, attribute, MemoryUtil.memAddress(value));
    }

    public static native void nglXSelectEvent(long var0, long var2, long var4, long var6);

    public static void glXSelectEvent(long display, long draw, long event_mask) {
        long __functionAddress = GLX13.getInstance().SelectEvent;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(draw);
        }
        GLX13.nglXSelectEvent(display, draw, event_mask, __functionAddress);
    }

    public static native void nglXGetSelectedEvent(long var0, long var2, long var4, long var6);

    public static void nglXGetSelectedEvent(long display, long draw, long event_mask) {
        long __functionAddress = GLX13.getInstance().GetSelectedEvent;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(display);
            Checks.checkPointer(draw);
        }
        GLX13.nglXGetSelectedEvent(display, draw, event_mask, __functionAddress);
    }

    public static void glXGetSelectedEvent(long display, long draw, ByteBuffer event_mask) {
        GLX13.nglXGetSelectedEvent(display, draw, MemoryUtil.memAddress(event_mask));
    }

    public static void glXGetSelectedEvent(long display, long draw, PointerBuffer event_mask) {
        GLX13.nglXGetSelectedEvent(display, draw, MemoryUtil.memAddress(event_mask));
    }
}

