/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.opengl.AMDDebugOutput;
import org.lwjgl.opengl.ARBDebugOutput;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.KHRDebug;
import org.lwjgl.system.linux.opengl.LinuxGLContext;
import org.lwjgl.system.macosx.opengl.MacOSXGLContext;
import org.lwjgl.system.windows.opengl.WindowsGLContext;

public abstract class GLContext
implements Pointer {
    final ContextCapabilities capabilities;

    protected GLContext(ContextCapabilities capabilities) {
        this.capabilities = capabilities;
        GL.setCurrent(this);
    }

    public static GLContext createFromCurrent() {
        switch (LWJGLUtil.getPlatform()) {
            case WINDOWS: {
                return WindowsGLContext.createFromCurrent();
            }
            case LINUX: {
                return LinuxGLContext.createFromCurrent();
            }
            case MACOSX: {
                return MacOSXGLContext.createFromCurrent();
            }
        }
        throw new IllegalStateException();
    }

    public ContextCapabilities getCapabilities() {
        return this.capabilities;
    }

    public void makeCurrent(long target) {
        this.makeCurrentImpl(target);
        GL.setCurrent(this);
    }

    public void makeCurrent(long targetDraw, long targetRead) {
        this.makeCurrentImpl(targetDraw, targetRead);
        GL.setCurrent(this);
    }

    protected abstract void makeCurrentImpl(long var1);

    protected abstract void makeCurrentImpl(long var1, long var3);

    public abstract boolean isCurrent();

    public void destroy() {
        if (this.capabilities.GL_ARB_debug_output && this.capabilities.__ARBDebugOutput.refDEBUGPROCARB != 0L) {
            ARBDebugOutput.glDebugMessageCallbackARB(null);
        }
        if (this.capabilities.GL_AMD_debug_output && this.capabilities.__AMDDebugOutput.refDEBUGPROCAMD != 0L) {
            AMDDebugOutput.glDebugMessageCallbackAMD(null);
        }
        if (this.capabilities.GL_KHR_debug && this.capabilities.__KHRDebug.refDEBUGPROC != 0L) {
            KHRDebug.glDebugMessageCallback(null);
        }
        if (this.capabilities.OpenGL43 && this.capabilities.__GL43.refDEBUGPROC != 0L) {
            GL43.glDebugMessageCallback(null);
        }
        this.destroyImpl();
    }

    protected abstract void destroyImpl();
}

