/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class GL41 {
    public static final int GL_SHADER_COMPILER = 36346;
    public static final int GL_SHADER_BINARY_FORMATS = 36344;
    public static final int GL_NUM_SHADER_BINARY_FORMATS = 36345;
    public static final int GL_MAX_VERTEX_UNIFORM_VECTORS = 36347;
    public static final int GL_MAX_VARYING_VECTORS = 36348;
    public static final int GL_MAX_FRAGMENT_UNIFORM_VECTORS = 36349;
    public static final int GL_IMPLEMENTATION_COLOR_READ_TYPE = 35738;
    public static final int GL_IMPLEMENTATION_COLOR_READ_FORMAT = 35739;
    public static final int GL_FIXED = 5132;
    public static final int GL_LOW_FLOAT = 36336;
    public static final int GL_MEDIUM_FLOAT = 36337;
    public static final int GL_HIGH_FLOAT = 36338;
    public static final int GL_LOW_INT = 36339;
    public static final int GL_MEDIUM_INT = 36340;
    public static final int GL_HIGH_INT = 36341;
    public static final int GL_RGB565 = 36194;
    public static final int GL_PROGRAM_BINARY_RETRIEVABLE_HINT = 33367;
    public static final int GL_PROGRAM_BINARY_LENGTH = 34625;
    public static final int GL_NUM_PROGRAM_BINARY_FORMATS = 34814;
    public static final int GL_PROGRAM_BINARY_FORMATS = 34815;
    public static final int GL_VERTEX_SHADER_BIT = 1;
    public static final int GL_FRAGMENT_SHADER_BIT = 2;
    public static final int GL_GEOMETRY_SHADER_BIT = 4;
    public static final int GL_TESS_CONTROL_SHADER_BIT = 8;
    public static final int GL_TESS_EVALUATION_SHADER_BIT = 16;
    public static final int GL_ALL_SHADER_BITS = -1;
    public static final int GL_PROGRAM_SEPARABLE = 33368;
    public static final int GL_ACTIVE_PROGRAM = 33369;
    public static final int GL_PROGRAM_PIPELINE_BINDING = 33370;
    public static final int GL_MAX_VIEWPORTS = 33371;
    public static final int GL_VIEWPORT_SUBPIXEL_BITS = 33372;
    public static final int GL_VIEWPORT_BOUNDS_RANGE = 33373;
    public static final int GL_LAYER_PROVOKING_VERTEX = 33374;
    public static final int GL_VIEWPORT_INDEX_PROVOKING_VERTEX = 33375;
    public static final int GL_UNDEFINED_VERTEX = 33376;
    public final long ReleaseShaderCompiler;
    public final long ShaderBinary;
    public final long GetShaderPrecisionFormat;
    public final long DepthRangef;
    public final long ClearDepthf;
    public final long GetProgramBinary;
    public final long ProgramBinary;
    public final long ProgramParameteri;
    public final long UseProgramStages;
    public final long ActiveShaderProgram;
    public final long CreateShaderProgramv;
    public final long BindProgramPipeline;
    public final long DeleteProgramPipelines;
    public final long GenProgramPipelines;
    public final long IsProgramPipeline;
    public final long GetProgramPipelineiv;
    public final long ProgramUniform1i;
    public final long ProgramUniform2i;
    public final long ProgramUniform3i;
    public final long ProgramUniform4i;
    public final long ProgramUniform1ui;
    public final long ProgramUniform2ui;
    public final long ProgramUniform3ui;
    public final long ProgramUniform4ui;
    public final long ProgramUniform1f;
    public final long ProgramUniform2f;
    public final long ProgramUniform3f;
    public final long ProgramUniform4f;
    public final long ProgramUniform1d;
    public final long ProgramUniform2d;
    public final long ProgramUniform3d;
    public final long ProgramUniform4d;
    public final long ProgramUniform1iv;
    public final long ProgramUniform2iv;
    public final long ProgramUniform3iv;
    public final long ProgramUniform4iv;
    public final long ProgramUniform1uiv;
    public final long ProgramUniform2uiv;
    public final long ProgramUniform3uiv;
    public final long ProgramUniform4uiv;
    public final long ProgramUniform1fv;
    public final long ProgramUniform2fv;
    public final long ProgramUniform3fv;
    public final long ProgramUniform4fv;
    public final long ProgramUniform1dv;
    public final long ProgramUniform2dv;
    public final long ProgramUniform3dv;
    public final long ProgramUniform4dv;
    public final long ProgramUniformMatrix2fv;
    public final long ProgramUniformMatrix3fv;
    public final long ProgramUniformMatrix4fv;
    public final long ProgramUniformMatrix2dv;
    public final long ProgramUniformMatrix3dv;
    public final long ProgramUniformMatrix4dv;
    public final long ProgramUniformMatrix2x3fv;
    public final long ProgramUniformMatrix3x2fv;
    public final long ProgramUniformMatrix2x4fv;
    public final long ProgramUniformMatrix4x2fv;
    public final long ProgramUniformMatrix3x4fv;
    public final long ProgramUniformMatrix4x3fv;
    public final long ProgramUniformMatrix2x3dv;
    public final long ProgramUniformMatrix3x2dv;
    public final long ProgramUniformMatrix2x4dv;
    public final long ProgramUniformMatrix4x2dv;
    public final long ProgramUniformMatrix3x4dv;
    public final long ProgramUniformMatrix4x3dv;
    public final long ValidateProgramPipeline;
    public final long GetProgramPipelineInfoLog;
    public final long VertexAttribL1d;
    public final long VertexAttribL2d;
    public final long VertexAttribL3d;
    public final long VertexAttribL4d;
    public final long VertexAttribL1dv;
    public final long VertexAttribL2dv;
    public final long VertexAttribL3dv;
    public final long VertexAttribL4dv;
    public final long VertexAttribLPointer;
    public final long GetVertexAttribLdv;
    public final long ViewportArrayv;
    public final long ViewportIndexedf;
    public final long ViewportIndexedfv;
    public final long ScissorArrayv;
    public final long ScissorIndexed;
    public final long ScissorIndexedv;
    public final long DepthRangeArrayv;
    public final long DepthRangeIndexed;
    public final long GetFloati_v;
    public final long GetDoublei_v;

    public GL41(FunctionProvider provider) {
        this.ReleaseShaderCompiler = provider.getFunctionAddress("glReleaseShaderCompiler");
        this.ShaderBinary = provider.getFunctionAddress("glShaderBinary");
        this.GetShaderPrecisionFormat = provider.getFunctionAddress("glGetShaderPrecisionFormat");
        this.DepthRangef = provider.getFunctionAddress("glDepthRangef");
        this.ClearDepthf = provider.getFunctionAddress("glClearDepthf");
        this.GetProgramBinary = provider.getFunctionAddress("glGetProgramBinary");
        this.ProgramBinary = provider.getFunctionAddress("glProgramBinary");
        this.ProgramParameteri = provider.getFunctionAddress("glProgramParameteri");
        this.UseProgramStages = provider.getFunctionAddress("glUseProgramStages");
        this.ActiveShaderProgram = provider.getFunctionAddress("glActiveShaderProgram");
        this.CreateShaderProgramv = provider.getFunctionAddress("glCreateShaderProgramv");
        this.BindProgramPipeline = provider.getFunctionAddress("glBindProgramPipeline");
        this.DeleteProgramPipelines = provider.getFunctionAddress("glDeleteProgramPipelines");
        this.GenProgramPipelines = provider.getFunctionAddress("glGenProgramPipelines");
        this.IsProgramPipeline = provider.getFunctionAddress("glIsProgramPipeline");
        this.GetProgramPipelineiv = provider.getFunctionAddress("glGetProgramPipelineiv");
        this.ProgramUniform1i = provider.getFunctionAddress("glProgramUniform1i");
        this.ProgramUniform2i = provider.getFunctionAddress("glProgramUniform2i");
        this.ProgramUniform3i = provider.getFunctionAddress("glProgramUniform3i");
        this.ProgramUniform4i = provider.getFunctionAddress("glProgramUniform4i");
        this.ProgramUniform1ui = provider.getFunctionAddress("glProgramUniform1ui");
        this.ProgramUniform2ui = provider.getFunctionAddress("glProgramUniform2ui");
        this.ProgramUniform3ui = provider.getFunctionAddress("glProgramUniform3ui");
        this.ProgramUniform4ui = provider.getFunctionAddress("glProgramUniform4ui");
        this.ProgramUniform1f = provider.getFunctionAddress("glProgramUniform1f");
        this.ProgramUniform2f = provider.getFunctionAddress("glProgramUniform2f");
        this.ProgramUniform3f = provider.getFunctionAddress("glProgramUniform3f");
        this.ProgramUniform4f = provider.getFunctionAddress("glProgramUniform4f");
        this.ProgramUniform1d = provider.getFunctionAddress("glProgramUniform1d");
        this.ProgramUniform2d = provider.getFunctionAddress("glProgramUniform2d");
        this.ProgramUniform3d = provider.getFunctionAddress("glProgramUniform3d");
        this.ProgramUniform4d = provider.getFunctionAddress("glProgramUniform4d");
        this.ProgramUniform1iv = provider.getFunctionAddress("glProgramUniform1iv");
        this.ProgramUniform2iv = provider.getFunctionAddress("glProgramUniform2iv");
        this.ProgramUniform3iv = provider.getFunctionAddress("glProgramUniform3iv");
        this.ProgramUniform4iv = provider.getFunctionAddress("glProgramUniform4iv");
        this.ProgramUniform1uiv = provider.getFunctionAddress("glProgramUniform1uiv");
        this.ProgramUniform2uiv = provider.getFunctionAddress("glProgramUniform2uiv");
        this.ProgramUniform3uiv = provider.getFunctionAddress("glProgramUniform3uiv");
        this.ProgramUniform4uiv = provider.getFunctionAddress("glProgramUniform4uiv");
        this.ProgramUniform1fv = provider.getFunctionAddress("glProgramUniform1fv");
        this.ProgramUniform2fv = provider.getFunctionAddress("glProgramUniform2fv");
        this.ProgramUniform3fv = provider.getFunctionAddress("glProgramUniform3fv");
        this.ProgramUniform4fv = provider.getFunctionAddress("glProgramUniform4fv");
        this.ProgramUniform1dv = provider.getFunctionAddress("glProgramUniform1dv");
        this.ProgramUniform2dv = provider.getFunctionAddress("glProgramUniform2dv");
        this.ProgramUniform3dv = provider.getFunctionAddress("glProgramUniform3dv");
        this.ProgramUniform4dv = provider.getFunctionAddress("glProgramUniform4dv");
        this.ProgramUniformMatrix2fv = provider.getFunctionAddress("glProgramUniformMatrix2fv");
        this.ProgramUniformMatrix3fv = provider.getFunctionAddress("glProgramUniformMatrix3fv");
        this.ProgramUniformMatrix4fv = provider.getFunctionAddress("glProgramUniformMatrix4fv");
        this.ProgramUniformMatrix2dv = provider.getFunctionAddress("glProgramUniformMatrix2dv");
        this.ProgramUniformMatrix3dv = provider.getFunctionAddress("glProgramUniformMatrix3dv");
        this.ProgramUniformMatrix4dv = provider.getFunctionAddress("glProgramUniformMatrix4dv");
        this.ProgramUniformMatrix2x3fv = provider.getFunctionAddress("glProgramUniformMatrix2x3fv");
        this.ProgramUniformMatrix3x2fv = provider.getFunctionAddress("glProgramUniformMatrix3x2fv");
        this.ProgramUniformMatrix2x4fv = provider.getFunctionAddress("glProgramUniformMatrix2x4fv");
        this.ProgramUniformMatrix4x2fv = provider.getFunctionAddress("glProgramUniformMatrix4x2fv");
        this.ProgramUniformMatrix3x4fv = provider.getFunctionAddress("glProgramUniformMatrix3x4fv");
        this.ProgramUniformMatrix4x3fv = provider.getFunctionAddress("glProgramUniformMatrix4x3fv");
        this.ProgramUniformMatrix2x3dv = provider.getFunctionAddress("glProgramUniformMatrix2x3dv");
        this.ProgramUniformMatrix3x2dv = provider.getFunctionAddress("glProgramUniformMatrix3x2dv");
        this.ProgramUniformMatrix2x4dv = provider.getFunctionAddress("glProgramUniformMatrix2x4dv");
        this.ProgramUniformMatrix4x2dv = provider.getFunctionAddress("glProgramUniformMatrix4x2dv");
        this.ProgramUniformMatrix3x4dv = provider.getFunctionAddress("glProgramUniformMatrix3x4dv");
        this.ProgramUniformMatrix4x3dv = provider.getFunctionAddress("glProgramUniformMatrix4x3dv");
        this.ValidateProgramPipeline = provider.getFunctionAddress("glValidateProgramPipeline");
        this.GetProgramPipelineInfoLog = provider.getFunctionAddress("glGetProgramPipelineInfoLog");
        this.VertexAttribL1d = provider.getFunctionAddress("glVertexAttribL1d");
        this.VertexAttribL2d = provider.getFunctionAddress("glVertexAttribL2d");
        this.VertexAttribL3d = provider.getFunctionAddress("glVertexAttribL3d");
        this.VertexAttribL4d = provider.getFunctionAddress("glVertexAttribL4d");
        this.VertexAttribL1dv = provider.getFunctionAddress("glVertexAttribL1dv");
        this.VertexAttribL2dv = provider.getFunctionAddress("glVertexAttribL2dv");
        this.VertexAttribL3dv = provider.getFunctionAddress("glVertexAttribL3dv");
        this.VertexAttribL4dv = provider.getFunctionAddress("glVertexAttribL4dv");
        this.VertexAttribLPointer = provider.getFunctionAddress("glVertexAttribLPointer");
        this.GetVertexAttribLdv = provider.getFunctionAddress("glGetVertexAttribLdv");
        this.ViewportArrayv = provider.getFunctionAddress("glViewportArrayv");
        this.ViewportIndexedf = provider.getFunctionAddress("glViewportIndexedf");
        this.ViewportIndexedfv = provider.getFunctionAddress("glViewportIndexedfv");
        this.ScissorArrayv = provider.getFunctionAddress("glScissorArrayv");
        this.ScissorIndexed = provider.getFunctionAddress("glScissorIndexed");
        this.ScissorIndexedv = provider.getFunctionAddress("glScissorIndexedv");
        this.DepthRangeArrayv = provider.getFunctionAddress("glDepthRangeArrayv");
        this.DepthRangeIndexed = provider.getFunctionAddress("glDepthRangeIndexed");
        this.GetFloati_v = provider.getFunctionAddress("glGetFloati_v");
        this.GetDoublei_v = provider.getFunctionAddress("glGetDoublei_v");
    }

    public static GL41 getInstance() {
        return GL.getCapabilities().__GL41;
    }

    static GL41 create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("OpenGL41")) {
            return null;
        }
        GL41 funcs = new GL41(provider);
        boolean supported = Checks.checkFunctions(funcs.ReleaseShaderCompiler, funcs.ShaderBinary, funcs.GetShaderPrecisionFormat, funcs.DepthRangef, funcs.ClearDepthf, funcs.GetProgramBinary, funcs.ProgramBinary, funcs.ProgramParameteri, funcs.UseProgramStages, funcs.ActiveShaderProgram, funcs.CreateShaderProgramv, funcs.BindProgramPipeline, funcs.DeleteProgramPipelines, funcs.GenProgramPipelines, funcs.IsProgramPipeline, funcs.GetProgramPipelineiv, funcs.ProgramUniform1i, funcs.ProgramUniform2i, funcs.ProgramUniform3i, funcs.ProgramUniform4i, funcs.ProgramUniform1ui, funcs.ProgramUniform2ui, funcs.ProgramUniform3ui, funcs.ProgramUniform4ui, funcs.ProgramUniform1f, funcs.ProgramUniform2f, funcs.ProgramUniform3f, funcs.ProgramUniform4f, funcs.ProgramUniform1d, funcs.ProgramUniform2d, funcs.ProgramUniform3d, funcs.ProgramUniform4d, funcs.ProgramUniform1iv, funcs.ProgramUniform2iv, funcs.ProgramUniform3iv, funcs.ProgramUniform4iv, funcs.ProgramUniform1uiv, funcs.ProgramUniform2uiv, funcs.ProgramUniform3uiv, funcs.ProgramUniform4uiv, funcs.ProgramUniform1fv, funcs.ProgramUniform2fv, funcs.ProgramUniform3fv, funcs.ProgramUniform4fv, funcs.ProgramUniform1dv, funcs.ProgramUniform2dv, funcs.ProgramUniform3dv, funcs.ProgramUniform4dv, funcs.ProgramUniformMatrix2fv, funcs.ProgramUniformMatrix3fv, funcs.ProgramUniformMatrix4fv, funcs.ProgramUniformMatrix2dv, funcs.ProgramUniformMatrix3dv, funcs.ProgramUniformMatrix4dv, funcs.ProgramUniformMatrix2x3fv, funcs.ProgramUniformMatrix3x2fv, funcs.ProgramUniformMatrix2x4fv, funcs.ProgramUniformMatrix4x2fv, funcs.ProgramUniformMatrix3x4fv, funcs.ProgramUniformMatrix4x3fv, funcs.ProgramUniformMatrix2x3dv, funcs.ProgramUniformMatrix3x2dv, funcs.ProgramUniformMatrix2x4dv, funcs.ProgramUniformMatrix4x2dv, funcs.ProgramUniformMatrix3x4dv, funcs.ProgramUniformMatrix4x3dv, funcs.ValidateProgramPipeline, funcs.GetProgramPipelineInfoLog, funcs.VertexAttribL1d, funcs.VertexAttribL2d, funcs.VertexAttribL3d, funcs.VertexAttribL4d, funcs.VertexAttribL1dv, funcs.VertexAttribL2dv, funcs.VertexAttribL3dv, funcs.VertexAttribL4dv, funcs.VertexAttribLPointer, funcs.GetVertexAttribLdv, funcs.ViewportArrayv, funcs.ViewportIndexedf, funcs.ViewportIndexedfv, funcs.ScissorArrayv, funcs.ScissorIndexed, funcs.ScissorIndexedv, funcs.DepthRangeArrayv, funcs.DepthRangeIndexed, funcs.GetFloati_v, funcs.GetDoublei_v);
        return GL.checkExtension("OpenGL41", funcs, supported);
    }

    public static native void nglReleaseShaderCompiler(long var0);

    public static void glReleaseShaderCompiler() {
        long __functionAddress = GL41.getInstance().ReleaseShaderCompiler;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglReleaseShaderCompiler(__functionAddress);
    }

    public static native void nglShaderBinary(int var0, long var1, int var3, long var4, int var6, long var7);

    public static void nglShaderBinary(int count, long shaders, int binaryformat, long binary, int length) {
        long __functionAddress = GL41.getInstance().ShaderBinary;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglShaderBinary(count, shaders, binaryformat, binary, length, __functionAddress);
    }

    public static void glShaderBinary(int count, ByteBuffer shaders, int binaryformat, ByteBuffer binary, int length) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)shaders, count << 2);
            Checks.checkBuffer((Buffer)binary, length);
        }
        GL41.nglShaderBinary(count, MemoryUtil.memAddress(shaders), binaryformat, MemoryUtil.memAddress(binary), length);
    }

    public static void glShaderBinary(IntBuffer shaders, int binaryformat, ByteBuffer binary) {
        GL41.nglShaderBinary(shaders.remaining(), MemoryUtil.memAddress(shaders), binaryformat, MemoryUtil.memAddress(binary), binary.remaining());
    }

    public static native void nglGetShaderPrecisionFormat(int var0, int var1, long var2, long var4, long var6);

    public static void nglGetShaderPrecisionFormat(int shadertype, int precisiontype, long range, long precision) {
        long __functionAddress = GL41.getInstance().GetShaderPrecisionFormat;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglGetShaderPrecisionFormat(shadertype, precisiontype, range, precision, __functionAddress);
    }

    public static void glGetShaderPrecisionFormat(int shadertype, int precisiontype, ByteBuffer range, ByteBuffer precision) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)range, 8);
            Checks.checkBuffer((Buffer)precision, 4);
        }
        GL41.nglGetShaderPrecisionFormat(shadertype, precisiontype, MemoryUtil.memAddress(range), MemoryUtil.memAddress(precision));
    }

    public static void glGetShaderPrecisionFormat(int shadertype, int precisiontype, IntBuffer range, IntBuffer precision) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)range, 2);
            Checks.checkBuffer((Buffer)precision, 1);
        }
        GL41.nglGetShaderPrecisionFormat(shadertype, precisiontype, MemoryUtil.memAddress(range), MemoryUtil.memAddress(precision));
    }

    public static int glGetShaderPrecisionFormat(int shadertype, int precisiontype, IntBuffer range) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)range, 2);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int precision = __buffer.intParam();
        GL41.nglGetShaderPrecisionFormat(shadertype, precisiontype, MemoryUtil.memAddress(range), __buffer.address() + (long)precision);
        return __buffer.intValue(precision);
    }

    public static native void nglDepthRangef(float var0, float var1, long var2);

    public static void glDepthRangef(float zNear, float zFar) {
        long __functionAddress = GL41.getInstance().DepthRangef;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglDepthRangef(zNear, zFar, __functionAddress);
    }

    public static native void nglClearDepthf(float var0, long var1);

    public static void glClearDepthf(float depth) {
        long __functionAddress = GL41.getInstance().ClearDepthf;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglClearDepthf(depth, __functionAddress);
    }

    public static native void nglGetProgramBinary(int var0, int var1, long var2, long var4, long var6, long var8);

    public static void nglGetProgramBinary(int program, int bufSize, long length, long binaryFormat, long binary) {
        long __functionAddress = GL41.getInstance().GetProgramBinary;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglGetProgramBinary(program, bufSize, length, binaryFormat, binary, __functionAddress);
    }

    public static void glGetProgramBinary(int program, int bufSize, ByteBuffer length, ByteBuffer binaryFormat, ByteBuffer binary) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)binary, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
            Checks.checkBuffer((Buffer)binaryFormat, 4);
        }
        GL41.nglGetProgramBinary(program, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(binaryFormat), MemoryUtil.memAddress(binary));
    }

    public static void glGetProgramBinary(int program, IntBuffer length, IntBuffer binaryFormat, ByteBuffer binary) {
        if (LWJGLUtil.CHECKS) {
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 1);
            }
            Checks.checkBuffer((Buffer)binaryFormat, 1);
        }
        GL41.nglGetProgramBinary(program, binary.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(binaryFormat), MemoryUtil.memAddress(binary));
    }

    public static ByteBuffer glGetProgramBinary(int program, int bufSize, IntBuffer binaryFormat) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)binaryFormat, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int binary = __buffer.bufferParam(bufSize);
        GL41.nglGetProgramBinary(program, bufSize, __buffer.address() + (long)length, MemoryUtil.memAddress(binaryFormat), __buffer.address() + (long)binary);
        return MemoryUtil.memByteBuffer(__buffer.address() + (long)binary, __buffer.intValue(length));
    }

    public static ByteBuffer glGetProgramBinary(int program, IntBuffer binaryFormat) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)binaryFormat, 1);
        }
        int bufSize = GL20.glGetProgrami(program, 34625);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int binary = __buffer.bufferParam(bufSize);
        GL41.nglGetProgramBinary(program, bufSize, __buffer.address() + (long)length, MemoryUtil.memAddress(binaryFormat), __buffer.address() + (long)binary);
        return MemoryUtil.memByteBuffer(__buffer.address() + (long)binary, __buffer.intValue(length));
    }

    public static native void nglProgramBinary(int var0, int var1, long var2, int var4, long var5);

    public static void nglProgramBinary(int program, int binaryFormat, long binary, int length) {
        long __functionAddress = GL41.getInstance().ProgramBinary;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramBinary(program, binaryFormat, binary, length, __functionAddress);
    }

    public static void glProgramBinary(int program, int binaryFormat, ByteBuffer binary, int length) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)binary, length);
        }
        GL41.nglProgramBinary(program, binaryFormat, MemoryUtil.memAddress(binary), length);
    }

    public static void glProgramBinary(int program, int binaryFormat, ByteBuffer binary) {
        GL41.nglProgramBinary(program, binaryFormat, MemoryUtil.memAddress(binary), binary.remaining());
    }

    public static native void nglProgramParameteri(int var0, int var1, int var2, long var3);

    public static void glProgramParameteri(int program, int pname, int value) {
        long __functionAddress = GL41.getInstance().ProgramParameteri;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramParameteri(program, pname, value, __functionAddress);
    }

    public static native void nglUseProgramStages(int var0, int var1, int var2, long var3);

    public static void glUseProgramStages(int pipeline, int stages, int program) {
        long __functionAddress = GL41.getInstance().UseProgramStages;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglUseProgramStages(pipeline, stages, program, __functionAddress);
    }

    public static native void nglActiveShaderProgram(int var0, int var1, long var2);

    public static void glActiveShaderProgram(int pipeline, int program) {
        long __functionAddress = GL41.getInstance().ActiveShaderProgram;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglActiveShaderProgram(pipeline, program, __functionAddress);
    }

    public static native int nglCreateShaderProgramv(int var0, int var1, long var2, long var4);

    public static int nglCreateShaderProgramv(int type, int count, long strings) {
        long __functionAddress = GL41.getInstance().CreateShaderProgramv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL41.nglCreateShaderProgramv(type, count, strings, __functionAddress);
    }

    public static int glCreateShaderProgram(int type, int count, ByteBuffer strings) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)strings, count << Pointer.POINTER_SHIFT);
        }
        return GL41.nglCreateShaderProgramv(type, count, MemoryUtil.memAddress(strings));
    }

    public static int glCreateShaderProgram(int type, PointerBuffer strings) {
        return GL41.nglCreateShaderProgramv(type, strings.remaining(), MemoryUtil.memAddress(strings));
    }

    public static int glCreateShaderProgram(int type, CharSequence ... strings) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int stringsAddress = __buffer.bufferParam(strings.length << Pointer.POINTER_SHIFT);
        ByteBuffer[] stringsBuffers = new ByteBuffer[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            stringsBuffers[i] = MemoryUtil.memEncodeUTF8(strings[i], true);
            __buffer.pointerParam(stringsAddress, i, MemoryUtil.memAddress(stringsBuffers[i]));
        }
        return GL41.nglCreateShaderProgramv(type, strings.length, __buffer.address() + (long)stringsAddress);
    }

    public static int glCreateShaderProgram(int type, CharSequence string) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        ByteBuffer stringBuffers = MemoryUtil.memEncodeUTF8(string, true);
        int stringsAddress = __buffer.pointerParam(MemoryUtil.memAddress(stringBuffers));
        return GL41.nglCreateShaderProgramv(type, 1, __buffer.address() + (long)stringsAddress);
    }

    public static native void nglBindProgramPipeline(int var0, long var1);

    public static void glBindProgramPipeline(int pipeline) {
        long __functionAddress = GL41.getInstance().BindProgramPipeline;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglBindProgramPipeline(pipeline, __functionAddress);
    }

    public static native void nglDeleteProgramPipelines(int var0, long var1, long var3);

    public static void nglDeleteProgramPipelines(int n, long pipelines) {
        long __functionAddress = GL41.getInstance().DeleteProgramPipelines;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglDeleteProgramPipelines(n, pipelines, __functionAddress);
    }

    public static void glDeleteProgramPipelines(int n, ByteBuffer pipelines) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)pipelines, n << 2);
        }
        GL41.nglDeleteProgramPipelines(n, MemoryUtil.memAddress(pipelines));
    }

    public static void glDeleteProgramPipelines(IntBuffer pipelines) {
        GL41.nglDeleteProgramPipelines(pipelines.remaining(), MemoryUtil.memAddress(pipelines));
    }

    public static void glDeleteProgramPipelines(int pipeline) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int pipelines = __buffer.intParam(pipeline);
        GL41.nglDeleteProgramPipelines(1, __buffer.address() + (long)pipelines);
    }

    public static native void nglGenProgramPipelines(int var0, long var1, long var3);

    public static void nglGenProgramPipelines(int n, long pipelines) {
        long __functionAddress = GL41.getInstance().GenProgramPipelines;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglGenProgramPipelines(n, pipelines, __functionAddress);
    }

    public static void glGenProgramPipelines(int n, ByteBuffer pipelines) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)pipelines, n << 2);
        }
        GL41.nglGenProgramPipelines(n, MemoryUtil.memAddress(pipelines));
    }

    public static void glGenProgramPipelines(IntBuffer pipelines) {
        GL41.nglGenProgramPipelines(pipelines.remaining(), MemoryUtil.memAddress(pipelines));
    }

    public static int glGenProgramPipelines() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int pipelines = __buffer.intParam();
        GL41.nglGenProgramPipelines(1, __buffer.address() + (long)pipelines);
        return __buffer.intValue(pipelines);
    }

    public static native boolean nglIsProgramPipeline(int var0, long var1);

    public static boolean glIsProgramPipeline(int pipeline) {
        long __functionAddress = GL41.getInstance().IsProgramPipeline;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL41.nglIsProgramPipeline(pipeline, __functionAddress);
    }

    public static native void nglGetProgramPipelineiv(int var0, int var1, long var2, long var4);

    public static void nglGetProgramPipelineiv(int pipeline, int pname, long params) {
        long __functionAddress = GL41.getInstance().GetProgramPipelineiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglGetProgramPipelineiv(pipeline, pname, params, __functionAddress);
    }

    public static void glGetProgramPipelinei(int pipeline, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL41.nglGetProgramPipelineiv(pipeline, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetProgramPipeline(int pipeline, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL41.nglGetProgramPipelineiv(pipeline, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetProgramPipelinei(int pipeline, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL41.nglGetProgramPipelineiv(pipeline, pname, __buffer.address() + (long)params);
        return __buffer.intValue(params);
    }

    public static native void nglProgramUniform1i(int var0, int var1, int var2, long var3);

    public static void glProgramUniform1i(int program, int location, int x) {
        long __functionAddress = GL41.getInstance().ProgramUniform1i;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform1i(program, location, x, __functionAddress);
    }

    public static native void nglProgramUniform2i(int var0, int var1, int var2, int var3, long var4);

    public static void glProgramUniform2i(int program, int location, int x, int y) {
        long __functionAddress = GL41.getInstance().ProgramUniform2i;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform2i(program, location, x, y, __functionAddress);
    }

    public static native void nglProgramUniform3i(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glProgramUniform3i(int program, int location, int x, int y, int z) {
        long __functionAddress = GL41.getInstance().ProgramUniform3i;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform3i(program, location, x, y, z, __functionAddress);
    }

    public static native void nglProgramUniform4i(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static void glProgramUniform4i(int program, int location, int x, int y, int z, int w) {
        long __functionAddress = GL41.getInstance().ProgramUniform4i;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform4i(program, location, x, y, z, w, __functionAddress);
    }

    public static native void nglProgramUniform1ui(int var0, int var1, int var2, long var3);

    public static void glProgramUniform1ui(int program, int location, int x) {
        long __functionAddress = GL41.getInstance().ProgramUniform1ui;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform1ui(program, location, x, __functionAddress);
    }

    public static native void nglProgramUniform2ui(int var0, int var1, int var2, int var3, long var4);

    public static void glProgramUniform2ui(int program, int location, int x, int y) {
        long __functionAddress = GL41.getInstance().ProgramUniform2ui;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform2ui(program, location, x, y, __functionAddress);
    }

    public static native void nglProgramUniform3ui(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glProgramUniform3ui(int program, int location, int x, int y, int z) {
        long __functionAddress = GL41.getInstance().ProgramUniform3ui;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform3ui(program, location, x, y, z, __functionAddress);
    }

    public static native void nglProgramUniform4ui(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static void glProgramUniform4ui(int program, int location, int x, int y, int z, int w) {
        long __functionAddress = GL41.getInstance().ProgramUniform4ui;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform4ui(program, location, x, y, z, w, __functionAddress);
    }

    public static native void nglProgramUniform1f(int var0, int var1, float var2, long var3);

    public static void glProgramUniform1f(int program, int location, float x) {
        long __functionAddress = GL41.getInstance().ProgramUniform1f;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform1f(program, location, x, __functionAddress);
    }

    public static native void nglProgramUniform2f(int var0, int var1, float var2, float var3, long var4);

    public static void glProgramUniform2f(int program, int location, float x, float y) {
        long __functionAddress = GL41.getInstance().ProgramUniform2f;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform2f(program, location, x, y, __functionAddress);
    }

    public static native void nglProgramUniform3f(int var0, int var1, float var2, float var3, float var4, long var5);

    public static void glProgramUniform3f(int program, int location, float x, float y, float z) {
        long __functionAddress = GL41.getInstance().ProgramUniform3f;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform3f(program, location, x, y, z, __functionAddress);
    }

    public static native void nglProgramUniform4f(int var0, int var1, float var2, float var3, float var4, float var5, long var6);

    public static void glProgramUniform4f(int program, int location, float x, float y, float z, float w) {
        long __functionAddress = GL41.getInstance().ProgramUniform4f;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform4f(program, location, x, y, z, w, __functionAddress);
    }

    public static native void nglProgramUniform1d(int var0, int var1, double var2, long var4);

    public static void glProgramUniform1d(int program, int location, double x) {
        long __functionAddress = GL41.getInstance().ProgramUniform1d;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform1d(program, location, x, __functionAddress);
    }

    public static native void nglProgramUniform2d(int var0, int var1, double var2, double var4, long var6);

    public static void glProgramUniform2d(int program, int location, double x, double y) {
        long __functionAddress = GL41.getInstance().ProgramUniform2d;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform2d(program, location, x, y, __functionAddress);
    }

    public static native void nglProgramUniform3d(int var0, int var1, double var2, double var4, double var6, long var8);

    public static void glProgramUniform3d(int program, int location, double x, double y, double z) {
        long __functionAddress = GL41.getInstance().ProgramUniform3d;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform3d(program, location, x, y, z, __functionAddress);
    }

    public static native void nglProgramUniform4d(int var0, int var1, double var2, double var4, double var6, double var8, long var10);

    public static void glProgramUniform4d(int program, int location, double x, double y, double z, double w) {
        long __functionAddress = GL41.getInstance().ProgramUniform4d;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform4d(program, location, x, y, z, w, __functionAddress);
    }

    public static native void nglProgramUniform1iv(int var0, int var1, int var2, long var3, long var5);

    public static void nglProgramUniform1iv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform1iv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform1iv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform1i(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2);
        }
        GL41.nglProgramUniform1iv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform1(int program, int location, IntBuffer value) {
        GL41.nglProgramUniform1iv(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform2iv(int var0, int var1, int var2, long var3, long var5);

    public static void nglProgramUniform2iv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform2iv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform2iv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform2i(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 2);
        }
        GL41.nglProgramUniform2iv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform2(int program, int location, IntBuffer value) {
        GL41.nglProgramUniform2iv(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform3iv(int var0, int var1, int var2, long var3, long var5);

    public static void nglProgramUniform3iv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform3iv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform3iv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform3i(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 9 << 2);
        }
        GL41.nglProgramUniform3iv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform3(int program, int location, IntBuffer value) {
        GL41.nglProgramUniform3iv(program, location, value.remaining() / 9, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform4iv(int var0, int var1, int var2, long var3, long var5);

    public static void nglProgramUniform4iv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform4iv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform4iv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform4i(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        GL41.nglProgramUniform4iv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform4(int program, int location, IntBuffer value) {
        GL41.nglProgramUniform4iv(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform1uiv(int var0, int var1, int var2, long var3, long var5);

    public static void nglProgramUniform1uiv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform1uiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform1uiv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform1ui(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2);
        }
        GL41.nglProgramUniform1uiv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform1u(int program, int location, IntBuffer value) {
        GL41.nglProgramUniform1uiv(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform2uiv(int var0, int var1, int var2, long var3, long var5);

    public static void nglProgramUniform2uiv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform2uiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform2uiv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform2ui(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 2);
        }
        GL41.nglProgramUniform2uiv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform2u(int program, int location, IntBuffer value) {
        GL41.nglProgramUniform2uiv(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform3uiv(int var0, int var1, int var2, long var3, long var5);

    public static void nglProgramUniform3uiv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform3uiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform3uiv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform3ui(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 9 << 2);
        }
        GL41.nglProgramUniform3uiv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform3u(int program, int location, IntBuffer value) {
        GL41.nglProgramUniform3uiv(program, location, value.remaining() / 9, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform4uiv(int var0, int var1, int var2, long var3, long var5);

    public static void nglProgramUniform4uiv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform4uiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform4uiv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform4ui(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        GL41.nglProgramUniform4uiv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform4u(int program, int location, IntBuffer value) {
        GL41.nglProgramUniform4uiv(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform1fv(int var0, int var1, int var2, long var3, long var5);

    public static void nglProgramUniform1fv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform1fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform1fv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform1f(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2);
        }
        GL41.nglProgramUniform1fv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform1(int program, int location, FloatBuffer value) {
        GL41.nglProgramUniform1fv(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform2fv(int var0, int var1, int var2, long var3, long var5);

    public static void nglProgramUniform2fv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform2fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform2fv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform2f(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 2);
        }
        GL41.nglProgramUniform2fv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform2(int program, int location, FloatBuffer value) {
        GL41.nglProgramUniform2fv(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform3fv(int var0, int var1, int var2, long var3, long var5);

    public static void nglProgramUniform3fv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform3fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform3fv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform3f(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 9 << 2);
        }
        GL41.nglProgramUniform3fv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform3(int program, int location, FloatBuffer value) {
        GL41.nglProgramUniform3fv(program, location, value.remaining() / 9, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform4fv(int var0, int var1, int var2, long var3, long var5);

    public static void nglProgramUniform4fv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform4fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform4fv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform4f(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        GL41.nglProgramUniform4fv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform4(int program, int location, FloatBuffer value) {
        GL41.nglProgramUniform4fv(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform1dv(int var0, int var1, int var2, long var3, long var5);

    public static void nglProgramUniform1dv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform1dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform1dv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform1d(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3);
        }
        GL41.nglProgramUniform1dv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform1(int program, int location, DoubleBuffer value) {
        GL41.nglProgramUniform1dv(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform2dv(int var0, int var1, int var2, long var3, long var5);

    public static void nglProgramUniform2dv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform2dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform2dv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform2d(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 3);
        }
        GL41.nglProgramUniform2dv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform2(int program, int location, DoubleBuffer value) {
        GL41.nglProgramUniform2dv(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform3dv(int var0, int var1, int var2, long var3, long var5);

    public static void nglProgramUniform3dv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform3dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform3dv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform3d(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 9 << 3);
        }
        GL41.nglProgramUniform3dv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform3(int program, int location, DoubleBuffer value) {
        GL41.nglProgramUniform3dv(program, location, value.remaining() / 9, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniform4dv(int var0, int var1, int var2, long var3, long var5);

    public static void nglProgramUniform4dv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform4dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform4dv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform4d(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 3);
        }
        GL41.nglProgramUniform4dv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform4(int program, int location, DoubleBuffer value) {
        GL41.nglProgramUniform4dv(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix2fv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void nglProgramUniformMatrix2fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix2fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix2fv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix2f(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        GL41.nglProgramUniformMatrix2fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix2(int program, int location, boolean transpose, FloatBuffer value) {
        GL41.nglProgramUniformMatrix2fv(program, location, value.remaining() >> 2, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix3fv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void nglProgramUniformMatrix3fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix3fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix3fv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix3f(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 9 << 2);
        }
        GL41.nglProgramUniformMatrix3fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix3(int program, int location, boolean transpose, FloatBuffer value) {
        GL41.nglProgramUniformMatrix3fv(program, location, value.remaining() / 9, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix4fv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void nglProgramUniformMatrix4fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix4fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix4fv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix4f(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 4 << 2);
        }
        GL41.nglProgramUniformMatrix4fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix4(int program, int location, boolean transpose, FloatBuffer value) {
        GL41.nglProgramUniformMatrix4fv(program, location, value.remaining() >> 4, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix2dv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void nglProgramUniformMatrix2dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix2dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix2dv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix2d(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 3);
        }
        GL41.nglProgramUniformMatrix2dv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix2(int program, int location, boolean transpose, DoubleBuffer value) {
        GL41.nglProgramUniformMatrix2dv(program, location, value.remaining() >> 2, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix3dv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void nglProgramUniformMatrix3dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix3dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix3dv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix3d(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 9 << 3);
        }
        GL41.nglProgramUniformMatrix3dv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix3(int program, int location, boolean transpose, DoubleBuffer value) {
        GL41.nglProgramUniformMatrix3dv(program, location, value.remaining() / 9, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix4dv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void nglProgramUniformMatrix4dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix4dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix4dv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix4d(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 4 << 3);
        }
        GL41.nglProgramUniformMatrix4dv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix4(int program, int location, boolean transpose, DoubleBuffer value) {
        GL41.nglProgramUniformMatrix4dv(program, location, value.remaining() >> 4, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix2x3fv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void nglProgramUniformMatrix2x3fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix2x3fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix2x3fv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix2x3f(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 6 << 2);
        }
        GL41.nglProgramUniformMatrix2x3fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix2x3(int program, int location, boolean transpose, FloatBuffer value) {
        GL41.nglProgramUniformMatrix2x3fv(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix3x2fv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void nglProgramUniformMatrix3x2fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix3x2fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix3x2fv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix3x2f(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 6 << 2);
        }
        GL41.nglProgramUniformMatrix3x2fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix3x2(int program, int location, boolean transpose, FloatBuffer value) {
        GL41.nglProgramUniformMatrix3x2fv(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix2x4fv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void nglProgramUniformMatrix2x4fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix2x4fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix2x4fv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix2x4f(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3 << 2);
        }
        GL41.nglProgramUniformMatrix2x4fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix2x4(int program, int location, boolean transpose, FloatBuffer value) {
        GL41.nglProgramUniformMatrix2x4fv(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix4x2fv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void nglProgramUniformMatrix4x2fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix4x2fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix4x2fv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix4x2f(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3 << 2);
        }
        GL41.nglProgramUniformMatrix4x2fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix4x2(int program, int location, boolean transpose, FloatBuffer value) {
        GL41.nglProgramUniformMatrix4x2fv(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix3x4fv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void nglProgramUniformMatrix3x4fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix3x4fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix3x4fv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix3x4f(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 12 << 2);
        }
        GL41.nglProgramUniformMatrix3x4fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix3x4(int program, int location, boolean transpose, FloatBuffer value) {
        GL41.nglProgramUniformMatrix3x4fv(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix4x3fv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void nglProgramUniformMatrix4x3fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix4x3fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix4x3fv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix4x3f(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 12 << 2);
        }
        GL41.nglProgramUniformMatrix4x3fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix4x3(int program, int location, boolean transpose, FloatBuffer value) {
        GL41.nglProgramUniformMatrix4x3fv(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix2x3dv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void nglProgramUniformMatrix2x3dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix2x3dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix2x3dv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix2x3d(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 6 << 3);
        }
        GL41.nglProgramUniformMatrix2x3dv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix2x3(int program, int location, boolean transpose, DoubleBuffer value) {
        GL41.nglProgramUniformMatrix2x3dv(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix3x2dv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void nglProgramUniformMatrix3x2dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix3x2dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix3x2dv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix3x2d(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 6 << 3);
        }
        GL41.nglProgramUniformMatrix3x2dv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix3x2(int program, int location, boolean transpose, DoubleBuffer value) {
        GL41.nglProgramUniformMatrix3x2dv(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix2x4dv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void nglProgramUniformMatrix2x4dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix2x4dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix2x4dv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix2x4d(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3 << 3);
        }
        GL41.nglProgramUniformMatrix2x4dv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix2x4(int program, int location, boolean transpose, DoubleBuffer value) {
        GL41.nglProgramUniformMatrix2x4dv(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix4x2dv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void nglProgramUniformMatrix4x2dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix4x2dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix4x2dv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix4x2d(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3 << 3);
        }
        GL41.nglProgramUniformMatrix4x2dv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix4x2(int program, int location, boolean transpose, DoubleBuffer value) {
        GL41.nglProgramUniformMatrix4x2dv(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix3x4dv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void nglProgramUniformMatrix3x4dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix3x4dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix3x4dv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix3x4d(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 12 << 3);
        }
        GL41.nglProgramUniformMatrix3x4dv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix3x4(int program, int location, boolean transpose, DoubleBuffer value) {
        GL41.nglProgramUniformMatrix3x4dv(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglProgramUniformMatrix4x3dv(int var0, int var1, int var2, boolean var3, long var4, long var6);

    public static void nglProgramUniformMatrix4x3dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix4x3dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix4x3dv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix4x3d(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 12 << 3);
        }
        GL41.nglProgramUniformMatrix4x3dv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix4x3(int program, int location, boolean transpose, DoubleBuffer value) {
        GL41.nglProgramUniformMatrix4x3dv(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglValidateProgramPipeline(int var0, long var1);

    public static void glValidateProgramPipeline(int pipeline) {
        long __functionAddress = GL41.getInstance().ValidateProgramPipeline;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglValidateProgramPipeline(pipeline, __functionAddress);
    }

    public static native void nglGetProgramPipelineInfoLog(int var0, int var1, long var2, long var4, long var6);

    public static void nglGetProgramPipelineInfoLog(int pipeline, int bufSize, long length, long infoLog) {
        long __functionAddress = GL41.getInstance().GetProgramPipelineInfoLog;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglGetProgramPipelineInfoLog(pipeline, bufSize, length, infoLog, __functionAddress);
    }

    public static void glGetProgramPipelineInfoLog(int pipeline, int bufSize, ByteBuffer length, ByteBuffer infoLog) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)infoLog, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        GL41.nglGetProgramPipelineInfoLog(pipeline, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    public static void glGetProgramPipelineInfoLog(int pipeline, IntBuffer length, ByteBuffer infoLog) {
        if (LWJGLUtil.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GL41.nglGetProgramPipelineInfoLog(pipeline, infoLog.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    public static String glGetProgramPipelineInfoLog(int pipeline, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int infoLog = __buffer.bufferParam(bufSize);
        GL41.nglGetProgramPipelineInfoLog(pipeline, bufSize, __buffer.address() + (long)length, __buffer.address() + (long)infoLog);
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBuffer(__buffer.address() + (long)infoLog, __buffer.intValue(length)));
    }

    public static String glGetProgramPipelineInfoLog(int pipeline) {
        int bufSize = GL41.glGetProgramPipelinei(pipeline, 35716);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int infoLog = __buffer.bufferParam(bufSize);
        GL41.nglGetProgramPipelineInfoLog(pipeline, bufSize, __buffer.address() + (long)length, __buffer.address() + (long)infoLog);
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBuffer(__buffer.address() + (long)infoLog, __buffer.intValue(length)));
    }

    public static native void nglVertexAttribL1d(int var0, double var1, long var3);

    public static void glVertexAttribL1d(int index, double x) {
        long __functionAddress = GL41.getInstance().VertexAttribL1d;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglVertexAttribL1d(index, x, __functionAddress);
    }

    public static native void nglVertexAttribL2d(int var0, double var1, double var3, long var5);

    public static void glVertexAttribL2d(int index, double x, double y) {
        long __functionAddress = GL41.getInstance().VertexAttribL2d;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglVertexAttribL2d(index, x, y, __functionAddress);
    }

    public static native void nglVertexAttribL3d(int var0, double var1, double var3, double var5, long var7);

    public static void glVertexAttribL3d(int index, double x, double y, double z) {
        long __functionAddress = GL41.getInstance().VertexAttribL3d;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglVertexAttribL3d(index, x, y, z, __functionAddress);
    }

    public static native void nglVertexAttribL4d(int var0, double var1, double var3, double var5, double var7, long var9);

    public static void glVertexAttribL4d(int index, double x, double y, double z, double w) {
        long __functionAddress = GL41.getInstance().VertexAttribL4d;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglVertexAttribL4d(index, x, y, z, w, __functionAddress);
    }

    public static native void nglVertexAttribL1dv(int var0, long var1, long var3);

    public static void nglVertexAttribL1dv(int index, long v) {
        long __functionAddress = GL41.getInstance().VertexAttribL1dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglVertexAttribL1dv(index, v, __functionAddress);
    }

    public static void glVertexAttribL1d(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 8);
        }
        GL41.nglVertexAttribL1dv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttribL1(int index, DoubleBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 1);
        }
        GL41.nglVertexAttribL1dv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttribL2dv(int var0, long var1, long var3);

    public static void nglVertexAttribL2dv(int index, long v) {
        long __functionAddress = GL41.getInstance().VertexAttribL2dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglVertexAttribL2dv(index, v, __functionAddress);
    }

    public static void glVertexAttribL2d(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 16);
        }
        GL41.nglVertexAttribL2dv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttribL2(int index, DoubleBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 2);
        }
        GL41.nglVertexAttribL2dv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttribL3dv(int var0, long var1, long var3);

    public static void nglVertexAttribL3dv(int index, long v) {
        long __functionAddress = GL41.getInstance().VertexAttribL3dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglVertexAttribL3dv(index, v, __functionAddress);
    }

    public static void glVertexAttribL3d(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 24);
        }
        GL41.nglVertexAttribL3dv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttribL3(int index, DoubleBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 3);
        }
        GL41.nglVertexAttribL3dv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttribL4dv(int var0, long var1, long var3);

    public static void nglVertexAttribL4dv(int index, long v) {
        long __functionAddress = GL41.getInstance().VertexAttribL4dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglVertexAttribL4dv(index, v, __functionAddress);
    }

    public static void glVertexAttribL4d(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 32);
        }
        GL41.nglVertexAttribL4dv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttribL4(int index, DoubleBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL41.nglVertexAttribL4dv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttribLPointer(int var0, int var1, int var2, int var3, long var4, long var6);

    public static void nglVertexAttribLPointer(int index, int size, int type, int stride, long pointer) {
        long __functionAddress = GL41.getInstance().VertexAttribLPointer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglVertexAttribLPointer(index, size, type, stride, pointer, __functionAddress);
    }

    public static void glVertexAttribLPointer(int index, int size, int type, int stride, ByteBuffer pointer) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        GL41.nglVertexAttribLPointer(index, size, type, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glVertexAttribLPointer(int index, int size, int type, int stride, long pointerOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34964, true);
        }
        GL41.nglVertexAttribLPointer(index, size, type, stride, pointerOffset);
    }

    public static void glVertexAttribLPointer(int index, int size, int stride, DoubleBuffer pointer) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        GL41.nglVertexAttribLPointer(index, size, 5130, stride, MemoryUtil.memAddress(pointer));
    }

    public static native void nglGetVertexAttribLdv(int var0, int var1, long var2, long var4);

    public static void nglGetVertexAttribLdv(int index, int pname, long params) {
        long __functionAddress = GL41.getInstance().GetVertexAttribLdv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglGetVertexAttribLdv(index, pname, params, __functionAddress);
    }

    public static void glGetVertexAttribLd(int index, int pname, ByteBuffer params) {
        GL41.nglGetVertexAttribLdv(index, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetVertexAttribL(int index, int pname, DoubleBuffer params) {
        GL41.nglGetVertexAttribLdv(index, pname, MemoryUtil.memAddress(params));
    }

    public static native void nglViewportArrayv(int var0, int var1, long var2, long var4);

    public static void nglViewportArrayv(int first, int count, long v) {
        long __functionAddress = GL41.getInstance().ViewportArrayv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglViewportArrayv(first, count, v, __functionAddress);
    }

    public static void glViewportArray(int first, int count, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, count << 2 << 2);
        }
        GL41.nglViewportArrayv(first, count, MemoryUtil.memAddress(v));
    }

    public static void glViewportArray(int first, FloatBuffer v) {
        GL41.nglViewportArrayv(first, v.remaining() >> 2, MemoryUtil.memAddress(v));
    }

    public static native void nglViewportIndexedf(int var0, float var1, float var2, float var3, float var4, long var5);

    public static void glViewportIndexedf(int index, float x, float y, float w, float h) {
        long __functionAddress = GL41.getInstance().ViewportIndexedf;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglViewportIndexedf(index, x, y, w, h, __functionAddress);
    }

    public static native void nglViewportIndexedfv(int var0, long var1, long var3);

    public static void nglViewportIndexedfv(int index, long v) {
        long __functionAddress = GL41.getInstance().ViewportIndexedfv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglViewportIndexedfv(index, v, __functionAddress);
    }

    public static void glViewportIndexedf(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 16);
        }
        GL41.nglViewportIndexedfv(index, MemoryUtil.memAddress(v));
    }

    public static void glViewportIndexed(int index, FloatBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL41.nglViewportIndexedfv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglScissorArrayv(int var0, int var1, long var2, long var4);

    public static void nglScissorArrayv(int first, int count, long v) {
        long __functionAddress = GL41.getInstance().ScissorArrayv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglScissorArrayv(first, count, v, __functionAddress);
    }

    public static void glScissorArray(int first, int count, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, count << 2 << 2);
        }
        GL41.nglScissorArrayv(first, count, MemoryUtil.memAddress(v));
    }

    public static void glScissorArray(int first, IntBuffer v) {
        GL41.nglScissorArrayv(first, v.remaining() >> 2, MemoryUtil.memAddress(v));
    }

    public static native void nglScissorIndexed(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glScissorIndexed(int index, int left, int bottom, int width, int height) {
        long __functionAddress = GL41.getInstance().ScissorIndexed;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglScissorIndexed(index, left, bottom, width, height, __functionAddress);
    }

    public static native void nglScissorIndexedv(int var0, long var1, long var3);

    public static void nglScissorIndexedv(int index, long v) {
        long __functionAddress = GL41.getInstance().ScissorIndexedv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglScissorIndexedv(index, v, __functionAddress);
    }

    public static void glScissorIndexed(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 16);
        }
        GL41.nglScissorIndexedv(index, MemoryUtil.memAddress(v));
    }

    public static void glScissorIndexed(int index, IntBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL41.nglScissorIndexedv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglDepthRangeArrayv(int var0, int var1, long var2, long var4);

    public static void nglDepthRangeArrayv(int first, int count, long v) {
        long __functionAddress = GL41.getInstance().DepthRangeArrayv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglDepthRangeArrayv(first, count, v, __functionAddress);
    }

    public static void glDepthRangeArray(int first, int count, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, count << 1 << 3);
        }
        GL41.nglDepthRangeArrayv(first, count, MemoryUtil.memAddress(v));
    }

    public static void glDepthRangeArray(int first, DoubleBuffer v) {
        GL41.nglDepthRangeArrayv(first, v.remaining() >> 1, MemoryUtil.memAddress(v));
    }

    public static native void nglDepthRangeIndexed(int var0, double var1, double var3, long var5);

    public static void glDepthRangeIndexed(int index, double zNear, double zFar) {
        long __functionAddress = GL41.getInstance().DepthRangeIndexed;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglDepthRangeIndexed(index, zNear, zFar, __functionAddress);
    }

    public static native void nglGetFloati_v(int var0, int var1, long var2, long var4);

    public static void nglGetFloati_v(int target, int index, long data) {
        long __functionAddress = GL41.getInstance().GetFloati_v;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglGetFloati_v(target, index, data, __functionAddress);
    }

    public static void glGetFloati(int target, int index, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)data, 4);
        }
        GL41.nglGetFloati_v(target, index, MemoryUtil.memAddress(data));
    }

    public static void glGetFloati(int target, int index, FloatBuffer data) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        GL41.nglGetFloati_v(target, index, MemoryUtil.memAddress(data));
    }

    public static float glGetFloati(int target, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int data = __buffer.floatParam();
        GL41.nglGetFloati_v(target, index, __buffer.address() + (long)data);
        return __buffer.floatValue(data);
    }

    public static native void nglGetDoublei_v(int var0, int var1, long var2, long var4);

    public static void nglGetDoublei_v(int target, int index, long data) {
        long __functionAddress = GL41.getInstance().GetDoublei_v;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglGetDoublei_v(target, index, data, __functionAddress);
    }

    public static void glGetDoublei(int target, int index, ByteBuffer data) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)data, 8);
        }
        GL41.nglGetDoublei_v(target, index, MemoryUtil.memAddress(data));
    }

    public static void glGetDoublei(int target, int index, DoubleBuffer data) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        GL41.nglGetDoublei_v(target, index, MemoryUtil.memAddress(data));
    }

    public static double glGetDoublei(int target, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int data = __buffer.doubleParam();
        GL41.nglGetDoublei_v(target, index, __buffer.address() + (long)data);
        return __buffer.doubleValue(data);
    }
}

