/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class GL32 {
    public static final int GL_CONTEXT_PROFILE_MASK = 37158;
    public static final int GL_CONTEXT_CORE_PROFILE_BIT = 1;
    public static final int GL_CONTEXT_COMPATIBILITY_PROFILE_BIT = 2;
    public static final int GL_MAX_VERTEX_OUTPUT_COMPONENTS = 37154;
    public static final int GL_MAX_GEOMETRY_INPUT_COMPONENTS = 37155;
    public static final int GL_MAX_GEOMETRY_OUTPUT_COMPONENTS = 37156;
    public static final int GL_MAX_FRAGMENT_INPUT_COMPONENTS = 37157;
    public static final int GL_FIRST_VERTEX_CONVENTION = 36429;
    public static final int GL_LAST_VERTEX_CONVENTION = 36430;
    public static final int GL_PROVOKING_VERTEX = 36431;
    public static final int GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION = 36428;
    public static final int GL_TEXTURE_CUBE_MAP_SEAMLESS = 34895;
    public static final int GL_SAMPLE_POSITION = 36432;
    public static final int GL_SAMPLE_MASK = 36433;
    public static final int GL_SAMPLE_MASK_VALUE = 36434;
    public static final int GL_TEXTURE_2D_MULTISAMPLE = 37120;
    public static final int GL_PROXY_TEXTURE_2D_MULTISAMPLE = 37121;
    public static final int GL_TEXTURE_2D_MULTISAMPLE_ARRAY = 37122;
    public static final int GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY = 37123;
    public static final int GL_MAX_SAMPLE_MASK_WORDS = 36441;
    public static final int GL_MAX_COLOR_TEXTURE_SAMPLES = 37134;
    public static final int GL_MAX_DEPTH_TEXTURE_SAMPLES = 37135;
    public static final int GL_MAX_INTEGER_SAMPLES = 37136;
    public static final int GL_TEXTURE_BINDING_2D_MULTISAMPLE = 37124;
    public static final int GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY = 37125;
    public static final int GL_TEXTURE_SAMPLES = 37126;
    public static final int GL_TEXTURE_FIXED_SAMPLE_LOCATIONS = 37127;
    public static final int GL_SAMPLER_2D_MULTISAMPLE = 37128;
    public static final int GL_INT_SAMPLER_2D_MULTISAMPLE = 37129;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE = 37130;
    public static final int GL_SAMPLER_2D_MULTISAMPLE_ARRAY = 37131;
    public static final int GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 37132;
    public static final int GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY = 37133;
    public static final int GL_DEPTH_CLAMP = 34383;
    public static final int GL_GEOMETRY_SHADER = 36313;
    public static final int GL_GEOMETRY_VERTICES_OUT = 36314;
    public static final int GL_GEOMETRY_INPUT_TYPE = 36315;
    public static final int GL_GEOMETRY_OUTPUT_TYPE = 36316;
    public static final int GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS = 35881;
    public static final int GL_MAX_GEOMETRY_VARYING_COMPONENTS = 36317;
    public static final int GL_MAX_VERTEX_VARYING_COMPONENTS = 36318;
    public static final int GL_MAX_GEOMETRY_UNIFORM_COMPONENTS = 36319;
    public static final int GL_MAX_GEOMETRY_OUTPUT_VERTICES = 36320;
    public static final int GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS = 36321;
    public static final int GL_LINES_ADJACENCY = 10;
    public static final int GL_LINE_STRIP_ADJACENCY = 11;
    public static final int GL_TRIANGLES_ADJACENCY = 12;
    public static final int GL_TRIANGLE_STRIP_ADJACENCY = 13;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS = 36264;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT = 36265;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_LAYERED = 36263;
    public static final int GL_PROGRAM_POINT_SIZE = 34370;
    public static final int GL_MAX_SERVER_WAIT_TIMEOUT = 37137;
    public static final int GL_OBJECT_TYPE = 37138;
    public static final int GL_SYNC_CONDITION = 37139;
    public static final int GL_SYNC_STATUS = 37140;
    public static final int GL_SYNC_FLAGS = 37141;
    public static final int GL_SYNC_FENCE = 37142;
    public static final int GL_SYNC_GPU_COMMANDS_COMPLETE = 37143;
    public static final int GL_UNSIGNALED = 37144;
    public static final int GL_SIGNALED = 37145;
    public static final int GL_SYNC_FLUSH_COMMANDS_BIT = 1;
    public static final long GL_TIMEOUT_IGNORED = -1L;
    public static final int GL_ALREADY_SIGNALED = 37146;
    public static final int GL_TIMEOUT_EXPIRED = 37147;
    public static final int GL_CONDITION_SATISFIED = 37148;
    public static final int GL_WAIT_FAILED = 37149;
    public final long GetBufferParameteri64v;
    public final long DrawElementsBaseVertex;
    public final long DrawRangeElementsBaseVertex;
    public final long DrawElementsInstancedBaseVertex;
    public final long MultiDrawElementsBaseVertex;
    public final long ProvokingVertex;
    public final long TexImage2DMultisample;
    public final long TexImage3DMultisample;
    public final long GetMultisamplefv;
    public final long SampleMaski;
    public final long FramebufferTexture;
    public final long FenceSync;
    public final long IsSync;
    public final long DeleteSync;
    public final long ClientWaitSync;
    public final long WaitSync;
    public final long GetInteger64v;
    public final long GetInteger64i_v;
    public final long GetSynciv;

    public GL32(FunctionProvider provider) {
        this.GetBufferParameteri64v = provider.getFunctionAddress("glGetBufferParameteri64v");
        this.DrawElementsBaseVertex = provider.getFunctionAddress("glDrawElementsBaseVertex");
        this.DrawRangeElementsBaseVertex = provider.getFunctionAddress("glDrawRangeElementsBaseVertex");
        this.DrawElementsInstancedBaseVertex = provider.getFunctionAddress("glDrawElementsInstancedBaseVertex");
        this.MultiDrawElementsBaseVertex = provider.getFunctionAddress("glMultiDrawElementsBaseVertex");
        this.ProvokingVertex = provider.getFunctionAddress("glProvokingVertex");
        this.TexImage2DMultisample = provider.getFunctionAddress("glTexImage2DMultisample");
        this.TexImage3DMultisample = provider.getFunctionAddress("glTexImage3DMultisample");
        this.GetMultisamplefv = provider.getFunctionAddress("glGetMultisamplefv");
        this.SampleMaski = provider.getFunctionAddress("glSampleMaski");
        this.FramebufferTexture = provider.getFunctionAddress("glFramebufferTexture");
        this.FenceSync = provider.getFunctionAddress("glFenceSync");
        this.IsSync = provider.getFunctionAddress("glIsSync");
        this.DeleteSync = provider.getFunctionAddress("glDeleteSync");
        this.ClientWaitSync = provider.getFunctionAddress("glClientWaitSync");
        this.WaitSync = provider.getFunctionAddress("glWaitSync");
        this.GetInteger64v = provider.getFunctionAddress("glGetInteger64v");
        this.GetInteger64i_v = provider.getFunctionAddress("glGetInteger64i_v");
        this.GetSynciv = provider.getFunctionAddress("glGetSynciv");
    }

    public static GL32 getInstance() {
        return GL.getCapabilities().__GL32;
    }

    static GL32 create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("OpenGL32")) {
            return null;
        }
        GL32 funcs = new GL32(provider);
        boolean supported = Checks.checkFunctions(funcs.GetBufferParameteri64v, funcs.DrawElementsBaseVertex, funcs.DrawRangeElementsBaseVertex, funcs.DrawElementsInstancedBaseVertex, funcs.MultiDrawElementsBaseVertex, funcs.ProvokingVertex, funcs.TexImage2DMultisample, funcs.TexImage3DMultisample, funcs.GetMultisamplefv, funcs.SampleMaski, funcs.FramebufferTexture, funcs.FenceSync, funcs.IsSync, funcs.DeleteSync, funcs.ClientWaitSync, funcs.WaitSync, funcs.GetInteger64v, funcs.GetInteger64i_v, funcs.GetSynciv);
        return GL.checkExtension("OpenGL32", funcs, supported);
    }

    public static native void nglGetBufferParameteri64v(int var0, int var1, long var2, long var4);

    public static void nglGetBufferParameteri64v(int target, int pname, long params) {
        long __functionAddress = GL32.getInstance().GetBufferParameteri64v;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL32.nglGetBufferParameteri64v(target, pname, params, __functionAddress);
    }

    public static void glGetBufferParameteri64(int target, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 8);
        }
        GL32.nglGetBufferParameteri64v(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetBufferParameter(int target, int pname, LongBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL32.nglGetBufferParameteri64v(target, pname, MemoryUtil.memAddress(params));
    }

    public static long glGetBufferParameteri64(int target, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.longParam();
        GL32.nglGetBufferParameteri64v(target, pname, __buffer.address() + (long)params);
        return __buffer.longValue(params);
    }

    public static native void nglDrawElementsBaseVertex(int var0, int var1, int var2, long var3, int var5, long var6);

    public static void nglDrawElementsBaseVertex(int mode, int count, int type, long indices, int basevertex) {
        long __functionAddress = GL32.getInstance().DrawElementsBaseVertex;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL32.nglDrawElementsBaseVertex(mode, count, type, indices, basevertex, __functionAddress);
    }

    public static void glDrawElementsBaseVertex(int mode, int count, int type, ByteBuffer indices, int basevertex) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count / GLChecks.typeToBytes(type));
            GLChecks.ensureBufferObject(34965, false);
        }
        GL32.nglDrawElementsBaseVertex(mode, count, type, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, int count, int type, long indicesOffset, int basevertex) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, true);
        }
        GL32.nglDrawElementsBaseVertex(mode, count, type, indicesOffset, basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, int type, ByteBuffer indices, int basevertex) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, true);
        }
        GL32.nglDrawElementsBaseVertex(mode, indices.remaining() * GLChecks.typeToBytes(type), type, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, ByteBuffer indices, int basevertex) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL32.nglDrawElementsBaseVertex(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, ShortBuffer indices, int basevertex) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL32.nglDrawElementsBaseVertex(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, IntBuffer indices, int basevertex) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL32.nglDrawElementsBaseVertex(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), basevertex);
    }

    public static native void nglDrawRangeElementsBaseVertex(int var0, int var1, int var2, int var3, int var4, long var5, int var7, long var8);

    public static void nglDrawRangeElementsBaseVertex(int mode, int start, int end, int count, int type, long indices, int basevertex) {
        long __functionAddress = GL32.getInstance().DrawRangeElementsBaseVertex;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL32.nglDrawRangeElementsBaseVertex(mode, start, end, count, type, indices, basevertex, __functionAddress);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, int count, int type, ByteBuffer indices, int basevertex) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count / GLChecks.typeToBytes(type));
            GLChecks.ensureBufferObject(34965, false);
        }
        GL32.nglDrawRangeElementsBaseVertex(mode, start, end, count, type, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, int count, int type, long indicesOffset, int basevertex) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, true);
        }
        GL32.nglDrawRangeElementsBaseVertex(mode, start, end, count, type, indicesOffset, basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, int type, ByteBuffer indices, int basevertex) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, true);
        }
        GL32.nglDrawRangeElementsBaseVertex(mode, start, end, indices.remaining() * GLChecks.typeToBytes(type), type, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, ByteBuffer indices, int basevertex) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL32.nglDrawRangeElementsBaseVertex(mode, start, end, indices.remaining(), 5121, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, ShortBuffer indices, int basevertex) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL32.nglDrawRangeElementsBaseVertex(mode, start, end, indices.remaining(), 5123, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, IntBuffer indices, int basevertex) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL32.nglDrawRangeElementsBaseVertex(mode, start, end, indices.remaining(), 5125, MemoryUtil.memAddress(indices), basevertex);
    }

    public static native void nglDrawElementsInstancedBaseVertex(int var0, int var1, int var2, long var3, int var5, int var6, long var7);

    public static void nglDrawElementsInstancedBaseVertex(int mode, int count, int type, long indices, int primcount, int basevertex) {
        long __functionAddress = GL32.getInstance().DrawElementsInstancedBaseVertex;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL32.nglDrawElementsInstancedBaseVertex(mode, count, type, indices, primcount, basevertex, __functionAddress);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, int count, int type, ByteBuffer indices, int primcount, int basevertex) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count / GLChecks.typeToBytes(type));
            GLChecks.ensureBufferObject(34965, false);
        }
        GL32.nglDrawElementsInstancedBaseVertex(mode, count, type, MemoryUtil.memAddress(indices), primcount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, int count, int type, long indicesOffset, int primcount, int basevertex) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, true);
        }
        GL32.nglDrawElementsInstancedBaseVertex(mode, count, type, indicesOffset, primcount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, int type, ByteBuffer indices, int primcount, int basevertex) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, true);
        }
        GL32.nglDrawElementsInstancedBaseVertex(mode, indices.remaining() * GLChecks.typeToBytes(type), type, MemoryUtil.memAddress(indices), primcount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, ByteBuffer indices, int primcount, int basevertex) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL32.nglDrawElementsInstancedBaseVertex(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), primcount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, ShortBuffer indices, int primcount, int basevertex) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL32.nglDrawElementsInstancedBaseVertex(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), primcount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, IntBuffer indices, int primcount, int basevertex) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        GL32.nglDrawElementsInstancedBaseVertex(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), primcount, basevertex);
    }

    public static native void nglMultiDrawElementsBaseVertex(int var0, long var1, int var3, long var4, int var6, long var7, long var9);

    public static void nglMultiDrawElementsBaseVertex(int mode, long count, int type, long indices, int primcount, long basevertex) {
        long __functionAddress = GL32.getInstance().MultiDrawElementsBaseVertex;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL32.nglMultiDrawElementsBaseVertex(mode, count, type, indices, primcount, basevertex, __functionAddress);
    }

    public static void glMultiDrawElementsBaseVertex(int mode, ByteBuffer count, int type, ByteBuffer indices, int primcount, ByteBuffer basevertex) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)count, primcount << 2);
            Checks.checkBuffer((Buffer)indices, primcount << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)basevertex, primcount << 2);
        }
        GL32.nglMultiDrawElementsBaseVertex(mode, MemoryUtil.memAddress(count), type, MemoryUtil.memAddress(indices), primcount, MemoryUtil.memAddress(basevertex));
    }

    public static void glMultiDrawElementsBaseVertex(int mode, IntBuffer count, int type, PointerBuffer indices, IntBuffer basevertex) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(indices, count.remaining());
            Checks.checkBuffer((Buffer)basevertex, count.remaining());
        }
        GL32.nglMultiDrawElementsBaseVertex(mode, MemoryUtil.memAddress(count), type, MemoryUtil.memAddress(indices), count.remaining(), MemoryUtil.memAddress(basevertex));
    }

    public static native void nglProvokingVertex(int var0, long var1);

    public static void glProvokingVertex(int mode) {
        long __functionAddress = GL32.getInstance().ProvokingVertex;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL32.nglProvokingVertex(mode, __functionAddress);
    }

    public static native void nglTexImage2DMultisample(int var0, int var1, int var2, int var3, int var4, boolean var5, long var6);

    public static void glTexImage2DMultisample(int target, int samples, int internalformat, int width, int height, boolean fixedsamplelocations) {
        long __functionAddress = GL32.getInstance().TexImage2DMultisample;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL32.nglTexImage2DMultisample(target, samples, internalformat, width, height, fixedsamplelocations, __functionAddress);
    }

    public static native void nglTexImage3DMultisample(int var0, int var1, int var2, int var3, int var4, int var5, boolean var6, long var7);

    public static void glTexImage3DMultisample(int target, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations) {
        long __functionAddress = GL32.getInstance().TexImage3DMultisample;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL32.nglTexImage3DMultisample(target, samples, internalformat, width, height, depth, fixedsamplelocations, __functionAddress);
    }

    public static native void nglGetMultisamplefv(int var0, int var1, long var2, long var4);

    public static void nglGetMultisamplefv(int pname, int index, long val) {
        long __functionAddress = GL32.getInstance().GetMultisamplefv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL32.nglGetMultisamplefv(pname, index, val, __functionAddress);
    }

    public static void glGetMultisamplef(int pname, int index, ByteBuffer val) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)val, 4);
        }
        GL32.nglGetMultisamplefv(pname, index, MemoryUtil.memAddress(val));
    }

    public static void glGetMultisample(int pname, int index, FloatBuffer val) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)val, 1);
        }
        GL32.nglGetMultisamplefv(pname, index, MemoryUtil.memAddress(val));
    }

    public static float glGetMultisamplef(int pname, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int val = __buffer.floatParam();
        GL32.nglGetMultisamplefv(pname, index, __buffer.address() + (long)val);
        return __buffer.floatValue(val);
    }

    public static native void nglSampleMaski(int var0, int var1, long var2);

    public static void glSampleMaski(int index, int mask) {
        long __functionAddress = GL32.getInstance().SampleMaski;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL32.nglSampleMaski(index, mask, __functionAddress);
    }

    public static native void nglFramebufferTexture(int var0, int var1, int var2, int var3, long var4);

    public static void glFramebufferTexture(int target, int attachment, int texture, int level) {
        long __functionAddress = GL32.getInstance().FramebufferTexture;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL32.nglFramebufferTexture(target, attachment, texture, level, __functionAddress);
    }

    public static native long nglFenceSync(int var0, int var1, long var2);

    public static long glFenceSync(int condition, int flags) {
        long __functionAddress = GL32.getInstance().FenceSync;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL32.nglFenceSync(condition, flags, __functionAddress);
    }

    public static native boolean nglIsSync(long var0, long var2);

    public static boolean glIsSync(long sync) {
        long __functionAddress = GL32.getInstance().IsSync;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(sync);
        }
        return GL32.nglIsSync(sync, __functionAddress);
    }

    public static native void nglDeleteSync(long var0, long var2);

    public static void glDeleteSync(long sync) {
        long __functionAddress = GL32.getInstance().DeleteSync;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(sync);
        }
        GL32.nglDeleteSync(sync, __functionAddress);
    }

    public static native int nglClientWaitSync(long var0, int var2, long var3, long var5);

    public static int glClientWaitSync(long sync, int flags, long timeout) {
        long __functionAddress = GL32.getInstance().ClientWaitSync;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(sync);
        }
        return GL32.nglClientWaitSync(sync, flags, timeout, __functionAddress);
    }

    public static native void nglWaitSync(long var0, int var2, long var3, long var5);

    public static void glWaitSync(long sync, int flags, long timeout) {
        long __functionAddress = GL32.getInstance().WaitSync;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(sync);
        }
        GL32.nglWaitSync(sync, flags, timeout, __functionAddress);
    }

    public static native void nglGetInteger64v(int var0, long var1, long var3);

    public static void nglGetInteger64v(int pname, long params) {
        long __functionAddress = GL32.getInstance().GetInteger64v;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL32.nglGetInteger64v(pname, params, __functionAddress);
    }

    public static void glGetInteger64(int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 8);
        }
        GL32.nglGetInteger64v(pname, MemoryUtil.memAddress(params));
    }

    public static void glGetInteger64(int pname, LongBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL32.nglGetInteger64v(pname, MemoryUtil.memAddress(params));
    }

    public static long glGetInteger64(int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.longParam();
        GL32.nglGetInteger64v(pname, __buffer.address() + (long)params);
        return __buffer.longValue(params);
    }

    public static native void nglGetInteger64i_v(int var0, int var1, long var2, long var4);

    public static void nglGetInteger64i_v(int pname, int index, long params) {
        long __functionAddress = GL32.getInstance().GetInteger64i_v;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL32.nglGetInteger64i_v(pname, index, params, __functionAddress);
    }

    public static void glGetInteger64i(int pname, int index, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 8);
        }
        GL32.nglGetInteger64i_v(pname, index, MemoryUtil.memAddress(params));
    }

    public static void glGetInteger64i(int pname, int index, LongBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL32.nglGetInteger64i_v(pname, index, MemoryUtil.memAddress(params));
    }

    public static long glGetInteger64i(int pname, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.longParam();
        GL32.nglGetInteger64i_v(pname, index, __buffer.address() + (long)params);
        return __buffer.longValue(params);
    }

    public static native void nglGetSynciv(long var0, int var2, int var3, long var4, long var6, long var8);

    public static void nglGetSynciv(long sync, int pname, int bufSize, long length, long values) {
        long __functionAddress = GL32.getInstance().GetSynciv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(sync);
        }
        GL32.nglGetSynciv(sync, pname, bufSize, length, values, __functionAddress);
    }

    public static void glGetSynci(long sync, int pname, int bufSize, ByteBuffer length, ByteBuffer values) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)values, bufSize << 2);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        GL32.nglGetSynciv(sync, pname, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(values));
    }

    public static void glGetSync(long sync, int pname, IntBuffer length, IntBuffer values) {
        if (LWJGLUtil.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GL32.nglGetSynciv(sync, pname, values.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(values));
    }

    public static int glGetSynci(long sync, int pname, IntBuffer length) {
        if (LWJGLUtil.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int values = __buffer.intParam();
        GL32.nglGetSynciv(sync, pname, 1, MemoryUtil.memAddressSafe(length), __buffer.address() + (long)values);
        return __buffer.intValue(values);
    }
}

