/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class GL20 {
    public static final int GL_SHADING_LANGUAGE_VERSION = 35724;
    public static final int GL_CURRENT_PROGRAM = 35725;
    public static final int GL_SHADER_TYPE = 35663;
    public static final int GL_DELETE_STATUS = 35712;
    public static final int GL_COMPILE_STATUS = 35713;
    public static final int GL_LINK_STATUS = 35714;
    public static final int GL_VALIDATE_STATUS = 35715;
    public static final int GL_INFO_LOG_LENGTH = 35716;
    public static final int GL_ATTACHED_SHADERS = 35717;
    public static final int GL_ACTIVE_UNIFORMS = 35718;
    public static final int GL_ACTIVE_UNIFORM_MAX_LENGTH = 35719;
    public static final int GL_ACTIVE_ATTRIBUTES = 35721;
    public static final int GL_ACTIVE_ATTRIBUTE_MAX_LENGTH = 35722;
    public static final int GL_SHADER_SOURCE_LENGTH = 35720;
    public static final int GL_FLOAT_VEC2 = 35664;
    public static final int GL_FLOAT_VEC3 = 35665;
    public static final int GL_FLOAT_VEC4 = 35666;
    public static final int GL_INT_VEC2 = 35667;
    public static final int GL_INT_VEC3 = 35668;
    public static final int GL_INT_VEC4 = 35669;
    public static final int GL_BOOL = 35670;
    public static final int GL_BOOL_VEC2 = 35671;
    public static final int GL_BOOL_VEC3 = 35672;
    public static final int GL_BOOL_VEC4 = 35673;
    public static final int GL_FLOAT_MAT2 = 35674;
    public static final int GL_FLOAT_MAT3 = 35675;
    public static final int GL_FLOAT_MAT4 = 35676;
    public static final int GL_SAMPLER_1D = 35677;
    public static final int GL_SAMPLER_2D = 35678;
    public static final int GL_SAMPLER_3D = 35679;
    public static final int GL_SAMPLER_CUBE = 35680;
    public static final int GL_SAMPLER_1D_SHADOW = 35681;
    public static final int GL_SAMPLER_2D_SHADOW = 35682;
    public static final int GL_VERTEX_SHADER = 35633;
    public static final int GL_MAX_VERTEX_UNIFORM_COMPONENTS = 35658;
    public static final int GL_MAX_VARYING_FLOATS = 35659;
    public static final int GL_MAX_VERTEX_ATTRIBS = 34921;
    public static final int GL_MAX_TEXTURE_IMAGE_UNITS = 34930;
    public static final int GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS = 35660;
    public static final int GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS = 35661;
    public static final int GL_MAX_TEXTURE_COORDS = 34929;
    public static final int GL_VERTEX_PROGRAM_POINT_SIZE = 34370;
    public static final int GL_VERTEX_PROGRAM_TWO_SIDE = 34371;
    public static final int GL_VERTEX_ATTRIB_ARRAY_ENABLED = 34338;
    public static final int GL_VERTEX_ATTRIB_ARRAY_SIZE = 34339;
    public static final int GL_VERTEX_ATTRIB_ARRAY_STRIDE = 34340;
    public static final int GL_VERTEX_ATTRIB_ARRAY_TYPE = 34341;
    public static final int GL_VERTEX_ATTRIB_ARRAY_NORMALIZED = 34922;
    public static final int GL_CURRENT_VERTEX_ATTRIB = 34342;
    public static final int GL_VERTEX_ATTRIB_ARRAY_POINTER = 34373;
    public static final int GL_FRAGMENT_SHADER = 35632;
    public static final int GL_MAX_FRAGMENT_UNIFORM_COMPONENTS = 35657;
    public static final int GL_FRAGMENT_SHADER_DERIVATIVE_HINT = 35723;
    public static final int GL_MAX_DRAW_BUFFERS = 34852;
    public static final int GL_DRAW_BUFFER0 = 34853;
    public static final int GL_DRAW_BUFFER1 = 34854;
    public static final int GL_DRAW_BUFFER2 = 34855;
    public static final int GL_DRAW_BUFFER3 = 34856;
    public static final int GL_DRAW_BUFFER4 = 34857;
    public static final int GL_DRAW_BUFFER5 = 34858;
    public static final int GL_DRAW_BUFFER6 = 34859;
    public static final int GL_DRAW_BUFFER7 = 34860;
    public static final int GL_DRAW_BUFFER8 = 34861;
    public static final int GL_DRAW_BUFFER9 = 34862;
    public static final int GL_DRAW_BUFFER10 = 34863;
    public static final int GL_DRAW_BUFFER11 = 34864;
    public static final int GL_DRAW_BUFFER12 = 34865;
    public static final int GL_DRAW_BUFFER13 = 34866;
    public static final int GL_DRAW_BUFFER14 = 34867;
    public static final int GL_DRAW_BUFFER15 = 34868;
    public static final int GL_POINT_SPRITE = 34913;
    public static final int GL_COORD_REPLACE = 34914;
    public static final int GL_POINT_SPRITE_COORD_ORIGIN = 36000;
    public static final int GL_LOWER_LEFT = 36001;
    public static final int GL_UPPER_LEFT = 36002;
    public static final int GL_BLEND_EQUATION_RGB = 32777;
    public static final int GL_BLEND_EQUATION_ALPHA = 34877;
    public static final int GL_STENCIL_BACK_FUNC_ATI = 34816;
    public static final int GL_STENCIL_BACK_FAIL_ATI = 34817;
    public static final int GL_STENCIL_BACK_PASS_DEPTH_FAIL_ATI = 34818;
    public static final int GL_STENCIL_BACK_PASS_DEPTH_PASS_ATI = 34819;
    public static final int GL_STENCIL_BACK_REF = 36003;
    public static final int GL_STENCIL_BACK_VALUE_MASK = 36004;
    public static final int GL_STENCIL_BACK_WRITEMASK = 36005;
    public final long CreateProgram;
    public final long DeleteProgram;
    public final long IsProgram;
    public final long CreateShader;
    public final long DeleteShader;
    public final long IsShader;
    public final long AttachShader;
    public final long DetachShader;
    public final long ShaderSource;
    public final long CompileShader;
    public final long LinkProgram;
    public final long UseProgram;
    public final long ValidateProgram;
    public final long Uniform1f;
    public final long Uniform2f;
    public final long Uniform3f;
    public final long Uniform4f;
    public final long Uniform1i;
    public final long Uniform2i;
    public final long Uniform3i;
    public final long Uniform4i;
    public final long Uniform1fv;
    public final long Uniform2fv;
    public final long Uniform3fv;
    public final long Uniform4fv;
    public final long Uniform1iv;
    public final long Uniform2iv;
    public final long Uniform3iv;
    public final long Uniform4iv;
    public final long UniformMatrix2fv;
    public final long UniformMatrix3fv;
    public final long UniformMatrix4fv;
    public final long GetShaderiv;
    public final long GetProgramiv;
    public final long GetShaderInfoLog;
    public final long GetProgramInfoLog;
    public final long GetAttachedShaders;
    public final long GetUniformLocation;
    public final long GetActiveUniform;
    public final long GetUniformfv;
    public final long GetUniformiv;
    public final long GetShaderSource;
    public final long VertexAttrib1f;
    public final long VertexAttrib1s;
    public final long VertexAttrib1d;
    public final long VertexAttrib2f;
    public final long VertexAttrib2s;
    public final long VertexAttrib2d;
    public final long VertexAttrib3f;
    public final long VertexAttrib3s;
    public final long VertexAttrib3d;
    public final long VertexAttrib4f;
    public final long VertexAttrib4s;
    public final long VertexAttrib4d;
    public final long VertexAttrib4Nub;
    public final long VertexAttrib1fv;
    public final long VertexAttrib1sv;
    public final long VertexAttrib1dv;
    public final long VertexAttrib2fv;
    public final long VertexAttrib2sv;
    public final long VertexAttrib2dv;
    public final long VertexAttrib3fv;
    public final long VertexAttrib3sv;
    public final long VertexAttrib3dv;
    public final long VertexAttrib4fv;
    public final long VertexAttrib4sv;
    public final long VertexAttrib4dv;
    public final long VertexAttrib4iv;
    public final long VertexAttrib4bv;
    public final long VertexAttrib4ubv;
    public final long VertexAttrib4usv;
    public final long VertexAttrib4uiv;
    public final long VertexAttrib4Nbv;
    public final long VertexAttrib4Nsv;
    public final long VertexAttrib4Niv;
    public final long VertexAttrib4Nubv;
    public final long VertexAttrib4Nusv;
    public final long VertexAttrib4Nuiv;
    public final long VertexAttribPointer;
    public final long EnableVertexAttribArray;
    public final long DisableVertexAttribArray;
    public final long BindAttribLocation;
    public final long GetActiveAttrib;
    public final long GetAttribLocation;
    public final long GetVertexAttribiv;
    public final long GetVertexAttribfv;
    public final long GetVertexAttribdv;
    public final long GetVertexAttribPointerv;
    public final long DrawBuffers;
    public final long BlendEquationSeparate;
    public final long StencilOpSeparate;
    public final long StencilFuncSeparate;
    public final long StencilMaskSeparate;

    public GL20(FunctionProvider provider) {
        this.CreateProgram = provider.getFunctionAddress("glCreateProgram");
        this.DeleteProgram = provider.getFunctionAddress("glDeleteProgram");
        this.IsProgram = provider.getFunctionAddress("glIsProgram");
        this.CreateShader = provider.getFunctionAddress("glCreateShader");
        this.DeleteShader = provider.getFunctionAddress("glDeleteShader");
        this.IsShader = provider.getFunctionAddress("glIsShader");
        this.AttachShader = provider.getFunctionAddress("glAttachShader");
        this.DetachShader = provider.getFunctionAddress("glDetachShader");
        this.ShaderSource = provider.getFunctionAddress("glShaderSource");
        this.CompileShader = provider.getFunctionAddress("glCompileShader");
        this.LinkProgram = provider.getFunctionAddress("glLinkProgram");
        this.UseProgram = provider.getFunctionAddress("glUseProgram");
        this.ValidateProgram = provider.getFunctionAddress("glValidateProgram");
        this.Uniform1f = provider.getFunctionAddress("glUniform1f");
        this.Uniform2f = provider.getFunctionAddress("glUniform2f");
        this.Uniform3f = provider.getFunctionAddress("glUniform3f");
        this.Uniform4f = provider.getFunctionAddress("glUniform4f");
        this.Uniform1i = provider.getFunctionAddress("glUniform1i");
        this.Uniform2i = provider.getFunctionAddress("glUniform2i");
        this.Uniform3i = provider.getFunctionAddress("glUniform3i");
        this.Uniform4i = provider.getFunctionAddress("glUniform4i");
        this.Uniform1fv = provider.getFunctionAddress("glUniform1fv");
        this.Uniform2fv = provider.getFunctionAddress("glUniform2fv");
        this.Uniform3fv = provider.getFunctionAddress("glUniform3fv");
        this.Uniform4fv = provider.getFunctionAddress("glUniform4fv");
        this.Uniform1iv = provider.getFunctionAddress("glUniform1iv");
        this.Uniform2iv = provider.getFunctionAddress("glUniform2iv");
        this.Uniform3iv = provider.getFunctionAddress("glUniform3iv");
        this.Uniform4iv = provider.getFunctionAddress("glUniform4iv");
        this.UniformMatrix2fv = provider.getFunctionAddress("glUniformMatrix2fv");
        this.UniformMatrix3fv = provider.getFunctionAddress("glUniformMatrix3fv");
        this.UniformMatrix4fv = provider.getFunctionAddress("glUniformMatrix4fv");
        this.GetShaderiv = provider.getFunctionAddress("glGetShaderiv");
        this.GetProgramiv = provider.getFunctionAddress("glGetProgramiv");
        this.GetShaderInfoLog = provider.getFunctionAddress("glGetShaderInfoLog");
        this.GetProgramInfoLog = provider.getFunctionAddress("glGetProgramInfoLog");
        this.GetAttachedShaders = provider.getFunctionAddress("glGetAttachedShaders");
        this.GetUniformLocation = provider.getFunctionAddress("glGetUniformLocation");
        this.GetActiveUniform = provider.getFunctionAddress("glGetActiveUniform");
        this.GetUniformfv = provider.getFunctionAddress("glGetUniformfv");
        this.GetUniformiv = provider.getFunctionAddress("glGetUniformiv");
        this.GetShaderSource = provider.getFunctionAddress("glGetShaderSource");
        this.VertexAttrib1f = provider.getFunctionAddress("glVertexAttrib1f");
        this.VertexAttrib1s = provider.getFunctionAddress("glVertexAttrib1s");
        this.VertexAttrib1d = provider.getFunctionAddress("glVertexAttrib1d");
        this.VertexAttrib2f = provider.getFunctionAddress("glVertexAttrib2f");
        this.VertexAttrib2s = provider.getFunctionAddress("glVertexAttrib2s");
        this.VertexAttrib2d = provider.getFunctionAddress("glVertexAttrib2d");
        this.VertexAttrib3f = provider.getFunctionAddress("glVertexAttrib3f");
        this.VertexAttrib3s = provider.getFunctionAddress("glVertexAttrib3s");
        this.VertexAttrib3d = provider.getFunctionAddress("glVertexAttrib3d");
        this.VertexAttrib4f = provider.getFunctionAddress("glVertexAttrib4f");
        this.VertexAttrib4s = provider.getFunctionAddress("glVertexAttrib4s");
        this.VertexAttrib4d = provider.getFunctionAddress("glVertexAttrib4d");
        this.VertexAttrib4Nub = provider.getFunctionAddress("glVertexAttrib4Nub");
        this.VertexAttrib1fv = provider.getFunctionAddress("glVertexAttrib1fv");
        this.VertexAttrib1sv = provider.getFunctionAddress("glVertexAttrib1sv");
        this.VertexAttrib1dv = provider.getFunctionAddress("glVertexAttrib1dv");
        this.VertexAttrib2fv = provider.getFunctionAddress("glVertexAttrib2fv");
        this.VertexAttrib2sv = provider.getFunctionAddress("glVertexAttrib2sv");
        this.VertexAttrib2dv = provider.getFunctionAddress("glVertexAttrib2dv");
        this.VertexAttrib3fv = provider.getFunctionAddress("glVertexAttrib3fv");
        this.VertexAttrib3sv = provider.getFunctionAddress("glVertexAttrib3sv");
        this.VertexAttrib3dv = provider.getFunctionAddress("glVertexAttrib3dv");
        this.VertexAttrib4fv = provider.getFunctionAddress("glVertexAttrib4fv");
        this.VertexAttrib4sv = provider.getFunctionAddress("glVertexAttrib4sv");
        this.VertexAttrib4dv = provider.getFunctionAddress("glVertexAttrib4dv");
        this.VertexAttrib4iv = provider.getFunctionAddress("glVertexAttrib4iv");
        this.VertexAttrib4bv = provider.getFunctionAddress("glVertexAttrib4bv");
        this.VertexAttrib4ubv = provider.getFunctionAddress("glVertexAttrib4ubv");
        this.VertexAttrib4usv = provider.getFunctionAddress("glVertexAttrib4usv");
        this.VertexAttrib4uiv = provider.getFunctionAddress("glVertexAttrib4uiv");
        this.VertexAttrib4Nbv = provider.getFunctionAddress("glVertexAttrib4Nbv");
        this.VertexAttrib4Nsv = provider.getFunctionAddress("glVertexAttrib4Nsv");
        this.VertexAttrib4Niv = provider.getFunctionAddress("glVertexAttrib4Niv");
        this.VertexAttrib4Nubv = provider.getFunctionAddress("glVertexAttrib4Nubv");
        this.VertexAttrib4Nusv = provider.getFunctionAddress("glVertexAttrib4Nusv");
        this.VertexAttrib4Nuiv = provider.getFunctionAddress("glVertexAttrib4Nuiv");
        this.VertexAttribPointer = provider.getFunctionAddress("glVertexAttribPointer");
        this.EnableVertexAttribArray = provider.getFunctionAddress("glEnableVertexAttribArray");
        this.DisableVertexAttribArray = provider.getFunctionAddress("glDisableVertexAttribArray");
        this.BindAttribLocation = provider.getFunctionAddress("glBindAttribLocation");
        this.GetActiveAttrib = provider.getFunctionAddress("glGetActiveAttrib");
        this.GetAttribLocation = provider.getFunctionAddress("glGetAttribLocation");
        this.GetVertexAttribiv = provider.getFunctionAddress("glGetVertexAttribiv");
        this.GetVertexAttribfv = provider.getFunctionAddress("glGetVertexAttribfv");
        this.GetVertexAttribdv = provider.getFunctionAddress("glGetVertexAttribdv");
        this.GetVertexAttribPointerv = provider.getFunctionAddress("glGetVertexAttribPointerv");
        this.DrawBuffers = provider.getFunctionAddress("glDrawBuffers");
        this.BlendEquationSeparate = provider.getFunctionAddress("glBlendEquationSeparate");
        this.StencilOpSeparate = provider.getFunctionAddress("glStencilOpSeparate");
        this.StencilFuncSeparate = provider.getFunctionAddress("glStencilFuncSeparate");
        this.StencilMaskSeparate = provider.getFunctionAddress("glStencilMaskSeparate");
    }

    public static GL20 getInstance() {
        return GL.getCapabilities().__GL20;
    }

    static GL20 create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("OpenGL20")) {
            return null;
        }
        GL20 funcs = new GL20(provider);
        boolean supported = Checks.checkFunctions(funcs.CreateProgram, funcs.DeleteProgram, funcs.IsProgram, funcs.CreateShader, funcs.DeleteShader, funcs.IsShader, funcs.AttachShader, funcs.DetachShader, funcs.ShaderSource, funcs.CompileShader, funcs.LinkProgram, funcs.UseProgram, funcs.ValidateProgram, funcs.Uniform1f, funcs.Uniform2f, funcs.Uniform3f, funcs.Uniform4f, funcs.Uniform1i, funcs.Uniform2i, funcs.Uniform3i, funcs.Uniform4i, funcs.Uniform1fv, funcs.Uniform2fv, funcs.Uniform3fv, funcs.Uniform4fv, funcs.Uniform1iv, funcs.Uniform2iv, funcs.Uniform3iv, funcs.Uniform4iv, funcs.UniformMatrix2fv, funcs.UniformMatrix3fv, funcs.UniformMatrix4fv, funcs.GetShaderiv, funcs.GetProgramiv, funcs.GetShaderInfoLog, funcs.GetProgramInfoLog, funcs.GetAttachedShaders, funcs.GetUniformLocation, funcs.GetActiveUniform, funcs.GetUniformfv, funcs.GetUniformiv, funcs.GetShaderSource, funcs.VertexAttrib1f, funcs.VertexAttrib1s, funcs.VertexAttrib1d, funcs.VertexAttrib2f, funcs.VertexAttrib2s, funcs.VertexAttrib2d, funcs.VertexAttrib3f, funcs.VertexAttrib3s, funcs.VertexAttrib3d, funcs.VertexAttrib4f, funcs.VertexAttrib4s, funcs.VertexAttrib4d, funcs.VertexAttrib4Nub, funcs.VertexAttrib1fv, funcs.VertexAttrib1sv, funcs.VertexAttrib1dv, funcs.VertexAttrib2fv, funcs.VertexAttrib2sv, funcs.VertexAttrib2dv, funcs.VertexAttrib3fv, funcs.VertexAttrib3sv, funcs.VertexAttrib3dv, funcs.VertexAttrib4fv, funcs.VertexAttrib4sv, funcs.VertexAttrib4dv, funcs.VertexAttrib4iv, funcs.VertexAttrib4bv, funcs.VertexAttrib4ubv, funcs.VertexAttrib4usv, funcs.VertexAttrib4uiv, funcs.VertexAttrib4Nbv, funcs.VertexAttrib4Nsv, funcs.VertexAttrib4Niv, funcs.VertexAttrib4Nubv, funcs.VertexAttrib4Nusv, funcs.VertexAttrib4Nuiv, funcs.VertexAttribPointer, funcs.EnableVertexAttribArray, funcs.DisableVertexAttribArray, funcs.BindAttribLocation, funcs.GetActiveAttrib, funcs.GetAttribLocation, funcs.GetVertexAttribiv, funcs.GetVertexAttribfv, funcs.GetVertexAttribdv, funcs.GetVertexAttribPointerv, funcs.DrawBuffers, funcs.BlendEquationSeparate, funcs.StencilOpSeparate, funcs.StencilFuncSeparate, funcs.StencilMaskSeparate);
        return GL.checkExtension("OpenGL20", funcs, supported);
    }

    public static native int nglCreateProgram(long var0);

    public static int glCreateProgram() {
        long __functionAddress = GL20.getInstance().CreateProgram;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL20.nglCreateProgram(__functionAddress);
    }

    public static native void nglDeleteProgram(int var0, long var1);

    public static void glDeleteProgram(int program) {
        long __functionAddress = GL20.getInstance().DeleteProgram;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglDeleteProgram(program, __functionAddress);
    }

    public static native boolean nglIsProgram(int var0, long var1);

    public static boolean glIsProgram(int program) {
        long __functionAddress = GL20.getInstance().IsProgram;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL20.nglIsProgram(program, __functionAddress);
    }

    public static native int nglCreateShader(int var0, long var1);

    public static int glCreateShader(int type) {
        long __functionAddress = GL20.getInstance().CreateShader;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL20.nglCreateShader(type, __functionAddress);
    }

    public static native void nglDeleteShader(int var0, long var1);

    public static void glDeleteShader(int shader) {
        long __functionAddress = GL20.getInstance().DeleteShader;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglDeleteShader(shader, __functionAddress);
    }

    public static native boolean nglIsShader(int var0, long var1);

    public static boolean glIsShader(int shader) {
        long __functionAddress = GL20.getInstance().IsShader;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL20.nglIsShader(shader, __functionAddress);
    }

    public static native void nglAttachShader(int var0, int var1, long var2);

    public static void glAttachShader(int program, int shader) {
        long __functionAddress = GL20.getInstance().AttachShader;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglAttachShader(program, shader, __functionAddress);
    }

    public static native void nglDetachShader(int var0, int var1, long var2);

    public static void glDetachShader(int program, int shader) {
        long __functionAddress = GL20.getInstance().DetachShader;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglDetachShader(program, shader, __functionAddress);
    }

    public static native void nglShaderSource(int var0, int var1, long var2, long var4, long var6);

    public static void nglShaderSource(int shader, int count, long strings, long length) {
        long __functionAddress = GL20.getInstance().ShaderSource;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglShaderSource(shader, count, strings, length, __functionAddress);
    }

    public static void glShaderSource(int shader, int count, ByteBuffer strings, ByteBuffer length) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)strings, count << Pointer.POINTER_SHIFT);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, count << 2);
            }
        }
        GL20.nglShaderSource(shader, count, MemoryUtil.memAddress(strings), MemoryUtil.memAddressSafe(length));
    }

    public static void glShaderSource(int shader, PointerBuffer strings, IntBuffer length) {
        if (LWJGLUtil.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, strings.remaining());
        }
        GL20.nglShaderSource(shader, strings.remaining(), MemoryUtil.memAddress(strings), MemoryUtil.memAddressSafe(length));
    }

    public static void glShaderSource(int shader, CharSequence ... strings) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int stringsLengths = __buffer.bufferParam(strings.length << 2);
        for (int i = 0; i < strings.length; ++i) {
            __buffer.intParam(stringsLengths, i, strings[i].length());
        }
        int stringsAddress = __buffer.bufferParam(strings.length << Pointer.POINTER_SHIFT);
        ByteBuffer[] stringsBuffers = new ByteBuffer[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            stringsBuffers[i] = MemoryUtil.memEncodeUTF8(strings[i], false);
            __buffer.pointerParam(stringsAddress, i, MemoryUtil.memAddress(stringsBuffers[i]));
        }
        GL20.nglShaderSource(shader, strings.length, __buffer.address() + (long)stringsAddress, __buffer.address() + (long)stringsLengths);
    }

    public static void glShaderSource(int shader, CharSequence string) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int stringsLengths = __buffer.intParam(string.length());
        ByteBuffer stringBuffers = MemoryUtil.memEncodeUTF8(string, false);
        int stringsAddress = __buffer.pointerParam(MemoryUtil.memAddress(stringBuffers));
        GL20.nglShaderSource(shader, 1, __buffer.address() + (long)stringsAddress, __buffer.address() + (long)stringsLengths);
    }

    public static native void nglCompileShader(int var0, long var1);

    public static void glCompileShader(int shader) {
        long __functionAddress = GL20.getInstance().CompileShader;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglCompileShader(shader, __functionAddress);
    }

    public static native void nglLinkProgram(int var0, long var1);

    public static void glLinkProgram(int program) {
        long __functionAddress = GL20.getInstance().LinkProgram;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglLinkProgram(program, __functionAddress);
    }

    public static native void nglUseProgram(int var0, long var1);

    public static void glUseProgram(int program) {
        long __functionAddress = GL20.getInstance().UseProgram;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglUseProgram(program, __functionAddress);
    }

    public static native void nglValidateProgram(int var0, long var1);

    public static void glValidateProgram(int program) {
        long __functionAddress = GL20.getInstance().ValidateProgram;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglValidateProgram(program, __functionAddress);
    }

    public static native void nglUniform1f(int var0, float var1, long var2);

    public static void glUniform1f(int location, float v0) {
        long __functionAddress = GL20.getInstance().Uniform1f;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglUniform1f(location, v0, __functionAddress);
    }

    public static native void nglUniform2f(int var0, float var1, float var2, long var3);

    public static void glUniform2f(int location, float v0, float v1) {
        long __functionAddress = GL20.getInstance().Uniform2f;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglUniform2f(location, v0, v1, __functionAddress);
    }

    public static native void nglUniform3f(int var0, float var1, float var2, float var3, long var4);

    public static void glUniform3f(int location, float v0, float v1, float v2) {
        long __functionAddress = GL20.getInstance().Uniform3f;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglUniform3f(location, v0, v1, v2, __functionAddress);
    }

    public static native void nglUniform4f(int var0, float var1, float var2, float var3, float var4, long var5);

    public static void glUniform4f(int location, float v0, float v1, float v2, float v3) {
        long __functionAddress = GL20.getInstance().Uniform4f;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglUniform4f(location, v0, v1, v2, v3, __functionAddress);
    }

    public static native void nglUniform1i(int var0, int var1, long var2);

    public static void glUniform1i(int location, int v0) {
        long __functionAddress = GL20.getInstance().Uniform1i;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglUniform1i(location, v0, __functionAddress);
    }

    public static native void nglUniform2i(int var0, int var1, int var2, long var3);

    public static void glUniform2i(int location, int v0, int v1) {
        long __functionAddress = GL20.getInstance().Uniform2i;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglUniform2i(location, v0, v1, __functionAddress);
    }

    public static native void nglUniform3i(int var0, int var1, int var2, int var3, long var4);

    public static void glUniform3i(int location, int v0, int v1, int v2) {
        long __functionAddress = GL20.getInstance().Uniform3i;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglUniform3i(location, v0, v1, v2, __functionAddress);
    }

    public static native void nglUniform4i(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glUniform4i(int location, int v0, int v1, int v2, int v3) {
        long __functionAddress = GL20.getInstance().Uniform4i;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglUniform4i(location, v0, v1, v2, v3, __functionAddress);
    }

    public static native void nglUniform1fv(int var0, int var1, long var2, long var4);

    public static void nglUniform1fv(int location, int count, long value) {
        long __functionAddress = GL20.getInstance().Uniform1fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglUniform1fv(location, count, value, __functionAddress);
    }

    public static void glUniform1f(int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2);
        }
        GL20.nglUniform1fv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform1(int location, FloatBuffer value) {
        GL20.nglUniform1fv(location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static native void nglUniform2fv(int var0, int var1, long var2, long var4);

    public static void nglUniform2fv(int location, int count, long value) {
        long __functionAddress = GL20.getInstance().Uniform2fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglUniform2fv(location, count, value, __functionAddress);
    }

    public static void glUniform2f(int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 2);
        }
        GL20.nglUniform2fv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform2(int location, FloatBuffer value) {
        GL20.nglUniform2fv(location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static native void nglUniform3fv(int var0, int var1, long var2, long var4);

    public static void nglUniform3fv(int location, int count, long value) {
        long __functionAddress = GL20.getInstance().Uniform3fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglUniform3fv(location, count, value, __functionAddress);
    }

    public static void glUniform3f(int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 3 << 2);
        }
        GL20.nglUniform3fv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform3(int location, FloatBuffer value) {
        GL20.nglUniform3fv(location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static native void nglUniform4fv(int var0, int var1, long var2, long var4);

    public static void nglUniform4fv(int location, int count, long value) {
        long __functionAddress = GL20.getInstance().Uniform4fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglUniform4fv(location, count, value, __functionAddress);
    }

    public static void glUniform4f(int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        GL20.nglUniform4fv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform4(int location, FloatBuffer value) {
        GL20.nglUniform4fv(location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static native void nglUniform1iv(int var0, int var1, long var2, long var4);

    public static void nglUniform1iv(int location, int count, long value) {
        long __functionAddress = GL20.getInstance().Uniform1iv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglUniform1iv(location, count, value, __functionAddress);
    }

    public static void glUniform1i(int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2);
        }
        GL20.nglUniform1iv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform1(int location, IntBuffer value) {
        GL20.nglUniform1iv(location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static native void nglUniform2iv(int var0, int var1, long var2, long var4);

    public static void nglUniform2iv(int location, int count, long value) {
        long __functionAddress = GL20.getInstance().Uniform2iv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglUniform2iv(location, count, value, __functionAddress);
    }

    public static void glUniform2i(int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 2);
        }
        GL20.nglUniform2iv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform2(int location, IntBuffer value) {
        GL20.nglUniform2iv(location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static native void nglUniform3iv(int var0, int var1, long var2, long var4);

    public static void nglUniform3iv(int location, int count, long value) {
        long __functionAddress = GL20.getInstance().Uniform3iv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglUniform3iv(location, count, value, __functionAddress);
    }

    public static void glUniform3i(int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 3 << 2);
        }
        GL20.nglUniform3iv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform3(int location, IntBuffer value) {
        GL20.nglUniform3iv(location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static native void nglUniform4iv(int var0, int var1, long var2, long var4);

    public static void nglUniform4iv(int location, int count, long value) {
        long __functionAddress = GL20.getInstance().Uniform4iv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglUniform4iv(location, count, value, __functionAddress);
    }

    public static void glUniform4i(int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        GL20.nglUniform4iv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform4(int location, IntBuffer value) {
        GL20.nglUniform4iv(location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static native void nglUniformMatrix2fv(int var0, int var1, boolean var2, long var3, long var5);

    public static void nglUniformMatrix2fv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL20.getInstance().UniformMatrix2fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglUniformMatrix2fv(location, count, transpose, value, __functionAddress);
    }

    public static void glUniformMatrix2f(int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        GL20.nglUniformMatrix2fv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix2(int location, boolean transpose, FloatBuffer value) {
        GL20.nglUniformMatrix2fv(location, value.remaining() >> 2, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglUniformMatrix3fv(int var0, int var1, boolean var2, long var3, long var5);

    public static void nglUniformMatrix3fv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL20.getInstance().UniformMatrix3fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglUniformMatrix3fv(location, count, transpose, value, __functionAddress);
    }

    public static void glUniformMatrix3f(int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 9 << 2);
        }
        GL20.nglUniformMatrix3fv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix3(int location, boolean transpose, FloatBuffer value) {
        GL20.nglUniformMatrix3fv(location, value.remaining() / 9, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglUniformMatrix4fv(int var0, int var1, boolean var2, long var3, long var5);

    public static void nglUniformMatrix4fv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL20.getInstance().UniformMatrix4fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglUniformMatrix4fv(location, count, transpose, value, __functionAddress);
    }

    public static void glUniformMatrix4f(int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 4 << 2);
        }
        GL20.nglUniformMatrix4fv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix4(int location, boolean transpose, FloatBuffer value) {
        GL20.nglUniformMatrix4fv(location, value.remaining() >> 4, transpose, MemoryUtil.memAddress(value));
    }

    public static native void nglGetShaderiv(int var0, int var1, long var2, long var4);

    public static void nglGetShaderiv(int shader, int pname, long params) {
        long __functionAddress = GL20.getInstance().GetShaderiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglGetShaderiv(shader, pname, params, __functionAddress);
    }

    public static void glGetShaderi(int shader, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL20.nglGetShaderiv(shader, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetShader(int shader, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL20.nglGetShaderiv(shader, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetShaderi(int shader, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL20.nglGetShaderiv(shader, pname, __buffer.address() + (long)params);
        return __buffer.intValue(params);
    }

    public static native void nglGetProgramiv(int var0, int var1, long var2, long var4);

    public static void nglGetProgramiv(int program, int pname, long params) {
        long __functionAddress = GL20.getInstance().GetProgramiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglGetProgramiv(program, pname, params, __functionAddress);
    }

    public static void glGetProgrami(int program, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL20.nglGetProgramiv(program, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetProgram(int program, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL20.nglGetProgramiv(program, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetProgrami(int program, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL20.nglGetProgramiv(program, pname, __buffer.address() + (long)params);
        return __buffer.intValue(params);
    }

    public static native void nglGetShaderInfoLog(int var0, int var1, long var2, long var4, long var6);

    public static void nglGetShaderInfoLog(int shader, int maxLength, long length, long infoLog) {
        long __functionAddress = GL20.getInstance().GetShaderInfoLog;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglGetShaderInfoLog(shader, maxLength, length, infoLog, __functionAddress);
    }

    public static void glGetShaderInfoLog(int shader, int maxLength, ByteBuffer length, ByteBuffer infoLog) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)infoLog, maxLength);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        GL20.nglGetShaderInfoLog(shader, maxLength, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    public static void glGetShaderInfoLog(int shader, IntBuffer length, ByteBuffer infoLog) {
        if (LWJGLUtil.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GL20.nglGetShaderInfoLog(shader, infoLog.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    public static String glGetShaderInfoLog(int shader, int maxLength) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int infoLog = __buffer.bufferParam(maxLength);
        GL20.nglGetShaderInfoLog(shader, maxLength, __buffer.address() + (long)length, __buffer.address() + (long)infoLog);
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBuffer(__buffer.address() + (long)infoLog, __buffer.intValue(length)));
    }

    public static String glGetShaderInfoLog(int shader) {
        int maxLength = GL20.glGetShaderi(shader, 35716);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int infoLog = __buffer.bufferParam(maxLength);
        GL20.nglGetShaderInfoLog(shader, maxLength, __buffer.address() + (long)length, __buffer.address() + (long)infoLog);
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBuffer(__buffer.address() + (long)infoLog, __buffer.intValue(length)));
    }

    public static native void nglGetProgramInfoLog(int var0, int var1, long var2, long var4, long var6);

    public static void nglGetProgramInfoLog(int program, int maxLength, long length, long infoLog) {
        long __functionAddress = GL20.getInstance().GetProgramInfoLog;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglGetProgramInfoLog(program, maxLength, length, infoLog, __functionAddress);
    }

    public static void glGetProgramInfoLog(int program, int maxLength, ByteBuffer length, ByteBuffer infoLog) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)infoLog, maxLength);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        GL20.nglGetProgramInfoLog(program, maxLength, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    public static void glGetProgramInfoLog(int program, IntBuffer length, ByteBuffer infoLog) {
        if (LWJGLUtil.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GL20.nglGetProgramInfoLog(program, infoLog.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    public static String glGetProgramInfoLog(int program, int maxLength) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int infoLog = __buffer.bufferParam(maxLength);
        GL20.nglGetProgramInfoLog(program, maxLength, __buffer.address() + (long)length, __buffer.address() + (long)infoLog);
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBuffer(__buffer.address() + (long)infoLog, __buffer.intValue(length)));
    }

    public static String glGetProgramInfoLog(int program) {
        int maxLength = GL20.glGetProgrami(program, 35716);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int infoLog = __buffer.bufferParam(maxLength);
        GL20.nglGetProgramInfoLog(program, maxLength, __buffer.address() + (long)length, __buffer.address() + (long)infoLog);
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBuffer(__buffer.address() + (long)infoLog, __buffer.intValue(length)));
    }

    public static native void nglGetAttachedShaders(int var0, int var1, long var2, long var4, long var6);

    public static void nglGetAttachedShaders(int program, int maxCount, long count, long shaders) {
        long __functionAddress = GL20.getInstance().GetAttachedShaders;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglGetAttachedShaders(program, maxCount, count, shaders, __functionAddress);
    }

    public static void glGetAttachedShaders(int program, int maxCount, ByteBuffer count, ByteBuffer shaders) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)shaders, maxCount << 2);
            if (count != null) {
                Checks.checkBuffer((Buffer)count, 4);
            }
        }
        GL20.nglGetAttachedShaders(program, maxCount, MemoryUtil.memAddressSafe(count), MemoryUtil.memAddress(shaders));
    }

    public static void glGetAttachedShaders(int program, IntBuffer count, IntBuffer shaders) {
        if (LWJGLUtil.CHECKS && count != null) {
            Checks.checkBuffer((Buffer)count, 1);
        }
        GL20.nglGetAttachedShaders(program, shaders.remaining(), MemoryUtil.memAddressSafe(count), MemoryUtil.memAddress(shaders));
    }

    public static IntBuffer glGetAttachedShaders(int program, int maxCount) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int count = __buffer.intParam();
        int shaders = __buffer.bufferParam(maxCount << 2);
        GL20.nglGetAttachedShaders(program, maxCount, __buffer.address() + (long)count, __buffer.address() + (long)shaders);
        return MemoryUtil.memIntBuffer(__buffer.address() + (long)shaders, __buffer.intValue(count));
    }

    public static IntBuffer glGetAttachedShaders(int program) {
        int maxCount = GL20.glGetProgrami(program, 35717);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int count = __buffer.intParam();
        int shaders = __buffer.bufferParam(maxCount << 2);
        GL20.nglGetAttachedShaders(program, maxCount, __buffer.address() + (long)count, __buffer.address() + (long)shaders);
        return MemoryUtil.memIntBuffer(__buffer.address() + (long)shaders, __buffer.intValue(count));
    }

    public static native int nglGetUniformLocation(int var0, long var1, long var3);

    public static int nglGetUniformLocation(int program, long name) {
        long __functionAddress = GL20.getInstance().GetUniformLocation;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL20.nglGetUniformLocation(program, name, __functionAddress);
    }

    public static int glGetUniformLocation(int program, ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(name);
        }
        return GL20.nglGetUniformLocation(program, MemoryUtil.memAddress(name));
    }

    public static int glGetUniformLocation(int program, CharSequence name) {
        ByteBuffer nameEncoded = MemoryUtil.memEncodeASCII(name);
        return GL20.nglGetUniformLocation(program, MemoryUtil.memAddress(nameEncoded));
    }

    public static native void nglGetActiveUniform(int var0, int var1, int var2, long var3, long var5, long var7, long var9, long var11);

    public static void nglGetActiveUniform(int program, int index, int maxLength, long length, long size, long type, long name) {
        long __functionAddress = GL20.getInstance().GetActiveUniform;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglGetActiveUniform(program, index, maxLength, length, size, type, name, __functionAddress);
    }

    public static void glGetActiveUniform(int program, int index, int maxLength, ByteBuffer length, ByteBuffer size, ByteBuffer type, ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)name, maxLength);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
            Checks.checkBuffer((Buffer)size, 4);
            Checks.checkBuffer((Buffer)type, 4);
        }
        GL20.nglGetActiveUniform(program, index, maxLength, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    public static void glGetActiveUniform(int program, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 1);
            }
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        GL20.nglGetActiveUniform(program, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    public static String glGetActiveUniform(int program, int index, int maxLength, IntBuffer size, IntBuffer type) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(maxLength);
        GL20.nglGetActiveUniform(program, index, maxLength, __buffer.address() + (long)length, MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), __buffer.address() + (long)name);
        return MemoryUtil.memDecodeASCII(MemoryUtil.memByteBuffer(__buffer.address() + (long)name, __buffer.intValue(length)));
    }

    public static String glGetActiveUniform(int program, int index, IntBuffer size, IntBuffer type) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        int maxLength = GL20.glGetProgrami(program, 35719);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(maxLength);
        GL20.nglGetActiveUniform(program, index, maxLength, __buffer.address() + (long)length, MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), __buffer.address() + (long)name);
        return MemoryUtil.memDecodeASCII(MemoryUtil.memByteBuffer(__buffer.address() + (long)name, __buffer.intValue(length)));
    }

    public static native void nglGetUniformfv(int var0, int var1, long var2, long var4);

    public static void nglGetUniformfv(int program, int location, long params) {
        long __functionAddress = GL20.getInstance().GetUniformfv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglGetUniformfv(program, location, params, __functionAddress);
    }

    public static void glGetUniformf(int program, int location, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL20.nglGetUniformfv(program, location, MemoryUtil.memAddress(params));
    }

    public static void glGetUniform(int program, int location, FloatBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL20.nglGetUniformfv(program, location, MemoryUtil.memAddress(params));
    }

    public static float glGetUniformf(int program, int location) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.floatParam();
        GL20.nglGetUniformfv(program, location, __buffer.address() + (long)params);
        return __buffer.floatValue(params);
    }

    public static native void nglGetUniformiv(int var0, int var1, long var2, long var4);

    public static void nglGetUniformiv(int program, int location, long params) {
        long __functionAddress = GL20.getInstance().GetUniformiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglGetUniformiv(program, location, params, __functionAddress);
    }

    public static void glGetUniformi(int program, int location, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL20.nglGetUniformiv(program, location, MemoryUtil.memAddress(params));
    }

    public static void glGetUniform(int program, int location, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL20.nglGetUniformiv(program, location, MemoryUtil.memAddress(params));
    }

    public static int glGetUniformi(int program, int location) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL20.nglGetUniformiv(program, location, __buffer.address() + (long)params);
        return __buffer.intValue(params);
    }

    public static native void nglGetShaderSource(int var0, int var1, long var2, long var4, long var6);

    public static void nglGetShaderSource(int shader, int maxLength, long length, long source) {
        long __functionAddress = GL20.getInstance().GetShaderSource;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglGetShaderSource(shader, maxLength, length, source, __functionAddress);
    }

    public static void glGetShaderSource(int shader, int maxLength, ByteBuffer length, ByteBuffer source) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)source, maxLength);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        GL20.nglGetShaderSource(shader, maxLength, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(source));
    }

    public static void glGetShaderSource(int shader, IntBuffer length, ByteBuffer source) {
        if (LWJGLUtil.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GL20.nglGetShaderSource(shader, source.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(source));
    }

    public static String glGetShaderSource(int shader, int maxLength) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int source = __buffer.bufferParam(maxLength);
        GL20.nglGetShaderSource(shader, maxLength, __buffer.address() + (long)length, __buffer.address() + (long)source);
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBuffer(__buffer.address() + (long)source, __buffer.intValue(length)));
    }

    public static String glGetShaderSource(int shader) {
        int maxLength = GL20.glGetShaderi(shader, 35720);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int source = __buffer.bufferParam(maxLength);
        GL20.nglGetShaderSource(shader, maxLength, __buffer.address() + (long)length, __buffer.address() + (long)source);
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBuffer(__buffer.address() + (long)source, __buffer.intValue(length)));
    }

    public static native void nglVertexAttrib1f(int var0, float var1, long var2);

    public static void glVertexAttrib1f(int index, float v0) {
        long __functionAddress = GL20.getInstance().VertexAttrib1f;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib1f(index, v0, __functionAddress);
    }

    public static native void nglVertexAttrib1s(int var0, short var1, long var2);

    public static void glVertexAttrib1s(int index, short v0) {
        long __functionAddress = GL20.getInstance().VertexAttrib1s;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib1s(index, v0, __functionAddress);
    }

    public static native void nglVertexAttrib1d(int var0, double var1, long var3);

    public static void glVertexAttrib1d(int index, double v0) {
        long __functionAddress = GL20.getInstance().VertexAttrib1d;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib1d(index, v0, __functionAddress);
    }

    public static native void nglVertexAttrib2f(int var0, float var1, float var2, long var3);

    public static void glVertexAttrib2f(int index, float v0, float v1) {
        long __functionAddress = GL20.getInstance().VertexAttrib2f;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib2f(index, v0, v1, __functionAddress);
    }

    public static native void nglVertexAttrib2s(int var0, short var1, short var2, long var3);

    public static void glVertexAttrib2s(int index, short v0, short v1) {
        long __functionAddress = GL20.getInstance().VertexAttrib2s;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib2s(index, v0, v1, __functionAddress);
    }

    public static native void nglVertexAttrib2d(int var0, double var1, double var3, long var5);

    public static void glVertexAttrib2d(int index, double v0, double v1) {
        long __functionAddress = GL20.getInstance().VertexAttrib2d;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib2d(index, v0, v1, __functionAddress);
    }

    public static native void nglVertexAttrib3f(int var0, float var1, float var2, float var3, long var4);

    public static void glVertexAttrib3f(int index, float v0, float v1, float v2) {
        long __functionAddress = GL20.getInstance().VertexAttrib3f;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib3f(index, v0, v1, v2, __functionAddress);
    }

    public static native void nglVertexAttrib3s(int var0, short var1, short var2, short var3, long var4);

    public static void glVertexAttrib3s(int index, short v0, short v1, short v2) {
        long __functionAddress = GL20.getInstance().VertexAttrib3s;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib3s(index, v0, v1, v2, __functionAddress);
    }

    public static native void nglVertexAttrib3d(int var0, double var1, double var3, double var5, long var7);

    public static void glVertexAttrib3d(int index, double v0, double v1, double v2) {
        long __functionAddress = GL20.getInstance().VertexAttrib3d;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib3d(index, v0, v1, v2, __functionAddress);
    }

    public static native void nglVertexAttrib4f(int var0, float var1, float var2, float var3, float var4, long var5);

    public static void glVertexAttrib4f(int index, float v0, float v1, float v2, float v3) {
        long __functionAddress = GL20.getInstance().VertexAttrib4f;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib4f(index, v0, v1, v2, v3, __functionAddress);
    }

    public static native void nglVertexAttrib4s(int var0, short var1, short var2, short var3, short var4, long var5);

    public static void glVertexAttrib4s(int index, short v0, short v1, short v2, short v3) {
        long __functionAddress = GL20.getInstance().VertexAttrib4s;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib4s(index, v0, v1, v2, v3, __functionAddress);
    }

    public static native void nglVertexAttrib4d(int var0, double var1, double var3, double var5, double var7, long var9);

    public static void glVertexAttrib4d(int index, double v0, double v1, double v2, double v3) {
        long __functionAddress = GL20.getInstance().VertexAttrib4d;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib4d(index, v0, v1, v2, v3, __functionAddress);
    }

    public static native void nglVertexAttrib4Nub(int var0, byte var1, byte var2, byte var3, byte var4, long var5);

    public static void glVertexAttrib4Nub(int index, byte x, byte y, byte z, byte w) {
        long __functionAddress = GL20.getInstance().VertexAttrib4Nub;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib4Nub(index, x, y, z, w, __functionAddress);
    }

    public static native void nglVertexAttrib1fv(int var0, long var1, long var3);

    public static void nglVertexAttrib1fv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib1fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib1fv(index, v, __functionAddress);
    }

    public static void glVertexAttrib1f(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib1fv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib1(int index, FloatBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 1);
        }
        GL20.nglVertexAttrib1fv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttrib1sv(int var0, long var1, long var3);

    public static void nglVertexAttrib1sv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib1sv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib1sv(index, v, __functionAddress);
    }

    public static void glVertexAttrib1s(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 2);
        }
        GL20.nglVertexAttrib1sv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib1(int index, ShortBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 1);
        }
        GL20.nglVertexAttrib1sv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttrib1dv(int var0, long var1, long var3);

    public static void nglVertexAttrib1dv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib1dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib1dv(index, v, __functionAddress);
    }

    public static void glVertexAttrib1d(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 8);
        }
        GL20.nglVertexAttrib1dv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib1(int index, DoubleBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 1);
        }
        GL20.nglVertexAttrib1dv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttrib2fv(int var0, long var1, long var3);

    public static void nglVertexAttrib2fv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib2fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib2fv(index, v, __functionAddress);
    }

    public static void glVertexAttrib2f(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 8);
        }
        GL20.nglVertexAttrib2fv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib2(int index, FloatBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 2);
        }
        GL20.nglVertexAttrib2fv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttrib2sv(int var0, long var1, long var3);

    public static void nglVertexAttrib2sv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib2sv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib2sv(index, v, __functionAddress);
    }

    public static void glVertexAttrib2s(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib2sv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib2(int index, ShortBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 2);
        }
        GL20.nglVertexAttrib2sv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttrib2dv(int var0, long var1, long var3);

    public static void nglVertexAttrib2dv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib2dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib2dv(index, v, __functionAddress);
    }

    public static void glVertexAttrib2d(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 16);
        }
        GL20.nglVertexAttrib2dv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib2(int index, DoubleBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 2);
        }
        GL20.nglVertexAttrib2dv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttrib3fv(int var0, long var1, long var3);

    public static void nglVertexAttrib3fv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib3fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib3fv(index, v, __functionAddress);
    }

    public static void glVertexAttrib3f(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 12);
        }
        GL20.nglVertexAttrib3fv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib3(int index, FloatBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 3);
        }
        GL20.nglVertexAttrib3fv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttrib3sv(int var0, long var1, long var3);

    public static void nglVertexAttrib3sv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib3sv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib3sv(index, v, __functionAddress);
    }

    public static void glVertexAttrib3s(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 6);
        }
        GL20.nglVertexAttrib3sv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib3(int index, ShortBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 3);
        }
        GL20.nglVertexAttrib3sv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttrib3dv(int var0, long var1, long var3);

    public static void nglVertexAttrib3dv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib3dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib3dv(index, v, __functionAddress);
    }

    public static void glVertexAttrib3d(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 24);
        }
        GL20.nglVertexAttrib3dv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib3(int index, DoubleBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 3);
        }
        GL20.nglVertexAttrib3dv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttrib4fv(int var0, long var1, long var3);

    public static void nglVertexAttrib4fv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib4fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib4fv(index, v, __functionAddress);
    }

    public static void glVertexAttrib4f(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 16);
        }
        GL20.nglVertexAttrib4fv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib4(int index, FloatBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4fv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttrib4sv(int var0, long var1, long var3);

    public static void nglVertexAttrib4sv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib4sv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib4sv(index, v, __functionAddress);
    }

    public static void glVertexAttrib4s(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 8);
        }
        GL20.nglVertexAttrib4sv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib4(int index, ShortBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4sv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttrib4dv(int var0, long var1, long var3);

    public static void nglVertexAttrib4dv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib4dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib4dv(index, v, __functionAddress);
    }

    public static void glVertexAttrib4d(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 32);
        }
        GL20.nglVertexAttrib4dv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib4(int index, DoubleBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4dv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttrib4iv(int var0, long var1, long var3);

    public static void nglVertexAttrib4iv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib4iv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib4iv(index, v, __functionAddress);
    }

    public static void glVertexAttrib4i(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 16);
        }
        GL20.nglVertexAttrib4iv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib4(int index, IntBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4iv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttrib4bv(int var0, long var1, long var3);

    public static void nglVertexAttrib4bv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib4bv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib4bv(index, v, __functionAddress);
    }

    public static void glVertexAttrib4b(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4bv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttrib4ubv(int var0, long var1, long var3);

    public static void nglVertexAttrib4ubv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib4ubv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib4ubv(index, v, __functionAddress);
    }

    public static void glVertexAttrib4ub(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4ubv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttrib4usv(int var0, long var1, long var3);

    public static void nglVertexAttrib4usv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib4usv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib4usv(index, v, __functionAddress);
    }

    public static void glVertexAttrib4us(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 8);
        }
        GL20.nglVertexAttrib4usv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib4u(int index, ShortBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4usv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttrib4uiv(int var0, long var1, long var3);

    public static void nglVertexAttrib4uiv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib4uiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib4uiv(index, v, __functionAddress);
    }

    public static void glVertexAttrib4ui(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 16);
        }
        GL20.nglVertexAttrib4uiv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib4u(int index, IntBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4uiv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttrib4Nbv(int var0, long var1, long var3);

    public static void nglVertexAttrib4Nbv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib4Nbv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib4Nbv(index, v, __functionAddress);
    }

    public static void glVertexAttrib4Nb(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4Nbv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttrib4Nsv(int var0, long var1, long var3);

    public static void nglVertexAttrib4Nsv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib4Nsv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib4Nsv(index, v, __functionAddress);
    }

    public static void glVertexAttrib4Ns(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 8);
        }
        GL20.nglVertexAttrib4Nsv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib4N(int index, ShortBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4Nsv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttrib4Niv(int var0, long var1, long var3);

    public static void nglVertexAttrib4Niv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib4Niv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib4Niv(index, v, __functionAddress);
    }

    public static void glVertexAttrib4Ni(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 16);
        }
        GL20.nglVertexAttrib4Niv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib4N(int index, IntBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4Niv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttrib4Nubv(int var0, long var1, long var3);

    public static void nglVertexAttrib4Nubv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib4Nubv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib4Nubv(index, v, __functionAddress);
    }

    public static void glVertexAttrib4Nub(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4Nubv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttrib4Nusv(int var0, long var1, long var3);

    public static void nglVertexAttrib4Nusv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib4Nusv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib4Nusv(index, v, __functionAddress);
    }

    public static void glVertexAttrib4Nus(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 8);
        }
        GL20.nglVertexAttrib4Nusv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib4Nu(int index, ShortBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4Nusv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttrib4Nuiv(int var0, long var1, long var3);

    public static void nglVertexAttrib4Nuiv(int index, long v) {
        long __functionAddress = GL20.getInstance().VertexAttrib4Nuiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttrib4Nuiv(index, v, __functionAddress);
    }

    public static void glVertexAttrib4Nui(int index, ByteBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 16);
        }
        GL20.nglVertexAttrib4Nuiv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttrib4Nu(int index, IntBuffer v) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL20.nglVertexAttrib4Nuiv(index, MemoryUtil.memAddress(v));
    }

    public static native void nglVertexAttribPointer(int var0, int var1, int var2, boolean var3, int var4, long var5, long var7);

    public static void nglVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, long pointer) {
        long __functionAddress = GL20.getInstance().VertexAttribPointer;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglVertexAttribPointer(index, size, type, normalized, stride, pointer, __functionAddress);
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, ByteBuffer pointer) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        GL20.nglVertexAttribPointer(index, size, type, normalized, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glVertexAttribPointer(int index, int size, int type, boolean normalized, int stride, long pointerOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34964, true);
        }
        GL20.nglVertexAttribPointer(index, size, type, normalized, stride, pointerOffset);
    }

    public static void glVertexAttribPointer(int index, int size, boolean normalized, int stride, ShortBuffer pointer) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        GL20.nglVertexAttribPointer(index, size, 5122, normalized, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glVertexAttribPointer(int index, int size, boolean normalized, int stride, IntBuffer pointer) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        GL20.nglVertexAttribPointer(index, size, 5124, normalized, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glVertexAttribPointer(int index, int size, boolean normalized, int stride, FloatBuffer pointer) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        GL20.nglVertexAttribPointer(index, size, 5126, normalized, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glVertexAttribPointer(int index, int size, boolean normalized, int stride, DoubleBuffer pointer) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        GL20.nglVertexAttribPointer(index, size, 5130, normalized, stride, MemoryUtil.memAddress(pointer));
    }

    public static native void nglEnableVertexAttribArray(int var0, long var1);

    public static void glEnableVertexAttribArray(int index) {
        long __functionAddress = GL20.getInstance().EnableVertexAttribArray;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglEnableVertexAttribArray(index, __functionAddress);
    }

    public static native void nglDisableVertexAttribArray(int var0, long var1);

    public static void glDisableVertexAttribArray(int index) {
        long __functionAddress = GL20.getInstance().DisableVertexAttribArray;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglDisableVertexAttribArray(index, __functionAddress);
    }

    public static native void nglBindAttribLocation(int var0, int var1, long var2, long var4);

    public static void nglBindAttribLocation(int program, int index, long name) {
        long __functionAddress = GL20.getInstance().BindAttribLocation;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglBindAttribLocation(program, index, name, __functionAddress);
    }

    public static void glBindAttribLocation(int program, int index, ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(name);
        }
        GL20.nglBindAttribLocation(program, index, MemoryUtil.memAddress(name));
    }

    public static void glBindAttribLocation(int program, int index, CharSequence name) {
        ByteBuffer nameEncoded = MemoryUtil.memEncodeASCII(name);
        GL20.nglBindAttribLocation(program, index, MemoryUtil.memAddress(nameEncoded));
    }

    public static native void nglGetActiveAttrib(int var0, int var1, int var2, long var3, long var5, long var7, long var9, long var11);

    public static void nglGetActiveAttrib(int program, int index, int maxLength, long length, long size, long type, long name) {
        long __functionAddress = GL20.getInstance().GetActiveAttrib;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglGetActiveAttrib(program, index, maxLength, length, size, type, name, __functionAddress);
    }

    public static void glGetActiveAttrib(int program, int index, int maxLength, ByteBuffer length, ByteBuffer size, ByteBuffer type, ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)name, maxLength);
        }
        GL20.nglGetActiveAttrib(program, index, maxLength, MemoryUtil.memAddress(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    public static void glGetActiveAttrib(int program, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        GL20.nglGetActiveAttrib(program, index, name.remaining(), MemoryUtil.memAddress(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    public static String glGetActiveAttrib(int program, int index, int maxLength, IntBuffer size, IntBuffer type) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(maxLength);
        GL20.nglGetActiveAttrib(program, index, maxLength, __buffer.address() + (long)length, MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), __buffer.address() + (long)name);
        return MemoryUtil.memDecodeASCII(MemoryUtil.memByteBuffer(__buffer.address() + (long)name, __buffer.intValue(length)));
    }

    public static String glGetActiveAttrib(int program, int index, IntBuffer size, IntBuffer type) {
        int maxLength = GL20.glGetProgrami(program, 35722);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(maxLength);
        GL20.nglGetActiveAttrib(program, index, maxLength, __buffer.address() + (long)length, MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), __buffer.address() + (long)name);
        return MemoryUtil.memDecodeASCII(MemoryUtil.memByteBuffer(__buffer.address() + (long)name, __buffer.intValue(length)));
    }

    public static native int nglGetAttribLocation(int var0, long var1, long var3);

    public static int nglGetAttribLocation(int program, long name) {
        long __functionAddress = GL20.getInstance().GetAttribLocation;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL20.nglGetAttribLocation(program, name, __functionAddress);
    }

    public static int glGetAttribLocation(int program, ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(name);
        }
        return GL20.nglGetAttribLocation(program, MemoryUtil.memAddress(name));
    }

    public static int glGetAttribLocation(int program, CharSequence name) {
        ByteBuffer nameEncoded = MemoryUtil.memEncodeASCII(name);
        return GL20.nglGetAttribLocation(program, MemoryUtil.memAddress(nameEncoded));
    }

    public static native void nglGetVertexAttribiv(int var0, int var1, long var2, long var4);

    public static void nglGetVertexAttribiv(int index, int pname, long params) {
        long __functionAddress = GL20.getInstance().GetVertexAttribiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglGetVertexAttribiv(index, pname, params, __functionAddress);
    }

    public static void glGetVertexAttribi(int index, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL20.nglGetVertexAttribiv(index, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetVertexAttrib(int index, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL20.nglGetVertexAttribiv(index, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetVertexAttribi(int index, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL20.nglGetVertexAttribiv(index, pname, __buffer.address() + (long)params);
        return __buffer.intValue(params);
    }

    public static native void nglGetVertexAttribfv(int var0, int var1, long var2, long var4);

    public static void nglGetVertexAttribfv(int index, int pname, long params) {
        long __functionAddress = GL20.getInstance().GetVertexAttribfv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglGetVertexAttribfv(index, pname, params, __functionAddress);
    }

    public static void glGetVertexAttribf(int index, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 16);
        }
        GL20.nglGetVertexAttribfv(index, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetVertexAttrib(int index, int pname, FloatBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL20.nglGetVertexAttribfv(index, pname, MemoryUtil.memAddress(params));
    }

    public static native void nglGetVertexAttribdv(int var0, int var1, long var2, long var4);

    public static void nglGetVertexAttribdv(int index, int pname, long params) {
        long __functionAddress = GL20.getInstance().GetVertexAttribdv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglGetVertexAttribdv(index, pname, params, __functionAddress);
    }

    public static void glGetVertexAttribd(int index, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 32);
        }
        GL20.nglGetVertexAttribdv(index, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetVertexAttrib(int index, int pname, DoubleBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL20.nglGetVertexAttribdv(index, pname, MemoryUtil.memAddress(params));
    }

    public static native void nglGetVertexAttribPointerv(int var0, int var1, long var2, long var4);

    public static void nglGetVertexAttribPointerv(int index, int pname, long pointer) {
        long __functionAddress = GL20.getInstance().GetVertexAttribPointerv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglGetVertexAttribPointerv(index, pname, pointer, __functionAddress);
    }

    public static void glGetVertexAttribPointer(int index, int pname, ByteBuffer pointer) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)pointer, 1 << Pointer.POINTER_SHIFT);
        }
        GL20.nglGetVertexAttribPointerv(index, pname, MemoryUtil.memAddress(pointer));
    }

    public static void glGetVertexAttribPointer(int index, int pname, PointerBuffer pointer) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer(pointer, 1);
        }
        GL20.nglGetVertexAttribPointerv(index, pname, MemoryUtil.memAddress(pointer));
    }

    public static long glGetVertexAttribPointer(int index, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int pointer = __buffer.pointerParam();
        GL20.nglGetVertexAttribPointerv(index, pname, __buffer.address() + (long)pointer);
        return __buffer.pointerValue(pointer);
    }

    public static native void nglDrawBuffers(int var0, long var1, long var3);

    public static void nglDrawBuffers(int n, long bufs) {
        long __functionAddress = GL20.getInstance().DrawBuffers;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglDrawBuffers(n, bufs, __functionAddress);
    }

    public static void glDrawBuffers(int n, ByteBuffer bufs) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)bufs, n << 2);
        }
        GL20.nglDrawBuffers(n, MemoryUtil.memAddress(bufs));
    }

    public static void glDrawBuffers(IntBuffer bufs) {
        GL20.nglDrawBuffers(bufs.remaining(), MemoryUtil.memAddress(bufs));
    }

    public static void glDrawBuffers(int buf) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int bufs = __buffer.intParam(buf);
        GL20.nglDrawBuffers(1, __buffer.address() + (long)bufs);
    }

    public static native void nglBlendEquationSeparate(int var0, int var1, long var2);

    public static void glBlendEquationSeparate(int modeRGB, int modeAlpha) {
        long __functionAddress = GL20.getInstance().BlendEquationSeparate;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglBlendEquationSeparate(modeRGB, modeAlpha, __functionAddress);
    }

    public static native void nglStencilOpSeparate(int var0, int var1, int var2, int var3, long var4);

    public static void glStencilOpSeparate(int face, int sfail, int dpfail, int dppass) {
        long __functionAddress = GL20.getInstance().StencilOpSeparate;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglStencilOpSeparate(face, sfail, dpfail, dppass, __functionAddress);
    }

    public static native void nglStencilFuncSeparate(int var0, int var1, int var2, int var3, long var4);

    public static void glStencilFuncSeparate(int face, int func, int ref, int mask) {
        long __functionAddress = GL20.getInstance().StencilFuncSeparate;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglStencilFuncSeparate(face, func, ref, mask, __functionAddress);
    }

    public static native void nglStencilMaskSeparate(int var0, int var1, long var2);

    public static void glStencilMaskSeparate(int face, int mask) {
        long __functionAddress = GL20.getInstance().StencilMaskSeparate;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL20.nglStencilMaskSeparate(face, mask, __functionAddress);
    }
}

