/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLContext;
import org.lwjgl.opengl.GLX11;
import org.lwjgl.opengl.GLX12;
import org.lwjgl.opengl.GLX14;
import org.lwjgl.opengl.GLXARBGetProcAddress;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.opengl.Util;
import org.lwjgl.opengl.WGLARBExtensionsString;
import org.lwjgl.opengl.WGLEXTExtensionsString;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.DynamicLinkLibrary;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.linux.GLX;
import org.lwjgl.system.windows.WGL;

public final class GL {
    private static FunctionProvider functionProvider;
    private static final ThreadLocal<GLContext> contextTL;

    private GL() {
    }

    public static void create() {
        String libName;
        switch (LWJGLUtil.getPlatform()) {
            case WINDOWS: {
                libName = "opengl32";
                break;
            }
            case LINUX: {
                libName = "GL";
                break;
            }
            case MACOSX: {
                libName = "/System/Library/Frameworks/OpenGL.framework";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        GL.create(System.getProperty("org.lwjgl.opengl.libname", libName));
    }

    public static void create(String libName) {
        if (functionProvider != null) {
            throw new IllegalStateException("OpenGL has already been created.");
        }
        final DynamicLinkLibrary OPENGL = LWJGLUtil.loadLibraryNative(libName);
        switch (LWJGLUtil.getPlatform()) {
            abstract class FunctionProviderGL
            extends FunctionProvider.Default {
                final /* synthetic */ DynamicLinkLibrary val$OPENGL;

                FunctionProviderGL(DynamicLinkLibrary dynamicLinkLibrary) {
                    this.val$OPENGL = dynamicLinkLibrary;
                }

                abstract long getExtensionAddress(ByteBuffer var1);

                @Override
                public long getFunctionAddress(CharSequence functionName) {
                    ByteBuffer nameBuffer = MemoryUtil.memEncodeASCII(functionName);
                    long address = this.getExtensionAddress(nameBuffer);
                    if (address == 0L && (address = this.val$OPENGL.getFunctionAddress(nameBuffer)) == 0L) {
                        LWJGLUtil.log("Failed to locate address for GL function " + functionName);
                    }
                    return address;
                }

                @Override
                protected void destroy() {
                    this.val$OPENGL.release();
                }
            }
            case WINDOWS: {
                functionProvider = new FunctionProviderGL(){
                    {
                        super(dynamicLinkLibrary);
                    }

                    @Override
                    long getExtensionAddress(ByteBuffer name) {
                        return WGL.wglGetProcAddress(name);
                    }
                };
                break;
            }
            case LINUX: {
                functionProvider = new FunctionProviderGL(){
                    final long glXGetProcAddress;
                    final long glXGetProcAddressARB;
                    {
                        super(dynamicLinkLibrary);
                        this.glXGetProcAddress = OPENGL.getFunctionAddress("glXGetProcAddress");
                        this.glXGetProcAddressARB = OPENGL.getFunctionAddress("glXGetProcAddressARB");
                    }

                    @Override
                    long getExtensionAddress(ByteBuffer name) {
                        if (this.glXGetProcAddress != 0L) {
                            return GLX14.nglXGetProcAddress(MemoryUtil.memAddress(name), this.glXGetProcAddress);
                        }
                        if (this.glXGetProcAddressARB != 0L) {
                            return GLXARBGetProcAddress.nglXGetProcAddressARB(MemoryUtil.memAddress(name), this.glXGetProcAddressARB);
                        }
                        return 0L;
                    }
                };
                break;
            }
            case MACOSX: {
                functionProvider = new FunctionProviderGL(){
                    {
                        super(dynamicLinkLibrary);
                    }

                    @Override
                    long getExtensionAddress(ByteBuffer name) {
                        return 0L;
                    }
                };
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public static void destroy() {
        if (functionProvider == null) {
            return;
        }
        functionProvider.release();
        functionProvider = null;
    }

    public static FunctionProvider getFunctionProvider() {
        return functionProvider;
    }

    public static void setCurrent(GLContext context) {
        contextTL.set(context);
    }

    public static GLContext getCurrent() {
        return contextTL.get();
    }

    public static ContextCapabilities getCapabilities() {
        GLContext currentContext = contextTL.get();
        if (currentContext == null) {
            throw new IllegalStateException("There is no OpenGL context current in the current thread.");
        }
        return currentContext.capabilities;
    }

    public static ContextCapabilities createCapabilities(boolean forwardCompatible) {
        int minorVersion;
        int majorVersion;
        long GetError = functionProvider.getFunctionAddress("glGetError");
        long GetString = functionProvider.getFunctionAddress("glGetString");
        long GetIntegerv = functionProvider.getFunctionAddress("glGetIntegerv");
        if (GetError == 0L || GetString == 0L || GetIntegerv == 0L) {
            throw new IllegalStateException("Core OpenGL functions could not be found. Make sure that a GL context is current in the current thread.");
        }
        int errorCode = GL11.nglGetError(GetError);
        if (errorCode != 0) {
            LWJGLUtil.log("A GL context was in an error state before the creation of its capabilities instance. Error: " + Util.translateGLErrorString(errorCode));
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        __buffer.intParam(0, 0, 0);
        GL11.nglGetIntegerv(33307, __buffer.address(), GetIntegerv);
        if (GL11.nglGetError(GetError) == 0 && 3 <= (majorVersion = __buffer.intValue(0))) {
            GL11.nglGetIntegerv(33308, __buffer.address(), GetIntegerv);
            minorVersion = __buffer.intValue(0);
        } else {
            APIUtil.APIVersion version = APIUtil.apiParseVersion(MemoryUtil.memDecodeUTF8(Checks.checkPointer(GL11.nglGetString(7938, GetString))));
            majorVersion = version.major;
            minorVersion = version.minor;
        }
        if (majorVersion < 1 || majorVersion == 1 && minorVersion < 1) {
            throw new IllegalStateException("OpenGL 1.1 is required.");
        }
        int[][] GL_VERSIONS = new int[][]{{1, 2, 3, 4, 5}, {0, 1}, {0, 1, 2, 3}, {0, 1, 2, 3, 4, 5}};
        HashSet<String> supportedExtensions = new HashSet<String>(128);
        for (int major = 1; major <= GL_VERSIONS.length; ++major) {
            for (int minor : GL_VERSIONS[major - 1]) {
                if (major >= majorVersion && (major != majorVersion || minor > minorVersion)) continue;
                supportedExtensions.add(String.format("OpenGL%d%d", major, minor));
            }
        }
        if (majorVersion < 3) {
            String extensionsString = MemoryUtil.memDecodeASCII(Checks.checkPointer(GL11.nglGetString(7939, GetString)));
            StringTokenizer tokenizer = new StringTokenizer(extensionsString);
            while (tokenizer.hasMoreTokens()) {
                supportedExtensions.add(tokenizer.nextToken());
            }
        } else {
            GL11.nglGetIntegerv(33309, __buffer.address(), GetIntegerv);
            int extensionCount = __buffer.intValue(0);
            long GetStringi = Checks.checkPointer(Checks.checkFunctionAddress(functionProvider.getFunctionAddress("glGetStringi")));
            for (int i = 0; i < extensionCount; ++i) {
                supportedExtensions.add(MemoryUtil.memDecodeASCII(GL30.nglGetStringi(7939, i, GetStringi)));
            }
            GL11.nglGetIntegerv(33310, __buffer.address(), GetIntegerv);
            if ((__buffer.intValue(0) & 1) != 0) {
                forwardCompatible = true;
            } else if (3 < majorVersion || 1 <= minorVersion) {
                if (3 < majorVersion || 2 <= minorVersion) {
                    GL11.nglGetIntegerv(37158, __buffer.address(), GetIntegerv);
                    if ((__buffer.intValue(0) & 1) != 0) {
                        forwardCompatible = true;
                    }
                } else {
                    forwardCompatible = !supportedExtensions.contains("GL_ARB_compatibility");
                }
            }
        }
        switch (LWJGLUtil.getPlatform()) {
            case WINDOWS: {
                GL.addWGLExtensions(supportedExtensions);
                break;
            }
            case LINUX: {
                GL.addGLXExtensions(supportedExtensions);
                break;
            }
            case MACOSX: {
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return new ContextCapabilities(GL.getFunctionProvider(), supportedExtensions, forwardCompatible);
    }

    private static void addWGLExtensions(Set<String> supportedExtensions) {
        String wglExtensions;
        long wglGetExtensionsString = functionProvider.getFunctionAddress("wglGetExtensionsStringARB");
        if (wglGetExtensionsString != 0L) {
            wglExtensions = MemoryUtil.memDecodeASCII(WGLARBExtensionsString.nwglGetExtensionsStringARB(WGL.wglGetCurrentDC(), wglGetExtensionsString));
        } else {
            wglGetExtensionsString = functionProvider.getFunctionAddress("wglGetExtensionsStringEXT");
            if (wglGetExtensionsString == 0L) {
                return;
            }
            wglExtensions = MemoryUtil.memDecodeASCII(WGLEXTExtensionsString.nwglGetExtensionsStringEXT(wglGetExtensionsString));
        }
        StringTokenizer tokenizer = new StringTokenizer(wglExtensions);
        while (tokenizer.hasMoreTokens()) {
            supportedExtensions.add(tokenizer.nextToken());
        }
    }

    private static void addGLXExtensions(Set<String> supportedExtensions) {
        APIBuffer __buffer;
        long glXGetCurrentDisplay = GL.getFunctionProvider().getFunctionAddress("glXGetCurrentDisplay");
        if (glXGetCurrentDisplay == 0L) {
            throw new OpenGLException("Failed to retrieve glXGetCurrentDisplay function address.");
        }
        long display = GLX12.nglXGetCurrentDisplay(glXGetCurrentDisplay);
        if (GLX.nglXQueryVersion(display, (__buffer = APIUtil.apiBuffer()).address(), __buffer.address() + 4L) == 0) {
            throw new OpenGLException("GLX is not available.");
        }
        int majorVersion = __buffer.intValue(0);
        int minorVersion = __buffer.intValue(4);
        if (majorVersion != 1) {
            throw new OpenGLException("Invalid GLX major version: " + majorVersion);
        }
        int[][] GLX_VERSIONS = new int[][]{{1, 2, 3, 4}};
        for (int major = 1; major <= GLX_VERSIONS.length; ++major) {
            int[] minors;
            for (int minor : minors = GLX_VERSIONS[major - 1]) {
                if (major >= majorVersion && (major != majorVersion || minor > minorVersion)) continue;
                supportedExtensions.add("GLX_" + Integer.toString(major) + Integer.toString(minor));
            }
        }
        long glXQueryExtensionsString = functionProvider.getFunctionAddress("glXQueryExtensionsString");
        if (glXQueryExtensionsString == 0L) {
            return;
        }
        String glxExtensions = MemoryUtil.memDecodeASCII(GLX11.nglXQueryExtensionsString(display, 0, glXQueryExtensionsString));
        StringTokenizer tokenizer = new StringTokenizer(glxExtensions);
        while (tokenizer.hasMoreTokens()) {
            supportedExtensions.add(tokenizer.nextToken());
        }
    }

    static long getFunctionAddress(FunctionProvider provider, String functionName, boolean fc) {
        return fc ? 0L : provider.getFunctionAddress(functionName);
    }

    static <T> T checkExtension(String extension, T functions, boolean supported) {
        if (supported) {
            return functions;
        }
        LWJGLUtil.log("[GL] " + extension + " was reported as available but an entry point is missing.");
        return null;
    }

    static {
        contextTL = new ThreadLocal();
        if (!Boolean.getBoolean("org.lwjgl.opengl.explicitInit")) {
            GL.create();
        }
    }
}

