/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL20;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class EXTTransformFeedback {
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_EXT = 35982;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_START_EXT = 35972;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_EXT = 35973;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_EXT = 35983;
    public static final int GL_INTERLEAVED_ATTRIBS_EXT = 35980;
    public static final int GL_SEPARATE_ATTRIBS_EXT = 35981;
    public static final int GL_PRIMITIVES_GENERATED_EXT = 35975;
    public static final int GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_EXT = 35976;
    public static final int GL_RASTERIZER_DISCARD_EXT = 35977;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_EXT = 35978;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_EXT = 35979;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_EXT = 35968;
    public static final int GL_TRANSFORM_FEEDBACK_VARYINGS_EXT = 35971;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_MODE_EXT = 35967;
    public static final int GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH_EXT = 35958;
    public final long BindBufferRangeEXT;
    public final long BindBufferOffsetEXT;
    public final long BindBufferBaseEXT;
    public final long BeginTransformFeedbackEXT;
    public final long EndTransformFeedbackEXT;
    public final long TransformFeedbackVaryingsEXT;
    public final long GetTransformFeedbackVaryingEXT;
    public final long GetIntegerIndexedvEXT;
    public final long GetBooleanIndexedvEXT;

    public EXTTransformFeedback(FunctionProvider provider) {
        this.BindBufferRangeEXT = provider.getFunctionAddress("glBindBufferRangeEXT");
        this.BindBufferOffsetEXT = provider.getFunctionAddress("glBindBufferOffsetEXT");
        this.BindBufferBaseEXT = provider.getFunctionAddress("glBindBufferBaseEXT");
        this.BeginTransformFeedbackEXT = provider.getFunctionAddress("glBeginTransformFeedbackEXT");
        this.EndTransformFeedbackEXT = provider.getFunctionAddress("glEndTransformFeedbackEXT");
        this.TransformFeedbackVaryingsEXT = provider.getFunctionAddress("glTransformFeedbackVaryingsEXT");
        this.GetTransformFeedbackVaryingEXT = provider.getFunctionAddress("glGetTransformFeedbackVaryingEXT");
        this.GetIntegerIndexedvEXT = provider.getFunctionAddress("glGetIntegerIndexedvEXT");
        this.GetBooleanIndexedvEXT = provider.getFunctionAddress("glGetBooleanIndexedvEXT");
    }

    public static EXTTransformFeedback getInstance() {
        return GL.getCapabilities().__EXTTransformFeedback;
    }

    static EXTTransformFeedback create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_EXT_transform_feedback")) {
            return null;
        }
        EXTTransformFeedback funcs = new EXTTransformFeedback(provider);
        boolean supported = Checks.checkFunctions(funcs.BindBufferRangeEXT, funcs.BindBufferOffsetEXT, funcs.BindBufferBaseEXT, funcs.BeginTransformFeedbackEXT, funcs.EndTransformFeedbackEXT, funcs.TransformFeedbackVaryingsEXT, funcs.GetTransformFeedbackVaryingEXT, funcs.GetIntegerIndexedvEXT, funcs.GetBooleanIndexedvEXT);
        return GL.checkExtension("GL_EXT_transform_feedback", funcs, supported);
    }

    public static native void nglBindBufferRangeEXT(int var0, int var1, int var2, long var3, long var5, long var7);

    public static void glBindBufferRangeEXT(int target, int index, int buffer, long offset, long size) {
        long __functionAddress = EXTTransformFeedback.getInstance().BindBufferRangeEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        EXTTransformFeedback.nglBindBufferRangeEXT(target, index, buffer, offset, size, __functionAddress);
    }

    public static native void nglBindBufferOffsetEXT(int var0, int var1, int var2, long var3, long var5);

    public static void glBindBufferOffsetEXT(int target, int index, int buffer, long offset) {
        long __functionAddress = EXTTransformFeedback.getInstance().BindBufferOffsetEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        EXTTransformFeedback.nglBindBufferOffsetEXT(target, index, buffer, offset, __functionAddress);
    }

    public static native void nglBindBufferBaseEXT(int var0, int var1, int var2, long var3);

    public static void glBindBufferBaseEXT(int target, int index, int buffer) {
        long __functionAddress = EXTTransformFeedback.getInstance().BindBufferBaseEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        EXTTransformFeedback.nglBindBufferBaseEXT(target, index, buffer, __functionAddress);
    }

    public static native void nglBeginTransformFeedbackEXT(int var0, long var1);

    public static void glBeginTransformFeedbackEXT(int primitiveMode) {
        long __functionAddress = EXTTransformFeedback.getInstance().BeginTransformFeedbackEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        EXTTransformFeedback.nglBeginTransformFeedbackEXT(primitiveMode, __functionAddress);
    }

    public static native void nglEndTransformFeedbackEXT(long var0);

    public static void glEndTransformFeedbackEXT() {
        long __functionAddress = EXTTransformFeedback.getInstance().EndTransformFeedbackEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        EXTTransformFeedback.nglEndTransformFeedbackEXT(__functionAddress);
    }

    public static native void nglTransformFeedbackVaryingsEXT(int var0, int var1, long var2, int var4, long var5);

    public static void nglTransformFeedbackVaryingsEXT(int program, int count, long varyings, int bufferMode) {
        long __functionAddress = EXTTransformFeedback.getInstance().TransformFeedbackVaryingsEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        EXTTransformFeedback.nglTransformFeedbackVaryingsEXT(program, count, varyings, bufferMode, __functionAddress);
    }

    public static void glTransformFeedbackVaryingsEXT(int program, int count, ByteBuffer varyings, int bufferMode) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)varyings, count << Pointer.POINTER_SHIFT);
        }
        EXTTransformFeedback.nglTransformFeedbackVaryingsEXT(program, count, MemoryUtil.memAddress(varyings), bufferMode);
    }

    public static void glTransformFeedbackVaryingsEXT(int program, PointerBuffer varyings, int bufferMode) {
        EXTTransformFeedback.nglTransformFeedbackVaryingsEXT(program, varyings.remaining(), MemoryUtil.memAddress(varyings), bufferMode);
    }

    public static void glTransformFeedbackVaryingsEXT(int program, CharSequence[] varyings, int bufferMode) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int varyingsAddress = __buffer.bufferParam(varyings.length << Pointer.POINTER_SHIFT);
        ByteBuffer[] varyingsBuffers = new ByteBuffer[varyings.length];
        for (int i = 0; i < varyings.length; ++i) {
            varyingsBuffers[i] = MemoryUtil.memEncodeASCII(varyings[i], true);
            __buffer.pointerParam(varyingsAddress, i, MemoryUtil.memAddress(varyingsBuffers[i]));
        }
        EXTTransformFeedback.nglTransformFeedbackVaryingsEXT(program, varyings.length, __buffer.address() + (long)varyingsAddress, bufferMode);
    }

    public static void glTransformFeedbackVaryingsEXT(int program, CharSequence varying, int bufferMode) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        ByteBuffer varyingBuffers = MemoryUtil.memEncodeASCII(varying, true);
        int varyingsAddress = __buffer.pointerParam(MemoryUtil.memAddress(varyingBuffers));
        EXTTransformFeedback.nglTransformFeedbackVaryingsEXT(program, 1, __buffer.address() + (long)varyingsAddress, bufferMode);
    }

    public static native void nglGetTransformFeedbackVaryingEXT(int var0, int var1, int var2, long var3, long var5, long var7, long var9, long var11);

    public static void nglGetTransformFeedbackVaryingEXT(int program, int index, int bufSize, long length, long size, long type, long name) {
        long __functionAddress = EXTTransformFeedback.getInstance().GetTransformFeedbackVaryingEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        EXTTransformFeedback.nglGetTransformFeedbackVaryingEXT(program, index, bufSize, length, size, type, name, __functionAddress);
    }

    public static void glGetTransformFeedbackVaryingEXT(int program, int index, int bufSize, ByteBuffer length, ByteBuffer size, ByteBuffer type, ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)name, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
            Checks.checkBuffer((Buffer)size, 4);
            Checks.checkBuffer((Buffer)type, 4);
        }
        EXTTransformFeedback.nglGetTransformFeedbackVaryingEXT(program, index, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    public static void glGetTransformFeedbackVaryingEXT(int program, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 1);
            }
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        EXTTransformFeedback.nglGetTransformFeedbackVaryingEXT(program, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    public static String glGetTransformFeedbackVaryingEXT(int program, int index, int bufSize, IntBuffer size, IntBuffer type) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(bufSize);
        EXTTransformFeedback.nglGetTransformFeedbackVaryingEXT(program, index, bufSize, __buffer.address() + (long)length, MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), __buffer.address() + (long)name);
        return MemoryUtil.memDecodeASCII(MemoryUtil.memByteBuffer(__buffer.address() + (long)name, __buffer.intValue(length)));
    }

    public static String glGetTransformFeedbackVaryingEXT(int program, int index, IntBuffer size, IntBuffer type) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        int bufSize = GL.getCapabilities().OpenGL20 ? GL20.glGetProgrami(program, 35958) : ARBShaderObjects.glGetObjectParameteriARB(program, 35958);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(bufSize);
        EXTTransformFeedback.nglGetTransformFeedbackVaryingEXT(program, index, bufSize, __buffer.address() + (long)length, MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), __buffer.address() + (long)name);
        return MemoryUtil.memDecodeASCII(MemoryUtil.memByteBuffer(__buffer.address() + (long)name, __buffer.intValue(length)));
    }

    public static native void nglGetIntegerIndexedvEXT(int var0, int var1, long var2, long var4);

    public static void nglGetIntegerIndexedvEXT(int param, int index, long values) {
        long __functionAddress = EXTTransformFeedback.getInstance().GetIntegerIndexedvEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        EXTTransformFeedback.nglGetIntegerIndexedvEXT(param, index, values, __functionAddress);
    }

    public static void glGetIntegerIndexedEXT(int param, int index, ByteBuffer values) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)values, 4);
        }
        EXTTransformFeedback.nglGetIntegerIndexedvEXT(param, index, MemoryUtil.memAddress(values));
    }

    public static void glGetIntegerIndexedEXT(int param, int index, IntBuffer values) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)values, 1);
        }
        EXTTransformFeedback.nglGetIntegerIndexedvEXT(param, index, MemoryUtil.memAddress(values));
    }

    public static int glGetIntegerIndexedEXT(int param, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int values = __buffer.intParam();
        EXTTransformFeedback.nglGetIntegerIndexedvEXT(param, index, __buffer.address() + (long)values);
        return __buffer.intValue(values);
    }

    public static native void nglGetBooleanIndexedvEXT(int var0, int var1, long var2, long var4);

    public static void nglGetBooleanIndexedvEXT(int param, int index, long values) {
        long __functionAddress = EXTTransformFeedback.getInstance().GetBooleanIndexedvEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        EXTTransformFeedback.nglGetBooleanIndexedvEXT(param, index, values, __functionAddress);
    }

    public static void glGetBooleanIndexedEXT(int param, int index, ByteBuffer values) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)values, 1);
        }
        EXTTransformFeedback.nglGetBooleanIndexedvEXT(param, index, MemoryUtil.memAddress(values));
    }

    public static boolean glGetBooleanIndexedEXT(int param, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int values = __buffer.booleanParam();
        EXTTransformFeedback.nglGetBooleanIndexedvEXT(param, index, __buffer.address() + (long)values);
        return __buffer.booleanValue(values);
    }
}

