/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class EXTFramebufferObject {
    public static final int GL_FRAMEBUFFER_EXT = 36160;
    public static final int GL_RENDERBUFFER_EXT = 36161;
    public static final int GL_STENCIL_INDEX1_EXT = 36166;
    public static final int GL_STENCIL_INDEX4_EXT = 36167;
    public static final int GL_STENCIL_INDEX8_EXT = 36168;
    public static final int GL_STENCIL_INDEX16_EXT = 36169;
    public static final int GL_RENDERBUFFER_WIDTH_EXT = 36162;
    public static final int GL_RENDERBUFFER_HEIGHT_EXT = 36163;
    public static final int GL_RENDERBUFFER_INTERNAL_FORMAT_EXT = 36164;
    public static final int GL_RENDERBUFFER_RED_SIZE_EXT = 36176;
    public static final int GL_RENDERBUFFER_GREEN_SIZE_EXT = 36177;
    public static final int GL_RENDERBUFFER_BLUE_SIZE_EXT = 36178;
    public static final int GL_RENDERBUFFER_ALPHA_SIZE_EXT = 36179;
    public static final int GL_RENDERBUFFER_DEPTH_SIZE_EXT = 36180;
    public static final int GL_RENDERBUFFER_STENCIL_SIZE_EXT = 36181;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT = 36048;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT = 36049;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT = 36050;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT = 36051;
    public static final int GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT = 36052;
    public static final int GL_COLOR_ATTACHMENT0_EXT = 36064;
    public static final int GL_COLOR_ATTACHMENT1_EXT = 36065;
    public static final int GL_COLOR_ATTACHMENT2_EXT = 36066;
    public static final int GL_COLOR_ATTACHMENT3_EXT = 36067;
    public static final int GL_COLOR_ATTACHMENT4_EXT = 36068;
    public static final int GL_COLOR_ATTACHMENT5_EXT = 36069;
    public static final int GL_COLOR_ATTACHMENT6_EXT = 36070;
    public static final int GL_COLOR_ATTACHMENT7_EXT = 36071;
    public static final int GL_COLOR_ATTACHMENT8_EXT = 36072;
    public static final int GL_COLOR_ATTACHMENT9_EXT = 36073;
    public static final int GL_COLOR_ATTACHMENT10_EXT = 36074;
    public static final int GL_COLOR_ATTACHMENT11_EXT = 36075;
    public static final int GL_COLOR_ATTACHMENT12_EXT = 36076;
    public static final int GL_COLOR_ATTACHMENT13_EXT = 36077;
    public static final int GL_COLOR_ATTACHMENT14_EXT = 36078;
    public static final int GL_COLOR_ATTACHMENT15_EXT = 36079;
    public static final int GL_DEPTH_ATTACHMENT_EXT = 36096;
    public static final int GL_STENCIL_ATTACHMENT_EXT = 36128;
    public static final int GL_FRAMEBUFFER_COMPLETE_EXT = 36053;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT = 36054;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT = 36055;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT = 36057;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT = 36058;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT = 36059;
    public static final int GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT = 36060;
    public static final int GL_FRAMEBUFFER_UNSUPPORTED_EXT = 36061;
    public static final int GL_FRAMEBUFFER_BINDING_EXT = 36006;
    public static final int GL_RENDERBUFFER_BINDING_EXT = 36007;
    public static final int GL_MAX_COLOR_ATTACHMENTS_EXT = 36063;
    public static final int GL_MAX_RENDERBUFFER_SIZE_EXT = 34024;
    public static final int GL_INVALID_FRAMEBUFFER_OPERATION_EXT = 1286;
    public final long IsRenderbufferEXT;
    public final long BindRenderbufferEXT;
    public final long DeleteRenderbuffersEXT;
    public final long GenRenderbuffersEXT;
    public final long RenderbufferStorageEXT;
    public final long GetRenderbufferParameterivEXT;
    public final long IsFramebufferEXT;
    public final long BindFramebufferEXT;
    public final long DeleteFramebuffersEXT;
    public final long GenFramebuffersEXT;
    public final long CheckFramebufferStatusEXT;
    public final long FramebufferTexture1DEXT;
    public final long FramebufferTexture2DEXT;
    public final long FramebufferTexture3DEXT;
    public final long FramebufferRenderbufferEXT;
    public final long GetFramebufferAttachmentParameterivEXT;
    public final long GenerateMipmapEXT;

    public EXTFramebufferObject(FunctionProvider provider) {
        this.IsRenderbufferEXT = provider.getFunctionAddress("glIsRenderbufferEXT");
        this.BindRenderbufferEXT = provider.getFunctionAddress("glBindRenderbufferEXT");
        this.DeleteRenderbuffersEXT = provider.getFunctionAddress("glDeleteRenderbuffersEXT");
        this.GenRenderbuffersEXT = provider.getFunctionAddress("glGenRenderbuffersEXT");
        this.RenderbufferStorageEXT = provider.getFunctionAddress("glRenderbufferStorageEXT");
        this.GetRenderbufferParameterivEXT = provider.getFunctionAddress("glGetRenderbufferParameterivEXT");
        this.IsFramebufferEXT = provider.getFunctionAddress("glIsFramebufferEXT");
        this.BindFramebufferEXT = provider.getFunctionAddress("glBindFramebufferEXT");
        this.DeleteFramebuffersEXT = provider.getFunctionAddress("glDeleteFramebuffersEXT");
        this.GenFramebuffersEXT = provider.getFunctionAddress("glGenFramebuffersEXT");
        this.CheckFramebufferStatusEXT = provider.getFunctionAddress("glCheckFramebufferStatusEXT");
        this.FramebufferTexture1DEXT = provider.getFunctionAddress("glFramebufferTexture1DEXT");
        this.FramebufferTexture2DEXT = provider.getFunctionAddress("glFramebufferTexture2DEXT");
        this.FramebufferTexture3DEXT = provider.getFunctionAddress("glFramebufferTexture3DEXT");
        this.FramebufferRenderbufferEXT = provider.getFunctionAddress("glFramebufferRenderbufferEXT");
        this.GetFramebufferAttachmentParameterivEXT = provider.getFunctionAddress("glGetFramebufferAttachmentParameterivEXT");
        this.GenerateMipmapEXT = provider.getFunctionAddress("glGenerateMipmapEXT");
    }

    public static EXTFramebufferObject getInstance() {
        return GL.getCapabilities().__EXTFramebufferObject;
    }

    static EXTFramebufferObject create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_EXT_framebuffer_object")) {
            return null;
        }
        EXTFramebufferObject funcs = new EXTFramebufferObject(provider);
        boolean supported = Checks.checkFunctions(funcs.IsRenderbufferEXT, funcs.BindRenderbufferEXT, funcs.DeleteRenderbuffersEXT, funcs.GenRenderbuffersEXT, funcs.RenderbufferStorageEXT, funcs.GetRenderbufferParameterivEXT, funcs.IsFramebufferEXT, funcs.BindFramebufferEXT, funcs.DeleteFramebuffersEXT, funcs.GenFramebuffersEXT, funcs.CheckFramebufferStatusEXT, funcs.FramebufferTexture1DEXT, funcs.FramebufferTexture2DEXT, funcs.FramebufferTexture3DEXT, funcs.FramebufferRenderbufferEXT, funcs.GetFramebufferAttachmentParameterivEXT, funcs.GenerateMipmapEXT);
        return GL.checkExtension("GL_EXT_framebuffer_object", funcs, supported);
    }

    public static native boolean nglIsRenderbufferEXT(int var0, long var1);

    public static boolean glIsRenderbufferEXT(int renderbuffer) {
        long __functionAddress = EXTFramebufferObject.getInstance().IsRenderbufferEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return EXTFramebufferObject.nglIsRenderbufferEXT(renderbuffer, __functionAddress);
    }

    public static native void nglBindRenderbufferEXT(int var0, int var1, long var2);

    public static void glBindRenderbufferEXT(int target, int renderbuffer) {
        long __functionAddress = EXTFramebufferObject.getInstance().BindRenderbufferEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        EXTFramebufferObject.nglBindRenderbufferEXT(target, renderbuffer, __functionAddress);
    }

    public static native void nglDeleteRenderbuffersEXT(int var0, long var1, long var3);

    public static void nglDeleteRenderbuffersEXT(int n, long renderbuffers) {
        long __functionAddress = EXTFramebufferObject.getInstance().DeleteRenderbuffersEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        EXTFramebufferObject.nglDeleteRenderbuffersEXT(n, renderbuffers, __functionAddress);
    }

    public static void glDeleteRenderbuffersEXT(int n, ByteBuffer renderbuffers) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)renderbuffers, n << 2);
        }
        EXTFramebufferObject.nglDeleteRenderbuffersEXT(n, MemoryUtil.memAddress(renderbuffers));
    }

    public static void glDeleteRenderbuffersEXT(IntBuffer renderbuffers) {
        EXTFramebufferObject.nglDeleteRenderbuffersEXT(renderbuffers.remaining(), MemoryUtil.memAddress(renderbuffers));
    }

    public static void glDeleteRenderbuffersEXT(int renderbuffer) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int renderbuffers = __buffer.intParam(renderbuffer);
        EXTFramebufferObject.nglDeleteRenderbuffersEXT(1, __buffer.address() + (long)renderbuffers);
    }

    public static native void nglGenRenderbuffersEXT(int var0, long var1, long var3);

    public static void nglGenRenderbuffersEXT(int n, long renderbuffers) {
        long __functionAddress = EXTFramebufferObject.getInstance().GenRenderbuffersEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        EXTFramebufferObject.nglGenRenderbuffersEXT(n, renderbuffers, __functionAddress);
    }

    public static void glGenRenderbuffersEXT(int n, ByteBuffer renderbuffers) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)renderbuffers, n << 2);
        }
        EXTFramebufferObject.nglGenRenderbuffersEXT(n, MemoryUtil.memAddress(renderbuffers));
    }

    public static void glGenRenderbuffersEXT(IntBuffer renderbuffers) {
        EXTFramebufferObject.nglGenRenderbuffersEXT(renderbuffers.remaining(), MemoryUtil.memAddress(renderbuffers));
    }

    public static int glGenRenderbuffersEXT() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int renderbuffers = __buffer.intParam();
        EXTFramebufferObject.nglGenRenderbuffersEXT(1, __buffer.address() + (long)renderbuffers);
        return __buffer.intValue(renderbuffers);
    }

    public static native void nglRenderbufferStorageEXT(int var0, int var1, int var2, int var3, long var4);

    public static void glRenderbufferStorageEXT(int target, int internalformat, int width, int height) {
        long __functionAddress = EXTFramebufferObject.getInstance().RenderbufferStorageEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        EXTFramebufferObject.nglRenderbufferStorageEXT(target, internalformat, width, height, __functionAddress);
    }

    public static native void nglGetRenderbufferParameterivEXT(int var0, int var1, long var2, long var4);

    public static void nglGetRenderbufferParameterivEXT(int target, int pname, long params) {
        long __functionAddress = EXTFramebufferObject.getInstance().GetRenderbufferParameterivEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        EXTFramebufferObject.nglGetRenderbufferParameterivEXT(target, pname, params, __functionAddress);
    }

    public static void glGetRenderbufferParameteriEXT(int target, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        EXTFramebufferObject.nglGetRenderbufferParameterivEXT(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetRenderbufferParameterEXT(int target, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTFramebufferObject.nglGetRenderbufferParameterivEXT(target, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetRenderbufferParameteriEXT(int target, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        EXTFramebufferObject.nglGetRenderbufferParameterivEXT(target, pname, __buffer.address() + (long)params);
        return __buffer.intValue(params);
    }

    public static native boolean nglIsFramebufferEXT(int var0, long var1);

    public static boolean glIsFramebufferEXT(int framebuffer) {
        long __functionAddress = EXTFramebufferObject.getInstance().IsFramebufferEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return EXTFramebufferObject.nglIsFramebufferEXT(framebuffer, __functionAddress);
    }

    public static native void nglBindFramebufferEXT(int var0, int var1, long var2);

    public static void glBindFramebufferEXT(int target, int framebuffer) {
        long __functionAddress = EXTFramebufferObject.getInstance().BindFramebufferEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        EXTFramebufferObject.nglBindFramebufferEXT(target, framebuffer, __functionAddress);
    }

    public static native void nglDeleteFramebuffersEXT(int var0, long var1, long var3);

    public static void nglDeleteFramebuffersEXT(int n, long framebuffers) {
        long __functionAddress = EXTFramebufferObject.getInstance().DeleteFramebuffersEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        EXTFramebufferObject.nglDeleteFramebuffersEXT(n, framebuffers, __functionAddress);
    }

    public static void glDeleteFramebuffersEXT(int n, ByteBuffer framebuffers) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)framebuffers, n << 2);
        }
        EXTFramebufferObject.nglDeleteFramebuffersEXT(n, MemoryUtil.memAddress(framebuffers));
    }

    public static void glDeleteFramebuffersEXT(IntBuffer framebuffers) {
        EXTFramebufferObject.nglDeleteFramebuffersEXT(framebuffers.remaining(), MemoryUtil.memAddress(framebuffers));
    }

    public static void glDeleteFramebuffersEXT(int framebuffer) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int framebuffers = __buffer.intParam(framebuffer);
        EXTFramebufferObject.nglDeleteFramebuffersEXT(1, __buffer.address() + (long)framebuffers);
    }

    public static native void nglGenFramebuffersEXT(int var0, long var1, long var3);

    public static void nglGenFramebuffersEXT(int n, long framebuffers) {
        long __functionAddress = EXTFramebufferObject.getInstance().GenFramebuffersEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        EXTFramebufferObject.nglGenFramebuffersEXT(n, framebuffers, __functionAddress);
    }

    public static void glGenFramebuffersEXT(int n, ByteBuffer framebuffers) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)framebuffers, n << 2);
        }
        EXTFramebufferObject.nglGenFramebuffersEXT(n, MemoryUtil.memAddress(framebuffers));
    }

    public static void glGenFramebuffersEXT(IntBuffer framebuffers) {
        EXTFramebufferObject.nglGenFramebuffersEXT(framebuffers.remaining(), MemoryUtil.memAddress(framebuffers));
    }

    public static int glGenFramebuffersEXT() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int framebuffers = __buffer.intParam();
        EXTFramebufferObject.nglGenFramebuffersEXT(1, __buffer.address() + (long)framebuffers);
        return __buffer.intValue(framebuffers);
    }

    public static native int nglCheckFramebufferStatusEXT(int var0, long var1);

    public static int glCheckFramebufferStatusEXT(int target) {
        long __functionAddress = EXTFramebufferObject.getInstance().CheckFramebufferStatusEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return EXTFramebufferObject.nglCheckFramebufferStatusEXT(target, __functionAddress);
    }

    public static native void nglFramebufferTexture1DEXT(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glFramebufferTexture1DEXT(int target, int attachment, int textarget, int texture, int level) {
        long __functionAddress = EXTFramebufferObject.getInstance().FramebufferTexture1DEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        EXTFramebufferObject.nglFramebufferTexture1DEXT(target, attachment, textarget, texture, level, __functionAddress);
    }

    public static native void nglFramebufferTexture2DEXT(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glFramebufferTexture2DEXT(int target, int attachment, int textarget, int texture, int level) {
        long __functionAddress = EXTFramebufferObject.getInstance().FramebufferTexture2DEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        EXTFramebufferObject.nglFramebufferTexture2DEXT(target, attachment, textarget, texture, level, __functionAddress);
    }

    public static native void nglFramebufferTexture3DEXT(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static void glFramebufferTexture3DEXT(int target, int attachment, int textarget, int texture, int level, int zoffset) {
        long __functionAddress = EXTFramebufferObject.getInstance().FramebufferTexture3DEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        EXTFramebufferObject.nglFramebufferTexture3DEXT(target, attachment, textarget, texture, level, zoffset, __functionAddress);
    }

    public static native void nglFramebufferRenderbufferEXT(int var0, int var1, int var2, int var3, long var4);

    public static void glFramebufferRenderbufferEXT(int target, int attachment, int renderbuffertarget, int renderbuffer) {
        long __functionAddress = EXTFramebufferObject.getInstance().FramebufferRenderbufferEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        EXTFramebufferObject.nglFramebufferRenderbufferEXT(target, attachment, renderbuffertarget, renderbuffer, __functionAddress);
    }

    public static native void nglGetFramebufferAttachmentParameterivEXT(int var0, int var1, int var2, long var3, long var5);

    public static void nglGetFramebufferAttachmentParameterivEXT(int target, int attachment, int pname, long params) {
        long __functionAddress = EXTFramebufferObject.getInstance().GetFramebufferAttachmentParameterivEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        EXTFramebufferObject.nglGetFramebufferAttachmentParameterivEXT(target, attachment, pname, params, __functionAddress);
    }

    public static void glGetFramebufferAttachmentParameteriEXT(int target, int attachment, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        EXTFramebufferObject.nglGetFramebufferAttachmentParameterivEXT(target, attachment, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetFramebufferAttachmentParameterEXT(int target, int attachment, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTFramebufferObject.nglGetFramebufferAttachmentParameterivEXT(target, attachment, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetFramebufferAttachmentParameteriEXT(int target, int attachment, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        EXTFramebufferObject.nglGetFramebufferAttachmentParameterivEXT(target, attachment, pname, __buffer.address() + (long)params);
        return __buffer.intValue(params);
    }

    public static native void nglGenerateMipmapEXT(int var0, long var1);

    public static void glGenerateMipmapEXT(int target) {
        long __functionAddress = EXTFramebufferObject.getInstance().GenerateMipmapEXT;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        EXTFramebufferObject.nglGenerateMipmapEXT(target, __functionAddress);
    }
}

