/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.AMDDebugOutput;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.MemoryUtil;

public interface DEBUGPROCAMD {
    public void invoke(int var1, int var2, int var3, int var4, long var5);

    public static final class Util {
        static final long CALLBACK = Util.setCallback(APIUtil.apiCallbackMethod(DEBUGPROCAMD.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE));
        private static final DEBUGPROCAMD DEFAULT = new StrAdapter(){

            @Override
            public void invoke(int id, int category, int severity, String message) {
                String description;
                System.err.println("[LWJGL] AMD_debug_output message");
                this.printDetail("ID", String.format("0x%X", id));
                switch (category) {
                    case 37193: {
                        description = "API ERROR";
                        break;
                    }
                    case 37194: {
                        description = "WINDOW SYSTEM";
                        break;
                    }
                    case 37195: {
                        description = "DEPRECATION";
                        break;
                    }
                    case 37196: {
                        description = "UNDEFINED BEHAVIOR";
                        break;
                    }
                    case 37197: {
                        description = "PERFORMANCE";
                        break;
                    }
                    case 37198: {
                        description = "SHADER COMPILER";
                        break;
                    }
                    case 37199: {
                        description = "APPLICATION";
                        break;
                    }
                    case 37200: {
                        description = "OTHER";
                        break;
                    }
                    default: {
                        description = this.getUnknownToken(category);
                    }
                }
                this.printDetail("Category", description);
                switch (severity) {
                    case 37190: {
                        description = "HIGH";
                        break;
                    }
                    case 37191: {
                        description = "MEDIUM";
                        break;
                    }
                    case 37192: {
                        description = "LOW";
                        break;
                    }
                    default: {
                        description = this.getUnknownToken(severity);
                    }
                }
                this.printDetail("Severity", description);
                this.printDetail("Message", message);
            }

            private String getUnknownToken(int token) {
                return String.format("Unknown (0x%X)", token);
            }

            private void printDetail(String type, String message) {
                System.err.printf("\t%s: %s\n", type, message);
            }
        };

        private Util() {
        }

        private static native long setCallback(Method var0);

        static long register(AMDDebugOutput context, DEBUGPROCAMD proc) {
            if (context.refDEBUGPROCAMD != 0L) {
                MemoryUtil.memGlobalRefDelete(context.refDEBUGPROCAMD);
            }
            context.refDEBUGPROCAMD = proc == null ? 0L : MemoryUtil.memGlobalRefNew(proc);
            return context.refDEBUGPROCAMD;
        }

        public static DEBUGPROCAMD getDefault() {
            return DEFAULT;
        }
    }

    public static abstract class StrAdapter
    implements Str {
        @Override
        public void invoke(int id, int category, int severity, int length, long message) {
            this.invoke(id, category, severity, MemoryUtil.memByteBuffer(message, length));
        }

        public void invoke(int id, int category, int severity, ByteBuffer message) {
            this.invoke(id, category, severity, MemoryUtil.memDecodeUTF8(message));
        }

        @Override
        public void invoke(int id, int category, int severity, String message) {
        }
    }

    public static interface Str
    extends DEBUGPROCAMD {
        public void invoke(int var1, int var2, int var3, String var4);
    }
}

