/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.KHRDebug;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.MemoryUtil;

public interface DEBUGPROC {
    public void invoke(int var1, int var2, int var3, int var4, int var5, long var6);

    public static final class Util {
        static final long CALLBACK = Util.setCallback(APIUtil.apiCallbackMethod(DEBUGPROC.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Long.TYPE));
        private static final DEBUGPROC DEFAULT = new StrAdapter(){

            @Override
            public void invoke(int source, int type, int id, int severity, String message) {
                String description;
                System.err.println("[LWJGL] OpenGL debug message");
                this.printDetail("ID", String.format("0x%X", id));
                switch (source) {
                    case 33350: {
                        description = "API";
                        break;
                    }
                    case 33351: {
                        description = "WINDOW SYSTEM";
                        break;
                    }
                    case 33352: {
                        description = "SHADER COMPILER";
                        break;
                    }
                    case 33353: {
                        description = "THIRD PARTY";
                        break;
                    }
                    case 33354: {
                        description = "APPLICATION";
                        break;
                    }
                    case 33355: {
                        description = "OTHER";
                        break;
                    }
                    default: {
                        description = this.getUnknownToken(source);
                    }
                }
                this.printDetail("Source", description);
                switch (type) {
                    case 33356: {
                        description = "ERROR";
                        break;
                    }
                    case 33357: {
                        description = "DEPRECATED BEHAVIOR";
                        break;
                    }
                    case 33358: {
                        description = "UNDEFINED BEHAVIOR";
                        break;
                    }
                    case 33359: {
                        description = "PORTABILITY";
                        break;
                    }
                    case 33360: {
                        description = "PERFORMANCE";
                        break;
                    }
                    case 33361: {
                        description = "OTHER";
                        break;
                    }
                    case 33384: {
                        description = "MARKER";
                        break;
                    }
                    default: {
                        description = this.getUnknownToken(type);
                    }
                }
                this.printDetail("Type", description);
                switch (severity) {
                    case 37190: {
                        description = "HIGH";
                        break;
                    }
                    case 37191: {
                        description = "MEDIUM";
                        break;
                    }
                    case 37192: {
                        description = "LOW";
                        break;
                    }
                    case 33387: {
                        description = "NOTIFICATION";
                        break;
                    }
                    default: {
                        description = this.getUnknownToken(severity);
                    }
                }
                this.printDetail("Severity", description);
                this.printDetail("Message", message);
            }

            private String getUnknownToken(int token) {
                return String.format("Unknown (0x%X)", token);
            }

            private void printDetail(String type, String message) {
                System.err.printf("\t%s: %s\n", type, message);
            }
        };

        private Util() {
        }

        private static native long setCallback(Method var0);

        static long register(GL43 context, DEBUGPROC proc) {
            if (context.refDEBUGPROC != 0L) {
                MemoryUtil.memGlobalRefDelete(context.refDEBUGPROC);
            }
            context.refDEBUGPROC = proc == null ? 0L : MemoryUtil.memGlobalRefNew(proc);
            return context.refDEBUGPROC;
        }

        static long register(KHRDebug context, DEBUGPROC proc) {
            if (context.refDEBUGPROC != 0L) {
                MemoryUtil.memGlobalRefDelete(context.refDEBUGPROC);
            }
            context.refDEBUGPROC = proc == null ? 0L : MemoryUtil.memGlobalRefNew(proc);
            return context.refDEBUGPROC;
        }

        public static DEBUGPROC getDefault() {
            return DEFAULT;
        }
    }

    public static abstract class StrAdapter
    implements Str {
        @Override
        public void invoke(int source, int type, int id, int severity, int length, long message) {
            this.invoke(source, type, id, severity, MemoryUtil.memByteBuffer(message, length));
        }

        public void invoke(int source, int type, int id, int severity, ByteBuffer message) {
            this.invoke(source, type, id, severity, MemoryUtil.memDecodeUTF8(message));
        }

        @Override
        public void invoke(int source, int type, int id, int severity, String message) {
        }
    }

    public static interface Str
    extends DEBUGPROC {
        public void invoke(int var1, int var2, int var3, int var4, String var5);
    }
}

