/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBWindowPos {
    public final long WindowPos2iARB;
    public final long WindowPos2sARB;
    public final long WindowPos2fARB;
    public final long WindowPos2dARB;
    public final long WindowPos2ivARB;
    public final long WindowPos2svARB;
    public final long WindowPos2fvARB;
    public final long WindowPos2dvARB;
    public final long WindowPos3iARB;
    public final long WindowPos3sARB;
    public final long WindowPos3fARB;
    public final long WindowPos3dARB;
    public final long WindowPos3ivARB;
    public final long WindowPos3svARB;
    public final long WindowPos3fvARB;
    public final long WindowPos3dvARB;

    public ARBWindowPos(FunctionProvider provider) {
        this.WindowPos2iARB = provider.getFunctionAddress("glWindowPos2iARB");
        this.WindowPos2sARB = provider.getFunctionAddress("glWindowPos2sARB");
        this.WindowPos2fARB = provider.getFunctionAddress("glWindowPos2fARB");
        this.WindowPos2dARB = provider.getFunctionAddress("glWindowPos2dARB");
        this.WindowPos2ivARB = provider.getFunctionAddress("glWindowPos2ivARB");
        this.WindowPos2svARB = provider.getFunctionAddress("glWindowPos2svARB");
        this.WindowPos2fvARB = provider.getFunctionAddress("glWindowPos2fvARB");
        this.WindowPos2dvARB = provider.getFunctionAddress("glWindowPos2dvARB");
        this.WindowPos3iARB = provider.getFunctionAddress("glWindowPos3iARB");
        this.WindowPos3sARB = provider.getFunctionAddress("glWindowPos3sARB");
        this.WindowPos3fARB = provider.getFunctionAddress("glWindowPos3fARB");
        this.WindowPos3dARB = provider.getFunctionAddress("glWindowPos3dARB");
        this.WindowPos3ivARB = provider.getFunctionAddress("glWindowPos3ivARB");
        this.WindowPos3svARB = provider.getFunctionAddress("glWindowPos3svARB");
        this.WindowPos3fvARB = provider.getFunctionAddress("glWindowPos3fvARB");
        this.WindowPos3dvARB = provider.getFunctionAddress("glWindowPos3dvARB");
    }

    public static ARBWindowPos getInstance() {
        return GL.getCapabilities().__ARBWindowPos;
    }

    static ARBWindowPos create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_window_pos")) {
            return null;
        }
        ARBWindowPos funcs = new ARBWindowPos(provider);
        boolean supported = Checks.checkFunctions(funcs.WindowPos2iARB, funcs.WindowPos2sARB, funcs.WindowPos2fARB, funcs.WindowPos2dARB, funcs.WindowPos2ivARB, funcs.WindowPos2svARB, funcs.WindowPos2fvARB, funcs.WindowPos2dvARB, funcs.WindowPos3iARB, funcs.WindowPos3sARB, funcs.WindowPos3fARB, funcs.WindowPos3dARB, funcs.WindowPos3ivARB, funcs.WindowPos3svARB, funcs.WindowPos3fvARB, funcs.WindowPos3dvARB);
        return GL.checkExtension("GL_ARB_window_pos", funcs, supported);
    }

    public static native void nglWindowPos2iARB(int var0, int var1, long var2);

    public static void glWindowPos2iARB(int x, int y) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos2iARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBWindowPos.nglWindowPos2iARB(x, y, __functionAddress);
    }

    public static native void nglWindowPos2sARB(short var0, short var1, long var2);

    public static void glWindowPos2sARB(short x, short y) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos2sARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBWindowPos.nglWindowPos2sARB(x, y, __functionAddress);
    }

    public static native void nglWindowPos2fARB(float var0, float var1, long var2);

    public static void glWindowPos2fARB(float x, float y) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos2fARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBWindowPos.nglWindowPos2fARB(x, y, __functionAddress);
    }

    public static native void nglWindowPos2dARB(double var0, double var2, long var4);

    public static void glWindowPos2dARB(double x, double y) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos2dARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBWindowPos.nglWindowPos2dARB(x, y, __functionAddress);
    }

    public static native void nglWindowPos2ivARB(long var0, long var2);

    public static void nglWindowPos2ivARB(long p) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos2ivARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBWindowPos.nglWindowPos2ivARB(p, __functionAddress);
    }

    public static void glWindowPos2iARB(ByteBuffer p) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)p, 8);
        }
        ARBWindowPos.nglWindowPos2ivARB(MemoryUtil.memAddress(p));
    }

    public static void glWindowPos2ARB(IntBuffer p) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)p, 2);
        }
        ARBWindowPos.nglWindowPos2ivARB(MemoryUtil.memAddress(p));
    }

    public static native void nglWindowPos2svARB(long var0, long var2);

    public static void nglWindowPos2svARB(long p) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos2svARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBWindowPos.nglWindowPos2svARB(p, __functionAddress);
    }

    public static void glWindowPos2sARB(ByteBuffer p) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)p, 4);
        }
        ARBWindowPos.nglWindowPos2svARB(MemoryUtil.memAddress(p));
    }

    public static void glWindowPos2ARB(ShortBuffer p) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)p, 2);
        }
        ARBWindowPos.nglWindowPos2svARB(MemoryUtil.memAddress(p));
    }

    public static native void nglWindowPos2fvARB(long var0, long var2);

    public static void nglWindowPos2fvARB(long p) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos2fvARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBWindowPos.nglWindowPos2fvARB(p, __functionAddress);
    }

    public static void glWindowPos2fARB(ByteBuffer p) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)p, 8);
        }
        ARBWindowPos.nglWindowPos2fvARB(MemoryUtil.memAddress(p));
    }

    public static void glWindowPos2ARB(FloatBuffer p) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)p, 2);
        }
        ARBWindowPos.nglWindowPos2fvARB(MemoryUtil.memAddress(p));
    }

    public static native void nglWindowPos2dvARB(long var0, long var2);

    public static void nglWindowPos2dvARB(long p) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos2dvARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBWindowPos.nglWindowPos2dvARB(p, __functionAddress);
    }

    public static void glWindowPos2dARB(ByteBuffer p) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)p, 16);
        }
        ARBWindowPos.nglWindowPos2dvARB(MemoryUtil.memAddress(p));
    }

    public static void glWindowPos2ARB(DoubleBuffer p) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)p, 2);
        }
        ARBWindowPos.nglWindowPos2dvARB(MemoryUtil.memAddress(p));
    }

    public static native void nglWindowPos3iARB(int var0, int var1, int var2, long var3);

    public static void glWindowPos3iARB(int x, int y, int z) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos3iARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBWindowPos.nglWindowPos3iARB(x, y, z, __functionAddress);
    }

    public static native void nglWindowPos3sARB(short var0, short var1, short var2, long var3);

    public static void glWindowPos3sARB(short x, short y, short z) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos3sARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBWindowPos.nglWindowPos3sARB(x, y, z, __functionAddress);
    }

    public static native void nglWindowPos3fARB(float var0, float var1, float var2, long var3);

    public static void glWindowPos3fARB(float x, float y, float z) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos3fARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBWindowPos.nglWindowPos3fARB(x, y, z, __functionAddress);
    }

    public static native void nglWindowPos3dARB(double var0, double var2, double var4, long var6);

    public static void glWindowPos3dARB(double x, double y, double z) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos3dARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBWindowPos.nglWindowPos3dARB(x, y, z, __functionAddress);
    }

    public static native void nglWindowPos3ivARB(long var0, long var2);

    public static void nglWindowPos3ivARB(long p) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos3ivARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBWindowPos.nglWindowPos3ivARB(p, __functionAddress);
    }

    public static void glWindowPos3iARB(ByteBuffer p) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)p, 12);
        }
        ARBWindowPos.nglWindowPos3ivARB(MemoryUtil.memAddress(p));
    }

    public static void glWindowPos3ARB(IntBuffer p) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)p, 3);
        }
        ARBWindowPos.nglWindowPos3ivARB(MemoryUtil.memAddress(p));
    }

    public static native void nglWindowPos3svARB(long var0, long var2);

    public static void nglWindowPos3svARB(long p) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos3svARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBWindowPos.nglWindowPos3svARB(p, __functionAddress);
    }

    public static void glWindowPos3sARB(ByteBuffer p) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)p, 6);
        }
        ARBWindowPos.nglWindowPos3svARB(MemoryUtil.memAddress(p));
    }

    public static void glWindowPos3ARB(ShortBuffer p) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)p, 3);
        }
        ARBWindowPos.nglWindowPos3svARB(MemoryUtil.memAddress(p));
    }

    public static native void nglWindowPos3fvARB(long var0, long var2);

    public static void nglWindowPos3fvARB(long p) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos3fvARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBWindowPos.nglWindowPos3fvARB(p, __functionAddress);
    }

    public static void glWindowPos3fARB(ByteBuffer p) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)p, 12);
        }
        ARBWindowPos.nglWindowPos3fvARB(MemoryUtil.memAddress(p));
    }

    public static void glWindowPos3ARB(FloatBuffer p) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)p, 3);
        }
        ARBWindowPos.nglWindowPos3fvARB(MemoryUtil.memAddress(p));
    }

    public static native void nglWindowPos3dvARB(long var0, long var2);

    public static void nglWindowPos3dvARB(long p) {
        long __functionAddress = ARBWindowPos.getInstance().WindowPos3dvARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ARBWindowPos.nglWindowPos3dvARB(p, __functionAddress);
    }

    public static void glWindowPos3dARB(ByteBuffer p) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)p, 24);
        }
        ARBWindowPos.nglWindowPos3dvARB(MemoryUtil.memAddress(p));
    }

    public static void glWindowPos3ARB(DoubleBuffer p) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)p, 3);
        }
        ARBWindowPos.nglWindowPos3dvARB(MemoryUtil.memAddress(p));
    }
}

